/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shape;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.constant.EnumPalette;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.BondIterator;
import org.jmol.shape.Shape;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.JmolEdge;
import org.jmol.util.P3;
import org.jmol.util.P3i;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sticks
extends Shape {
    private int myMask;
    private boolean reportAll;
    private BS bsOrderSet;
    private BS selectedBonds;
    private static final int MAX_BOND_CLICK_DISTANCE_SQUARED = 100;
    private final P3i ptXY = new P3i();

    @Override
    public void initShape() {
        super.initShape();
        this.myMask = 1023;
        this.reportAll = false;
    }

    @Override
    protected void setSize(int n, BS bS) {
        if (n == Integer.MAX_VALUE) {
            this.selectedBonds = BSUtil.copy(bS);
            return;
        }
        if (n == Integer.MIN_VALUE) {
            if (this.bsOrderSet == null) {
                this.bsOrderSet = new BS();
            }
            this.bsOrderSet.or(bS);
            return;
        }
        if (this.bsSizeSet == null) {
            this.bsSizeSet = new BS();
        }
        BondIterator bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIteratorForType(this.myMask, bS);
        short s = (short)n;
        while (bondIterator.hasNext()) {
            this.bsSizeSet.set(bondIterator.nextIndex());
            bondIterator.next().setMad(s);
        }
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        if ("type" == string) {
            this.myMask = (Integer)object;
            return;
        }
        if ("reportAll" == string) {
            this.reportAll = true;
            return;
        }
        if ("reset" == string) {
            this.bsOrderSet = null;
            this.bsSizeSet = null;
            this.bsColixSet = null;
            this.selectedBonds = null;
            return;
        }
        if ("bondOrder" == string) {
            BondIterator bondIterator;
            if (this.bsOrderSet == null) {
                this.bsOrderSet = new BS();
            }
            short s = ((Integer)object).shortValue();
            BondIterator bondIterator2 = bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIteratorForType(65535, bS);
            while (bondIterator.hasNext()) {
                this.bsOrderSet.set(bondIterator.nextIndex());
                bondIterator.next().setOrder(s);
            }
            return;
        }
        if ("color" == string) {
            BondIterator bondIterator;
            EnumPalette enumPalette;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            short s = C.getColixO(object);
            EnumPalette enumPalette2 = enumPalette = object instanceof EnumPalette ? (EnumPalette)((Object)object) : null;
            if (enumPalette == EnumPalette.TYPE || enumPalette == EnumPalette.ENERGY) {
                BondIterator bondIterator3;
                boolean bl = enumPalette == EnumPalette.ENERGY;
                BondIterator bondIterator4 = bondIterator3 = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIteratorForType(this.myMask, bS);
                while (bondIterator3.hasNext()) {
                    this.bsColixSet.set(bondIterator3.nextIndex());
                    Bond bond = bondIterator3.next();
                    if (bl) {
                        bond.setColix(this.getColixB(s, enumPalette.id, bond));
                        bond.setPaletteID(enumPalette.id);
                        continue;
                    }
                    bond.setColix(C.getColix(JmolEdge.getArgbHbondType(bond.order)));
                }
                return;
            }
            if (s == 2 && enumPalette != EnumPalette.CPK) {
                return;
            }
            BondIterator bondIterator5 = bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIteratorForType(this.myMask, bS);
            while (bondIterator.hasNext()) {
                int n = bondIterator.nextIndex();
                Bond bond = bondIterator.next();
                bond.setColix(s);
                this.bsColixSet.setBitTo(n, s != 0 && s != 2);
            }
            return;
        }
        if ("translucency" == string) {
            BondIterator bondIterator;
            if (this.bsColixSet == null) {
                this.bsColixSet = new BS();
            }
            boolean bl = ((String)object).equals("translucent");
            BondIterator bondIterator6 = bondIterator = this.selectedBonds != null ? this.modelSet.getBondIterator(this.selectedBonds) : this.modelSet.getBondIteratorForType(this.myMask, bS);
            while (bondIterator.hasNext()) {
                this.bsColixSet.set(bondIterator.nextIndex());
                bondIterator.next().setTranslucent(bl, this.translucentLevel);
            }
            return;
        }
        if ("deleteModelAtoms" == string) {
            return;
        }
        this.setPropS(string, object, bS);
    }

    @Override
    public Object getProperty(String string, int n) {
        if (string.equals("selectionState")) {
            return this.selectedBonds != null ? "select BONDS " + Escape.eBS(this.selectedBonds) + "\n" : "";
        }
        if (string.equals("sets")) {
            return new BS[]{this.bsOrderSet, this.bsSizeSet, this.bsColixSet};
        }
        return null;
    }

    @Override
    public void setModelClickability() {
        Bond[] bondArray = this.modelSet.bonds;
        int n = this.modelSet.bondCount;
        while (--n >= 0) {
            Bond bond = bondArray[n];
            if ((bond.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(bond.getAtomIndex1()) || this.modelSet.isAtomHidden(bond.getAtomIndex2())) continue;
            bond.getAtom1().setClickable(this.myVisibilityFlag);
            bond.getAtom2().setClickable(this.myVisibilityFlag);
        }
    }

    @Override
    public String getShapeState() {
        return this.viewer.getBondState(this, this.bsOrderSet, this.reportAll);
    }

    @Override
    public boolean checkObjectHovered(int n, int n2, BS bS) {
        P3 p3 = new P3();
        Bond bond = this.findPickedBond(n, n2, bS, p3);
        if (bond == null) {
            return false;
        }
        this.viewer.highlightBond(bond.index, true);
        return true;
    }

    @Override
    public Map<String, Object> checkObjectClicked(int n, int n2, int n3, BS bS, boolean bl) {
        P3 p3 = new P3();
        Bond bond = this.findPickedBond(n, n2, bS, p3);
        if (bond == null) {
            return null;
        }
        short s = bond.getAtom1().modelIndex;
        String string = bond.getIdentity();
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("pt", p3);
        hashtable.put("index", bond.index);
        hashtable.put("modelIndex", Integer.valueOf(s));
        hashtable.put("model", this.viewer.getModelNumberDotted(s));
        hashtable.put("type", "bond");
        hashtable.put("info", string);
        this.viewer.setStatusAtomPicked(-3, "[\"bond\",\"" + bond.getIdentity() + "\"," + p3.x + "," + p3.y + "," + p3.z + "]");
        return hashtable;
    }

    private Bond findPickedBond(int n, int n2, BS bS, P3 p3) {
        int n3 = 100;
        if (this.gdata.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n3 <<= 1;
        }
        Bond bond = null;
        P3 p32 = new P3();
        Bond[] bondArray = this.modelSet.bonds;
        int n4 = this.modelSet.bondCount;
        while (--n4 >= 0) {
            float f;
            Bond bond2 = bondArray[n4];
            if (bond2.getShapeVisibilityFlags() == 0) continue;
            Atom atom = bond2.getAtom1();
            Atom atom2 = bond2.getAtom2();
            if (!atom.isVisible(0) || !atom2.isVisible(0)) continue;
            p32.setT(atom);
            p32.add(atom2);
            p32.scale(0.5f);
            int n5 = this.coordinateInRange(n, n2, p32, n3, this.ptXY);
            if (n5 < 0 || (f = 1.0f * (float)(this.ptXY.x - atom.screenX) / (float)(atom2.screenX - atom.screenX)) < 0.4f || f > 0.6f) continue;
            n3 = n5;
            bond = bond2;
            p3.setT(p32);
        }
        return bond;
    }
}

