/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.api.JmolRendererInterface;
import org.jmol.g3d.Graphics3D;
import org.jmol.util.ColorUtil;
import org.jmol.util.JmolFont;

class TextRenderer {
    private int height;
    private int ascent;
    private int width;
    private int mapWidth;
    private int size;
    private byte[] tmap;
    private boolean isInvalid;
    private static final byte[] translucency = new byte[]{7, 6, 5, 4, 3, 2, 1, 8};
    private static boolean working;
    private static final Map<JmolFont, Map<String, TextRenderer>> htFont3d;
    private static final Map<JmolFont, Map<String, TextRenderer>> htFont3dAntialias;

    static synchronized void clearFontCache() {
        if (working) {
            return;
        }
        htFont3d.clear();
        htFont3dAntialias.clear();
    }

    static int plot(int n, int n2, int n3, int n4, int n5, String string, JmolFont jmolFont, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, boolean bl) {
        if (string.length() == 0) {
            return 0;
        }
        if (string.indexOf("<su") >= 0 || string.indexOf("<color") >= 0) {
            return TextRenderer.plotByCharacter(n, n2, n3, n4, n5, string, jmolFont, graphics3D, jmolRendererInterface, bl);
        }
        int n6 = jmolFont.getAscent();
        TextRenderer textRenderer = TextRenderer.getPlotText3D(n, n2 -= n6, graphics3D, string, jmolFont, bl);
        if (textRenderer.isInvalid) {
            return textRenderer.width;
        }
        if (bl && (n4 & 0xC0C0C0) == 0) {
            n4 |= 0x40404;
        }
        if (jmolRendererInterface != null || n < 0 || n + textRenderer.width > graphics3D.width || n2 < 0 || n2 + textRenderer.height > graphics3D.height) {
            TextRenderer.plotClipped(n, n2, n3, n4, n5, graphics3D, jmolRendererInterface, textRenderer.mapWidth, textRenderer.height, textRenderer.tmap);
        } else {
            TextRenderer.plotUnclipped(n, n2, n3, n4, n5, graphics3D, textRenderer.mapWidth, textRenderer.height, textRenderer.tmap);
        }
        return textRenderer.width;
    }

    private static int plotByCharacter(int n, int n2, int n3, int n4, int n5, String string, JmolFont jmolFont, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, boolean bl) {
        int n6 = 0;
        int n7 = string.length();
        int n8 = Math.round((float)jmolFont.getHeight() * 0.25f);
        int n9 = -Math.round((float)jmolFont.getHeight() * 0.3f);
        int n10 = 0;
        for (int i = 0; i < n7; ++i) {
            int n11;
            if (string.charAt(i) == '<') {
                if (i + 5 < n7 && string.substring(i, i + 6).equals("<color")) {
                    n10 = n4;
                    n11 = string.indexOf(">", i);
                    if (n11 < 0) continue;
                    n4 = ColorUtil.getArgbFromString(string.substring(i + 7, n11).trim());
                    i = n11;
                    continue;
                }
                if (i + 7 < n7 && string.substring(i, i + 8).equals("</color>")) {
                    i += 7;
                    n4 = n10;
                    continue;
                }
                if (i + 4 < n7 && string.substring(i, i + 5).equals("<sub>")) {
                    i += 4;
                    n2 += n8;
                    continue;
                }
                if (i + 4 < n7 && string.substring(i, i + 5).equals("<sup>")) {
                    i += 4;
                    n2 += n9;
                    continue;
                }
                if (i + 5 < n7 && string.substring(i, i + 6).equals("</sub>")) {
                    i += 5;
                    n2 -= n8;
                    continue;
                }
                if (i + 5 < n7 && string.substring(i, i + 6).equals("</sup>")) {
                    i += 5;
                    n2 -= n9;
                    continue;
                }
            }
            n11 = TextRenderer.plot(n + n6, n2, n3, n4, n5, string.substring(i, i + 1), jmolFont, graphics3D, jmolRendererInterface, bl);
            n6 += n11;
        }
        return n6;
    }

    private static void plotUnclipped(int n, int n2, int n3, int n4, int n5, Graphics3D graphics3D, int n6, int n7, byte[] byArray) {
        int n8 = 0;
        int[] nArray = graphics3D.zbuf;
        int n9 = graphics3D.width;
        int n10 = n2 * n9 + n;
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n6; ++j) {
                byte by;
                if ((by = byArray[n8++]) != 0 && n3 < nArray[n10]) {
                    graphics3D.shadeTextPixel(n10, n3, n4, n5, by);
                }
                ++n10;
            }
            n10 += n9 - n6;
        }
    }

    private static void plotClipped(int n, int n2, int n3, int n4, int n5, Graphics3D graphics3D, JmolRendererInterface jmolRendererInterface, int n6, int n7, byte[] byArray) {
        if (jmolRendererInterface == null) {
            jmolRendererInterface = graphics3D;
        }
        int n8 = 0;
        for (int i = 0; i < n7; ++i) {
            for (int j = 0; j < n6; ++j) {
                byte by;
                if ((by = byArray[n8++]) == 0) continue;
                jmolRendererInterface.plotImagePixel(n4, n + j, n2 + i, n3, by, n5);
            }
        }
    }

    private TextRenderer(String string, JmolFont jmolFont) {
        this.ascent = jmolFont.getAscent();
        this.height = jmolFont.getHeight();
        this.width = jmolFont.stringWidth(string);
        if (this.width == 0) {
            return;
        }
        this.mapWidth = this.width;
        this.size = this.mapWidth * this.height;
    }

    private static synchronized TextRenderer getPlotText3D(int n, int n2, Graphics3D graphics3D, String string, JmolFont jmolFont, boolean bl) {
        working = true;
        Map<JmolFont, Map<String, TextRenderer>> map = bl ? htFont3dAntialias : htFont3d;
        Map<String, TextRenderer> map2 = map.get(jmolFont);
        TextRenderer textRenderer = null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (map2 != null) {
            textRenderer = map2.get(string);
        } else {
            map2 = new Hashtable<String, TextRenderer>();
            bl2 = true;
        }
        if (textRenderer == null) {
            textRenderer = new TextRenderer(string, jmolFont);
            bl3 = true;
        }
        boolean bl4 = textRenderer.isInvalid = textRenderer.width == 0 || n + textRenderer.width <= 0 || n >= graphics3D.width || n2 + textRenderer.height <= 0 || n2 >= graphics3D.height;
        if (textRenderer.isInvalid) {
            return textRenderer;
        }
        if (bl2) {
            map.put(jmolFont, map2);
        }
        if (bl3) {
            textRenderer.setTranslucency(string, jmolFont, graphics3D);
            map2.put(string, textRenderer);
        }
        working = false;
        return textRenderer;
    }

    private void setTranslucency(String string, JmolFont jmolFont, Graphics3D graphics3D) {
        int[] nArray = graphics3D.apiPlatform.getTextPixels(string, jmolFont, graphics3D.platform.getGraphicsForTextOrImage(this.mapWidth, this.height), graphics3D.platform.offscreenImage, this.mapWidth, this.height, this.ascent);
        if (nArray == null) {
            return;
        }
        this.tmap = new byte[this.size];
        int n = nArray.length;
        while (--n >= 0) {
            int n2 = nArray[n] & 0xFF;
            if (n2 == 0) continue;
            this.tmap[n] = translucency[n2 >> 5];
        }
    }

    static {
        htFont3d = new Hashtable<JmolFont, Map<String, TextRenderer>>();
        htFont3dAntialias = new Hashtable<JmolFont, Map<String, TextRenderer>>();
    }
}

