/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.g3d;

import java.util.Arrays;
import java.util.Comparator;
import org.jmol.api.ApiPlatform;
import org.jmol.api.JmolRendererInterface;
import org.jmol.constant.EnumStereoMode;
import org.jmol.g3d.CircleRenderer;
import org.jmol.g3d.CylinderRenderer;
import org.jmol.g3d.HermiteRenderer;
import org.jmol.g3d.ImageRenderer;
import org.jmol.g3d.LineRenderer;
import org.jmol.g3d.Pixelator;
import org.jmol.g3d.PixelatorShaded;
import org.jmol.g3d.Platform3D;
import org.jmol.g3d.SphereRenderer;
import org.jmol.g3d.TextRenderer;
import org.jmol.g3d.TextSorter;
import org.jmol.g3d.TextString;
import org.jmol.g3d.TriangleRenderer;
import org.jmol.modelset.Atom;
import org.jmol.util.ArrayUtil;
import org.jmol.util.C;
import org.jmol.util.GData;
import org.jmol.util.JmolFont;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.MeshSurface;
import org.jmol.util.Normix;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.Rgb16;
import org.jmol.util.Shader;
import org.jmol.util.V3;
import org.jmol.viewer.Viewer;

public final class Graphics3D
extends GData
implements JmolRendererInterface {
    Platform3D platform;
    LineRenderer line3d;
    private CircleRenderer circle3d;
    private SphereRenderer sphere3d;
    private TriangleRenderer triangle3d;
    private CylinderRenderer cylinder3d;
    private HermiteRenderer hermite3d;
    private boolean isFullSceneAntialiasingEnabled;
    private boolean antialias2;
    private TextString[] strings = null;
    private int stringCount;
    private byte[] anaglyphChannelBytes;
    private boolean twoPass = false;
    private boolean addAllPixels;
    private boolean haveTranslucentObjects;
    protected int[] pbuf;
    protected int[] pbufT;
    protected int[] zbuf;
    protected int[] zbufT;
    protected int translucencyMask;
    private boolean renderLow;
    private int[] shadesCurrent;
    private int anaglyphLength;
    private boolean isScreened;
    private int argbNoisyUp;
    private int argbNoisyDn;
    private JmolFont currentFont;
    private Pixelator pixel;
    protected int zMargin;
    private int currentShadeIndex;
    private int lastRawColor;
    private int translucencyLog;
    private int saveAmbient;
    private int saveDiffuse;
    public static Comparator<TextString> sort;
    private boolean currentlyRendering;
    private final V3 vectorAB = new V3();
    private final V3 vectorAC = new V3();
    private final V3 vectorNormal = new V3();
    private static final short normixCount;
    private final V3[] transformedVectors = new V3[normixCount];
    private final byte[] shadeIndexes;
    private final byte[] shadeIndexes2Sided;
    private static byte nullShadeIndex;

    public void clear() {
        this.stringCount = 0;
        this.strings = null;
        TextRenderer.clearFontCache();
    }

    public void destroy() {
        this.releaseBuffers();
        this.platform = null;
        this.graphicsForMetrics = null;
    }

    public GData getGData() {
        return this;
    }

    void setZMargin(int n) {
        this.zMargin = n;
    }

    public Graphics3D() {
        int n = normixCount;
        while (--n >= 0) {
            this.transformedVectors[n] = new V3();
        }
        this.shadeIndexes = new byte[normixCount];
        this.shadeIndexes2Sided = new byte[normixCount];
    }

    public void initialize(ApiPlatform apiPlatform) {
        this.apiPlatform = apiPlatform;
        this.platform = new Platform3D(apiPlatform);
        this.graphicsForMetrics = this.platform.getGraphicsForMetrics();
        this.line3d = new LineRenderer(this);
        this.circle3d = new CircleRenderer(this);
        this.sphere3d = new SphereRenderer(this);
        this.triangle3d = new TriangleRenderer(this);
        this.cylinder3d = new CylinderRenderer(this);
        this.hermite3d = new HermiteRenderer(this);
    }

    public boolean currentlyRendering() {
        return this.currentlyRendering;
    }

    public void setWindowParameters(int n, int n2, boolean bl) {
        this.setWinParams(n, n2, bl);
        if (this.currentlyRendering) {
            this.endRendering();
        }
    }

    public boolean checkTranslucent(boolean bl) {
        if (bl) {
            this.haveTranslucentObjects = true;
        }
        return !this.twoPass || this.twoPass && this.isPass2 == bl;
    }

    public void beginRendering(Matrix3f matrix3f, boolean bl, boolean bl2, boolean bl3) {
        if (this.currentlyRendering) {
            this.endRendering();
        }
        this.renderLow = bl3;
        if (this.windowWidth != this.newWindowWidth || this.windowHeight != this.newWindowHeight || this.newAntialiasing != this.isFullSceneAntialiasingEnabled) {
            this.windowWidth = this.newWindowWidth;
            this.windowHeight = this.newWindowHeight;
            this.isFullSceneAntialiasingEnabled = this.newAntialiasing;
            this.releaseBuffers();
        }
        this.setRotationMatrix(matrix3f);
        this.antialiasEnabled = this.antialiasThisFrame = this.newAntialiasing;
        this.currentlyRendering = true;
        if (this.strings != null) {
            int n = Math.min(this.strings.length, this.stringCount);
            while (--n >= 0) {
                this.strings[n] = null;
            }
        }
        this.stringCount = 0;
        this.twoPass = true;
        this.isPass2 = false;
        this.colixCurrent = 0;
        this.haveTranslucentObjects = false;
        this.translucentCoverOnly = !bl;
        this.addAllPixels = true;
        if (this.pbuf == null) {
            this.platform.allocateBuffers(this.windowWidth, this.windowHeight, this.antialiasThisFrame, bl2);
            this.pbuf = this.platform.pBuffer;
            this.zbuf = this.platform.zBuffer;
        }
        this.setWidthHeight(this.antialiasThisFrame);
        this.platform.clearBuffer();
        if (this.backgroundImage != null) {
            this.plotImage(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, this.backgroundImage, null, (short)0, 0, 0);
        }
    }

    public void setBackgroundTransparent(boolean bl) {
        if (this.platform != null) {
            this.platform.setBackgroundTransparent(bl);
        }
    }

    private void releaseBuffers() {
        this.pbuf = null;
        this.zbuf = null;
        this.pbufT = null;
        this.zbufT = null;
        this.platform.releaseBuffers();
        this.line3d.clearLineCache();
    }

    public boolean setPass2(boolean bl) {
        if (!this.haveTranslucentObjects || !this.currentlyRendering) {
            return false;
        }
        this.isPass2 = true;
        this.colixCurrent = 0;
        this.addAllPixels = true;
        if (this.pbufT == null || this.antialias2 != bl) {
            this.platform.allocateTBuffers(bl);
            this.pbufT = this.platform.pBufferT;
            this.zbufT = this.platform.zBufferT;
        }
        this.antialias2 = bl;
        if (this.antialiasThisFrame && !this.antialias2) {
            this.downsampleFullSceneAntialiasing(true);
        }
        this.platform.clearTBuffer();
        return true;
    }

    public void endRendering() {
        if (!this.currentlyRendering) {
            return;
        }
        if (this.pbuf != null) {
            if (this.isPass2) {
                this.mergeOpaqueAndTranslucentBuffers();
            }
            if (this.antialiasThisFrame) {
                this.downsampleFullSceneAntialiasing(false);
            }
        }
        this.platform.setBackgroundColor(this.bgcolor);
        this.platform.notifyEndOfRendering();
        this.currentlyRendering = false;
    }

    public Object getScreenImage(boolean bl) {
        return this.platform.bufferedImage;
    }

    public void applyAnaglygh(EnumStereoMode enumStereoMode, int[] nArray) {
        switch (enumStereoMode) {
            case REDCYAN: {
                this.applyCyanAnaglyph();
                break;
            }
            case CUSTOM: {
                this.applyCustomAnaglyph(nArray);
                break;
            }
            case REDBLUE: {
                this.applyBlueAnaglyph();
                break;
            }
            case REDGREEN: {
                this.applyGreenAnaglyph();
                break;
            }
            case DOUBLE: {
                break;
            }
        }
    }

    public void snapshotAnaglyphChannelBytes() {
        if (this.currentlyRendering) {
            throw new NullPointerException();
        }
        this.anaglyphLength = this.windowWidth * this.windowHeight;
        if (this.anaglyphChannelBytes == null || this.anaglyphChannelBytes.length != this.anaglyphLength) {
            this.anaglyphChannelBytes = new byte[this.anaglyphLength];
        }
        int n = this.anaglyphLength;
        while (--n >= 0) {
            this.anaglyphChannelBytes[n] = (byte)this.pbuf[n];
        }
    }

    public void applyCustomAnaglyph(int[] nArray) {
        int n = nArray[0];
        int n2 = nArray[1] & 0xFFFFFF;
        int n3 = this.anaglyphLength;
        while (--n3 >= 0) {
            int n4 = this.anaglyphChannelBytes[n3] & 0xFF;
            n4 = (n4 | (n4 | n4 << 8) << 8) & n2;
            this.pbuf[n3] = this.pbuf[n3] & n | n4;
        }
    }

    public void applyGreenAnaglyph() {
        int n = this.anaglyphLength;
        while (--n >= 0) {
            int n2 = (this.anaglyphChannelBytes[n] & 0xFF) << 8;
            this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n2;
        }
    }

    public void applyBlueAnaglyph() {
        int n = this.anaglyphLength;
        while (--n >= 0) {
            int n2 = this.anaglyphChannelBytes[n] & 0xFF;
            this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n2;
        }
    }

    public void applyCyanAnaglyph() {
        int n = this.anaglyphLength;
        while (--n >= 0) {
            int n2 = this.anaglyphChannelBytes[n] & 0xFF;
            int n3 = n2 << 8 | n2;
            this.pbuf[n] = this.pbuf[n] & 0xFFFF0000 | n3;
        }
    }

    public void releaseScreenImage() {
        this.platform.clearScreenBufferThreaded();
    }

    public boolean haveTranslucentObjects() {
        return this.haveTranslucentObjects;
    }

    public void setTempZSlab(int n) {
        this.zSlab = n;
    }

    public void setZShade(boolean bl, int n, int n2, int n3) {
        if (bl) {
            this.setZShade2(n, n2, n3);
            this.pixel = new PixelatorShaded(this);
        } else {
            this.pixel = new Pixelator(this);
        }
    }

    private void downsampleFullSceneAntialiasing(boolean bl) {
        int n;
        int n2;
        int n3;
        int n4 = this.width;
        int n5 = 0;
        int n6 = 0;
        int n7 = this.bgcolor;
        if (bl) {
            n7 += (n7 & 0xFF) == 255 ? -1 : 1;
        }
        for (n3 = 0; n3 < this.pbuf.length; ++n3) {
            if (this.pbuf[n3] != 0) continue;
            this.pbuf[n3] = n7;
        }
        n7 &= 0xFFFFFF;
        n3 = this.windowHeight;
        while (--n3 >= 0) {
            n2 = this.windowWidth;
            while (--n2 >= 0) {
                n = (this.pbuf[n6] >> 2 & 0x3F3F3F3F) + (this.pbuf[n6++ + n4] >> 2 & 0x3F3F3F3F) + (this.pbuf[n6] >> 2 & 0x3F3F3F3F) + (this.pbuf[n6++ + n4] >> 2 & 0x3F3F3F3F);
                n += (n & 0xC0C0C0C0) >> 6;
                this.pbuf[n5] = n & 0xFFFFFF;
                ++n5;
            }
            n6 += n4;
        }
        if (bl) {
            n6 = 0;
            n5 = 0;
            n3 = this.windowHeight;
            while (--n3 >= 0) {
                n2 = this.windowWidth;
                while (--n2 >= 0) {
                    n = Math.min(this.zbuf[n6], this.zbuf[n6 + n4]);
                    n = Math.min(n, this.zbuf[++n6]);
                    if ((n = Math.min(n, this.zbuf[n6 + n4])) != Integer.MAX_VALUE) {
                        n >>= 1;
                    }
                    this.zbuf[n5] = this.pbuf[n5] == n7 ? Integer.MAX_VALUE : n;
                    ++n5;
                    ++n6;
                }
                n6 += n4;
            }
            this.antialiasThisFrame = false;
            this.setWidthHeight(false);
        }
    }

    void mergeOpaqueAndTranslucentBuffers() {
        if (this.pbufT == null) {
            return;
        }
        for (int i = 0; i < this.bufferSize; ++i) {
            Graphics3D.mergeBufferPixel(this.pbuf, i, this.pbufT[i], this.bgcolor);
        }
    }

    static void mergeBufferPixel(int[] nArray, int n, int n2, int n3) {
        if (n2 == 0) {
            return;
        }
        int n4 = nArray[n];
        if (n4 == n2) {
            return;
        }
        if (n4 == 0) {
            n4 = n3;
        }
        int n5 = n4 & 0xFF00FF;
        int n6 = n4 & 0xFF00;
        int n7 = n2 & 0xFF00FF;
        int n8 = n2 & 0xFF00;
        int n9 = n2 >> 24 & 0xF;
        switch (n9) {
            case 0: {
                n5 = n7;
                n6 = n8;
                break;
            }
            case 1: {
                n5 = (n7 << 2) + (n7 << 1) + n7 + n5 >> 3 & 0xFF00FF;
                n6 = (n8 << 2) + (n8 << 1) + n8 + n6 >> 3 & 0xFF00;
                break;
            }
            case 2: {
                n5 = (n7 << 1) + n7 + n5 >> 2 & 0xFF00FF;
                n6 = (n8 << 1) + n8 + n6 >> 2 & 0xFF00;
                break;
            }
            case 3: {
                n5 = (n7 << 2) + n7 + (n5 << 1) + n5 >> 3 & 0xFF00FF;
                n6 = (n8 << 2) + n8 + (n6 << 1) + n6 >> 3 & 0xFF00;
                break;
            }
            case 4: {
                n5 = n5 + n7 >> 1 & 0xFF00FF;
                n6 = n6 + n8 >> 1 & 0xFF00;
                break;
            }
            case 5: {
                n5 = (n7 << 1) + n7 + (n5 << 2) + n5 >> 3 & 0xFF00FF;
                n6 = (n8 << 1) + n8 + (n6 << 2) + n6 >> 3 & 0xFF00;
                break;
            }
            case 6: {
                n5 = (n5 << 1) + n5 + n7 >> 2 & 0xFF00FF;
                n6 = (n6 << 1) + n6 + n8 >> 2 & 0xFF00;
                break;
            }
            case 7: {
                n5 = (n5 << 2) + (n5 << 1) + n5 + n7 >> 3 & 0xFF00FF;
                n6 = (n6 << 2) + (n6 << 1) + n6 + n8 >> 3 & 0xFF00;
            }
        }
        nArray[n] = 0xFF000000 | n5 | n6;
    }

    public boolean hasContent() {
        return this.platform.hasContent();
    }

    public void setColor(int n) {
        this.argbNoisyUp = this.argbNoisyDn = n;
        this.argbCurrent = this.argbNoisyDn;
    }

    public boolean setColix(short s) {
        boolean bl = C.isColixLastAvailable(s);
        if (!bl && s == this.colixCurrent && this.currentShadeIndex == -1) {
            return true;
        }
        int n = s & 0x7800;
        if (n == 16384) {
            return false;
        }
        if (this.renderLow) {
            n = 0;
        }
        boolean bl2 = n != 0;
        this.isScreened = bl2 && n == 30720;
        if (!this.checkTranslucent(bl2 && !this.isScreened)) {
            return false;
        }
        boolean bl3 = this.addAllPixels = this.isPass2 || !bl2;
        if (this.isPass2) {
            this.translucencyMask = n << 13 | 0xFFFFFF;
            this.translucencyLog = n >> 11;
        } else {
            this.translucencyLog = 0;
        }
        this.colixCurrent = s;
        if (bl && this.argbCurrent != this.lastRawColor) {
            if (this.argbCurrent == 0) {
                this.argbCurrent = -1;
            }
            this.lastRawColor = this.argbCurrent;
            this.shader.setLastColix(this.argbCurrent, this.inGreyscaleMode);
        }
        this.shadesCurrent = this.getShades(s);
        this.currentShadeIndex = -1;
        this.setColor(this.getColorArgbOrGray(s));
        return true;
    }

    void addPixel(int n, int n2, int n3) {
        this.pixel.addPixel(n, n2, n3);
    }

    void clearPixel(int n, int n2) {
        this.pixel.clearPixel(n, n2);
    }

    public void drawFilledCircle(short s, short s2, int n, int n2, int n3, int n4) {
        boolean bl;
        if (this.isClippedZ(n4)) {
            return;
        }
        int n5 = (n + 1) / 2;
        boolean bl2 = bl = n2 < n5 || n2 + n5 >= this.width || n3 < n5 || n3 + n5 >= this.height;
        if (bl && this.isClippedXY(n, n2, n3)) {
            return;
        }
        if (s != 0 && this.setColix(s)) {
            if (bl) {
                this.circle3d.plotCircleCenteredClipped(n2, n3, n4, n);
            } else {
                this.circle3d.plotCircleCenteredUnclipped(n2, n3, n4, n);
            }
        }
        if (s2 != 0 && this.setColix(s2)) {
            if (bl) {
                this.circle3d.plotFilledCircleCenteredClipped(n2, n3, n4, n);
            } else {
                this.circle3d.plotFilledCircleCenteredUnclipped(n2, n3, n4, n);
            }
        }
    }

    public void volumeRender4(int n, int n2, int n3, int n4) {
        boolean bl;
        if (n == 1) {
            this.plotPixelClippedXYZ(n2, n3, n4);
            return;
        }
        if (this.isClippedZ(n4)) {
            return;
        }
        int n5 = (n + 1) / 2;
        boolean bl2 = bl = n2 < n5 || n2 + n5 >= this.width || n3 < n5 || n3 + n5 >= this.height;
        if (bl && this.isClippedXY(n, n2, n3)) {
            return;
        }
        if (bl) {
            this.circle3d.plotFilledCircleCenteredClipped(n2, n3, n4, n);
        } else {
            this.circle3d.plotFilledCircleCenteredUnclipped(n2, n3, n4, n);
        }
    }

    public void fillSphereXYZ(int n, int n2, int n3, int n4) {
        switch (n) {
            case 1: {
                this.plotPixelClippedArgb(this.argbCurrent, n2, n3, n4);
                return;
            }
            case 0: {
                return;
            }
        }
        if (n <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, !this.addAllPixels, n, n2, n3, n4, null, null, null, -1, null, this.addAllPixels);
        }
    }

    public void volumeRender(boolean bl) {
        if (bl) {
            this.saveAmbient = this.shader.ambientPercent;
            this.saveDiffuse = this.shader.diffusePercent;
            this.setAmbientPercent(100);
            this.setDiffusePercent(0);
        } else {
            this.setAmbientPercent(this.saveAmbient);
            this.setDiffusePercent(this.saveDiffuse);
        }
    }

    public void fillSphereI(int n, P3i p3i) {
        this.fillSphereXYZ(n, p3i.x, p3i.y, p3i.z);
    }

    public void fillSphere(int n, P3 p3) {
        this.fillSphereXYZ(n, Math.round(p3.x), Math.round(p3.y), Math.round(p3.z));
    }

    public void fillEllipsoid(P3 p3, P3[] p3Array, int n, int n2, int n3, int n4, Matrix3f matrix3f, double[] dArray, Matrix4f matrix4f, int n5, P3i[] p3iArray) {
        switch (n4) {
            case 1: {
                this.plotPixelClippedArgb(this.argbCurrent, n, n2, n3);
                return;
            }
            case 0: {
                return;
            }
        }
        if (n4 <= (this.antialiasThisFrame ? 2000 : 1000)) {
            this.sphere3d.render(this.shadesCurrent, !this.addAllPixels, n4, n, n2, n3, matrix3f, dArray, matrix4f, n5, p3iArray, this.addAllPixels);
        }
    }

    public void drawRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (n4 != 0 && this.isClippedZ(n4)) {
            return;
        }
        int n7 = n5 - 1;
        int n8 = n6 - 1;
        int n9 = n + n7;
        int n10 = n2 + n8;
        if (n2 >= 0 && n2 < this.height) {
            this.drawHLine(n, n2, n3, n7);
        }
        if (n10 >= 0 && n10 < this.height) {
            this.drawHLine(n, n10, n3, n7);
        }
        if (n >= 0 && n < this.width) {
            this.drawVLine(n, n2, n3, n8);
        }
        if (n9 >= 0 && n9 < this.width) {
            this.drawVLine(n9, n2, n3, n8);
        }
    }

    private void drawHLine(int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            n += n4;
            n4 = -n4;
        }
        if (n < 0) {
            n4 += n;
            n = 0;
        }
        if (n + n4 >= this.width) {
            n4 = this.width - 1 - n;
        }
        int n5 = n + this.width * n2;
        if (this.addAllPixels) {
            for (int i = 0; i <= n4; ++i) {
                if (n3 < this.zbuf[n5]) {
                    this.addPixel(n5, n3, this.argbCurrent);
                }
                ++n5;
            }
            return;
        }
        boolean bl = ((n ^ n2) & 1) != 0;
        for (int i = 0; i <= n4; ++i) {
            if ((bl = !bl) && n3 < this.zbuf[n5]) {
                this.addPixel(n5, n3, this.argbCurrent);
            }
            ++n5;
        }
    }

    private void drawVLine(int n, int n2, int n3, int n4) {
        if (n4 < 0) {
            n2 += n4;
            n4 = -n4;
        }
        if (n2 < 0) {
            n4 += n2;
            n2 = 0;
        }
        if (n2 + n4 >= this.height) {
            n4 = this.height - 1 - n2;
        }
        int n5 = n + this.width * n2;
        if (this.addAllPixels) {
            for (int i = 0; i <= n4; ++i) {
                if (n3 < this.zbuf[n5]) {
                    this.addPixel(n5, n3, this.argbCurrent);
                }
                n5 += this.width;
            }
            return;
        }
        boolean bl = ((n ^ n2) & 1) != 0;
        for (int i = 0; i <= n4; ++i) {
            if ((bl = !bl) && n3 < this.zbuf[n5]) {
                this.addPixel(n5, n3, this.argbCurrent);
            }
            n5 += this.width;
        }
    }

    public void fillRect(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isClippedZ(n4)) {
            return;
        }
        if (n < 0) {
            if ((n5 += n) <= 0) {
                return;
            }
            n = 0;
        }
        if (n + n5 > this.width && (n5 = this.width - n) <= 0) {
            return;
        }
        if (n2 < 0) {
            if ((n6 += n2) <= 0) {
                return;
            }
            n2 = 0;
        }
        if (n2 + n6 > this.height) {
            n6 = this.height - n2;
        }
        while (--n6 >= 0) {
            this.plotPixelsUnclippedCount(n5, n, n2++, n3);
        }
    }

    public void drawString(String string, JmolFont jmolFont, int n, int n2, int n3, int n4, short s) {
        this.currentShadeIndex = 0;
        if (string == null) {
            return;
        }
        if (this.isClippedZ(n4)) {
            return;
        }
        this.drawStringNoSlab(string, jmolFont, n, n2, n3, s);
    }

    public void drawStringNoSlab(String string, JmolFont jmolFont, int n, int n2, int n3, short s) {
        if (string == null) {
            return;
        }
        if (this.strings == null) {
            this.strings = new TextString[10];
        }
        if (this.stringCount == this.strings.length) {
            this.strings = (TextString[])ArrayUtil.doubleLength(this.strings);
        }
        TextString textString = new TextString();
        textString.setText(string, jmolFont == null ? this.currentFont : (this.currentFont = jmolFont), this.argbCurrent, C.isColixTranslucent(s) ? this.getColorArgbOrGray(s) & 0xFFFFFF | (s & 0x7800) << 13 : 0, n, n2, n3);
        this.strings[this.stringCount++] = textString;
    }

    public void renderAllStrings(Object object) {
        if (this.strings == null) {
            return;
        }
        if (this.stringCount >= 2) {
            if (sort == null) {
                sort = new TextSorter();
            }
            Arrays.sort(this.strings, sort);
        }
        for (int i = 0; i < this.stringCount; ++i) {
            TextString textString = this.strings[i];
            this.plotText(textString.x, textString.y, textString.z, textString.argb, textString.bgargb, textString.text, textString.font, (JmolRendererInterface)object);
        }
        this.strings = null;
        this.stringCount = 0;
    }

    public void plotText(int n, int n2, int n3, int n4, int n5, String string, JmolFont jmolFont, JmolRendererInterface jmolRendererInterface) {
        TextRenderer.plot(n, n2, n3, n4, n5, string, jmolFont, this, jmolRendererInterface, this.antialiasThisFrame);
    }

    public void drawImage(Object object, int n, int n2, int n3, int n4, short s, int n5, int n6) {
        if (object == null || n5 == 0 || n6 == 0 || this.isClippedZ(n4)) {
            return;
        }
        this.plotImage(n, n2, n3, object, null, s, n5, n6);
    }

    public void plotImage(int n, int n2, int n3, Object object, JmolRendererInterface jmolRendererInterface, short s, int n4, int n5) {
        this.setColix(s);
        if (!this.isPass2) {
            this.translucencyMask = -1;
        }
        if (s == 0) {
            this.argbCurrent = 0;
        }
        ImageRenderer.plotImage(n, n2, n3, object, this, jmolRendererInterface, this.antialiasThisFrame, this.argbCurrent, n4, n5);
    }

    public void setFontFid(byte by) {
        this.currentFont = JmolFont.getFont3D(by);
    }

    public void setFont(JmolFont jmolFont) {
        this.currentFont = jmolFont;
    }

    public JmolFont getFont3DCurrent() {
        return this.currentFont;
    }

    public void drawPixel(int n, int n2, int n3) {
        this.plotPixelClippedXYZ(n, n2, n3);
    }

    public void drawPoints(int n, int[] nArray, int n2) {
        if (n2 > 1) {
            float f = (float)(n2 * n2) * 0.8f;
            for (int i = -n2; i < n2; ++i) {
                for (int j = -n2; j < n2; ++j) {
                    if ((float)(i * i + j * j) > f) continue;
                    this.plotPoints(n, nArray, i, j);
                    this.plotPoints(n, nArray, i, j);
                }
            }
        } else {
            this.plotPoints(n, nArray, 0, 0);
        }
    }

    public void drawDashedLine(int n, int n2, P3i p3i, P3i p3i2) {
        this.line3d.plotDashedLine(this.argbCurrent, !this.addAllPixels, n, n2, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z, true);
    }

    public void drawDottedLine(P3i p3i, P3i p3i2) {
        this.line3d.plotDashedLine(this.argbCurrent, !this.addAllPixels, 2, 1, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z, true);
    }

    public void drawLineXYZ(int n, int n2, int n3, int n4, int n5, int n6) {
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, n, n2, n3, n4, n5, n6, true);
    }

    public void drawLine(short s, short s2, int n, int n2, int n3, int n4, int n5, int n6) {
        if (!this.setColix(s)) {
            s = 0;
        }
        boolean bl = !this.addAllPixels;
        int n7 = this.argbCurrent;
        if (!this.setColix(s2)) {
            s2 = 0;
        }
        if (s == 0 && s2 == 0) {
            return;
        }
        this.line3d.plotLine(n7, bl, this.argbCurrent, !this.addAllPixels, n, n2, n3, n4, n5, n6, true);
    }

    public void drawLineAB(P3i p3i, P3i p3i2) {
        this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z, true);
    }

    public void fillCylinderXYZ(short s, short s2, byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        boolean bl;
        if (!this.setColix(s)) {
            s = 0;
        }
        boolean bl2 = bl = !this.addAllPixels;
        if (!this.setColix(s2)) {
            s2 = 0;
        }
        if (s == 0 && s2 == 0) {
            return;
        }
        this.cylinder3d.render(s, s2, bl, !this.addAllPixels, by, n, n2, n3, n4, n5, n6, n7);
    }

    public void fillCylinderScreen(byte by, int n, int n2, int n3, int n4, int n5, int n6, int n7) {
        this.cylinder3d.render(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, by, n, n2, n3, n4, n5, n6, n7);
    }

    public void fillCylinderScreen3I(byte by, int n, P3i p3i, P3i p3i2, P3 p3, P3 p32, float f) {
        this.cylinder3d.render(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, by, n, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z);
    }

    public void fillCylinder(byte by, int n, P3i p3i, P3i p3i2) {
        this.cylinder3d.render(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, by, n, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z);
    }

    public void fillCylinderBits(byte by, int n, P3 p3, P3 p32) {
        this.cylinder3d.renderBits(this.colixCurrent, this.colixCurrent, !this.addAllPixels, !this.addAllPixels, by, n, p3.x, p3.y, p3.z, p32.x, p32.y, p32.z);
    }

    public void fillConeScreen(byte by, int n, P3i p3i, P3i p3i2, boolean bl) {
        this.cylinder3d.renderCone(this.colixCurrent, !this.addAllPixels, by, n, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z, false, bl);
    }

    public void fillConeSceen3f(byte by, int n, P3 p3, P3 p32) {
        this.cylinder3d.renderCone(this.colixCurrent, !this.addAllPixels, by, n, p3.x, p3.y, p3.z, p32.x, p32.y, p32.z, true, false);
    }

    public void drawHermite4(int n, P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4) {
        this.hermite3d.renderHermiteRope(false, n, 0, 0, 0, p3i, p3i2, p3i3, p3i4);
    }

    public void drawHermite7(boolean bl, boolean bl2, int n, P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4, P3i p3i5, P3i p3i6, P3i p3i7, P3i p3i8, int n2, short s) {
        if (s == 0) {
            this.hermite3d.renderHermiteRibbon(bl, bl2, n, p3i, p3i2, p3i3, p3i4, p3i5, p3i6, p3i7, p3i8, n2, 0);
            return;
        }
        this.hermite3d.renderHermiteRibbon(bl, bl2, n, p3i, p3i2, p3i3, p3i4, p3i5, p3i6, p3i7, p3i8, n2, 1);
        short s2 = this.colixCurrent;
        this.setColix(s);
        this.hermite3d.renderHermiteRibbon(bl, bl2, n, p3i, p3i2, p3i3, p3i4, p3i5, p3i6, p3i7, p3i8, n2, -1);
        this.setColix(s2);
    }

    public void fillHermite(int n, int n2, int n3, int n4, P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4) {
        this.hermite3d.renderHermiteRope(true, n, n2, n3, n4, p3i, p3i2, p3i3, p3i4);
    }

    public void drawTriangle3C(P3i p3i, short s, P3i p3i2, short s2, P3i p3i3, short s3, int n) {
        if ((n & 1) == 1) {
            this.drawLine(s, s2, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z);
        }
        if ((n & 2) == 2) {
            this.drawLine(s2, s3, p3i2.x, p3i2.y, p3i2.z, p3i3.x, p3i3.y, p3i3.z);
        }
        if ((n & 4) == 4) {
            this.drawLine(s, s3, p3i.x, p3i.y, p3i.z, p3i3.x, p3i3.y, p3i3.z);
        }
    }

    public void drawTriangle3I(P3i p3i, P3i p3i2, P3i p3i3, int n) {
        if ((n & 1) == 1) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, p3i.x, p3i.y, p3i.z, p3i2.x, p3i2.y, p3i2.z, true);
        }
        if ((n & 2) == 2) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, p3i2.x, p3i2.y, p3i2.z, p3i3.x, p3i3.y, p3i3.z, true);
        }
        if ((n & 4) == 4) {
            this.line3d.plotLine(this.argbCurrent, !this.addAllPixels, this.argbCurrent, !this.addAllPixels, p3i.x, p3i.y, p3i.z, p3i3.x, p3i3.y, p3i3.z, true);
        }
    }

    public void fillTriangleTwoSided(short s, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        this.setColorNoisy(this.getShadeIndex(s));
        this.triangle3d.fillTriangleXYZ(n, n2, n3, n4, n5, n6, n7, n8, n9, false);
    }

    public void fillTriangle3f(P3 p3, P3 p32, P3 p33, boolean bl) {
        int n = this.getShadeIndexP3(p3, p32, p33);
        if (bl) {
            this.setColorNoisy(n);
        } else {
            this.setColor(this.shadesCurrent[n]);
        }
        this.triangle3d.fillTriangleP3f(p3, p32, p33, false);
    }

    public void fillTriangle3i(P3i p3i, P3i p3i2, P3i p3i3, P3 p3, P3 p32, P3 p33) {
        this.triangle3d.fillTriangleP3i(p3i, p3i2, p3i3, false);
    }

    public void fillTriangle(P3i p3i, short s, short s2, P3i p3i2, short s3, short s4, P3i p3i3, short s5, short s6, float f) {
        boolean bl;
        if (!this.isPass2 && s2 == s4 && s2 == s6 && s == s3 && s == s5) {
            this.setTriangleColixAndShadeIndex(s, this.getShadeIndex(s2));
            bl = false;
        } else {
            if (!this.setTriangleTranslucency(s, s3, s5)) {
                return;
            }
            this.triangle3d.setGouraud(this.getShades(s)[this.getShadeIndex(s2)], this.getShades(s3)[this.getShadeIndex(s4)], this.getShades(s5)[this.getShadeIndex(s6)]);
            bl = true;
        }
        this.triangle3d.fillTriangleP3if(p3i, p3i2, p3i3, f, bl);
    }

    public void fillTriangle3CN(P3i p3i, short s, short s2, P3i p3i2, short s3, short s4, P3i p3i3, short s5, short s6) {
        boolean bl;
        if (!this.isPass2 && s2 == s4 && s2 == s6 && s == s3 && s == s5) {
            this.setTriangleColixAndShadeIndex(s, this.getShadeIndex(s2));
            bl = false;
        } else {
            if (!this.setTriangleTranslucency(s, s3, s5)) {
                return;
            }
            this.triangle3d.setGouraud(this.getShades(s)[this.getShadeIndex(s2)], this.getShades(s3)[this.getShadeIndex(s4)], this.getShades(s5)[this.getShadeIndex(s6)]);
            bl = true;
        }
        this.triangle3d.fillTriangleP3i(p3i, p3i2, p3i3, bl);
    }

    private void setTriangleColixAndShadeIndex(short s, int n) {
        if (s == this.colixCurrent && this.currentShadeIndex == n) {
            return;
        }
        this.currentShadeIndex = -1;
        this.setColix(s);
        this.setColorNoisy(n);
    }

    private boolean setTriangleTranslucency(short s, short s2, short s3) {
        if (!this.isPass2) {
            return true;
        }
        int n = s & 0x7800;
        int n2 = s2 & 0x7800;
        int n3 = s3 & 0x7800;
        int n4 = GData.roundInt(((n &= 0xFFFFBFFF) + (n2 &= 0xFFFFBFFF) + (n3 &= 0xFFFFBFFF)) / 3) & 0x7800;
        this.translucencyMask = n4 << 13 | 0xFFFFFF;
        return true;
    }

    public void drawQuadrilateral(short s, P3i p3i, P3i p3i2, P3i p3i3, P3i p3i4) {
        this.setColix(s);
        this.drawLineAB(p3i, p3i2);
        this.drawLineAB(p3i2, p3i3);
        this.drawLineAB(p3i3, p3i4);
        this.drawLineAB(p3i4, p3i);
    }

    public void fillQuadrilateral(P3 p3, P3 p32, P3 p33, P3 p34) {
        this.setColorNoisy(this.getShadeIndexP3(p3, p32, p33));
        this.triangle3d.fillTriangleP3f(p3, p32, p33, false);
        this.triangle3d.fillTriangleP3f(p3, p33, p34, false);
    }

    public void fillQuadrilateral3i(P3i p3i, short s, short s2, P3i p3i2, short s3, short s4, P3i p3i3, short s5, short s6, P3i p3i4, short s7, short s8) {
        this.fillTriangle3CN(p3i, s, s2, p3i2, s3, s4, p3i3, s5, s6);
        this.fillTriangle3CN(p3i, s, s2, p3i3, s5, s6, p3i4, s7, s8);
    }

    public void drawSurface(MeshSurface meshSurface, short s) {
    }

    void plotPixelClippedXYZ(int n, int n2, int n3) {
        if (this.isClipped3(n, n2, n3)) {
            return;
        }
        int n4 = n2 * this.width + n;
        if (n3 < this.zbuf[n4]) {
            this.addPixel(n4, n3, this.argbCurrent);
        }
    }

    public void plotPixelClippedP3i(P3i p3i) {
        this.plotPixelClippedXYZ(p3i.x, p3i.y, p3i.z);
    }

    void plotPixelClippedArgb(int n, int n2, int n3, int n4) {
        if (this.isClipped3(n2, n3, n4)) {
            return;
        }
        int n5 = n3 * this.width + n2;
        if (n4 < this.zbuf[n5]) {
            this.addPixel(n5, n4, n);
        }
    }

    public void plotImagePixel(int n, int n2, int n3, int n4, int n5, int n6) {
        if (this.isClipped(n2, n3)) {
            return;
        }
        int n7 = n3 * this.width + n2;
        if (n4 < this.zbuf[n7]) {
            this.shadeTextPixel(n7, n4, n, n6, n5);
        }
    }

    void plotPixelClippedScreened(int n, boolean bl, int n2, int n3, int n4) {
        if (this.isClipped3(n2, n3, n4)) {
            return;
        }
        if (bl && ((n2 ^ n3) & 1) != 0) {
            return;
        }
        int n5 = n3 * this.width + n2;
        if (n4 < this.zbuf[n5]) {
            this.addPixel(n5, n4, n);
        }
    }

    void plotPixelUnclipped(int n, int n2, int n3) {
        int n4 = n2 * this.width + n;
        if (n3 < this.zbuf[n4]) {
            this.addPixel(n4, n3, this.argbCurrent);
        }
    }

    void plotPixelUnclippedArgb(int n, int n2, int n3, int n4) {
        int n5 = n3 * this.width + n2;
        if (n4 < this.zbuf[n5]) {
            this.addPixel(n5, n4, n);
        }
    }

    void plotPixelsClipped(int n, int n2, int n3, int n4) {
        if (n3 < 0 || n3 >= this.height || n2 >= this.width) {
            return;
        }
        if (n2 < 0) {
            n += n2;
            n2 = 0;
        }
        if (n + n2 > this.width) {
            n = this.width - n2;
        }
        if (n <= 0) {
            return;
        }
        int n5 = n3 * this.width + n2;
        int n6 = n5 + n;
        int n7 = 1;
        if (!this.addAllPixels) {
            n7 = 2;
            if (((n2 ^ n3) & 1) != 0) {
                ++n5;
            }
        }
        while (n5 < n6) {
            if (n4 < this.zbuf[n5]) {
                this.addPixel(n5, n4, this.argbCurrent);
            }
            n5 += n7;
        }
    }

    void plotPixelsClippedRaster(int n, int n2, int n3, int n4, int n5, Rgb16 rgb16, Rgb16 rgb162) {
        if (n <= 0 || n3 < 0 || n3 >= this.height || n2 >= this.width || n4 < this.slab && n5 < this.slab || n4 > this.depth && n5 > this.depth) {
            return;
        }
        int n6 = (n2 << 16) + (n3 << 1) ^ 0x33333333;
        int n7 = (n4 << 10) + 512;
        int n8 = n5 - n4;
        int n9 = n / 2;
        int n10 = GData.roundInt(((n8 << 10) + (n8 >= 0 ? n9 : -n9)) / n);
        if (n2 < 0) {
            n2 = -n2;
            n7 += n10 * n2;
            if ((n -= n2) <= 0) {
                return;
            }
            n2 = 0;
        }
        if (n + n2 > this.width) {
            n = this.width - n2;
        }
        boolean bl = ((n2 ^ n3) & 1) != 0;
        int n11 = n3 * this.width + n2;
        if (rgb16 == null) {
            while (--n >= 0) {
                int n12;
                if ((this.addAllPixels || (bl = !bl)) && (n12 = n7 >> 10) >= this.slab && n12 <= this.depth && n12 < this.zbuf[n11]) {
                    int n13 = (n6 = (n6 << 16) + (n6 << 1) + n6 & Integer.MAX_VALUE) >> 16 & 7;
                    this.addPixel(n11, n12, n13 == 0 ? this.argbNoisyDn : (n13 == 1 ? this.argbNoisyUp : this.argbCurrent));
                }
                ++n11;
                n7 += n10;
            }
        } else {
            int n14 = rgb16.rScaled << 8;
            int n15 = (rgb162.rScaled - rgb16.rScaled << 8) / n;
            int n16 = rgb16.gScaled;
            int n17 = (rgb162.gScaled - n16) / n;
            int n18 = rgb16.bScaled;
            int n19 = (rgb162.bScaled - n18) / n;
            while (--n >= 0) {
                int n20;
                if ((this.addAllPixels || (bl = !bl)) && (n20 = n7 >> 10) >= this.slab && n20 <= this.depth && n20 < this.zbuf[n11]) {
                    this.addPixel(n11, n20, 0xFF000000 | n14 & 0xFF0000 | n16 & 0xFF00 | n18 >> 8 & 0xFF);
                }
                ++n11;
                n7 += n10;
                n14 += n15;
                n16 += n17;
                n18 += n19;
            }
        }
    }

    void plotPixelsUnclippedRaster(int n, int n2, int n3, int n4, int n5, Rgb16 rgb16, Rgb16 rgb162) {
        if (n <= 0) {
            return;
        }
        int n6 = ((n2 << 16) + (n3 << 1) ^ 0x33333333) & Integer.MAX_VALUE;
        boolean bl = ((n2 ^ n3) & 1) != 0;
        int n7 = (n4 << 10) + 512;
        int n8 = n5 - n4;
        int n9 = n / 2;
        int n10 = GData.roundInt(((n8 << 10) + (n8 >= 0 ? n9 : -n9)) / n);
        int n11 = n3 * this.width + n2;
        if (rgb16 == null) {
            while (--n >= 0) {
                int n12;
                if ((this.addAllPixels || (bl = !bl)) && (n12 = n7 >> 10) < this.zbuf[n11]) {
                    int n13 = (n6 = (n6 << 16) + (n6 << 1) + n6 & Integer.MAX_VALUE) >> 16 & 7;
                    this.addPixel(n11, n12, n13 == 0 ? this.argbNoisyDn : (n13 == 1 ? this.argbNoisyUp : this.argbCurrent));
                }
                ++n11;
                n7 += n10;
            }
        } else {
            int n14 = rgb16.rScaled << 8;
            int n15 = GData.roundInt((rgb162.rScaled - rgb16.rScaled << 8) / n);
            int n16 = rgb16.gScaled;
            int n17 = GData.roundInt((rgb162.gScaled - n16) / n);
            int n18 = rgb16.bScaled;
            int n19 = GData.roundInt((rgb162.bScaled - n18) / n);
            while (--n >= 0) {
                int n20;
                if ((this.addAllPixels || (bl = !bl)) && (n20 = n7 >> 10) < this.zbuf[n11]) {
                    this.addPixel(n11, n20, 0xFF000000 | n14 & 0xFF0000 | n16 & 0xFF00 | n18 >> 8 & 0xFF);
                }
                ++n11;
                n7 += n10;
                n14 += n15;
                n16 += n17;
                n18 += n19;
            }
        }
    }

    void plotPixelsUnclippedCount(int n, int n2, int n3, int n4) {
        int n5 = n3 * this.width + n2;
        if (this.addAllPixels) {
            while (--n >= 0) {
                if (n4 < this.zbuf[n5]) {
                    this.addPixel(n5, n4, this.argbCurrent);
                }
                ++n5;
            }
        } else {
            int n6 = n5 + n;
            if (((n2 ^ n3) & 1) != 0 && ++n5 == n6) {
                return;
            }
            do {
                if (n4 >= this.zbuf[n5]) continue;
                this.addPixel(n5, n4, this.argbCurrent);
            } while ((n5 += 2) < n6);
        }
    }

    private void plotPoints(int n, int[] nArray, int n2, int n3) {
        int n4 = n * 3;
        while (n4 > 0) {
            int n5;
            int n6;
            int n7;
            int n8 = nArray[--n4];
            --n4;
            if (this.isClipped3(n7 = nArray[--n4] + n2, n6 = nArray[n4] + n3, n8)) continue;
            if (n8 < this.zbuf[n5 = n6 * this.width + n7++]) {
                this.addPixel(n5, n8, this.argbCurrent);
            }
            if (!this.antialiasThisFrame) continue;
            n5 = n6 * this.width + n7;
            if (!this.isClipped3(n7, n6, n8) && n8 < this.zbuf[n5]) {
                this.addPixel(n5, n8, this.argbCurrent);
            }
            n5 = ++n6 * this.width + n7;
            if (!this.isClipped3(n7, n6, n8) && n8 < this.zbuf[n5]) {
                this.addPixel(n5, n8, this.argbCurrent);
            }
            n5 = n6 * this.width + --n7;
            if (this.isClipped3(n7, n6, n8) || n8 >= this.zbuf[n5]) continue;
            this.addPixel(n5, n8, this.argbCurrent);
        }
    }

    void setColorNoisy(int n) {
        this.currentShadeIndex = n;
        this.argbCurrent = this.shadesCurrent[n];
        this.argbNoisyUp = this.shadesCurrent[n < Shader.shadeIndexLast ? n + 1 : Shader.shadeIndexLast];
        this.argbNoisyDn = this.shadesCurrent[n > 0 ? n - 1 : 0];
    }

    public void setNoisySurfaceShade(P3i p3i, P3i p3i2, P3i p3i3) {
        int n;
        this.vectorAB.set(p3i2.x - p3i.x, p3i2.y - p3i.y, p3i2.z - p3i.z);
        if (p3i3 == null) {
            n = this.shader.getShadeIndex(-this.vectorAB.x, -this.vectorAB.y, this.vectorAB.z);
        } else {
            this.vectorAC.set(p3i3.x - p3i.x, p3i3.y - p3i.y, p3i3.z - p3i.z);
            this.vectorAB.cross(this.vectorAB, this.vectorAC);
            int n2 = n = this.vectorAB.z >= 0.0f ? this.shader.getShadeIndex(-this.vectorAB.x, -this.vectorAB.y, this.vectorAB.z) : this.shader.getShadeIndex(this.vectorAB.x, this.vectorAB.y, -this.vectorAB.z);
        }
        if (n > Shader.shadeIndexNoisyLimit) {
            n = Shader.shadeIndexNoisyLimit;
        }
        this.setColorNoisy(n);
    }

    private int getShadeIndexP3(P3 p3, P3 p32, P3 p33) {
        this.vectorAB.sub2(p32, p3);
        this.vectorAC.sub2(p33, p3);
        this.vectorNormal.cross(this.vectorAB, this.vectorAC);
        int n = this.vectorNormal.z >= 0.0f ? this.shader.getShadeIndex(-this.vectorNormal.x, -this.vectorNormal.y, this.vectorNormal.z) : this.shader.getShadeIndex(this.vectorNormal.x, this.vectorNormal.y, -this.vectorNormal.z);
        return n;
    }

    public void renderBackground(JmolRendererInterface jmolRendererInterface) {
        if (this.backgroundImage != null) {
            this.plotImage(Integer.MIN_VALUE, 0, Integer.MIN_VALUE, this.backgroundImage, jmolRendererInterface, (short)0, 0, 0);
        }
    }

    public void drawAtom(Atom atom) {
        this.fillSphereXYZ(atom.screenDiameter, atom.screenX, atom.screenY, atom.screenZ);
    }

    public int getExportType() {
        return 0;
    }

    public String getExportName() {
        return null;
    }

    public boolean canDoTriangles() {
        return true;
    }

    public boolean isCartesianExport() {
        return false;
    }

    public JmolRendererInterface initializeExporter(String string, Viewer viewer, double d, GData gData, Object object) {
        return null;
    }

    public String finalizeOutput() {
        return null;
    }

    public void drawBond(P3 p3, P3 p32, short s, short s2, byte by, short s3, int n) {
    }

    public boolean drawEllipse(P3 p3, P3 p32, P3 p33, boolean bl, boolean bl2) {
        return false;
    }

    public double getPrivateKey() {
        return 0.0;
    }

    public void clearFontCache() {
        TextRenderer.clearFontCache();
    }

    public V3[] getTransformedVertexVectors() {
        return this.transformedVectors;
    }

    public boolean isDirectedTowardsCamera(short s) {
        return s < 0 || this.transformedVectors[s].z > 0.0f;
    }

    public void setRotationMatrix(Matrix3f matrix3f) {
        V3[] v3Array = Normix.getVertexVectors();
        int n = normixCount;
        while (--n >= 0) {
            V3 v3 = this.transformedVectors[n];
            matrix3f.transform2(v3Array[n], v3);
            this.shadeIndexes[n] = this.shader.getShadeB(v3.x, -v3.y, v3.z);
            this.shadeIndexes2Sided[n] = v3.z >= 0.0f ? this.shadeIndexes[n] : this.shader.getShadeB(-v3.x, v3.y, -v3.z);
        }
    }

    public int getShadeIndex(short s) {
        return s == -10000 || s == 9999 ? nullShadeIndex : (s < 0 ? this.shadeIndexes2Sided[~s] : this.shadeIndexes[s]);
    }

    public void renderCrossHairs(int[] nArray, int n, int n2, P3 p3, float f) {
        boolean bl = this.isAntialiased();
        this.setColix((short)(f < 0.0f ? 10 : (f > 100.0f ? 11 : 23)));
        int n3 = Math.max(Math.min(this.width, Math.round(p3.x)), 0);
        int n4 = Math.max(Math.min(this.height, Math.round(p3.y)), 0);
        int n5 = Math.round(p3.z) + 1;
        int n6 = bl ? 8 : 4;
        int n7 = bl ? 20 : 10;
        int n8 = bl ? 2 : 1;
        this.drawRect(n3 - n6, n4, n5, 0, n7, n8);
        this.drawRect(n3, n4 - n6, n5, 0, n8, n7);
        this.drawRect(n3 - n6, n4 - n6, n5, 0, n7, n7);
        n6 = n7;
        this.setColix((float)nArray[1] < p3.x ? (short)21 : 11);
        this.drawRect(n3 - n6, n4, n5, 0, n7 >>= 1, n8);
        this.setColix((float)nArray[0] > p3.x ? (short)21 : 11);
        this.drawRect(n3 + n7, n4, n5, 0, n7, n8);
        this.setColix((float)nArray[3] < p3.y ? (short)21 : 11);
        this.drawRect(n3, n4 - n6, n5, 0, n8, n7);
        this.setColix((float)nArray[2] > p3.y ? (short)21 : 11);
        this.drawRect(n3, n4 + n7, n5, 0, n8, n7);
    }

    public boolean initializeOutput(String string, Viewer viewer, double d, GData gData, Object object) {
        return false;
    }

    void shadeTextPixel(int n, int n2, int n3, int n4, int n5) {
        switch (n5) {
            case 8: {
                this.addPixel(n, n2, n3);
                return;
            }
        }
        if (n4 != 0) {
            Graphics3D.mergeBufferPixel(this.pbuf, n, n4, this.bgcolor);
        }
        if ((n5 += this.translucencyLog) > 7) {
            return;
        }
        Graphics3D.mergeBufferPixel(this.pbuf, n, n3 & 0xFFFFFF | n5 << 24, this.bgcolor);
        this.zbuf[n] = n2;
    }

    static {
        normixCount = Normix.getNormixCount();
        nullShadeIndex = (byte)50;
    }
}

