/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export;

import java.awt.Image;
import java.util.Hashtable;
import org.jmol.export.___Exporter;
import org.jmol.modelset.Atom;
import org.jmol.util.AxisAngle4f;
import org.jmol.util.BS;
import org.jmol.util.C;
import org.jmol.util.JmolFont;
import org.jmol.util.JmolList;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.Tuple3f;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class __CartesianExporter
extends ___Exporter {
    protected AxisAngle4f viewpoint = new AxisAngle4f();
    protected P3 ptScaled = new P3();
    protected Matrix4f sphereMatrix = new Matrix4f();

    public __CartesianExporter() {
        this.exportType = 1;
        this.lineWidthMad = (short)100;
    }

    protected P3 getModelCenter() {
        return this.referenceCenter;
    }

    protected P3 getCameraPosition() {
        P3 p3 = new P3();
        P3 p32 = P3.new3(this.screenWidth / 2, this.screenHeight / 2, 0.0f);
        this.viewer.unTransformPoint(p32, p3);
        p3.sub(this.center);
        this.tempP3.set(this.screenWidth / 2, this.screenHeight / 2, this.cameraDistance * this.scalePixelsPerAngstrom);
        this.viewer.unTransformPoint(this.tempP3, this.tempP3);
        this.tempP3.sub(this.center);
        p3.add(this.tempP3);
        return this.cameraPosition;
    }

    private void setTempPoints(P3 p3, P3 p32, boolean bl) {
        if (bl) {
            this.tempP1.setT(p3);
            this.tempP2.setT(p32);
        } else {
            this.viewer.unTransformPoint(p3, this.tempP1);
            this.viewer.unTransformPoint(p32, this.tempP2);
        }
    }

    protected float scale(float f) {
        return f * this.exportScale;
    }

    protected Tuple3f scalePt(Tuple3f tuple3f) {
        if (this.exportScale == 1.0f) {
            return tuple3f;
        }
        this.ptScaled.setT(tuple3f);
        this.ptScaled.scale(this.exportScale);
        return this.ptScaled;
    }

    protected int getCoordinateMap(Tuple3f[] tuple3fArray, int[] nArray, BS bS) {
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (bS != null && !bS.get(i) || Float.isNaN(tuple3fArray[i].x)) {
                if (bS == null) continue;
                bS.clear(i);
                continue;
            }
            nArray[i] = n++;
        }
        return n;
    }

    protected int[] getNormalMap(Tuple3f[] tuple3fArray, int n, BS bS, JmolList<String> jmolList) {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            if (bS != null && !bS.get(i) || Float.isNaN(tuple3fArray[i].x)) {
                if (bS == null) continue;
                bS.clear(i);
                continue;
            }
            String string = this.getTriad(tuple3fArray[i]) + "\n";
            if (hashtable.containsKey(string)) {
                nArray[i] = (Integer)hashtable.get(string);
                continue;
            }
            nArray[i] = jmolList.size();
            jmolList.addLast(string);
            hashtable.put(string, nArray[i]);
        }
        return nArray;
    }

    protected void outputIndices(int[][] nArray, int[] nArray2, int n, BS bS, int n2) {
        int n3;
        boolean bl = bS == null;
        int n4 = n3 = bl ? n - 1 : bS.nextSetBit(0);
        while (n4 >= 0) {
            this.outputFace(nArray[n4], nArray2, n2);
            n4 = bl ? n4 - 1 : bS.nextSetBit(n4 + 1);
        }
    }

    protected abstract void outputFace(int[] var1, int[] var2, int var3);

    protected abstract void outputCircle(P3 var1, P3 var2, float var3, short var4, boolean var5);

    protected abstract void outputCone(P3 var1, P3 var2, float var3, short var4);

    protected abstract boolean outputCylinder(P3 var1, P3 var2, P3 var3, short var4, byte var5, float var6, P3 var7, P3 var8, boolean var9);

    protected abstract void outputEllipsoid(P3 var1, P3[] var2, short var3);

    protected abstract void outputSphere(P3 var1, float var2, short var3, boolean var4);

    protected abstract void outputTextPixel(P3 var1, int var2);

    protected abstract void outputTriangle(P3 var1, P3 var2, P3 var3, short var4);

    @Override
    void drawAtom(Atom atom) {
        short s = atom.getColix();
        this.outputSphere(atom, (float)atom.madAtom / 2000.0f, s, C.isColixTranslucent(s));
    }

    @Override
    void drawCircle(int n, int n2, int n3, int n4, short s, boolean bl) {
        this.tempP3.set(n, n2, n3);
        this.viewer.unTransformPoint(this.tempP3, this.tempP1);
        float f = this.viewer.unscaleToScreen(n3, n4) / 2.0f;
        this.tempP3.set(n, n2, n3 + 1);
        this.viewer.unTransformPoint(this.tempP3, this.tempP3);
        this.outputCircle(this.tempP1, this.tempP3, f, s, bl);
    }

    @Override
    boolean drawEllipse(P3 p3, P3 p32, P3 p33, short s, boolean bl) {
        this.tempV1.setT(p32);
        this.tempV1.sub(p3);
        this.tempV2.setT(p33);
        this.tempV2.sub(p3);
        this.tempV2.cross(this.tempV1, this.tempV2);
        this.tempV2.normalize();
        this.tempV2.scale(bl ? 0.002f : 0.005f);
        this.tempP1.setT(p3);
        this.tempP1.sub(this.tempV2);
        this.tempP2.setT(p3);
        this.tempP2.add(this.tempV2);
        return this.outputCylinder(p3, this.tempP1, this.tempP2, s, bl ? (byte)2 : 0, 1.01f, p32, p33, true);
    }

    @Override
    void drawPixel(short s, int n, int n2, int n3, int n4) {
        this.tempP3.set(n, n2, n3);
        this.viewer.unTransformPoint(this.tempP3, this.tempP1);
        this.outputSphere(this.tempP1, 0.02f * (float)n4, s, true);
    }

    @Override
    void drawTextPixel(int n, int n2, int n3, int n4) {
        this.tempP3.set(n2, n3, n4);
        this.viewer.unTransformPoint(this.tempP3, this.tempP1);
        this.outputTextPixel(this.tempP1, n);
    }

    @Override
    void fillConeScreen(short s, byte by, int n, P3 p3, P3 p32, boolean bl) {
        this.viewer.unTransformPoint(p3, this.tempP1);
        this.viewer.unTransformPoint(p32, this.tempP2);
        float f = this.viewer.unscaleToScreen(p3.z, n) / 2.0f;
        if (f < 0.05f) {
            f = 0.05f;
        }
        this.outputCone(this.tempP1, this.tempP2, f, s);
    }

    @Override
    void drawCylinder(P3 p3, P3 p32, short s, short s2, byte by, int n, int n2) {
        this.setTempPoints(p3, p32, n2 < 0);
        float f = (float)n / 2000.0f;
        if (s == s2) {
            this.outputCylinder(null, this.tempP1, this.tempP2, s, by, f, null, null, n2 != -1);
        } else {
            this.tempV2.setT(this.tempP2);
            this.tempV2.add(this.tempP1);
            this.tempV2.scale(0.5f);
            this.tempP3.setT(this.tempV2);
            this.outputCylinder(null, this.tempP1, this.tempP3, s, by == 3 ? (byte)0 : by, f, null, null, true);
            this.outputCylinder(null, this.tempP3, this.tempP2, s2, by == 3 ? (byte)0 : by, f, null, null, true);
            if (by == 3) {
                this.outputSphere(this.tempP1, f * 1.01f, s, n2 != -2);
                this.outputSphere(this.tempP2, f * 1.01f, s2, n2 != -2);
            }
        }
    }

    @Override
    void fillCylinderScreenMad(short s, byte by, int n, P3 p3, P3 p32) {
        float f = (float)n / 2000.0f;
        this.setTempPoints(p3, p32, false);
        this.outputCylinder(null, this.tempP1, this.tempP2, s, by, f, null, null, true);
    }

    @Override
    void fillCylinderScreen(short s, byte by, int n, P3 p3, P3 p32) {
        int n2 = (int)(this.viewer.unscaleToScreen((p3.z + p32.z) / 2.0f, n) * 1000.0f);
        this.fillCylinderScreenMad(s, by, n2, p3, p32);
    }

    @Override
    void fillEllipsoid(P3 p3, P3[] p3Array, short s, int n, int n2, int n3, int n4, Matrix3f matrix3f, double[] dArray, Matrix4f matrix4f, P3i[] p3iArray) {
        this.outputEllipsoid(p3, p3Array, s);
    }

    @Override
    void fillSphere(short s, int n, P3 p3) {
        this.viewer.unTransformPoint(p3, this.tempP1);
        this.outputSphere(this.tempP1, this.viewer.unscaleToScreen(p3.z, n) / 2.0f, s, true);
    }

    @Override
    protected void fillTriangle(short s, P3 p3, P3 p32, P3 p33, boolean bl) {
        this.viewer.unTransformPoint(p3, this.tempP1);
        this.viewer.unTransformPoint(p32, this.tempP2);
        this.viewer.unTransformPoint(p33, this.tempP3);
        this.outputTriangle(this.tempP1, this.tempP2, this.tempP3, s);
        if (bl) {
            this.outputTriangle(this.tempP1, this.tempP3, this.tempP2, s);
        }
    }

    @Override
    void plotImage(int n, int n2, int n3, Image image, short s, int n4, int n5) {
        this.g3d.plotImage(n, n2, n3, image, this.jmolRenderer, s, n4, n5);
    }

    @Override
    void plotText(int n, int n2, int n3, short s, String string, JmolFont jmolFont) {
        this.g3d.plotText(n, n2, n3, this.g3d.getColorArgbOrGray(s), 0, string, jmolFont, this.jmolRenderer);
    }

    protected void setSphereMatrix(Tuple3f tuple3f, float f, float f2, float f3, AxisAngle4f axisAngle4f, Matrix4f matrix4f) {
        if (axisAngle4f != null) {
            Matrix3f matrix3f = new Matrix3f();
            Matrix3f matrix3f2 = new Matrix3f();
            matrix3f2.m00 = f;
            matrix3f2.m11 = f2;
            matrix3f2.m22 = f3;
            matrix3f.setAA(axisAngle4f);
            matrix3f.mul(matrix3f2);
            matrix4f.setM3(matrix3f);
        } else {
            matrix4f.setIdentity();
            matrix4f.m00 = f;
            matrix4f.m11 = f2;
            matrix4f.m22 = f3;
        }
        matrix4f.m03 = tuple3f.x;
        matrix4f.m13 = tuple3f.y;
        matrix4f.m23 = tuple3f.z;
        matrix4f.m33 = 1.0f;
    }
}

