/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shapecgo.CGOMesh;
import org.jmol.shapespecial.DrawMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Measure;
import org.jmol.util.MeshSurface;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.P4;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Draw
extends MeshCollection {
    DrawMesh[] dmeshes = new DrawMesh[4];
    protected DrawMesh thisMesh;
    private P3[] ptList;
    private V3 offset = new V3();
    private int nPoints;
    private int diameter;
    private float width;
    protected float newScale;
    private float length;
    private boolean isCurve;
    private boolean isArc;
    private boolean isArrow;
    private boolean isLine;
    private boolean isVector;
    private boolean isCircle;
    private boolean isPerpendicular;
    private boolean isCylinder;
    private boolean isVertices;
    private boolean isPlane;
    private boolean isReversed;
    private boolean isRotated45;
    private boolean isCrossed;
    private boolean isValid;
    private boolean noHead;
    private boolean isBarb;
    private int indicatedModelIndex = -1;
    private int[] modelInfo;
    private boolean makePoints;
    private int nidentifiers;
    private int nbitsets;
    private P4 plane;
    private BS bsAllModels;
    private JmolList<Object> polygon;
    private JmolList<Object[]> vData;
    private String intersectID;
    private P3[] boundBox;
    private JmolList<P3[]> lineData;
    private static final int PT_COORD = 1;
    private static final int PT_IDENTIFIER = 2;
    private static final int PT_BITSET = 3;
    private static final int PT_MODEL_INDEX = 4;
    private static final int PT_MODEL_BASED_POINTS = 5;
    MeshSurface slabData;
    private final V3 vAB = new V3();
    private final V3 vAC = new V3();
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private final P3i ptXY = new P3i();

    public Draw() {
        this.htObjects = new Hashtable();
    }

    public void allocMesh(String string, Mesh mesh) {
        int n = this.meshCount++;
        this.dmeshes = (DrawMesh[])ArrayUtil.ensureLength((Object)this.dmeshes, (int)(this.meshCount * 2));
        this.meshes = this.dmeshes;
        this.dmeshes[n] = mesh == null ? new DrawMesh(string, this.colix, n) : (DrawMesh)mesh;
        this.thisMesh = this.dmeshes[n];
        this.currentMesh = this.dmeshes[n];
        this.currentMesh.color = this.color;
        this.currentMesh.index = n;
        if (string != null && string != "+PREVIOUS_MESH+" && this.htObjects != null) {
            this.htObjects.put(string.toUpperCase(), this.currentMesh);
        }
    }

    protected void setPropertySuper(String string, Object object, BS bS) {
        this.currentMesh = this.thisMesh;
        this.setPropMC(string, object, bS);
        this.thisMesh = (DrawMesh)this.currentMesh;
    }

    public void initShape() {
        super.initShape();
        this.myType = "draw";
    }

    public void setProperty(String string, Object object, BS bS) {
        if ("init" == string) {
            this.initDraw();
            this.setPropertySuper("init", object, bS);
            return;
        }
        if ("length" == string) {
            this.length = ((Float)object).floatValue();
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            return;
        }
        if ("intersect" == string) {
            if (object instanceof String) {
                this.intersectID = (String)object;
            } else {
                this.boundBox = (P3[])object;
            }
            return;
        }
        if ("slab" == string) {
            int n = this.getIndexFromName((String)object);
            if (n < 0) {
                return;
            }
            Mesh mesh = this.meshes[n];
            if (mesh.checkByteCount != 1) {
                return;
            }
            this.slabData = MeshSurface.newSlab((P3[])mesh.vertices, (int)mesh.vertexCount, (float[])new float[mesh.vertexCount], (int[][])mesh.polygonIndexes, (int)mesh.polygonCount, (int)1);
            return;
        }
        if ("lineData" == string) {
            this.lineData = new JmolList();
            if (this.indicatedModelIndex < 0) {
                this.indicatedModelIndex = this.viewer.getCurrentModelIndex();
            }
            float[] fArray = (float[])object;
            int n = fArray.length / 6;
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                this.lineData.addLast((Object)new P3[]{P3.new3((float)fArray[n2++], (float)fArray[n2++], (float)fArray[n2++]), P3.new3((float)fArray[n2++], (float)fArray[n2++], (float)fArray[n2++])});
            }
            return;
        }
        if ("modelIndex" == string) {
            this.indicatedModelIndex = (Integer)object;
            if (this.indicatedModelIndex < 0 || this.indicatedModelIndex >= this.viewer.getModelCount()) {
                return;
            }
            Object[] objectArray = new Object[2];
            objectArray[0] = 4;
            this.modelInfo = new int[]{this.indicatedModelIndex, 0};
            objectArray[1] = this.modelInfo;
            this.vData.addLast((Object)objectArray);
            return;
        }
        if ("planedef" == string) {
            this.plane = (P4)object;
            if (this.intersectID != null || this.boundBox != null || this.slabData != null) {
                return;
            }
            if (this.isCircle || this.isArc) {
                this.isPlane = true;
            }
            this.vData.addLast((Object)new Object[]{1, P3.new3((float)Float.NaN, (float)Float.NaN, (float)Float.NaN)});
            return;
        }
        if ("perp" == string) {
            this.isPerpendicular = true;
            return;
        }
        if ("cylinder" == string) {
            this.isCylinder = true;
            return;
        }
        if ("plane" == string) {
            this.isPlane = true;
            return;
        }
        if ("curve" == string) {
            this.isCurve = true;
            return;
        }
        if ("arrow" == string) {
            this.isArrow = true;
            return;
        }
        if ("line" == string) {
            this.isLine = true;
            this.isCurve = true;
            return;
        }
        if ("arc" == string) {
            this.isCurve = true;
            this.isArc = true;
            if (this.isArrow) {
                this.isArrow = false;
                this.isVector = true;
            }
            return;
        }
        if ("circle" == string) {
            this.isCircle = true;
            return;
        }
        if ("vector" == string) {
            this.isArrow = true;
            this.isVector = true;
            return;
        }
        if ("vertices" == string) {
            this.isVertices = true;
            return;
        }
        if ("reverse" == string) {
            this.isReversed = true;
            return;
        }
        if ("nohead" == string) {
            this.noHead = true;
            return;
        }
        if ("isbarb" == string) {
            this.isBarb = true;
            return;
        }
        if ("rotate45" == string) {
            this.isRotated45 = true;
            return;
        }
        if ("crossed" == string) {
            this.isCrossed = true;
            return;
        }
        if ("points" == string) {
            this.newScale = ((Integer)object).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 1.0f;
            }
            return;
        }
        if ("scale" == string) {
            this.newScale = ((Integer)object).floatValue() / 100.0f;
            if (this.newScale == 0.0f) {
                this.newScale = 0.01f;
            }
            if (this.thisMesh != null) {
                this.scale(this.thisMesh, this.newScale);
                this.thisMesh.initialize(1073741964, null, null);
            }
            return;
        }
        if ("diameter" == string) {
            this.diameter = ((Float)object).intValue();
            return;
        }
        if ("width" == string) {
            this.width = ((Float)object).floatValue();
            return;
        }
        if ("identifier" == string) {
            String string2 = (String)object;
            int n = this.getIndexFromName(string2);
            if (n >= 0) {
                this.vData.addLast((Object)new Object[]{2, new int[]{n, this.isReversed ? 1 : 0, this.isVertices ? 1 : 0}});
                this.isVertices = false;
                this.isReversed = false;
                ++this.nidentifiers;
            } else {
                Logger.error((String)("draw identifier " + object + " not found"));
                this.isValid = false;
            }
            return;
        }
        if ("polygon" == string) {
            this.polygon = (JmolList)object;
            if (this.polygon == null) {
                this.polygon = new JmolList();
            }
            return;
        }
        if ("coord" == string) {
            this.vData.addLast((Object)new Object[]{1, object});
            if (this.indicatedModelIndex >= 0) {
                this.modelInfo[1] = this.modelInfo[1] + 1;
            }
            return;
        }
        if ("offset" == string) {
            this.offset = V3.newV((Tuple3f)((P3)object));
            if (this.thisMesh != null) {
                this.thisMesh.offset(this.offset);
            }
            return;
        }
        if ("atomSet" == string) {
            if (BSUtil.cardinalityOf((BS)((BS)object)) == 0) {
                return;
            }
            BS bS2 = (BS)object;
            this.vData.addLast((Object)new Object[]{3, bS2});
            ++this.nbitsets;
            if (this.isCircle && this.diameter == 0 && this.width == 0.0f) {
                this.width = this.viewer.calcRotationRadiusBs(bS2) * 2.0f;
            }
            return;
        }
        if ("modelBasedPoints" == string) {
            this.vData.addLast((Object)new Object[]{5, object});
            return;
        }
        if ("set" == string) {
            if (this.thisMesh == null) {
                this.allocMesh(null, null);
                this.thisMesh.colix = this.colix;
                this.thisMesh.color = this.color;
            }
            boolean bl = this.thisMesh.isValid = this.isValid ? this.setDrawing((int[])object) : false;
            if (this.thisMesh.isValid) {
                if (this.thisMesh.vertexCount > 2 && this.length != Float.MAX_VALUE && this.newScale == 1.0f) {
                    this.newScale = this.length;
                }
                this.scale(this.thisMesh, this.newScale);
                this.thisMesh.initialize(1073741964, null, null);
                Draw.setAxes(this.thisMesh);
                this.thisMesh.title = this.title;
                this.thisMesh.visible = true;
            }
            this.nPoints = -1;
            this.vData = null;
            this.lineData = null;
            return;
        }
        if (string == "deleteModelAtoms") {
            this.deleteModels(((int[])((Object[])object)[2])[0]);
            return;
        }
        this.setPropertySuper(string, object, bS);
    }

    protected void deleteModels(int n) {
        int n2 = this.meshCount;
        while (--n2 >= 0) {
            boolean bl;
            DrawMesh drawMesh = this.dmeshes[n2];
            if (drawMesh == null) continue;
            boolean bl2 = bl = drawMesh.modelIndex == n;
            if (drawMesh.modelFlags != null) {
                drawMesh.deleteAtoms(n);
                bl = drawMesh.modelFlags.length() == 0;
                if (!bl) continue;
            }
            if (bl) {
                --this.meshCount;
                this.deleteMeshElement(n2);
                continue;
            }
            if (this.meshes[n2].modelIndex <= n) continue;
            --this.meshes[n2].modelIndex;
        }
        this.resetObjects();
    }

    protected void deleteMeshElement(int n) {
        if (this.meshes[n] == this.currentMesh) {
            this.thisMesh = null;
            this.currentMesh = null;
        }
        this.dmeshes = (CGOMesh[])ArrayUtil.deleteElements((Object)this.meshes, (int)n, (int)1);
        this.meshes = this.dmeshes;
    }

    private void initDraw() {
        this.boundBox = null;
        this.bsAllModels = null;
        this.colix = (short)5;
        this.color = -1;
        this.diameter = 0;
        this.explicitID = false;
        this.indicatedModelIndex = -1;
        this.intersectID = null;
        this.isLine = false;
        this.isCylinder = false;
        this.isCircle = false;
        this.isPlane = false;
        this.isArrow = false;
        this.isArc = false;
        this.isCurve = false;
        this.isBarb = false;
        this.noHead = false;
        this.isCrossed = false;
        this.isRotated45 = false;
        this.isReversed = false;
        this.isFixed = false;
        this.isVector = false;
        this.isVertices = false;
        this.isPerpendicular = false;
        this.isValid = true;
        this.length = Float.MAX_VALUE;
        this.lineData = null;
        this.newScale = 0.0f;
        this.nbitsets = 0;
        this.nidentifiers = 0;
        this.offset = null;
        this.plane = null;
        this.polygon = null;
        this.slabData = null;
        this.vData = new JmolList();
        this.width = 0.0f;
        this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
    }

    protected void resetObjects() {
        this.htObjects.clear();
        int n = 0;
        while (n < this.meshCount) {
            Mesh mesh = this.meshes[n];
            mesh.index = n++;
            this.htObjects.put(mesh.thisID.toUpperCase(), mesh);
        }
    }

    public boolean getPropertyData(String string, Object[] objectArray) {
        if (string == "getCenter") {
            String string2 = (String)objectArray[0];
            int n = (Integer)objectArray[1];
            int n2 = (Integer)objectArray[2];
            objectArray[2] = this.getSpinCenter(string2, n, n2);
            return objectArray[2] != null;
        }
        if (string == "getSpinAxis") {
            String string3 = (String)objectArray[0];
            int n = (Integer)objectArray[1];
            objectArray[2] = this.getSpinAxis(string3, n);
            return objectArray[2] != null;
        }
        return this.getPropDataMC(string, objectArray);
    }

    public Object getProperty(String string, int n) {
        if (string == "command") {
            return this.getCommand(this.thisMesh);
        }
        if (string == "type") {
            return this.thisMesh == null ? EnumDrawType.NONE.id : this.thisMesh.drawType.id;
        }
        return this.getPropMC(string);
    }

    private P3 getSpinCenter(String string, int n, int n2) {
        DrawMesh drawMesh;
        String string2;
        int n3 = string.indexOf("[");
        if (n3 > 0) {
            string2 = string.substring(0, n3);
            int n4 = string.lastIndexOf("]");
            if (n4 < n3) {
                n4 = string.length();
            }
            try {
                n = Integer.parseInt(string.substring(n3 + 1, n4));
            }
            catch (Exception exception) {}
        } else {
            string2 = string;
        }
        if ((drawMesh = (DrawMesh)this.getMesh(string2)) == null || drawMesh.vertices == null) {
            return null;
        }
        if (n == Integer.MAX_VALUE) {
            return P3.new3((float)(drawMesh.index + 1), (float)this.meshCount, (float)drawMesh.vertexCount);
        }
        if (n != Integer.MIN_VALUE) {
            n = drawMesh.getVertexIndexFromNumber(n);
        }
        return n >= 0 ? drawMesh.vertices[n] : (drawMesh.ptCenters == null || n2 < 0 || n2 >= drawMesh.ptCenters.length ? drawMesh.ptCenter : drawMesh.ptCenters[n2]);
    }

    private V3 getSpinAxis(String string, int n) {
        DrawMesh drawMesh = (DrawMesh)this.getMesh(string);
        return drawMesh == null || drawMesh.vertices == null ? null : (drawMesh.ptCenters == null || n < 0 ? drawMesh.axis : drawMesh.axes[n]);
    }

    private boolean setDrawing(int[] nArray) {
        if (this.thisMesh == null) {
            this.allocMesh(null, null);
        }
        this.thisMesh.clear("draw");
        this.thisMesh.diameter = this.diameter;
        this.thisMesh.width = this.width;
        if (this.intersectID != null || this.boundBox != null) {
            this.setIntersectData();
        } else if (this.slabData != null) {
            this.setSlabData();
        }
        if (this.polygon == null && (this.lineData == null ? this.vData.size() == 0 == (nArray == null) : this.lineData.size() == 0) || !this.isArrow && nArray != null) {
            return false;
        }
        int n = this.viewer.getModelCount();
        if (this.polygon != null || this.lineData != null || this.indicatedModelIndex < 0 && (this.isFixed || this.isArrow || this.isCurve || this.isCircle || this.isCylinder || n == 1)) {
            this.thisMesh.modelIndex = this.lineData == null ? this.viewer.getCurrentModelIndex() : this.indicatedModelIndex;
            boolean bl = this.thisMesh.isFixed = this.isFixed || this.lineData == null && this.thisMesh.modelIndex < 0 && n > 1;
            if (this.isFixed && n > 1) {
                this.thisMesh.modelIndex = -1;
            } else if (this.lineData == null && this.thisMesh.modelIndex < 0) {
                this.thisMesh.modelIndex = 0;
            }
            this.thisMesh.ptCenters = null;
            this.thisMesh.modelFlags = null;
            this.thisMesh.drawTypes = null;
            this.thisMesh.drawVertexCounts = null;
            this.thisMesh.connections = nArray;
            if (this.polygon != null) {
                if (this.polygon.size() == 0) {
                    return false;
                }
                this.thisMesh.isTriangleSet = true;
                this.thisMesh.vertices = (P3[])this.polygon.get(0);
                this.thisMesh.polygonIndexes = (int[][])this.polygon.get(1);
                this.thisMesh.drawVertexCount = this.thisMesh.vertexCount = this.thisMesh.vertices.length;
                this.thisMesh.polygonCount = this.thisMesh.polygonIndexes.length;
                for (int i = 0; i < this.thisMesh.polygonCount; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        if (this.thisMesh.polygonIndexes[i][j] < this.thisMesh.vertexCount) continue;
                        return false;
                    }
                }
                this.thisMesh.drawType = EnumDrawType.POLYGON;
                this.thisMesh.checkByteCount = 1;
            } else if (this.lineData != null) {
                this.thisMesh.lineData = this.lineData;
            } else {
                this.thisMesh.setPolygonCount(1);
                if (this.setPoints(-1, -1)) {
                    this.setPoints(-1, this.nPoints);
                }
                this.setPolygon(0);
            }
        } else {
            this.thisMesh.modelIndex = -1;
            this.thisMesh.setPolygonCount(n);
            this.thisMesh.ptCenters = new P3[n];
            this.thisMesh.modelFlags = new BS();
            this.thisMesh.drawTypes = new EnumDrawType[n];
            this.thisMesh.drawVertexCounts = new int[n];
            this.thisMesh.vertexCount = 0;
            if (this.indicatedModelIndex >= 0) {
                this.setPoints(-1, 0);
                this.thisMesh.drawType = EnumDrawType.MULTIPLE;
                this.thisMesh.drawVertexCount = -1;
                this.thisMesh.modelFlags.set(this.indicatedModelIndex);
                this.indicatedModelIndex = -1;
            } else {
                BS bS = this.viewer.getVisibleFramesBitSet();
                for (int i = 0; i < n; ++i) {
                    if (bS.get(i) && this.setPoints(i, -1)) {
                        this.setPoints(i, this.nPoints);
                        this.setPolygon(i);
                        this.thisMesh.setCenter(i);
                        this.thisMesh.drawTypes[i] = this.thisMesh.drawType;
                        this.thisMesh.drawVertexCounts[i] = this.thisMesh.drawVertexCount;
                        this.thisMesh.drawType = EnumDrawType.MULTIPLE;
                        this.thisMesh.drawVertexCount = -1;
                        this.thisMesh.modelFlags.set(i);
                        continue;
                    }
                    this.thisMesh.drawTypes[i] = EnumDrawType.NONE;
                    this.thisMesh.polygonIndexes[i] = new int[0];
                }
            }
        }
        this.thisMesh.isVector = this.isVector;
        this.thisMesh.noHead = this.noHead;
        this.thisMesh.isBarb = this.isBarb;
        this.thisMesh.width = this.thisMesh.drawType == EnumDrawType.CYLINDER || this.thisMesh.drawType == EnumDrawType.CIRCULARPLANE ? -Math.abs(this.width) : this.width;
        this.thisMesh.setCenter(-1);
        if (this.offset != null) {
            this.thisMesh.offset(this.offset);
        }
        if (this.thisMesh.thisID == null) {
            this.thisMesh.thisID = this.thisMesh.drawType.name + ++this.nUnnamed;
            this.htObjects.put(this.thisMesh.thisID, this.thisMesh);
        }
        this.clean();
        return true;
    }

    protected void clean() {
        int n = this.meshCount;
        while (--n >= 0) {
            if (this.meshes[n] != null && (this.meshes[n].vertexCount != 0 || this.meshes[n].connections != null || this.meshes[n].lineData != null)) continue;
            this.deleteMeshI(n);
        }
    }

    private void setIntersectData() {
        if (this.boundBox != null) {
            if (this.plane == null) {
                // empty if block
            }
        } else if (this.plane != null && this.intersectID != null) {
            JmolList jmolList = new JmolList();
            Object[] objectArray = new Object[]{this.intersectID, this.plane, jmolList, null};
            this.viewer.getShapePropertyData(24, "intersectPlane", objectArray);
            if (jmolList.size() == 0) {
                return;
            }
            this.indicatedModelIndex = (Integer)objectArray[3];
            this.lineData = jmolList;
        }
    }

    private void setSlabData() {
        if (this.plane != null) {
            this.slabData.getIntersection(0.0f, this.plane, null, null, null, null, null, false, true, 135266319, false);
            this.polygon = new JmolList();
            this.polygon.addLast((Object)this.slabData.vertices);
            this.polygon.addLast((Object)this.slabData.polygonIndexes);
        }
    }

    private void addPoint(P3 p3, int n) {
        boolean bl;
        boolean bl2 = bl = n < 0 || this.bsAllModels.get(n);
        if (this.makePoints) {
            if (!bl) {
                return;
            }
            this.ptList[this.nPoints] = P3.newP((Tuple3f)p3);
            if (p3.z == Float.MAX_VALUE || p3.z == -3.4028235E38f) {
                this.thisMesh.haveXyPoints = true;
            }
        } else if (n >= 0) {
            this.bsAllModels.set(n);
        }
        ++this.nPoints;
    }

    private boolean setPoints(int n, int n2) {
        boolean bl = this.makePoints = n2 >= 0;
        if (this.makePoints) {
            this.ptList = new P3[Math.max(5, n2)];
            if (this.bsAllModels == null) {
                this.bsAllModels = this.viewer.getVisibleFramesBitSet();
            }
        }
        this.nPoints = 0;
        int n3 = this.vData.size();
        int n4 = 0;
        BS bS = n < 0 ? null : this.viewer.getModelUndeletedAtomsBitSet(n);
        block7: for (int i = 0; i < n3; ++i) {
            Object[] objectArray = (Object[])this.vData.get(i);
            switch ((Integer)objectArray[0]) {
                case 4: {
                    int n5;
                    int[] nArray = (int[])objectArray[1];
                    n4 = nArray[0];
                    this.nPoints = nArray[1];
                    int n6 = Math.max(this.nPoints, 3);
                    int n7 = this.thisMesh.vertexCount;
                    if (this.nPoints <= 0) continue block7;
                    this.thisMesh.polygonIndexes[n4] = new int[n6];
                    int[] nArray2 = this.thisMesh.polygonIndexes[n4];
                    for (n5 = 0; n5 < this.nPoints; ++n5) {
                        objectArray = (Object[])this.vData.get(++i);
                        nArray2[n5] = this.thisMesh.addV((P3)objectArray[1]);
                    }
                    for (n5 = this.nPoints; n5 < 3; ++n5) {
                        nArray2[n5] = n7 + this.nPoints - 1;
                    }
                    this.thisMesh.drawTypes[n4] = EnumDrawType.getType(this.nPoints);
                    this.thisMesh.drawVertexCounts[n4] = this.nPoints;
                    this.thisMesh.modelFlags.set(n4);
                    continue block7;
                }
                case 1: {
                    this.addPoint((P3)objectArray[1], this.makePoints ? n : -1);
                    continue block7;
                }
                case 3: {
                    BS bS2 = BSUtil.copy((BS)((BS)objectArray[1]));
                    if (bS != null) {
                        bS2.and(bS);
                    }
                    if (bS2.length() <= 0) continue block7;
                    this.addPoint(this.viewer.getAtomSetCenter(bS2), this.makePoints ? n : -1);
                    continue block7;
                }
                case 2: {
                    boolean bl2;
                    int[] nArray2 = (int[])objectArray[1];
                    DrawMesh drawMesh = this.dmeshes[nArray2[0]];
                    boolean bl3 = nArray2[1] == 1;
                    boolean bl4 = bl2 = nArray2[2] == 1;
                    if (drawMesh.modelIndex > 0 && drawMesh.modelIndex != n) {
                        return false;
                    }
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BS();
                    }
                    if (this.isPlane && !this.isCircle || this.isPerpendicular || bl2) {
                        if (bl3) {
                            if (n < 0 || n >= drawMesh.polygonCount) {
                                int n8 = drawMesh.drawVertexCount;
                                while (--n8 >= 0) {
                                    this.addPoint(drawMesh.vertices[n8], n);
                                }
                                continue block7;
                            }
                            if (drawMesh.polygonIndexes[n] == null) continue block7;
                            int n9 = drawMesh.drawVertexCounts[n];
                            while (--n9 >= 0) {
                                this.addPoint(drawMesh.vertices[drawMesh.polygonIndexes[n][n9]], n);
                            }
                            continue block7;
                        }
                        if (n < 0 || n >= drawMesh.polygonCount) {
                            for (int j = 0; j < drawMesh.drawVertexCount; ++j) {
                                this.addPoint(drawMesh.vertices[j], n);
                            }
                            continue block7;
                        }
                        if (drawMesh.polygonIndexes[n] == null) continue block7;
                        for (int j = 0; j < drawMesh.drawVertexCounts[n]; ++j) {
                            this.addPoint(drawMesh.vertices[drawMesh.polygonIndexes[n][j]], n);
                        }
                        continue block7;
                    }
                    if (n < 0 || drawMesh.ptCenters == null || drawMesh.ptCenters[n] == null) {
                        this.addPoint(drawMesh.ptCenter, n);
                        continue block7;
                    }
                    this.addPoint(drawMesh.ptCenters[n], n);
                    continue block7;
                }
                case 5: {
                    BS bS2;
                    String[] stringArray = (String[])objectArray[1];
                    if (this.bsAllModels == null) {
                        this.bsAllModels = new BS();
                    }
                    for (int j = 0; j < stringArray.length; ++j) {
                        if (n >= 0 && j != n) continue;
                        Object object = Escape.unescapePointOrBitsetOrMatrixOrArray((String)stringArray[j]);
                        this.bsAllModels.set(j);
                        if (object instanceof P3) {
                            this.addPoint((P3)object, j);
                            continue;
                        }
                        if (!(object instanceof BS)) continue;
                        bS2 = (BS)object;
                        if (bS != null) {
                            bS2.and(bS);
                        }
                        if (bS2.length() <= 0) continue;
                        this.addPoint(this.viewer.getAtomSetCenter(bS2), j);
                    }
                    continue block7;
                }
            }
        }
        if (this.makePoints && this.isCrossed && this.nPoints == 4) {
            P3 p3 = this.ptList[1];
            this.ptList[1] = this.ptList[2];
            this.ptList[2] = p3;
        }
        return this.nPoints > 0;
    }

    private void setPolygon(int n) {
        int n2;
        int n3 = this.nPoints;
        EnumDrawType enumDrawType = EnumDrawType.POINT;
        if (this.isArc) {
            if (n3 >= 2) {
                enumDrawType = EnumDrawType.ARC;
            } else {
                this.isArc = false;
                this.isVector = false;
                this.isCurve = false;
                this.isArrow = true;
            }
        }
        if (this.isCircle) {
            this.length = 0.0f;
            if (n3 == 2) {
                this.isPlane = true;
            }
            if (!this.isPlane) {
                enumDrawType = EnumDrawType.CIRCLE;
            }
            if (this.width == 0.0f) {
                this.width = 1.0f;
            }
        } else if ((this.isCurve || this.isArrow) && n3 >= 2 && !this.isArc) {
            EnumDrawType enumDrawType2 = this.isLine ? EnumDrawType.LINE_SEGMENT : (enumDrawType = this.isCurve ? EnumDrawType.CURVE : EnumDrawType.ARROW);
        }
        if (this.isVector && !this.isArc) {
            if (n3 > 2) {
                n3 = 2;
            } else if (this.plane == null && n3 != 2) {
                this.isVector = false;
            }
        }
        if (this.thisMesh.haveXyPoints) {
            this.isPerpendicular = false;
            if (n3 == 3 && this.isPlane) {
                this.isPlane = false;
            }
            this.length = Float.MAX_VALUE;
            this.thisMesh.diameter = 0;
        } else if (n3 == 2 && this.isVector) {
            this.ptList[1].add((Tuple3f)this.ptList[0]);
        }
        float f = 0.0f;
        if (this.isArc || this.plane != null && this.isCircle) {
            if (this.plane != null) {
                f = Measure.distanceToPlane((P4)this.plane, (P3)this.ptList[0]);
                this.vAC.set(-this.plane.x, -this.plane.y, -this.plane.z);
                this.vAC.normalize();
                if (f < 0.0f) {
                    this.vAC.scale(-1.0f);
                }
                if (this.isCircle) {
                    this.vAC.scale(0.005f);
                    this.ptList[0].sub((Tuple3f)this.vAC);
                    this.vAC.scale(2.0f);
                }
                this.vAC.add((Tuple3f)this.ptList[0]);
                this.ptList[1] = P3.newP((Tuple3f)this.vAC);
                EnumDrawType enumDrawType3 = this.isArrow ? EnumDrawType.ARROW : (enumDrawType = this.isArc ? EnumDrawType.ARC : EnumDrawType.CIRCULARPLANE);
            }
            if (this.isArc) {
                f = Math.abs(f);
                if (n3 <= 3) {
                    if (n3 == 3) {
                        this.ptList[3] = P3.newP((Tuple3f)this.ptList[2]);
                        this.ptList[2] = Draw.randomPoint();
                    } else {
                        if (n3 == 2) {
                            this.ptList[2] = Draw.randomPoint();
                        }
                        this.ptList[3] = P3.new3((float)0.0f, (float)360.0f, (float)0.0f);
                    }
                }
                if (this.plane != null) {
                    this.ptList[3].z *= f;
                }
                n3 = 4;
            }
            this.plane = null;
        } else if (enumDrawType == EnumDrawType.POINT) {
            P3 p3;
            P3 p32 = new P3();
            V3 v3 = new V3();
            if (n3 == 2 && this.plane != null) {
                this.ptList[1] = P3.newP((Tuple3f)this.ptList[0]);
                V3 v32 = new V3();
                Measure.getPlaneProjection((P3)this.ptList[1], (P4)this.plane, (P3)this.ptList[1], (V3)v32);
                n3 = -2;
                if (this.isArrow) {
                    enumDrawType = EnumDrawType.ARROW;
                }
                this.plane = null;
            }
            if (n3 == 3 && this.isPlane && !this.isPerpendicular) {
                p3 = P3.newP((Tuple3f)this.ptList[1]);
                p3.sub((Tuple3f)this.ptList[0]);
                p3.scale(0.5f);
                this.ptList[3] = P3.newP((Tuple3f)this.ptList[2]);
                this.ptList[2].add((Tuple3f)p3);
                this.ptList[3].sub((Tuple3f)p3);
                n3 = 4;
            } else if (n3 >= 3 && !this.isPlane && this.isPerpendicular) {
                Measure.calcNormalizedNormal((P3)this.ptList[0], (P3)this.ptList[1], (P3)this.ptList[2], (V3)v3, (V3)this.vAB, (V3)this.vAC);
                p32 = new P3();
                Measure.calcAveragePointN((P3[])this.ptList, (int)n3, (P3)p32);
                f = this.length == Float.MAX_VALUE ? this.ptList[0].distance((Tuple3f)p32) : this.length;
                v3.scale(f);
                this.ptList[0].setT((Tuple3f)p32);
                this.ptList[1].setT((Tuple3f)p32);
                this.ptList[1].add((Tuple3f)v3);
                n3 = 2;
            } else if (n3 == 2 && this.isPerpendicular) {
                Measure.calcAveragePoint((P3)this.ptList[0], (P3)this.ptList[1], (P3)p32);
                float f2 = f = this.length == Float.MAX_VALUE ? this.ptList[0].distance((Tuple3f)p32) : this.length;
                if (this.isPlane && this.length != Float.MAX_VALUE) {
                    f /= 2.0f;
                }
                if (this.isPlane && this.isRotated45) {
                    f *= 1.4142f;
                }
                Measure.getNormalToLine((P3)this.ptList[0], (P3)this.ptList[1], (V3)v3);
                v3.scale(f);
                if (this.isPlane) {
                    this.ptList[2] = P3.newP((Tuple3f)p32);
                    this.ptList[2].sub((Tuple3f)v3);
                    p3 = P3.newP((Tuple3f)p32);
                    p3.add((Tuple3f)v3);
                    Measure.calcNormalizedNormal((P3)this.ptList[0], (P3)this.ptList[1], (P3)this.ptList[2], (V3)v3, (V3)this.vAB, (V3)this.vAC);
                    v3.scale(f);
                    this.ptList[3] = P3.newP((Tuple3f)p32);
                    this.ptList[3].add((Tuple3f)v3);
                    this.ptList[1].setT((Tuple3f)p32);
                    this.ptList[1].sub((Tuple3f)v3);
                    this.ptList[0].setT((Tuple3f)p3);
                    if (this.isRotated45) {
                        Measure.calcAveragePoint((P3)this.ptList[0], (P3)this.ptList[1], (P3)this.ptList[0]);
                        Measure.calcAveragePoint((P3)this.ptList[1], (P3)this.ptList[2], (P3)this.ptList[1]);
                        Measure.calcAveragePoint((P3)this.ptList[2], (P3)this.ptList[3], (P3)this.ptList[2]);
                        Measure.calcAveragePoint((P3)this.ptList[3], (P3)p3, (P3)this.ptList[3]);
                    }
                    n3 = 4;
                } else {
                    this.ptList[0].setT((Tuple3f)p32);
                    this.ptList[1].setT((Tuple3f)p32);
                    this.ptList[0].sub((Tuple3f)v3);
                    this.ptList[1].add((Tuple3f)v3);
                }
                if (this.isArrow && n3 != -2) {
                    this.isArrow = false;
                }
            } else if (n3 == 2 && this.length != Float.MAX_VALUE) {
                Measure.calcAveragePoint((P3)this.ptList[0], (P3)this.ptList[1], (P3)p32);
                v3.setT((Tuple3f)this.ptList[1]);
                v3.sub((Tuple3f)p32);
                v3.scale(0.5f / v3.length() * (this.length == 0.0f ? 0.01f : this.length));
                if (this.length == 0.0f) {
                    p32.setT((Tuple3f)this.ptList[0]);
                }
                this.ptList[0].setT((Tuple3f)p32);
                this.ptList[1].setT((Tuple3f)this.ptList[0]);
                this.ptList[0].sub((Tuple3f)v3);
                this.ptList[1].add((Tuple3f)v3);
            }
            if (n3 > 4) {
                n3 = 4;
            }
            switch (n3) {
                case -2: {
                    n3 = 2;
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    enumDrawType = this.isArc ? EnumDrawType.ARC : (this.isPlane && this.isCircle ? EnumDrawType.CIRCULARPLANE : (this.isCylinder ? EnumDrawType.CYLINDER : EnumDrawType.LINE));
                    break;
                }
                default: {
                    enumDrawType = this.thisMesh.connections == null ? EnumDrawType.PLANE : EnumDrawType.ARROW;
                }
            }
        }
        this.thisMesh.drawType = enumDrawType;
        this.thisMesh.drawVertexCount = n3;
        if (n3 == 0) {
            return;
        }
        int n4 = this.thisMesh.vertexCount;
        for (n2 = 0; n2 < n3; ++n2) {
            this.thisMesh.addV(this.ptList[n2]);
        }
        n2 = n3 < 3 ? 3 : n3;
        this.thisMesh.setPolygonCount(n + 1);
        this.thisMesh.polygonIndexes[n] = new int[n2];
        for (int i = 0; i < n2; ++i) {
            this.thisMesh.polygonIndexes[n][i] = n4 + (i < n3 ? i : n3 - 1);
        }
    }

    protected void scale(Mesh mesh, float f) {
        DrawMesh drawMesh = (DrawMesh)mesh;
        if (f == 0.0f || drawMesh.vertexCount == 0 && drawMesh.connections == null || drawMesh.scale == f) {
            return;
        }
        float f2 = f / drawMesh.scale;
        drawMesh.scale = f;
        drawMesh.isScaleSet = true;
        if (drawMesh.isRenderScalable()) {
            return;
        }
        V3 v3 = new V3();
        int n = -1;
        int n2 = 0;
        int n3 = drawMesh.polygonCount;
        while (--n3 >= 0) {
            P3 p3;
            P3 p32 = drawMesh.isVector ? drawMesh.vertices[0] : (p3 = drawMesh.ptCenters == null ? drawMesh.ptCenter : drawMesh.ptCenters[n3]);
            if (p3 == null) {
                return;
            }
            if (drawMesh.polygonIndexes[n3] == null) continue;
            n = -1;
            int n4 = drawMesh.polygonIndexes[n3].length;
            while (--n4 >= 0) {
                n2 = drawMesh.polygonIndexes[n3][n4];
                if (n2 == n) continue;
                n = n2;
                v3.sub2((Tuple3f)drawMesh.vertices[n2], (Tuple3f)p3);
                v3.scale(f2);
                v3.add((Tuple3f)p3);
                drawMesh.vertices[n2].setT((Tuple3f)v3);
            }
        }
    }

    private static final void setAxes(DrawMesh drawMesh) {
        drawMesh.axis = V3.new3((float)0.0f, (float)0.0f, (float)0.0f);
        drawMesh.axes = new V3[drawMesh.polygonCount > 0 ? drawMesh.polygonCount : 1];
        if (drawMesh.vertices == null) {
            return;
        }
        int n = 0;
        int n2 = drawMesh.polygonCount;
        while (--n2 >= 0) {
            int[] nArray = drawMesh.polygonIndexes[n2];
            drawMesh.axes[n2] = new V3();
            if (nArray != null && nArray.length != 0) {
                if (drawMesh.drawVertexCount == 2 || drawMesh.drawVertexCount < 0 && drawMesh.drawVertexCounts[n2] == 2) {
                    drawMesh.axes[n2].sub2((Tuple3f)drawMesh.vertices[nArray[0]], (Tuple3f)drawMesh.vertices[nArray[1]]);
                    ++n;
                } else {
                    Measure.calcNormalizedNormal((P3)drawMesh.vertices[nArray[0]], (P3)drawMesh.vertices[nArray[1]], (P3)drawMesh.vertices[nArray[2]], (V3)drawMesh.axes[n2], (V3)drawMesh.vAB, (V3)drawMesh.vAC);
                    ++n;
                }
            }
            drawMesh.axis.add((Tuple3f)drawMesh.axes[n2]);
        }
        if (n == 0) {
            return;
        }
        drawMesh.axis.scale(1.0f / (float)n);
    }

    public void setVisibilityFlags(BS bS) {
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh == null) continue;
            int n = drawMesh.visibilityFlags = drawMesh.isValid && drawMesh.visible ? this.myVisibilityFlag : 0;
            if (drawMesh.modelIndex >= 0 && !bS.get(drawMesh.modelIndex) || drawMesh.modelFlags != null && !BSUtil.haveCommon((BS)bS, (BS)drawMesh.modelFlags)) {
                drawMesh.visibilityFlags = 0;
                continue;
            }
            if (drawMesh.modelFlags == null) continue;
            drawMesh.bsMeshesVisible.clearAll();
            drawMesh.bsMeshesVisible.or(drawMesh.modelFlags);
            drawMesh.bsMeshesVisible.and(bS);
        }
    }

    public Map<String, Object> checkObjectClicked(int n, int n2, int n3, BS bS, boolean bl) {
        boolean bl2;
        boolean bl3 = this.viewer.getPickingMode() == 4;
        boolean bl4 = bl2 = this.viewer.getPickingMode() == 5;
        if (!bl3 && !bl && !bl2 || C.isColixTranslucent((short)this.colix)) {
            return null;
        }
        if (!this.findPickedObject(n, n2, false, bS)) {
            return null;
        }
        P3 p3 = this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][this.pickedVertex]];
        int n4 = this.pickedMesh.modelIndex;
        BS bS2 = ((DrawMesh)this.pickedMesh).modelFlags;
        if (n4 < 0 && bS2 != null && BSUtil.cardinalityOf((BS)bS2) == 1) {
            n4 = bS2.nextSetBit(0);
        }
        if (bl && !bl3) {
            if (n3 != 0) {
                this.setStatusPicked(-2, p3);
            }
            return this.getPickedPoint(p3, n4);
        }
        if (n3 == 0 || this.pickedMesh.polygonIndexes[this.pickedModel][0] == this.pickedMesh.polygonIndexes[this.pickedModel][1]) {
            return n3 == 0 ? this.getPickedPoint(p3, n4) : null;
        }
        boolean bl5 = this.viewer.isBound(n3, 42);
        if (this.pickedVertex == 0) {
            this.viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], bl5);
        } else {
            this.viewer.startSpinningAxis(this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][0]], this.pickedMesh.vertices[this.pickedMesh.polygonIndexes[this.pickedModel][1]], bl5);
        }
        return this.getPickedPoint(null, 0);
    }

    public boolean checkObjectHovered(int n, int n2, BS bS) {
        String string;
        if (!this.viewer.getDrawHover()) {
            return false;
        }
        if (C.isColixTranslucent((short)this.colix)) {
            return false;
        }
        if (!this.findPickedObject(n, n2, false, bS)) {
            return false;
        }
        if (this.gdata.isDisplayAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        String string2 = string = this.pickedMesh.title == null ? this.pickedMesh.thisID : this.pickedMesh.title[0];
        if (string.length() > 1 && string.charAt(0) == '>') {
            string = string.substring(1);
        }
        this.viewer.hoverOnPt(n, n2, string, this.pickedMesh.thisID, this.pickedPt);
        return true;
    }

    public synchronized boolean checkObjectDragged(int n, int n2, int n3, int n4, int n5, BS bS) {
        if (this.viewer.getPickingMode() != 4) {
            return false;
        }
        boolean bl = this.viewer.isBound(n5, 8);
        boolean bl2 = this.viewer.isBound(n5, 9);
        if (!bl && !bl2) {
            return false;
        }
        if (n == Integer.MIN_VALUE) {
            return this.findPickedObject(n3, n4, true, bS);
        }
        if (n == Integer.MAX_VALUE) {
            this.pickedMesh = null;
            return false;
        }
        if (this.pickedMesh == null) {
            return false;
        }
        DrawMesh drawMesh = (DrawMesh)this.pickedMesh;
        this.move2D(drawMesh, drawMesh.polygonIndexes[this.pickedModel], this.pickedVertex, n3, n4, bl);
        this.thisMesh = drawMesh;
        return true;
    }

    private void move2D(DrawMesh drawMesh, int[] nArray, int n, int n2, int n3, boolean bl) {
        int n4;
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (this.gdata.isAntialiased()) {
            n2 <<= 1;
            n3 <<= 1;
        }
        P3 p3 = new P3();
        int n5 = nArray[n];
        P3 p32 = P3.newP((Tuple3f)(drawMesh.altVertices == null ? drawMesh.vertices[n5] : (P3)drawMesh.altVertices[n5]));
        P3 p33 = new P3();
        V3 v3 = new V3();
        this.viewer.transformPt3f(p32, p3);
        p3.x = n2;
        p3.y = n3;
        this.viewer.unTransformPoint(p3, p33);
        v3.setT((Tuple3f)p33);
        v3.sub((Tuple3f)p32);
        if (drawMesh.isTriangleSet) {
            n = n5;
        }
        int n6 = !bl ? n + 1 : (drawMesh.isTriangleSet ? drawMesh.vertices.length : nArray.length);
        BS bS = new BS();
        int n7 = n4 = bl ? 0 : n;
        while (n4 < n6) {
            if (bl || n4 == n) {
                int n8;
                int n9 = n8 = drawMesh.isTriangleSet ? n4 : nArray[n4];
                if (!bS.get(n8)) {
                    bS.set(n8);
                    drawMesh.vertices[n8].add((Tuple3f)v3);
                }
            }
            ++n4;
        }
        if (drawMesh.altVertices != null) {
            drawMesh.recalcAltVertices = true;
        }
        drawMesh.setCenters();
    }

    private boolean findPickedObject(int n, int n2, boolean bl, BS bS) {
        int n3 = 100;
        if (this.gdata.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n3 <<= 1;
        }
        this.pickedModel = 0;
        this.pickedVertex = 0;
        this.pickedMesh = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int n4;
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.visibilityFlags == 0) continue;
            int n5 = n4 = drawMesh.isTriangleSet ? drawMesh.polygonCount : (drawMesh.modelFlags == null ? 1 : this.viewer.getModelCount());
            while (--n5 >= 0) {
                int n6;
                if (drawMesh.modelFlags != null && !drawMesh.modelFlags.get(n5) || drawMesh.polygonIndexes == null || !drawMesh.isTriangleSet && (n5 >= drawMesh.polygonIndexes.length || drawMesh.polygonIndexes[n5] == null)) continue;
                int n7 = n6 = drawMesh.isTriangleSet ? 3 : drawMesh.polygonIndexes[n5].length;
                while (--n6 >= 0) {
                    try {
                        int n8 = drawMesh.polygonIndexes[n5][n6];
                        P3 p3 = drawMesh.altVertices == null ? drawMesh.vertices[n8] : (P3)drawMesh.altVertices[n8];
                        int n9 = this.coordinateInRange(n, n2, p3, n3, this.ptXY);
                        if (n9 < 0) continue;
                        this.pickedMesh = drawMesh;
                        n3 = n9;
                        this.pickedModel = n5;
                        this.pickedVertex = n6;
                        this.pickedPt = p3;
                    }
                    catch (Exception exception) {
                        System.out.println(exception);
                    }
                }
            }
        }
        return this.pickedMesh != null;
    }

    protected String getCommand(Mesh mesh) {
        String string;
        if (mesh != null) {
            return this.getCommand2(mesh, mesh.modelIndex);
        }
        SB sB = new SB();
        String string2 = string = this.explicitID && this.previousMeshID != null && TextFormat.isWild((String)this.previousMeshID) ? this.previousMeshID.toUpperCase() : null;
        if (string != null && string.length() == 0) {
            string = null;
        }
        for (int i = 0; i < this.meshCount; ++i) {
            Mesh mesh2 = this.meshes[i];
            if (string != null && !TextFormat.isMatch((String)mesh2.thisID.toUpperCase(), (String)string, (boolean)true, (boolean)true)) continue;
            sB.append(this.getCommand2(mesh2, mesh2.modelIndex));
        }
        return sB.toString();
    }

    protected String getCommand2(Mesh mesh, int n) {
        Object object;
        int n2;
        DrawMesh drawMesh = (DrawMesh)mesh;
        if (drawMesh.drawType == EnumDrawType.NONE && drawMesh.lineData == null && drawMesh.drawVertexCount == 0 && drawMesh.drawVertexCounts == null) {
            return "";
        }
        SB sB = new SB();
        int n3 = this.viewer.getModelCount();
        if (!drawMesh.isFixed && n >= 0 && n3 > 1) {
            Draw.appendCmd((SB)sB, (String)("frame " + this.viewer.getModelNumberDotted(n)));
        }
        sB.append("  draw ID ").append(Escape.eS((String)drawMesh.thisID));
        if (drawMesh.isFixed) {
            sB.append(" fixed");
        }
        if (n < 0) {
            n = 0;
        }
        if (drawMesh.noHead) {
            sB.append(" noHead");
        } else if (drawMesh.isBarb) {
            sB.append(" barb");
        }
        if (drawMesh.scale != 1.0f && drawMesh.isScaleSet && (drawMesh.haveXyPoints || drawMesh.connections != null || drawMesh.drawType == EnumDrawType.CIRCLE || drawMesh.drawType == EnumDrawType.ARC)) {
            sB.append(" scale ").appendF(drawMesh.scale);
        }
        if (drawMesh.width != 0.0f) {
            sB.append(" diameter ").appendF(drawMesh.drawType == EnumDrawType.CYLINDER ? Math.abs(drawMesh.width) : (drawMesh.drawType == EnumDrawType.CIRCULARPLANE ? Math.abs(drawMesh.width * drawMesh.scale) : drawMesh.width));
        } else if (drawMesh.diameter > 0) {
            sB.append(" diameter ").appendI(drawMesh.diameter);
        }
        if (drawMesh.lineData != null) {
            sB.append("  lineData [");
            n2 = drawMesh.lineData.size();
            int n4 = 0;
            while (n4 < n2) {
                object = (P3[])drawMesh.lineData.get(n4);
                String string = Escape.eP((Tuple3f)object[0]);
                sB.append(string.substring(1, string.length() - 1));
                sB.append(",");
                string = Escape.eP((Tuple3f)object[1]);
                sB.append(string.substring(1, string.length() - 1));
                if (++n4 >= n2) continue;
                sB.append(", ");
            }
            sB.append("]");
        } else {
            n2 = drawMesh.drawVertexCount > 0 || drawMesh.drawVertexCounts == null ? drawMesh.drawVertexCount : drawMesh.drawVertexCounts[n >= 0 ? n : 0];
            switch (drawMesh.drawTypes == null ? drawMesh.drawType : drawMesh.drawTypes[n]) {
                case NONE: 
                case MULTIPLE: {
                    break;
                }
                case POLYGON: {
                    sB.append(" POLYGON ").appendI(n2);
                    break;
                }
                case PLANE: {
                    if (n2 != 4) break;
                    sB.append(" PLANE");
                    break;
                }
                case LINE_SEGMENT: {
                    sB.append(" LINE");
                    break;
                }
                case ARC: {
                    sB.append(drawMesh.isVector ? " ARROW ARC" : " ARC");
                    break;
                }
                case ARROW: {
                    sB.append(drawMesh.isVector ? " VECTOR" : " ARROW");
                    if (drawMesh.connections == null) break;
                    sB.append(" connect ").append(Escape.eAI((int[])drawMesh.connections));
                    break;
                }
                case CIRCLE: {
                    sB.append(" CIRCLE");
                    break;
                }
                case CURVE: {
                    sB.append(" CURVE");
                    break;
                }
                case CIRCULARPLANE: 
                case CYLINDER: {
                    sB.append(" CYLINDER");
                    break;
                }
                case POINT: {
                    n2 = 1;
                    break;
                }
                case LINE: {
                    n2 = 2;
                }
            }
            if (drawMesh.modelIndex < 0 && !drawMesh.isFixed) {
                for (int i = 0; i < n3; ++i) {
                    if (!Draw.isPolygonDisplayable(drawMesh, i)) continue;
                    if (n2 == 0) {
                        n2 = drawMesh.drawVertexCounts[i];
                    }
                    sB.append(" [ " + i);
                    object = Draw.getVertexList(drawMesh, i, n2);
                    if (((String)object).indexOf("NaN") >= 0) {
                        return "";
                    }
                    sB.append((String)object);
                    sB.append(" ] ");
                }
            } else if (drawMesh.drawType == EnumDrawType.POLYGON) {
                int n5;
                for (n5 = 0; n5 < drawMesh.vertexCount; ++n5) {
                    sB.append(" ").append(Escape.eP((Tuple3f)drawMesh.vertices[n5]));
                }
                sB.append(" ").appendI(drawMesh.polygonCount);
                for (n5 = 0; n5 < drawMesh.polygonCount; ++n5) {
                    if (drawMesh.polygonIndexes[n5] == null) {
                        sB.append(" [0 0 0 0]");
                        continue;
                    }
                    sB.append(" ").append(Escape.eAI((int[])drawMesh.polygonIndexes[n5]));
                }
            } else {
                String string = Draw.getVertexList(drawMesh, n, n2);
                if (string.indexOf("NaN") >= 0) {
                    return "";
                }
                sB.append(string);
            }
        }
        if (drawMesh.mat4 != null) {
            V3 v3 = new V3();
            drawMesh.mat4.get(v3);
            sB.append(" offset ").append(Escape.eP((Tuple3f)v3));
        }
        if (drawMesh.title != null) {
            String string = "";
            for (int i = 0; i < drawMesh.title.length; ++i) {
                string = string + "|" + drawMesh.title[i];
            }
            sB.append(Escape.eS((String)string.substring(1)));
        }
        sB.append(";\n");
        Draw.appendCmd((SB)sB, (String)drawMesh.getState("draw"));
        Draw.appendCmd((SB)sB, (String)Draw.getColorCommandUnk((String)"draw", (short)drawMesh.colix, (boolean)this.translucentAllowed));
        return sB.toString();
    }

    public static boolean isPolygonDisplayable(Mesh mesh, int n) {
        return n < mesh.polygonIndexes.length && mesh.polygonIndexes[n] != null && mesh.polygonIndexes[n].length > 0;
    }

    private static String getVertexList(DrawMesh drawMesh, int n, int n2) {
        String string = "";
        try {
            if (n >= drawMesh.polygonIndexes.length) {
                n = 0;
            }
            boolean bl = drawMesh.isVector && drawMesh.drawType != EnumDrawType.ARC;
            for (int i = 0; i < n2; ++i) {
                P3 p3 = drawMesh.vertices[drawMesh.polygonIndexes[n][i]];
                if (p3.z == Float.MAX_VALUE || p3.z == -3.4028235E38f) {
                    string = string + (i == 0 ? " " : " ,") + "[" + (int)p3.x + " " + (int)p3.y + (p3.z < 0.0f ? " %]" : "]");
                    continue;
                }
                if (bl && i == 1) {
                    P3 p32 = P3.newP((Tuple3f)p3);
                    p32.sub((Tuple3f)drawMesh.vertices[drawMesh.polygonIndexes[n][0]]);
                    string = string + " " + Escape.eP((Tuple3f)p32);
                    continue;
                }
                string = string + " " + Escape.eP((Tuple3f)p3);
            }
        }
        catch (Exception exception) {
            Logger.error((String)"Unexpected error in Draw.getVertexList");
        }
        return string;
    }

    public JmolList<Map<String, Object>> getShapeDetail() {
        JmolList jmolList = new JmolList();
        for (int i = 0; i < this.meshCount; ++i) {
            int n;
            JmolList jmolList2;
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.vertexCount == 0) continue;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            hashtable.put("fixed", drawMesh.ptCenters == null ? Boolean.TRUE : Boolean.FALSE);
            hashtable.put("ID", drawMesh.thisID == null ? "<noid>" : drawMesh.thisID);
            hashtable.put("drawType", drawMesh.drawType.name);
            if (drawMesh.diameter > 0) {
                hashtable.put("diameter", drawMesh.diameter);
            }
            if (drawMesh.width != 0.0f) {
                hashtable.put("width", Float.valueOf(drawMesh.width));
            }
            hashtable.put("scale", Float.valueOf(drawMesh.scale));
            if (drawMesh.drawType == EnumDrawType.MULTIPLE) {
                jmolList2 = new JmolList();
                n = this.viewer.getModelCount();
                for (int j = 0; j < n; ++j) {
                    if (drawMesh.ptCenters[j] == null) continue;
                    Hashtable<String, Object> hashtable2 = new Hashtable<String, Object>();
                    hashtable2.put("modelIndex", j);
                    hashtable2.put("command", this.getCommand2(drawMesh, j));
                    hashtable2.put("center", drawMesh.ptCenters[j]);
                    int n2 = drawMesh.drawVertexCounts[j];
                    hashtable2.put("vertexCount", n2);
                    if (n2 > 1) {
                        hashtable2.put("axis", drawMesh.axes[j]);
                    }
                    JmolList jmolList3 = new JmolList();
                    for (int k = 0; k < n2; ++k) {
                        jmolList3.addLast((Object)drawMesh.vertices[drawMesh.polygonIndexes[j][k]]);
                    }
                    hashtable2.put("vertices", jmolList3);
                    if (drawMesh.drawTypes[j] == EnumDrawType.LINE) {
                        float f = drawMesh.vertices[drawMesh.polygonIndexes[j][0]].distance((Tuple3f)drawMesh.vertices[drawMesh.polygonIndexes[j][1]]);
                        hashtable2.put("length_Ang", Float.valueOf(f));
                    }
                    jmolList2.addLast(hashtable2);
                }
                hashtable.put("models", jmolList2);
            } else {
                hashtable.put("command", this.getCommand(drawMesh));
                hashtable.put("center", drawMesh.ptCenter);
                if (drawMesh.drawVertexCount > 1) {
                    hashtable.put("axis", drawMesh.axis);
                }
                jmolList2 = new JmolList();
                for (n = 0; n < drawMesh.vertexCount; ++n) {
                    jmolList2.addLast((Object)drawMesh.vertices[n]);
                }
                hashtable.put("vertices", jmolList2);
                if (drawMesh.drawType == EnumDrawType.LINE) {
                    hashtable.put("length_Ang", Float.valueOf(drawMesh.vertices[0].distance((Tuple3f)drawMesh.vertices[1])));
                }
            }
            jmolList.addLast(hashtable);
        }
        return jmolList;
    }

    public String getShapeState() {
        SB sB = new SB();
        sB.append("\n");
        Draw.appendCmd((SB)sB, (String)(this.myType + " delete"));
        for (int i = 0; i < this.meshCount; ++i) {
            DrawMesh drawMesh = this.dmeshes[i];
            if (drawMesh.vertexCount == 0 && drawMesh.lineData == null) continue;
            sB.append(this.getCommand2(drawMesh, drawMesh.modelIndex));
            if (drawMesh.visible) continue;
            sB.append(" " + this.myType + " ID " + Escape.eS((String)drawMesh.thisID) + " off;\n");
        }
        return sB.toString();
    }

    public static P3 randomPoint() {
        return P3.new3((float)((float)Math.random()), (float)((float)Math.random()), (float)((float)Math.random()));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EnumDrawType {
        MULTIPLE(-1, "multiple"),
        NONE(0, "none"),
        POINT(1, "point"),
        LINE(2, "line"),
        PLANE(4, "plane"),
        CYLINDER(14, "cylinder"),
        ARROW(15, "arrow"),
        CIRCLE(16, "circle"),
        CURVE(17, "curve"),
        CIRCULARPLANE(18, "circularPlane"),
        ARC(19, "arc"),
        LINE_SEGMENT(20, "lineSegment"),
        POLYGON(21, "polygon");

        final int id;
        final String name;

        private EnumDrawType(int n2, String string2) {
            this.id = n2;
            this.name = string2;
        }

        public static EnumDrawType getType(int n) {
            switch (n) {
                case 1: {
                    return POINT;
                }
                case 2: {
                    return LINE;
                }
                case 4: {
                    return PLANE;
                }
            }
            return NONE;
        }
    }
}

