/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.SB;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

public class XmlVaspReader
extends XmlReader {
    private SB data;
    private String name;
    private int atomCount;
    private int iAtom;
    private boolean isE_wo_entrp = false;
    private boolean isE_fr_energy = false;
    private String enthalpy = null;
    private String gibbsEnergy = null;
    private String[] myAttributes = new String[]{"name"};
    boolean haveUnitCell = false;
    String[] atomNames;
    String[] atomSyms;
    String atomName;
    String atomSym;
    float a;
    float b;
    float c;
    float alpha;
    float beta;
    float gamma;

    XmlVaspReader() {
    }

    protected String[] getDOMAttributes() {
        return this.myAttributes;
    }

    protected void processXml(XmlReader xmlReader, Object object) throws Exception {
        xmlReader.doProcessLines = true;
        this.PX(xmlReader, object);
    }

    public void processStartElement(String string) {
        if (Logger.debugging) {
            Logger.debug((String)("xmlvasp: start " + string));
        }
        if (!this.parent.continuing) {
            return;
        }
        if ("calculation".equals(string)) {
            this.enthalpy = null;
            this.gibbsEnergy = null;
            return;
        }
        if ("i".equals(string)) {
            String string2 = (String)this.atts.get("name");
            if (string2.charAt(0) != 'e') {
                return;
            }
            this.isE_wo_entrp = string2.equals("e_wo_entrp");
            this.isE_fr_energy = string2.equals("e_fr_energy");
            this.keepChars = this.isE_wo_entrp || this.isE_fr_energy;
            return;
        }
        if ("structure".equals(string)) {
            if (!this.parent.doGetModel(++this.parent.modelNumber, null)) {
                this.parent.checkLastModel();
                return;
            }
            this.parent.setFractionalCoordinates(true);
            this.atomSetCollection.setDoFixPeriodic();
            this.atomSetCollection.newAtomSet();
            if (this.enthalpy != null) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("enthalpy", (Object)Parser.dVal((String)this.enthalpy));
            }
            if (this.gibbsEnergy != null) {
                this.atomSetCollection.setAtomSetEnergy("" + this.gibbsEnergy, this.parseFloatStr(this.gibbsEnergy));
                this.atomSetCollection.setAtomSetAuxiliaryInfo("gibbsEnergy", (Object)Parser.dVal((String)this.gibbsEnergy));
            }
            if (this.enthalpy != null && this.gibbsEnergy != null) {
                this.atomSetCollection.setAtomSetName("Enthalpy = " + this.enthalpy + " eV Gibbs Energy = " + this.gibbsEnergy + " eV");
            }
            return;
        }
        if (!this.parent.doProcessLines) {
            return;
        }
        if ("v".equals(string)) {
            this.keepChars = this.data != null;
            return;
        }
        if ("c".equals(string)) {
            this.keepChars = this.iAtom < this.atomCount;
            return;
        }
        if ("varray".equals(string)) {
            this.name = (String)this.atts.get("name");
            if (this.name != null && Parser.isOneOf((String)this.name, (String)";basis;positions;forces;")) {
                this.data = new SB();
            }
            return;
        }
        if ("atoms".equals(string)) {
            this.keepChars = true;
            return;
        }
    }

    void processEndElement(String string) {
        if (Logger.debugging) {
            Logger.debug((String)("xmlvasp: end " + string));
        }
        if (this.parent.doProcessLines) {
            if (this.isE_wo_entrp) {
                this.isE_wo_entrp = false;
                this.enthalpy = this.chars.trim();
            } else if (this.isE_fr_energy) {
                this.isE_fr_energy = false;
                this.gibbsEnergy = this.chars.trim();
            } else if ("v".equals(string) && this.data != null) {
                this.data.append(this.chars);
            } else if ("c".equals(string)) {
                if (this.iAtom < this.atomCount) {
                    if (this.atomName == null) {
                        this.atomName = this.atomSym = this.chars.trim();
                    } else {
                        this.atomNames[this.iAtom++] = this.atomName + this.chars.trim();
                        this.atomName = null;
                    }
                }
            } else if ("atoms".equals(string)) {
                this.atomCount = this.parseIntStr(this.chars);
                this.atomNames = new String[this.atomCount];
                this.atomSyms = new String[this.atomCount];
                this.iAtom = 0;
            } else if ("varray".equals(string) && this.data != null) {
                if (this.name != null) {
                    if ("basis".equals(this.name) && !this.haveUnitCell) {
                        this.haveUnitCell = true;
                        float[] fArray = XmlVaspReader.getTokensFloat((String)this.data.toString(), null, (int)9);
                        V3 v3 = V3.new3((float)fArray[0], (float)fArray[1], (float)fArray[2]);
                        V3 v32 = V3.new3((float)fArray[3], (float)fArray[4], (float)fArray[5]);
                        V3 v33 = V3.new3((float)fArray[6], (float)fArray[7], (float)fArray[8]);
                        this.a = v3.length();
                        this.b = v32.length();
                        this.c = v33.length();
                        v3.normalize();
                        v32.normalize();
                        v33.normalize();
                        this.alpha = (float)(Math.acos(v32.dot((Tuple3f)v33)) * 180.0 / Math.PI);
                        this.beta = (float)(Math.acos(v3.dot((Tuple3f)v33)) * 180.0 / Math.PI);
                        this.gamma = (float)(Math.acos(v3.dot((Tuple3f)v32)) * 180.0 / Math.PI);
                    } else if ("positions".equals(this.name)) {
                        this.parent.setUnitCell(this.a, this.b, this.c, this.alpha, this.beta, this.gamma);
                        float[] fArray = new float[this.atomCount * 3];
                        XmlVaspReader.getTokensFloat((String)this.data.toString(), (float[])fArray, (int)(this.atomCount * 3));
                        int n = 0;
                        for (int i = 0; i < this.atomCount; ++i) {
                            Atom atom = this.atomSetCollection.addNewAtom();
                            this.parent.setAtomCoordXYZ(atom, fArray[n++], fArray[n++], fArray[n++]);
                            atom.elementSymbol = this.atomSyms[i];
                            atom.atomName = this.atomNames[i];
                        }
                    } else if ("forces".equals(this.name)) {
                        float[] fArray = new float[this.atomCount * 3];
                        XmlVaspReader.getTokensFloat((String)this.data.toString(), (float[])fArray, (int)(this.atomCount * 3));
                        int n = 0;
                        int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
                        for (int i = 0; i < this.atomCount; ++i) {
                            this.atomSetCollection.addVibrationVector(n2 + i, fArray[n++], fArray[n++], fArray[n++]);
                        }
                    }
                }
                this.data = null;
            } else if ("structure".equals(string)) {
                try {
                    this.parent.applySymmetryAndSetTrajectory();
                }
                catch (Exception exception) {}
            } else {
                return;
            }
        }
        this.chars = null;
        this.keepChars = false;
    }
}

