/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import org.jmol.io.OutputStringBuilder;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.HBond;
import org.jmol.modelset.LabelToken;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.NucleicMonomer;
import org.jmol.util.BS;
import org.jmol.util.JmolList;
import org.jmol.util.Measure;
import org.jmol.util.P3;
import org.jmol.util.P4;
import org.jmol.util.SB;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NucleicPolymer
extends BioPolymer {
    NucleicPolymer(Monomer[] monomerArray) {
        super(monomerArray);
        this.type = 2;
        this.hasWingPoints = true;
    }

    Atom getNucleicPhosphorusAtom(int n) {
        return this.monomers[n].getLeadAtom();
    }

    @Override
    protected boolean calcEtaThetaAngles() {
        float f = Float.NaN;
        for (int i = 0; i < this.monomerCount - 2; ++i) {
            NucleicMonomer nucleicMonomer = (NucleicMonomer)this.monomers[i];
            NucleicMonomer nucleicMonomer2 = (NucleicMonomer)this.monomers[i + 1];
            Atom atom = nucleicMonomer.getP();
            Atom atom2 = nucleicMonomer.getC4P();
            Atom atom3 = nucleicMonomer2.getP();
            Atom atom4 = nucleicMonomer2.getC4P();
            if (i > 0) {
                NucleicMonomer nucleicMonomer3 = (NucleicMonomer)this.monomers[i - 1];
                Atom atom5 = nucleicMonomer3.getC4P();
                f = Measure.computeTorsion((Tuple3f)atom5, (Tuple3f)atom, (Tuple3f)atom2, (Tuple3f)atom3, (boolean)true);
            }
            float f2 = Measure.computeTorsion((Tuple3f)atom, (Tuple3f)atom2, (Tuple3f)atom3, (Tuple3f)atom4, (boolean)true);
            if (f < 0.0f) {
                f += 360.0f;
            }
            if (f2 < 0.0f) {
                f2 += 360.0f;
            }
            nucleicMonomer.setGroupParameter(1112539141, f);
            nucleicMonomer.setGroupParameter(1112539152, f2);
        }
        return true;
    }

    @Override
    public void calcRasmolHydrogenBonds(BioPolymer bioPolymer, BS bS, BS bS2, JmolList<Bond> jmolList, int n, int[][][] nArray, boolean bl, boolean bl2) {
        NucleicPolymer nucleicPolymer = (NucleicPolymer)bioPolymer;
        V3 v3 = new V3();
        V3 v32 = new V3();
        V3 v33 = new V3();
        int n2 = this.monomerCount;
        while (--n2 >= 0) {
            NucleicMonomer nucleicMonomer = (NucleicMonomer)this.monomers[n2];
            if (!nucleicMonomer.isPurine()) continue;
            Atom atom = nucleicMonomer.getN3();
            boolean bl3 = bS.get(atom.index);
            if (!bl3 && !bS2.get(atom.index)) continue;
            Atom atom2 = nucleicMonomer.getN1();
            Atom atom3 = nucleicMonomer.getN0();
            P4 p4 = new P4();
            Measure.getPlaneThroughPoints((P3)atom, (P3)atom2, (P3)atom3, (V3)v3, (V3)v32, (V3)v33, (P4)p4);
            Atom atom4 = null;
            float f = 25.0f;
            NucleicMonomer nucleicMonomer2 = null;
            int n3 = nucleicPolymer.monomerCount;
            while (--n3 >= 0) {
                NucleicMonomer nucleicMonomer3 = (NucleicMonomer)nucleicPolymer.monomers[n3];
                if (!nucleicMonomer3.isPyrimidine()) continue;
                Atom atom5 = nucleicMonomer3.getN3();
                if (bl3 ? !bS2.get(atom5.index) : !bS.get(atom5.index)) continue;
                Atom atom6 = nucleicMonomer3.getN0();
                float f2 = atom2.distanceSquared((Tuple3f)atom5);
                if (!(f2 < f) || !(atom3.distanceSquared((Tuple3f)atom6) > 50.0f) || !(Math.abs(Measure.distanceToPlane((P4)p4, (P3)atom5)) < 1.0f)) continue;
                nucleicMonomer2 = nucleicMonomer3;
                atom4 = atom5;
                f = f2;
            }
            n3 = 0;
            if (atom4 == null || (n3 += NucleicPolymer.addHydrogenBond(jmolList, atom2, atom4)) >= n) continue;
            if (nucleicMonomer.isGuanine()) {
                if ((n3 += NucleicPolymer.addHydrogenBond(jmolList, nucleicMonomer.getN2(), nucleicMonomer2.getO2())) >= n || (n3 += NucleicPolymer.addHydrogenBond(jmolList, nucleicMonomer.getO6(), nucleicMonomer2.getN4())) < n) continue;
                continue;
            }
            n3 += NucleicPolymer.addHydrogenBond(jmolList, nucleicMonomer.getN6(), nucleicMonomer2.getO4());
        }
    }

    protected static int addHydrogenBond(JmolList<Bond> jmolList, Atom atom, Atom atom2) {
        if (atom == null || atom2 == null) {
            return 0;
        }
        jmolList.addLast((Object)new HBond(atom, atom2, 18432, 1, 0, 0.0f));
        return 1;
    }

    @Override
    public void getPdbData(Viewer viewer, char c, char c2, int n, int n2, BS bS, BS bS2, boolean bl, boolean bl2, boolean bl3, LabelToken[] labelTokenArray, OutputStringBuilder outputStringBuilder, SB sB, BS bS3) {
        NucleicPolymer.getPdbData(viewer, this, c, c2, n, n2, bS, bS2, bl, bl2, bl3, labelTokenArray, outputStringBuilder, sB, bS3);
    }
}

