/*
 * Decompiled with CFR 0.152.
 */
package jspecview.util;

import java.util.BitSet;
import jspecview.util.JSVLogger;
import jspecview.util.JSVTextFormat;

public class JSVParser {
    private static final float[] decimalScale = new float[]{0.1f, 0.01f, 0.001f, 1.0E-4f, 1.0E-5f, 1.0E-6f, 1.0E-7f, 1.0E-8f};
    private static final float[] tensScale = new float[]{10.0f, 100.0f, 1000.0f, 10000.0f, 100000.0f, 1000000.0f};

    public static int parseStringInfestedFloatArray(String str, BitSet bs, float[] data) {
        return JSVParser.parseFloatArray(JSVParser.getTokens(str), bs, data);
    }

    public static float[] parseFloatArray(String str) {
        return JSVParser.parseFloatArray(str, new int[1]);
    }

    public static float[] parseFloatArray(String str, int[] next) {
        int n;
        int pt = next[0];
        if (pt < 0) {
            return new float[0];
        }
        if ((pt = str.indexOf("[", pt)) >= 0) {
            str = str.substring(pt + 1);
        }
        next[0] = pt + 1;
        pt = str.indexOf("]");
        if (pt < 0) {
            pt = str.length();
        } else {
            str = str.substring(0, pt);
        }
        next[0] = next[0] + (pt + 1);
        String[] tokens = JSVParser.getTokens(str);
        float[] f = new float[tokens.length];
        int i = n = JSVParser.parseFloatArray(tokens, null, f);
        while (i < f.length) {
            f[i] = Float.NaN;
            ++i;
        }
        return f;
    }

    public static int parseFloatArray(String[] tokens, BitSet bs, float[] data) {
        int len = data.length;
        int nTokens = tokens.length;
        int n = 0;
        int max = 0;
        boolean haveBitSet = bs != null;
        int i = haveBitSet ? bs.nextSetBit(0) : 0;
        while (i >= 0 && i < len && n < nTokens) {
            float f;
            while (Float.isNaN(f = JSVParser.parseFloat(tokens[n++])) && n < nTokens) {
            }
            if (!Float.isNaN(f)) {
                max = i;
                data[max] = f;
            }
            if (n == nTokens) break;
            int n2 = i = haveBitSet ? bs.nextSetBit(i + 1) : i + 1;
        }
        return max + 1;
    }

    private static String fixDataString(String str) {
        str = str.replace(';', str.indexOf(10) < 0 ? (char)'\n' : ' ');
        str = JSVTextFormat.trim(str, "\n \t");
        str = JSVTextFormat.simpleReplace(str, "\n ", "\n");
        str = JSVTextFormat.simpleReplace(str, "\n\n", "\n");
        return str;
    }

    public static float[][] parseFloatArray2d(String str) {
        str = JSVParser.fixDataString(str);
        int[] lines = JSVParser.markLines(str, '\n');
        int nLines = lines.length;
        float[][] data = new float[nLines][];
        int iLine = 0;
        int pt = 0;
        while (iLine < nLines) {
            String[] tokens = JSVParser.getTokens(str.substring(pt, lines[iLine]));
            data[iLine] = new float[tokens.length];
            JSVParser.parseFloatArray(tokens, data[iLine]);
            pt = lines[iLine++];
        }
        return data;
    }

    public static float[][][] parseFloatArray3d(String str) {
        str = JSVParser.fixDataString(str);
        int[] lines = JSVParser.markLines(str, '\n');
        int nLines = lines.length;
        String[] tokens = JSVParser.getTokens(str.substring(0, lines[0]));
        if (tokens.length != 3) {
            return new float[0][0][0];
        }
        int nX = JSVParser.parseInt(tokens[0]);
        int nY = JSVParser.parseInt(tokens[1]);
        int nZ = JSVParser.parseInt(tokens[2]);
        if (nX < 1 || nY < 1 || nZ < 1) {
            return new float[1][1][1];
        }
        float[][][] data = new float[nX][nY][];
        int iX = 0;
        int iY = 0;
        int iLine = 1;
        int pt = lines[0];
        while (iLine < nLines && iX < nX) {
            tokens = JSVParser.getTokens(str.substring(pt, lines[iLine]));
            if (tokens.length >= nZ) {
                float[] fArray = new float[tokens.length];
                data[iX][iY] = fArray;
                JSVParser.parseFloatArray(tokens, fArray);
                if (++iY == nY) {
                    ++iX;
                    iY = 0;
                }
            }
            pt = lines[iLine++];
        }
        if (iX != nX) {
            JSVLogger.info("Error reading 3D data -- nX = " + nX + ", but only " + iX + " blocks read");
            return new float[1][1][1];
        }
        return data;
    }

    public static void setSelectedFloats(float f, BitSet bs, float[] data) {
        int i0;
        boolean isAll = bs == null;
        int i = i0 = isAll ? 0 : bs.nextSetBit(0);
        while (i >= 0 && i < data.length) {
            data[i] = f;
            int n = i = isAll ? i + 1 : bs.nextSetBit(i + 1);
        }
    }

    public static float[] extractData(String data, int field, int nBytes, int firstLine) {
        return JSVParser.parseFloatArrayFromMatchAndField(data, null, 0, 0, null, field, nBytes, null, firstLine);
    }

    public static float[] parseFloatArrayFromMatchAndField(String str, BitSet bs, int fieldMatch, int fieldMatchColumnCount, int[] matchData, int field, int fieldColumnCount, float[] data, int firstLine) {
        int i = -1;
        boolean isMatch = matchData != null;
        int[] lines = JSVParser.markLines(str, str.indexOf(10) >= 0 ? (char)'\n' : ';');
        int iLine = firstLine <= 1 || firstLine >= lines.length ? 0 : firstLine - 1;
        int pt = iLine == 0 ? 0 : lines[iLine - 1];
        int nLines = lines.length;
        if (data == null) {
            data = new float[nLines - iLine];
        }
        int len = data.length;
        int minLen = fieldColumnCount <= 0 ? Math.max(field, fieldMatch) : Math.max(field + fieldColumnCount, fieldMatch + fieldMatchColumnCount) - 1;
        boolean haveBitSet = bs != null;
        while (iLine < nLines) {
            block4: {
                float f;
                block6: {
                    int iData;
                    block5: {
                        String[] tokens;
                        String line = str.substring(pt, lines[iLine]).trim();
                        pt = lines[iLine];
                        String[] stringArray = tokens = fieldColumnCount <= 0 ? JSVParser.getTokens(line) : null;
                        if (fieldColumnCount > 0 ? line.length() < minLen || Float.isNaN(f = JSVParser.parseFloat(line.substring(field - 1, field + fieldColumnCount - 1))) : tokens.length < minLen || Float.isNaN(f = JSVParser.parseFloat(tokens[field - 1]))) break block4;
                        if (!isMatch) break block5;
                        iData = JSVParser.parseInt(tokens == null ? line.substring(fieldMatch - 1, fieldMatch + fieldMatchColumnCount - 1) : tokens[fieldMatch - 1]);
                        if (iData == Integer.MIN_VALUE || iData < 0 || iData >= len || (iData = matchData[iData]) < 0) break block4;
                        if (haveBitSet) {
                            bs.set(iData);
                        }
                        break block6;
                    }
                    i = haveBitSet ? bs.nextSetBit(i + 1) : ++i;
                    if (i < 0 || i >= len) {
                        return data;
                    }
                    iData = i;
                }
                data[iData] = f;
            }
            ++iLine;
        }
        return data;
    }

    public static void parseFloatArray(String[] tokens, float[] data) {
        JSVParser.parseFloatArray(tokens, data, data.length);
    }

    public static void parseFloatArray(String[] tokens, float[] data, int nData) {
        int i = nData;
        while (--i >= 0) {
            float f = data[i] = i >= tokens.length ? Float.NaN : JSVParser.parseFloat(tokens[i]);
        }
    }

    public static float parseFloat(String str) {
        return JSVParser.parseFloat(str, new int[1]);
    }

    public static float parseFloatStrict(String str) {
        int cch = str.length();
        if (cch == 0) {
            return Float.NaN;
        }
        return JSVParser.parseFloatChecked(str, cch, new int[1], true);
    }

    public static int parseInt(String str) {
        return JSVParser.parseInt(str, new int[1]);
    }

    public static String[] getTokens(String line) {
        return JSVParser.getTokens(line, 0);
    }

    public static String parseToken(String str) {
        return JSVParser.parseToken(str, new int[1]);
    }

    public static String parseTrimmed(String str) {
        return JSVParser.parseTrimmed(str, 0, str.length());
    }

    public static String parseTrimmed(String str, int ichStart) {
        return JSVParser.parseTrimmed(str, ichStart, str.length());
    }

    public static String parseTrimmed(String str, int ichStart, int ichMax) {
        int cch = str.length();
        if (ichMax < cch) {
            cch = ichMax;
        }
        if (cch < ichStart) {
            return "";
        }
        return JSVParser.parseTrimmedChecked(str, ichStart, cch);
    }

    public static int[] markLines(String data, char eol) {
        int nLines = 0;
        int i = data.length();
        while (--i >= 0) {
            if (data.charAt(i) != eol) continue;
            ++nLines;
        }
        int[] lines = new int[nLines + 1];
        lines[nLines--] = data.length();
        int i2 = data.length();
        while (--i2 >= 0) {
            if (data.charAt(i2) != eol) continue;
            lines[nLines--] = i2 + 1;
        }
        return lines;
    }

    public static float parseFloat(String str, int[] next) {
        if (str == null) {
            return Float.NaN;
        }
        int cch = str.length();
        if (next[0] < 0 || next[0] >= cch) {
            return Float.NaN;
        }
        return JSVParser.parseFloatChecked(str, cch, next, false);
    }

    public static float parseFloat(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (next[0] < 0 || next[0] >= ichMax) {
            return Float.NaN;
        }
        return JSVParser.parseFloatChecked(str, ichMax, next, false);
    }

    /*
     * Unable to fully structure code
     */
    private static float parseFloatChecked(String str, int ichMax, int[] next, boolean isStrict) {
        digitSeen = false;
        value = 0.0f;
        ich = next[0];
        if (!isStrict || str.indexOf(10) == str.lastIndexOf(10)) ** GOTO lbl7
        return NaNf;
lbl-1000:
        // 1 sources

        {
            ++ich;
lbl7:
            // 2 sources

            ** while (ich < ichMax && JSVParser.isWhiteSpace((String)str, (int)ich))
        }
lbl8:
        // 1 sources

        negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            ++ich;
            negative = true;
        }
        ch = '\u0000';
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            value = value * 10.0f + (float)(ch - 48);
            ++ich;
            digitSeen = true;
        }
        isDecimal = false;
        if (ch == '.') {
            isDecimal = true;
            iscale = 0;
            while (++ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
                if (iscale < JSVParser.decimalScale.length) {
                    value += (float)(ch - 48) * JSVParser.decimalScale[iscale];
                }
                ++iscale;
                digitSeen = true;
            }
        }
        isExponent = false;
        if (!digitSeen) {
            value = NaNf;
        } else if (negative) {
            value = -value;
        }
        if (ich < ichMax && (ch == 'E' || ch == 'e' || ch == 'D')) {
            isExponent = true;
            if (++ich >= ichMax) {
                return NaNf;
            }
            ch = str.charAt(ich);
            if (ch == '+' && ++ich >= ichMax) {
                return NaNf;
            }
            next[0] = ich;
            exponent = JSVParser.parseIntChecked(str, ichMax, next);
            if (exponent == -2147483648) {
                return NaNf;
            }
            if (exponent > 0) {
                value = (float)((double)value * (exponent < JSVParser.tensScale.length ? (double)JSVParser.tensScale[exponent - 1] : Math.pow(10.0, exponent)));
            } else if (exponent < 0) {
                value = (float)((double)value * (-exponent < JSVParser.decimalScale.length ? (double)JSVParser.decimalScale[-exponent - 1] : Math.pow(10.0, exponent)));
            }
        } else {
            next[0] = ich;
        }
        if (value == -Infinityf) {
            value = -3.4028235E38f;
        } else if (value == Infinityf) {
            value = 3.4028235E38f;
        }
        return isStrict == false || (isExponent == false || isDecimal != false) && JSVParser.checkTrailingText(str, next[0], ichMax) != false ? value : NaNf;
    }

    private static boolean checkTrailingText(String str, int ich, int ichMax) {
        char ch;
        while (ich < ichMax && ((ch = str.charAt(ich)) == ' ' || ch == '\t' || ch == '\n' || ch == ';')) {
            ++ich;
        }
        return ich == ichMax;
    }

    public static int parseInt(String str, int[] next) {
        int cch = str.length();
        if (next[0] < 0 || next[0] >= cch) {
            return Integer.MIN_VALUE;
        }
        return JSVParser.parseIntChecked(str, cch, next);
    }

    public static int parseInt(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (next[0] < 0 || next[0] >= ichMax) {
            return Integer.MIN_VALUE;
        }
        return JSVParser.parseIntChecked(str, ichMax, next);
    }

    /*
     * Unable to fully structure code
     */
    private static int parseIntChecked(String str, int ichMax, int[] next) {
        digitSeen = false;
        value = 0;
        ich = next[0];
        if (ich >= 0) ** GOTO lbl7
        return -2147483648;
lbl-1000:
        // 1 sources

        {
            ++ich;
lbl7:
            // 2 sources

            ** while (ich < ichMax && JSVParser.isWhiteSpace((String)str, (int)ich))
        }
lbl8:
        // 1 sources

        negative = false;
        if (ich < ichMax && str.charAt(ich) == '-') {
            negative = true;
            ++ich;
        }
        while (ich < ichMax && (ch = str.charAt(ich)) >= '0' && ch <= '9') {
            value = value * 10 + (ch - 48);
            digitSeen = true;
            ++ich;
        }
        if (!digitSeen) {
            value = -2147483648;
        } else if (negative) {
            value = -value;
        }
        next[0] = ich;
        return value;
    }

    public static String[] getTokens(String line, int ich) {
        if (line == null) {
            return null;
        }
        int cchLine = line.length();
        if (ich < 0 || ich > cchLine) {
            return null;
        }
        int tokenCount = JSVParser.countTokens(line, ich);
        String[] tokens = new String[tokenCount];
        int[] next = new int[]{ich};
        int i = 0;
        while (i < tokenCount) {
            tokens[i] = JSVParser.parseTokenChecked(line, cchLine, next);
            ++i;
        }
        return tokens;
    }

    private static int countTokens(String line, int ich) {
        int tokenCount = 0;
        if (line != null) {
            int ichMax = line.length();
            while (true) {
                if (ich < ichMax && JSVParser.isWhiteSpace(line, ich)) {
                    ++ich;
                    continue;
                }
                if (ich == ichMax) break;
                ++tokenCount;
                while (++ich < ichMax && !JSVParser.isWhiteSpace(line, ich)) {
                }
            }
        }
        return tokenCount;
    }

    public static String parseToken(String str, int[] next) {
        int cch = str.length();
        if (next[0] < 0 || next[0] >= cch) {
            return null;
        }
        return JSVParser.parseTokenChecked(str, cch, next);
    }

    public static String parseToken(String str, int ichMax, int[] next) {
        int cch = str.length();
        if (ichMax > cch) {
            ichMax = cch;
        }
        if (next[0] < 0 || next[0] >= ichMax) {
            return null;
        }
        return JSVParser.parseTokenChecked(str, ichMax, next);
    }

    private static String parseTokenChecked(String str, int ichMax, int[] next) {
        int ich = next[0];
        while (ich < ichMax && JSVParser.isWhiteSpace(str, ich)) {
            ++ich;
        }
        int ichNonWhite = ich;
        while (ich < ichMax && !JSVParser.isWhiteSpace(str, ich)) {
            ++ich;
        }
        next[0] = ich;
        if (ichNonWhite == ich) {
            return null;
        }
        return str.substring(ichNonWhite, ich);
    }

    private static String parseTrimmedChecked(String str, int ich, int ichMax) {
        while (ich < ichMax && JSVParser.isWhiteSpace(str, ich)) {
            ++ich;
        }
        int ichLast = ichMax - 1;
        while (ichLast >= ich && JSVParser.isWhiteSpace(str, ichLast)) {
            --ichLast;
        }
        if (ichLast < ich) {
            return "";
        }
        return str.substring(ich, ichLast + 1);
    }

    public static String concatTokens(String[] tokens, int iFirst, int iEnd) {
        String str = "";
        String sep = "";
        int i = iFirst;
        while (i < iEnd) {
            if (i < tokens.length) {
                str = String.valueOf(str) + sep + tokens[i];
                sep = " ";
            }
            ++i;
        }
        return str;
    }

    public static String getNextQuotedString(String line, int ipt0) {
        int[] next = new int[]{ipt0};
        return JSVParser.getNextQuotedString(line, next);
    }

    public static String getNextQuotedString(String line, int[] next) {
        String value = line;
        int i = next[0];
        if (i < 0 || (i = value.indexOf("\"", i)) < 0) {
            return "";
        }
        next[0] = ++i;
        value = value.substring(i);
        i = -1;
        while (++i < value.length() && value.charAt(i) != '\"') {
            if (value.charAt(i) != '\\') continue;
            ++i;
        }
        next[0] = next[0] + (i + 1);
        return value.substring(0, i);
    }

    private static boolean isWhiteSpace(String str, int ich) {
        char ch;
        return ich >= 0 && ((ch = str.charAt(ich)) == ' ' || ch == '\t' || ch == '\n');
    }

    public static boolean isOneOf(String key, String semiList) {
        return key.indexOf(";") < 0 && (String.valueOf(';') + semiList + ';').indexOf(String.valueOf(';') + key + ';') >= 0;
    }

    public static String getQuotedAttribute(String info, String name) {
        int i = info.indexOf(String.valueOf(name) + "=");
        return i < 0 ? null : JSVParser.getNextQuotedString(info, i);
    }

    public static String getQuotedJSONAttribute(String json, String key1, String key2) {
        if (key2 == null) {
            key2 = key1;
        }
        key1 = "\"" + key1 + "\":";
        key2 = "\"" + key2 + "\":";
        int pt1 = json.indexOf(key1);
        int pt2 = json.indexOf(key2, pt1);
        return pt1 < 0 || pt2 < 0 ? null : JSVParser.getNextQuotedString(json, pt2 + key2.length());
    }

    public static int findOneOf(String str, String delim) {
        int n = str.length();
        int i = 0;
        while (i < n) {
            if (delim.indexOf(str.charAt(i)) >= 0) {
                return i;
            }
            ++i;
        }
        return -1;
    }
}

