/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.util.ArrayList;
import java.util.List;
import jspecview.common.JDXHeader;
import jspecview.common.JDXSpectrum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDXSource
extends JDXHeader {
    public static final int TYPE_VIEW = -2;
    public static final int TYPE_UNKNOWN = -1;
    public static final int TYPE_SIMPLE = 0;
    public static final int TYPE_BLOCK = 1;
    public static final int TYPE_NTUPLE = 2;
    public int type = 0;
    public boolean isCompoundSource = false;
    private List<JDXSpectrum> jdxSpectra;
    private String errors = "";
    private String filePath;
    public int peakCount;
    public boolean isView;

    public void dispose() {
        this.headerTable = null;
        this.jdxSpectra = null;
    }

    public JDXSource(int type, String filePath) {
        this.type = type;
        this.setFilePath(filePath);
        this.headerTable = new ArrayList();
        this.jdxSpectra = new ArrayList<JDXSpectrum>();
        this.isCompoundSource = type != 0;
    }

    public JDXSpectrum getJDXSpectrum(int index) {
        return this.jdxSpectra.size() <= index ? null : this.jdxSpectra.get(index);
    }

    public void addJDXSpectrum(String filePath, JDXSpectrum spectrum, boolean forceSub) {
        if (filePath == null) {
            filePath = this.filePath;
        }
        spectrum.setFilePath(filePath);
        int n = this.jdxSpectra.size();
        if (n == 0 || !this.jdxSpectra.get(n - 1).addSubSpectrum(spectrum, forceSub)) {
            this.jdxSpectra.add(spectrum);
        }
    }

    public int getNumberOfSpectra() {
        return this.jdxSpectra.size();
    }

    public List<JDXSpectrum> getSpectra() {
        return this.jdxSpectra;
    }

    public String getErrorLog() {
        return this.errors;
    }

    public void setErrorLog(String errors) {
        this.errors = errors;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public static JDXSource createView(List<JDXSpectrum> specs) {
        JDXSource source = new JDXSource(-2, "view");
        source.isView = true;
        int i = 0;
        while (i < specs.size()) {
            source.addJDXSpectrum(specs.get(i).getFilePath(), specs.get(i), false);
            ++i;
        }
        return source;
    }

    public String[][] getHeaderRowDataAsArray(boolean addDataClass, String[][] rowData) {
        if (rowData == null) {
            rowData = new String[0][0];
        }
        String[][] data = this.getHeaderRowDataAsArray(addDataClass, rowData.length);
        int i = rowData.length;
        while (--i >= 0) {
            data[data.length - rowData.length + i] = rowData[i];
        }
        return data;
    }
}

