/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Cursor;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanel;
import jspecview.common.JSVPanelNode;
import jspecview.common.JSVTreeNode;
import jspecview.common.ScriptInterface;
import jspecview.common.ScriptToken;
import jspecview.source.JDXSource;
import jspecview.util.JSVFileManager;
import jspecview.util.JSVLogger;
import jspecview.util.JSVParser;
import jspecview.util.JSVTextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSVTree
extends JTree {
    public static final int FILE_OPEN_OK = 0;
    public static final int FILE_OPEN_ALREADY = -1;
    public static final int FILE_OPEN_ERROR = -3;
    public static final int FILE_OPEN_NO_DATA = -4;
    public static final int OVERLAY_DIALOG = -1;
    public static final int OVERLAY_OFFSET = 99;
    private static final long serialVersionUID = 1L;
    protected ScriptInterface si;
    private JSVTreeNode rootNode;
    private DefaultTreeModel spectraTreeModel;

    public JSVTreeNode getRootNode() {
        return this.rootNode;
    }

    public DefaultTreeModel getDefaultModel() {
        return this.spectraTreeModel;
    }

    public JSVTree(final ScriptInterface si) {
        this.si = si;
        this.rootNode = new JSVTreeNode("Spectra", null);
        this.spectraTreeModel = new DefaultTreeModel(this.rootNode);
        this.setModel(this.spectraTreeModel);
        this.getSelectionModel().setSelectionMode(1);
        this.addTreeSelectionListener(new TreeSelectionListener(){

            public void valueChanged(TreeSelectionEvent e) {
                JSVTreeNode node = (JSVTreeNode)JSVTree.this.getLastSelectedPathComponent();
                if (node == null) {
                    return;
                }
                if (node.isLeaf()) {
                    si.setNode(node.panelNode, true);
                }
                si.setCurrentSource(node.panelNode.source);
            }
        });
        this.setRootVisible(false);
    }

    public void setSelectedPanel(ScriptInterface si, JSVPanel jsvp) {
        if (jsvp != null) {
            JSVTreeNode treeNode = (JSVTreeNode)JSVPanelNode.findNode((JSVPanel)jsvp, si.getPanelNodes()).treeNode;
            this.scrollPathToVisible(new TreePath(treeNode.getPath()));
            this.setSelectionPath(new TreePath(treeNode.getPath()));
        }
    }

    public static void closeSource(ScriptInterface si, JDXSource source) {
        List<JSVPanelNode> panelNodes = si.getPanelNodes();
        JSVTree tree = (JSVTree)si.getSpectraTree();
        JSVTreeNode rootNode = tree.getRootNode();
        DefaultTreeModel spectraTreeModel = tree.getDefaultModel();
        String fileName = source == null ? null : source.getFilePath();
        ArrayList<JSVTreeNode> toDelete = new ArrayList<JSVTreeNode>();
        Enumeration<TreeNode> enume = rootNode.children();
        while (enume.hasMoreElements()) {
            JSVTreeNode node = (JSVTreeNode)enume.nextElement();
            if (fileName != null && !node.panelNode.source.getFilePath().equals(fileName)) continue;
            Enumeration<TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                JSVTreeNode childNode = (JSVTreeNode)e.nextElement();
                toDelete.add(childNode);
                panelNodes.remove(childNode.panelNode);
            }
            toDelete.add(node);
            if (fileName != null) break;
        }
        int i = 0;
        while (i < toDelete.size()) {
            spectraTreeModel.removeNodeFromParent((MutableTreeNode)toDelete.get(i));
            ++i;
        }
        if (source == null) {
            JDXSource currentSource = si.getCurrentSource();
            if (currentSource != null) {
                currentSource.dispose();
            }
            if (si.getSelectedPanel() != null) {
                si.getSelectedPanel().dispose();
            }
        }
        if (si.getCurrentSource() == source) {
            si.setSelectedPanel(null);
            si.setCurrentSource(null);
        }
        int max = 0;
        int i2 = 0;
        while (i2 < panelNodes.size()) {
            float f = JSVParser.parseFloat(panelNodes.get((int)i2).id);
            if (f >= (float)(max + 1)) {
                max = (int)Math.floor(f);
            }
            ++i2;
        }
        si.setFileCount(max);
        System.gc();
        JSVLogger.checkMemory();
    }

    public static void setFrameAndTreeNode(ScriptInterface si, int i) {
        List<JSVPanelNode> panelNodes = si.getPanelNodes();
        if (panelNodes == null || i < 0 || i >= panelNodes.size()) {
            return;
        }
        si.setNode(panelNodes.get(i), false);
    }

    public static JSVPanelNode selectFrameNode(ScriptInterface si, JSVPanel jsvp) {
        JSVPanelNode node = JSVPanelNode.findNode(jsvp, si.getPanelNodes());
        if (node == null) {
            return null;
        }
        JTree spectraTree = (JTree)si.getSpectraTree();
        spectraTree.setSelectionPath(new TreePath(((JSVTreeNode)node.treeNode).getPath()));
        return si.setOverlayVisibility(node);
    }

    public static JSVPanel setSpectrum(ScriptInterface si, String value) {
        if (value.indexOf(46) >= 0) {
            JSVPanelNode node = JSVPanelNode.findNodeById(value, si.getPanelNodes());
            if (node == null) {
                return null;
            }
            si.setNode(node, false);
        } else {
            int n = JSVParser.parseInt(value);
            if (n <= 0) {
                si.checkOverlay();
                return null;
            }
            JSVTree.setFrameAndTreeNode(si, n - 1);
        }
        return si.getSelectedPanel();
    }

    public static JSVTreeNode createTree(ScriptInterface si, JDXSource source, JSVPanel[] panels) {
        JSVTree tree = (JSVTree)si.getSpectraTree();
        JSVTreeNode rootNode = tree.getRootNode();
        DefaultTreeModel spectraTreeModel = tree.getDefaultModel();
        List<JSVPanelNode> panelNodes = si.getPanelNodes();
        String fileName = JSVFileManager.getName(source.getFilePath());
        JSVPanelNode panelNode = new JSVPanelNode(null, fileName, source, null);
        JSVTreeNode fileNode = new JSVTreeNode(fileName, panelNode);
        panelNode.setTreeNode(fileNode);
        spectraTreeModel.insertNodeInto(fileNode, rootNode, rootNode.getChildCount());
        tree.scrollPathToVisible(new TreePath(fileNode.getPath()));
        int fileCount = si.getFileCount() + 1;
        si.setFileCount(fileCount);
        int i = 0;
        while (i < panels.length) {
            JSVPanel jsvp = panels[i];
            String id = String.valueOf(fileCount) + "." + (i + 1);
            panelNode = si.getNewPanelNode(id, fileName, source, jsvp);
            JSVTreeNode treeNode = new JSVTreeNode(panelNode.toString(), panelNode);
            panelNode.setTreeNode(treeNode);
            panelNodes.add(panelNode);
            spectraTreeModel.insertNodeInto(treeNode, fileNode, fileNode.getChildCount());
            tree.scrollPathToVisible(new TreePath(treeNode.getPath()));
            ++i;
        }
        JSVTree.selectFrameNode(si, panels[0]);
        return fileNode;
    }

    public static void close(ScriptInterface si, String value) {
        System.out.println("JSVTree close " + value);
        if (value == null || value.equalsIgnoreCase("all") || value.equals("*")) {
            si.closeSource(null);
            return;
        }
        List<JSVPanelNode> panelNodes = si.getPanelNodes();
        if ((value = value.replace('\\', '/')).endsWith("*")) {
            value = value.substring(0, value.length() - 1);
            int i = panelNodes.size();
            while (--i >= 0) {
                if (i >= panelNodes.size() || !panelNodes.get((int)i).fileName.startsWith(value)) continue;
                si.closeSource(panelNodes.get((int)i).source);
            }
        } else if (value.equals("selected")) {
            ArrayList<JDXSource> list = new ArrayList<JDXSource>();
            JDXSource lastSource = null;
            int i = panelNodes.size();
            while (--i >= 0) {
                JDXSource source = panelNodes.get((int)i).source;
                if (panelNodes.get((int)i).isSelected && (lastSource == null || lastSource != source)) {
                    list.add(source);
                }
                lastSource = source;
            }
            i = list.size();
            while (--i >= 0) {
                si.closeSource((JDXSource)list.get(i));
            }
        } else {
            JDXSource source;
            JDXSource jDXSource = source = value.length() == 0 ? si.getCurrentSource() : JSVPanelNode.findSourceByNameOrId(value, panelNodes);
            if (source == null) {
                return;
            }
            si.closeSource(source);
        }
        if (si.getSelectedPanel() == null && panelNodes.size() > 0) {
            si.setSelectedPanel(JSVPanelNode.getLastFileFirstNode(panelNodes));
        }
    }

    public static void load(ScriptInterface si, String value) {
        boolean isSimulation;
        List<String> tokens = ScriptToken.getTokens(value);
        String filename = tokens.get(0);
        int pt = 0;
        boolean isAppend = filename.equalsIgnoreCase("APPEND");
        boolean isCheck = filename.equalsIgnoreCase("CHECK");
        if (isAppend || isCheck) {
            filename = tokens.get(++pt);
        }
        if (isSimulation = filename.equalsIgnoreCase("MOL")) {
            filename = String.valueOf(JSVFileManager.SIMULATION_PROTOCOL) + "MOL=" + JSVTextFormat.trimQuotes(tokens.get(++pt));
        }
        if (!isCheck && !isAppend) {
            if (filename.equals("\"\"") && si.getCurrentSource() != null) {
                filename = si.getCurrentSource().getFilePath();
            }
            JSVTree.close(si, "all");
        }
        if ((filename = JSVTextFormat.trimQuotes(filename)).startsWith("$")) {
            isSimulation = true;
            filename = String.valueOf(JSVFileManager.SIMULATION_PROTOCOL) + filename;
        }
        int firstSpec = pt + 1 < tokens.size() ? Integer.valueOf(tokens.get(++pt)) : -1;
        int lastSpec = pt + 1 < tokens.size() ? Integer.valueOf(tokens.get(++pt)) : firstSpec;
        si.openDataOrFile(null, null, null, filename, firstSpec, lastSpec, isAppend);
    }

    public static int openDataOrFile(ScriptInterface si, String data, String name, List<JDXSpectrum> specs, String url, int firstSpec, int lastSpec, boolean isAppend) {
        boolean combine;
        if ("NONE".equals(name)) {
            JSVTree.close(si, "View*");
            return 0;
        }
        si.writeStatus("");
        String filePath = null;
        String newPath = null;
        String fileName = null;
        File file = null;
        URL base = null;
        boolean isView = false;
        if (data == null) {
            if (specs != null) {
                isView = true;
                fileName = filePath = "View" + si.incrementViewCount(1);
                newPath = filePath;
            } else if (url != null) {
                try {
                    base = si.getDocumentBase();
                    URL u = base == null ? new URL(url) : new URL(base, url);
                    filePath = u.toString();
                    si.setRecentURL(filePath);
                    fileName = JSVFileManager.getName(url);
                }
                catch (MalformedURLException e) {
                    file = new File(url);
                }
            }
        }
        if (file != null) {
            fileName = file.getName();
            newPath = filePath = file.getAbsolutePath();
            si.setRecentURL(null);
        }
        if (!isView && (JSVPanelNode.isOpen(si.getPanelNodes(), filePath) || JSVPanelNode.isOpen(si.getPanelNodes(), url))) {
            si.writeStatus(String.valueOf(filePath) + " is already open");
            return -1;
        }
        if (!isAppend && !isView) {
            JSVTree.close(si, "all");
        }
        si.setCursorObject(Cursor.getPredefinedCursor(3));
        try {
            si.setCurrentSource(isView ? JDXSource.createView(specs) : si.createSource(data, filePath, base, firstSpec, lastSpec));
        }
        catch (Exception e) {
            JSVLogger.error(e.getMessage());
            si.writeStatus(e.getMessage());
            si.setCursorObject(Cursor.getDefaultCursor());
            return -3;
        }
        si.setCursorObject(Cursor.getDefaultCursor());
        System.gc();
        JDXSource currentSource = si.getCurrentSource();
        if (newPath == null) {
            newPath = currentSource.getFilePath();
            if (newPath != null) {
                fileName = newPath.substring(newPath.lastIndexOf("/") + 1);
            }
        } else {
            currentSource.setFilePath(newPath);
        }
        si.setLoaded(fileName, newPath);
        JDXSpectrum spec = si.getCurrentSource().getJDXSpectrum(0);
        if (spec == null) {
            return -4;
        }
        specs = currentSource.getSpectra();
        JDXSpectrum.process(specs, si.getIRMode());
        boolean autoOverlay = si.getAutoCombine() || spec.isAutoOverlayFromJmolClick();
        boolean bl = combine = isView || autoOverlay && currentSource.isCompoundSource;
        if (combine) {
            JSVTree.combineSpectra(si, isView ? url : null);
        } else {
            JSVTree.splitSpectra(si);
        }
        if (!isView) {
            si.updateRecentMenus(filePath);
        }
        return 0;
    }

    private static void combineSpectra(ScriptInterface si, String name) {
        JDXSource source = si.getCurrentSource();
        List<JDXSpectrum> specs = source.getSpectra();
        JSVPanel jsvp = si.getNewJSVPanel(specs);
        jsvp.setTitle(source.getTitle());
        if (jsvp.getTitle().equals("")) {
            jsvp.getPanelData().setViewTitle(source.getFilePath());
            jsvp.setTitle(name);
        }
        si.setPropertiesFromPreferences(jsvp, true);
        (new JSVPanel[1])[0] = jsvp;
        JSVTree.createTree((ScriptInterface)si, (JDXSource)source, (JSVPanel[])new JSVPanel[1]).panelNode.isView = true;
        JSVPanelNode node = JSVPanelNode.findNode(si.getSelectedPanel(), si.getPanelNodes());
        node.setFrameTitle(name);
        node.isView = true;
        if (si.getAutoShowLegend() && si.getSelectedPanel().getPanelData().getNumberOfGraphSets() == 1) {
            node.setLegend(si.getOverlayLegend(jsvp));
        }
        si.setMenuEnables(node, false);
    }

    private static void splitSpectra(ScriptInterface si) {
        JDXSource source = si.getCurrentSource();
        List<JDXSpectrum> specs = source.getSpectra();
        JSVPanel[] panels = new JSVPanel[specs.size()];
        JSVPanel jsvp = null;
        int i = 0;
        while (i < specs.size()) {
            JDXSpectrum spec = specs.get(i);
            jsvp = si.getNewJSVPanel(spec);
            si.setPropertiesFromPreferences(jsvp, true);
            panels[i] = jsvp;
            ++i;
        }
        JSVTree.createTree(si, source, panels);
        si.getNewJSVPanel((JDXSpectrum)null);
        JSVPanelNode node = JSVPanelNode.findNode(si.getSelectedPanel(), si.getPanelNodes());
        si.setMenuEnables(node, true);
    }
}

