/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import jspecview.application.MainFrame;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVPanelNode;
import jspecview.source.JDXSource;
import jspecview.util.JSVFileManager;
import jspecview.util.JSVLogger;

public class TextDialog
extends JDialog {
    private static final long serialVersionUID = 1L;
    JPanel contentPanel = new JPanel();
    BorderLayout borderLayout = new BorderLayout();
    Reader reader;
    JScrollPane scrollPane;
    JEditorPane sourcePane = new JEditorPane();

    public TextDialog(Frame frame, String title, boolean modal, Reader reader) {
        super(frame, title, modal);
        try {
            this.reader = reader == null ? JSVFileManager.getBufferedReaderFromName(title, null, null) : reader;
            this.jbInit();
            this.pack();
            this.setVisible(true);
        }
        catch (Exception ex) {
            JSVLogger.error(ex.getMessage());
        }
    }

    public TextDialog(Frame frame, String title, String string, boolean modal) {
        this(frame, title, modal, new StringReader(string));
    }

    public TextDialog(Frame frame, String file, boolean modal) throws IOException {
        this(frame, file, modal, (Reader)null);
    }

    void jbInit() throws Exception {
        this.contentPanel.setLayout(this.borderLayout);
        this.sourcePane.read(this.reader, (Object)"the text");
        this.sourcePane.setEditable(false);
        this.sourcePane.setFont(new Font(null, 1, 12));
        this.getContentPane().add(this.contentPanel);
        this.scrollPane = new JScrollPane(this.sourcePane);
        this.scrollPane.setPreferredSize(new Dimension(500, 400));
        this.scrollPane.setMinimumSize(new Dimension(500, 400));
        this.contentPanel.add((Component)this.scrollPane, "Center");
    }

    public static void showProperties(Component c, JDXSpectrum spectrum) {
        Object[][] rowData = spectrum.getHeaderRowDataAsArray();
        Object[] columnNames = new String[]{"Label", "Description"};
        JTable table = new JTable(rowData, columnNames);
        table.setPreferredScrollableViewportSize(new Dimension(400, 195));
        JScrollPane scrollPane = new JScrollPane(table);
        JOptionPane.showMessageDialog(c, scrollPane, "Header Information", -1);
    }

    public static void showSource(MainFrame mainFrame) {
        JDXSource currentSource = mainFrame.getCurrentSource();
        List<JSVPanelNode> panelNodes = mainFrame.getPanelNodes();
        if (currentSource == null) {
            if (panelNodes.size() > 0) {
                JOptionPane.showMessageDialog(mainFrame, "Please Select a Spectrum", "Select Spectrum", 0);
            }
            return;
        }
        try {
            new TextDialog(mainFrame, currentSource.getFilePath(), true);
        }
        catch (IOException ex) {
            new TextDialog((Frame)mainFrame, "File Not Found", "File Not Found", true);
        }
    }

    public static void showError(MainFrame mainFrame) {
        JDXSource currentSource = mainFrame.getCurrentSource();
        if (currentSource == null) {
            JOptionPane.showMessageDialog(null, "Please Select a Spectrum", "Select Spectrum", 2);
            return;
        }
        String errorLog = currentSource.getErrorLog();
        if (errorLog != null) {
            new TextDialog((Frame)mainFrame, currentSource.getFilePath(), errorLog, true);
        }
    }
}

