/*
 * Decompiled with CFR 0.152.
 */
package jspecview.application;

import java.awt.Color;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.TreeMap;
import jspecview.common.AwtParameters;
import jspecview.common.Parameters;
import jspecview.common.ScriptToken;
import jspecview.util.JSVFileManager;
import jspecview.util.JSVTextFormat;
import jspecview.util.JSVXmlReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DisplaySchemesProcessor {
    private String fileName = "displaySchemes.xml";
    private TreeMap<String, Parameters> displaySchemes = new TreeMap();
    private JSVXmlReader reader;

    public Parameters loadDefault() {
        Parameters dsdef = new Parameters("Default");
        dsdef.setDisplayFont("default");
        dsdef.setColor(ScriptToken.TITLECOLOR, Color.BLACK);
        dsdef.setColor(ScriptToken.UNITSCOLOR, Color.BLACK);
        dsdef.setColor(ScriptToken.SCALECOLOR, Color.BLACK);
        dsdef.setColor(ScriptToken.COORDINATESCOLOR, Color.BLACK);
        dsdef.setColor(ScriptToken.PEAKTABCOLOR, Color.RED);
        dsdef.setColor(ScriptToken.HIGHLIGHTCOLOR, Color.DARK_GRAY);
        dsdef.setColor(ScriptToken.GRIDCOLOR, Color.BLACK);
        dsdef.setColor(ScriptToken.PLOTCOLOR, Color.BLACK);
        dsdef.setColor(ScriptToken.PLOTAREACOLOR, Color.WHITE);
        dsdef.setColor(ScriptToken.BACKGROUNDCOLOR, Color.WHITE);
        dsdef.setColor(ScriptToken.INTEGRALPLOTCOLOR, Color.RED);
        this.displaySchemes.put("Default", dsdef);
        return dsdef;
    }

    public Parameters getDefaultScheme() {
        Parameters ds = this.displaySchemes.get("Default");
        if (ds == null) {
            ds = this.loadDefault();
        }
        return ds;
    }

    public void store() throws IOException {
        this.serializeDisplaySchemes(new FileWriter(this.fileName));
    }

    public TreeMap<String, Parameters> getDisplaySchemes() {
        return this.displaySchemes;
    }

    public boolean load(InputStream stream) {
        try {
            return this.load(JSVFileManager.getBufferedReaderForInputStream(stream));
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean load(String dispSchemeFileName) {
        this.fileName = dispSchemeFileName;
        try {
            BufferedReader br = JSVFileManager.getBufferedReaderFromName(this.fileName, null, "##TITLE");
            return this.load(br);
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean load(BufferedReader br) {
        this.reader = new JSVXmlReader(br);
        String defaultDS = "Default";
        AwtParameters ds = null;
        try {
            while (this.reader.hasNext()) {
                ScriptToken st;
                if (this.reader.nextEvent() != 1) continue;
                String theTag = this.reader.getTagName();
                if (theTag.equals("displayschemes")) {
                    defaultDS = this.reader.getAttrValue("default");
                }
                if (theTag.equals("displayscheme")) {
                    String name = this.reader.getAttrValue("name");
                    ds = new AwtParameters(name);
                    if (name.equals(defaultDS)) {
                        ds.setDefault(true);
                    }
                    this.displaySchemes.put(name, ds);
                }
                if (ds == null) continue;
                if (theTag.equals("font")) {
                    String attr = this.reader.getAttrValue("face");
                    if (attr.length() <= 0) continue;
                    ds.setDisplayFont(attr);
                    continue;
                }
                if (theTag.equals("coordinateColor")) {
                    theTag = "coordinatesColor";
                }
                if ((st = ScriptToken.getScriptToken(theTag)) == ScriptToken.UNKNOWN) continue;
                Color color = this.getColor();
                if (color == null) {
                    String def;
                    switch (st) {
                        default: {
                            def = null;
                            break;
                        }
                        case TITLECOLOR: {
                            def = "#0000ff";
                            break;
                        }
                        case COORDINATESCOLOR: {
                            def = "#ff0000";
                            break;
                        }
                        case PEAKTABCOLOR: {
                            def = "#ff0000";
                            break;
                        }
                        case HIGHLIGHTCOLOR: {
                            def = "#808080";
                            break;
                        }
                        case SCALECOLOR: {
                            def = "#660000";
                            break;
                        }
                        case UNITSCOLOR: {
                            def = "#ff0000";
                            break;
                        }
                        case GRIDCOLOR: {
                            def = "#4e4c4c";
                            break;
                        }
                        case PLOTCOLOR: {
                            def = "#ff9900";
                            break;
                        }
                        case PLOTAREACOLOR: {
                            def = "#333333";
                            break;
                        }
                        case BACKGROUNDCOLOR: {
                            def = "#c0c0c0";
                        }
                    }
                    if (def != null) {
                        color = Color.decode(def);
                    }
                }
                if (color == null) continue;
                ds.setColor(st, color);
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    private Color getColor() {
        String value = this.reader.getAttrValueLC("hex");
        return value.length() == 0 || value.equals("default") ? null : AwtParameters.getColorFromString(value);
    }

    public void serializeDisplaySchemes(Writer writer) throws IOException {
        if (this.displaySchemes.size() == 0) {
            return;
        }
        StringWriter sw = new StringWriter();
        BufferedWriter buffer = new BufferedWriter(sw);
        String defaultDSName = "";
        for (Parameters ds : this.displaySchemes.values()) {
            if (ds.isDefault()) {
                defaultDSName = ds.getName();
            }
            buffer.write("\t<displayScheme name=\"" + ds.getName() + "\">");
            buffer.newLine();
            buffer.write("\t\t<font face = \"" + ds.getDisplayFont() + "\"/>");
            buffer.newLine();
            buffer.write("\t\t<titleColor hex = \"" + AwtParameters.colorToHexString(ds.getColor(ScriptToken.TITLECOLOR)) + "\"/>");
            buffer.newLine();
            buffer.write("\t\t<scaleColor hex = \"" + AwtParameters.colorToHexString(ds.getColor(ScriptToken.SCALECOLOR)) + "\"/>");
            buffer.newLine();
            buffer.write("\t\t<unitsColor hex = \"" + AwtParameters.colorToHexString(ds.getColor(ScriptToken.UNITSCOLOR)) + "\"/>");
            buffer.newLine();
            buffer.write("\t\t<coordinateColor hex = \"" + AwtParameters.colorToHexString(ds.getColor(ScriptToken.COORDINATESCOLOR)) + "\"/>");
            buffer.newLine();
            buffer.write("\t\t<highlightColor hex = \"" + AwtParameters.colorToHexString(ds.getColor(ScriptToken.HIGHLIGHTCOLOR)) + "\"/>");
            buffer.newLine();
            buffer.write("\t\t<peakTabColor hex = \"" + AwtParameters.colorToHexString(ds.getColor(ScriptToken.PEAKTABCOLOR)) + "\"/>");
            buffer.newLine();
            buffer.write("\t\t<gridColor hex = \"" + AwtParameters.colorToHexString(ds.getColor(ScriptToken.GRIDCOLOR)) + "\"/>");
            buffer.newLine();
            buffer.write("\t\t<plotColor hex = \"" + AwtParameters.colorToHexString(ds.getColor(ScriptToken.PLOTCOLOR)) + "\"/>");
            buffer.newLine();
            buffer.write("\t\t<plotAreaColor hex = \"" + AwtParameters.colorToHexString(ds.getColor(ScriptToken.PLOTAREACOLOR)) + "\"/>");
            buffer.newLine();
            buffer.write("\t\t<backgroundColor hex = \"" + AwtParameters.colorToHexString(ds.getColor(ScriptToken.BACKGROUNDCOLOR)) + "\"/>");
            buffer.newLine();
            buffer.write("\t</displayScheme>");
            buffer.newLine();
        }
        buffer.write("</displaySchemes>");
        buffer.flush();
        StringBuffer outBuffer = new StringBuffer();
        outBuffer.append("<?xml version=\"1.0\"?>" + JSVTextFormat.newLine);
        outBuffer.append("<displaySchemes default=\"" + defaultDSName + "\">" + JSVTextFormat.newLine);
        outBuffer.append(sw.getBuffer());
        writer.write(outBuffer.toString());
        writer.flush();
        writer.close();
    }
}

