/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import org.jmol.util.BS;
import org.jmol.util.Geodesic;
import org.jmol.util.J2SRequireImport;
import org.jmol.util.V3;

@J2SRequireImport(value={Geodesic.class})
public class Normix {
    private static final int NORMIX_GEODESIC_LEVEL = 3;
    private static short normixCount;
    private static V3[] vertexVectors;
    private static short[] inverseNormixes;
    private static short[][] neighborVertexesArrays;
    public static final short NORMIX_NULL = 9999;

    public static short getNormixCount() {
        if (normixCount == 0) {
            normixCount = Geodesic.getVertexCount(3);
        }
        return normixCount;
    }

    public static BS newVertexBitSet() {
        return BS.newN(Normix.getNormixCount());
    }

    public static V3[] getVertexVectors() {
        if (vertexVectors == null) {
            vertexVectors = Geodesic.getVertexVectors();
        }
        return vertexVectors;
    }

    public static void setInverseNormixes() {
        if (inverseNormixes != null) {
            return;
        }
        Normix.getNormixCount();
        Normix.getVertexVectors();
        inverseNormixes = new short[normixCount];
        BS bS = new BS();
        int n = normixCount;
        while (--n >= 0) {
            V3 v3 = vertexVectors[n];
            Normix.inverseNormixes[n] = Normix.getNormix(-v3.x, -v3.y, -v3.z, 3, bS);
        }
    }

    public static short getInverseNormix(short s) {
        return inverseNormixes[s];
    }

    private static short[][] getNeighborVertexArrays() {
        if (neighborVertexesArrays == null) {
            neighborVertexesArrays = Geodesic.getNeighborVertexesArrays();
        }
        return neighborVertexesArrays;
    }

    public static short getNormixV(V3 v3, BS bS) {
        return Normix.getNormix(v3.x, v3.y, v3.z, 3, bS);
    }

    public static short get2SidedNormix(V3 v3, BS bS) {
        return ~Normix.getNormixV(v3, bS);
    }

    private static short getNormix(double d, double d2, double d3, int n, BS bS) {
        double d4;
        short s;
        if (d3 >= 0.0) {
            s = 0;
            d4 = d3 - 1.0;
        } else {
            s = 11;
            d4 = d3 - -1.0;
        }
        bS.clearAll();
        bS.set(s);
        Normix.getVertexVectors();
        Normix.getNeighborVertexArrays();
        double d5 = d * d + d2 * d2 + d4 * d4;
        for (int i = 0; i <= n; ++i) {
            short[] sArray = neighborVertexesArrays[i];
            int n2 = 6 * s;
            int n3 = n2 + (s < 12 ? 5 : 6);
            while (--n3 >= n2) {
                short s2 = sArray[n3];
                if (bS.get(s2)) continue;
                bS.set(s2);
                V3 v3 = vertexVectors[s2];
                double d6 = (double)v3.x - d;
                double d7 = d6 * d6;
                if (d7 >= d5 || (d7 += (d6 = (double)v3.y - d2) * d6) >= d5 || (d7 += (d6 = (double)v3.z - d3) * d6) >= d5) continue;
                s = s2;
                d5 = d7;
            }
        }
        return s;
    }
}

