/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.smiles;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jmol.smiles.InvalidSmilesException;
import org.jmol.smiles.SmilesAromatic;
import org.jmol.smiles.SmilesAtom;
import org.jmol.smiles.SmilesBond;
import org.jmol.smiles.SmilesParser;
import org.jmol.smiles.SmilesSearch;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Elements;
import org.jmol.util.JmolEdge;
import org.jmol.util.JmolList;
import org.jmol.util.JmolMolecule;
import org.jmol.util.JmolNode;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.util.SB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SmilesGenerator {
    private JmolNode[] atoms;
    private int atomCount;
    private BS bsSelected;
    private BS bsAromatic;
    private SB ringSets;
    private SmilesSearch.VTemp vTemp = new SmilesSearch.VTemp();
    private int nPairs;
    private BS bsBondsUp = new BS();
    private BS bsBondsDn = new BS();
    private BS bsToDo;
    private JmolNode prevAtom;
    private JmolNode[] prevSp2Atoms;
    private Map<String, Object[]> htRingsSequence = new Hashtable<String, Object[]>();
    private Map<String, Object[]> htRings = new Hashtable<String, Object[]>();
    private BS bsIncludingH;

    String getSmiles(JmolNode[] jmolNodeArray, int n, BS bS) throws InvalidSmilesException {
        int n2 = bS.nextSetBit(0);
        if (n2 < 0) {
            return "";
        }
        this.atoms = jmolNodeArray;
        this.atomCount = n;
        this.bsSelected = bS = BSUtil.copy(bS);
        return this.getSmilesComponent(jmolNodeArray[n2], bS, false);
    }

    /*
     * Unable to fully structure code
     */
    String getBioSmiles(JmolNode[] var1_1, int var2_2, BS var3_3, boolean var4_4, boolean var5_5, String var6_6) throws InvalidSmilesException {
        this.atoms = var1_1;
        this.atomCount = var2_2;
        var7_7 = new SB();
        var8_8 = BSUtil.copy(var3_3);
        if (var6_6 != null) {
            var7_7.append("//* Jmol bioSMILES ").append(var6_6.replace('*', '_')).append(" *//");
        }
        var9_9 = "\n";
        var10_10 = new BS();
        var11_11 = null;
        var13_12 = new JmolList<Integer>();
        try {
            var14_13 = 0;
            var15_15 = var8_8.nextSetBit(0);
            while (var15_15 >= 0) {
                var16_17 = var1_1[var15_15];
                var17_18 = var16_17.getGroup1('?');
                var18_19 = var16_17.getBioStructureTypeName();
                var19_20 = var17_18.equals("?");
                if (var9_9 == null) ** GOTO lbl49
                if (var7_7.length() > 0) {
                    var7_7.append(var9_9);
                }
                var9_9 = null;
                var14_13 = 0;
                if (var18_19.length() <= 0) {
                    var12_16 = this.getSmilesComponent(var16_17, var8_8, true);
                    if (var12_16.equals(var11_11)) {
                        var9_9 = "";
                    } else {
                        var11_11 = var12_16;
                        var20_22 = var16_17.getGroup3(true);
                        if (var20_22 != null) {
                            var7_7.append("//* ").append(var20_22).append(" *//");
                        }
                        var7_7.append(var12_16);
                        var9_9 = ".\n";
                    }
                } else {
                    var20_21 = var16_17.getChainID();
                    if (var20_21 != 0) {
                        var12_16 = "//* chain " + var16_17.getChainIDStr() + " " + var18_19 + " " + var16_17.getResno() + " *// ";
                        var14_13 = var12_16.length();
                        var7_7.append(var12_16);
                    }
                    var7_7.append("~").appendC(var18_19.charAt(0)).append("~");
                    ++var14_13;
lbl49:
                    // 2 sources

                    if (var14_13 >= 75) {
                        var7_7.append("\n  ");
                        var14_13 = 2;
                    }
                    if (var19_20) {
                        this.addBracketedBioName(var7_7, var16_17, var18_19.length() > 0 ? ".0" : null);
                    } else {
                        var7_7.append(var17_18);
                    }
                    ++var14_13;
                    var20_21 = var16_17.getOffsetResidueAtom("0", 0);
                    if (var5_5) {
                        var16_17.getCrossLinkLeadAtomIndexes(var13_12);
                        for (var21_23 = 0; var21_23 < var13_12.size(); ++var21_23) {
                            var7_7.append(":");
                            var12_16 = this.getRingCache(var20_21, (Integer)var13_12.get(var21_23), this.htRingsSequence);
                            var7_7.append(var12_16);
                            var14_13 += 1 + var12_16.length();
                        }
                        var13_12.clear();
                    }
                    var16_17.getGroupBits(var10_10);
                    var8_8.andNot(var10_10);
                    var21_23 = var16_17.getOffsetResidueAtom("0", 1);
                    if (var21_23 < 0 || !var8_8.get(var21_23)) {
                        var7_7.append(" //* ").appendI(var16_17.getResno()).append(" *//");
                        if (var21_23 < 0 && (var21_23 = var8_8.nextSetBit(var15_15 + 1)) < 0) break;
                        if (var14_13 > 0) {
                            var9_9 = ".\n";
                        }
                    }
                    var15_15 = var21_23 - 1;
                }
                var15_15 = var8_8.nextSetBit(var15_15 + 1);
            }
        }
        catch (Exception var14_14) {
            System.out.println(var14_14.toString());
            return "";
        }
        if (!var4_4 && !this.htRingsSequence.isEmpty()) {
            this.dumpRingKeys(var7_7, this.htRingsSequence);
            throw new InvalidSmilesException("//* ?ring error? *//");
        }
        var12_16 = var7_7.toString();
        if (var12_16.endsWith(".\n")) {
            var12_16 = var12_16.substring(0, var12_16.length() - 2);
        }
        return var12_16;
    }

    private void addBracketedBioName(SB sB, JmolNode jmolNode, String string) {
        sB.append("[");
        if (string != null) {
            String string2 = jmolNode.getChainIDStr();
            sB.append(jmolNode.getGroup3(false));
            if (!string.equals(".0")) {
                sB.append(string).append("#").appendI(jmolNode.getElementNumber());
            }
            sB.append("//* ").appendI(jmolNode.getResno());
            if (string2.length() > 0) {
                sB.append(":").append(string2);
            }
            sB.append(" *//");
        } else {
            sB.append(Elements.elementNameFromNumber(jmolNode.getElementNumber()));
        }
        sB.append("]");
    }

    private String getSmilesComponent(JmolNode jmolNode, BS bS, boolean bl) throws InvalidSmilesException {
        if (jmolNode.getElementNumber() == 1 && jmolNode.getEdges().length > 0) {
            jmolNode = this.atoms[jmolNode.getBondedAtomIndex(0)];
        }
        this.bsSelected = JmolMolecule.getBranchBitSet(this.atoms, jmolNode.getIndex(), BSUtil.copy(bS), null, -1, true, false);
        bS.andNot(this.bsSelected);
        this.bsIncludingH = BSUtil.copy(this.bsSelected);
        int n = this.bsSelected.nextSetBit(0);
        while (n >= 0) {
            JmolNode jmolNode2 = this.atoms[n];
            if (jmolNode2.getElementNumber() == 1 && jmolNode2.getIsotopeNumber() == 0) {
                this.bsSelected.clear(n);
            }
            n = this.bsSelected.nextSetBit(n + 1);
        }
        if (this.bsSelected.cardinality() > 2) {
            SmilesSearch smilesSearch = null;
            smilesSearch = SmilesParser.getMolecule("A[=&@]A", true);
            smilesSearch.jmolAtoms = this.atoms;
            smilesSearch.setSelected(this.bsSelected);
            smilesSearch.jmolAtomCount = this.atomCount;
            smilesSearch.ringDataMax = 7;
            smilesSearch.setRingData(null);
            this.bsAromatic = smilesSearch.bsAromatic;
            this.ringSets = smilesSearch.ringSets;
            this.setBondDirections();
        } else {
            this.bsAromatic = new BS();
        }
        this.bsToDo = BSUtil.copy(this.bsSelected);
        SB sB = new SB();
        int n2 = this.bsToDo.nextSetBit(0);
        while (n2 >= 0) {
            if (this.atoms[n2].getCovalentBondCount() > 4) {
                this.getSmiles(sB, this.atoms[n2], bl, false);
                jmolNode = null;
            }
            n2 = this.bsToDo.nextSetBit(n2 + 1);
        }
        if (jmolNode != null) {
            while ((jmolNode = this.getSmiles(sB, jmolNode, bl, true)) != null) {
            }
        }
        while (this.bsToDo.cardinality() > 0 || !this.htRings.isEmpty()) {
            Iterator<Object[]> iterator = this.htRings.values().iterator();
            if (iterator.hasNext()) {
                jmolNode = this.atoms[(Integer)iterator.next()[1]];
                if (!this.bsToDo.get(jmolNode.getIndex())) {
                    break;
                }
            } else {
                jmolNode = this.atoms[this.bsToDo.nextSetBit(0)];
            }
            sB.append(".");
            this.prevSp2Atoms = null;
            this.prevAtom = null;
            while ((jmolNode = this.getSmiles(sB, jmolNode, bl, true)) != null) {
            }
        }
        if (!this.htRings.isEmpty()) {
            this.dumpRingKeys(sB, this.htRings);
            throw new InvalidSmilesException("//* ?ring error? *//\n" + sB);
        }
        return sB.toString();
    }

    private char getBondStereochemistry(JmolEdge jmolEdge, JmolNode jmolNode) {
        boolean bl;
        if (jmolEdge == null) {
            return '\u0000';
        }
        int n = jmolEdge.index;
        boolean bl2 = bl = jmolNode == null || jmolEdge.getAtomIndex1() == jmolNode.getIndex();
        return (char)(this.bsBondsUp.get(n) ? (bl ? 47 : 92) : (this.bsBondsDn.get(n) ? (bl ? 92 : 47) : 0));
    }

    private void setBondDirections() {
        BS bS = new BS();
        JmolEdge[][] jmolEdgeArray = new JmolEdge[2][3];
        int n = this.bsSelected.nextSetBit(0);
        while (n >= 0) {
            JmolNode jmolNode = this.atoms[n];
            JmolEdge[] jmolEdgeArray2 = jmolNode.getEdges();
            for (int i = 0; i < jmolEdgeArray2.length; ++i) {
                char c;
                JmolEdge jmolEdge = jmolEdgeArray2[i];
                int n2 = jmolEdge.index;
                if (bS.get(n2)) continue;
                JmolNode jmolNode2 = jmolEdge.getOtherAtomNode(jmolNode);
                if (jmolEdge.getCovalentOrder() != 2 || SmilesSearch.isRingBond(this.ringSets, n, jmolNode2.getIndex())) continue;
                bS.set(n2);
                JmolEdge jmolEdge2 = null;
                JmolNode jmolNode3 = null;
                char c2 = '\u0000';
                JmolNode[] jmolNodeArray = new JmolNode[]{jmolNode, jmolNode2};
                if (Logger.debugging) {
                    Logger.debug(jmolNode + " == " + jmolNode2);
                }
                int n3 = 1;
                for (c = '\u0000'; c < '\u0002' && n3 > 0 && n3 < 3; ++c) {
                    n3 = 0;
                    JmolNode jmolNode4 = jmolNodeArray[c];
                    JmolEdge[] jmolEdgeArray3 = jmolNode4.getEdges();
                    for (int j = 0; j < jmolEdgeArray3.length; ++j) {
                        if (jmolEdgeArray3[j].getCovalentOrder() != 1) continue;
                        jmolEdgeArray[c][n3++] = jmolEdgeArray3[j];
                        if (this.getBondStereochemistry(jmolEdgeArray3[j], jmolNode4) == '\u0000') continue;
                        jmolEdge2 = jmolEdgeArray3[j];
                        c2 = c;
                    }
                }
                if (n3 == 3 || n3 == 0) continue;
                if (jmolEdge2 == null) {
                    c2 = '\u0000';
                    jmolEdge2 = jmolEdgeArray[c2][0];
                    this.bsBondsUp.set(jmolEdge2.index);
                }
                c = this.getBondStereochemistry(jmolEdge2, jmolNodeArray[c2]);
                jmolNode3 = jmolEdge2.getOtherAtomNode(jmolNodeArray[c2]);
                if (jmolNode3 == null) continue;
                for (int j = 0; j < 2; ++j) {
                    for (int k = 0; k < 2; ++k) {
                        JmolEdge jmolEdge3 = jmolEdgeArray[j][k];
                        if (jmolEdge3 == null || jmolEdge3 == jmolEdge2) continue;
                        int n4 = jmolEdge3.index;
                        JmolNode jmolNode5 = jmolEdge3.getOtherAtomNode(jmolNodeArray[j]);
                        if (jmolNode5 == null) continue;
                        char c3 = this.getBondStereochemistry(jmolEdge3, jmolNodeArray[j]);
                        boolean bl = SmilesSearch.isDiaxial(jmolNodeArray[c2], jmolNodeArray[j], jmolNode3, jmolNode5, this.vTemp, 0.0f);
                        if (c3 == '\u0000' || c3 != c == bl) {
                            boolean bl2 = c == '\\' && bl || c == '/' && !bl;
                            if (bl2 == (jmolEdge3.getAtomIndex1() != jmolNode5.getIndex())) {
                                this.bsBondsUp.set(n4);
                            } else {
                                this.bsBondsDn.set(n4);
                            }
                        } else {
                            Logger.error("BOND STEREOCHEMISTRY ERROR");
                        }
                        if (!Logger.debugging) continue;
                        Logger.debug(this.getBondStereochemistry(jmolEdge2, jmolNodeArray[0]) + " " + jmolNode3.getIndex() + " " + jmolNode5.getIndex() + " " + this.getBondStereochemistry(jmolEdge3, jmolNodeArray[j]));
                    }
                }
            }
            n = this.bsSelected.nextSetBit(n + 1);
        }
    }

    private JmolNode getSmiles(SB sB, JmolNode jmolNode, boolean bl, boolean bl2) {
        String string;
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2;
        int n3;
        char c;
        int n4;
        Object object4;
        int n5 = jmolNode.getIndex();
        if (!this.bsToDo.get(n5)) {
            return null;
        }
        this.bsToDo.clear(n5);
        boolean bl3 = !this.bsSelected.get(n5);
        int n6 = this.prevAtom == null ? -1 : this.prevAtom.getIndex();
        boolean bl4 = this.bsAromatic.get(n5);
        boolean bl5 = this.prevSp2Atoms != null;
        JmolNode[] jmolNodeArray = this.prevSp2Atoms;
        int n7 = 0;
        int n8 = jmolNode.getElementNumber();
        int n9 = 0;
        JmolList<JmolEdge> jmolList = new JmolList<JmolEdge>();
        JmolEdge jmolEdge = null;
        JmolEdge jmolEdge2 = null;
        JmolEdge[] jmolEdgeArray = jmolNode.getEdges();
        Object object5 = null;
        int n10 = bl4 ? 10 : 0;
        JmolNode[] jmolNodeArray2 = new JmolNode[7];
        if (Logger.debugging) {
            Logger.debug(sB.toString());
        }
        if (jmolEdgeArray != null) {
            int n11 = jmolEdgeArray.length;
            while (--n11 >= 0) {
                boolean bl6;
                JmolEdge jmolEdge3 = jmolEdgeArray[n11];
                if (!jmolEdge3.isCovalent()) continue;
                object4 = jmolEdgeArray[n11].getOtherAtomNode(jmolNode);
                n4 = object4.getIndex();
                if (n4 == n6) {
                    jmolEdge2 = jmolEdgeArray[n11];
                    continue;
                }
                boolean bl7 = bl6 = object4.getElementNumber() == 1 && object4.getIsotopeNumber() == 0;
                if (!this.bsIncludingH.get(n4)) {
                    if (bl6 || !bl || !this.bsSelected.get(n5)) continue;
                    this.bsToDo.set(n4);
                }
                if (bl6) {
                    object5 = object4;
                    if (++n9 <= 1) continue;
                    n10 = 10;
                    continue;
                }
                jmolList.addLast(jmolEdgeArray[n11]);
            }
        }
        String string2 = null;
        if (jmolNodeArray == null) {
            jmolNodeArray = new JmolNode[5];
        }
        if (jmolEdge2 != null) {
            string2 = SmilesBond.getBondOrderString(jmolEdge2.getCovalentOrder());
            if (this.prevSp2Atoms == null) {
                jmolNodeArray[n7++] = this.prevAtom;
            } else {
                n7 = 2;
            }
        }
        n7 += n9;
        char c2 = '\u0000';
        object4 = new BS();
        if (bl2) {
            for (n4 = 0; n4 < jmolList.size(); ++n4) {
                JmolEdge jmolEdge4 = (JmolEdge)jmolList.get(n4);
                JmolNode jmolNode2 = jmolEdge4.getOtherAtomNode(jmolNode);
                c = jmolNode2.getCovalentBondCount() - jmolNode2.getCovalentHydrogenCount();
                int n12 = jmolEdge4.getCovalentOrder();
                if (n12 == 1 && c == '\u0001' && n4 < jmolList.size() - (jmolEdge == null ? 1 : 0)) {
                    ((BS)object4).set(jmolEdge4.index);
                    continue;
                }
                if (n12 <= 1 && c <= c2 || this.htRings.containsKey(SmilesGenerator.getRingKey(jmolNode2.getIndex(), n5))) continue;
                c2 = n12 > 1 ? 1000 + n12 : c;
                jmolEdge = jmolEdge4;
            }
        }
        JmolNode jmolNode3 = jmolEdge == null ? null : jmolEdge.getOtherAtomNode(jmolNode);
        int n13 = n3 = jmolEdge == null ? 0 : jmolEdge.getCovalentOrder();
        if (n10 < 7 && jmolEdge2 != null) {
            if (jmolEdge2.getCovalentOrder() == 2 && n3 == 2 && this.prevSp2Atoms != null && this.prevSp2Atoms[1] != null) {
                jmolNodeArray2[n10++] = this.prevSp2Atoms[0];
                jmolNodeArray2[n10++] = this.prevSp2Atoms[1];
            } else {
                jmolNodeArray2[n10++] = this.prevAtom;
            }
        }
        if (n10 < 7 && n9 == 1) {
            jmolNodeArray2[n10++] = object5;
        }
        boolean bl8 = n3 == 1 && this.prevSp2Atoms == null;
        c = this.getBondStereochemistry(jmolEdge2, this.prevAtom);
        SB sB2 = new SB();
        for (n2 = 0; n2 < jmolList.size(); ++n2) {
            object3 = (JmolEdge)jmolList.get(n2);
            if (!((BS)object4).get(((JmolEdge)object3).index)) continue;
            JmolNode jmolNode4 = ((JmolEdge)object3).getOtherAtomNode(jmolNode);
            object2 = new SB();
            ((SB)object2).append("(");
            this.prevAtom = jmolNode;
            this.prevSp2Atoms = null;
            object = jmolEdge;
            this.getSmiles((SB)object2, jmolNode4, bl, bl2);
            jmolEdge = object;
            ((SB)object2).append(")");
            if (sB2.indexOf(((SB)object2).toString()) >= 0) {
                n10 = 10;
            }
            sB2.appendSB((SB)object2);
            jmolList.remove(n2--);
            if (n10 < 7) {
                jmolNodeArray2[n10++] = jmolNode4;
            }
            if (n7 >= 5) continue;
            jmolNodeArray[n7++] = jmolNode4;
        }
        int n14 = n2 = n3 == 2 ? jmolNode3.getIndex() : -1;
        if (n9 > 1 || bl4 || n2 < 0 || SmilesSearch.isRingBond(this.ringSets, n5, n2)) {
            n7 = -1;
        }
        if (n7 < 0) {
            jmolNodeArray = null;
        }
        if (string2 != null || c != '\u0000') {
            if (c != '\u0000') {
                string2 = "" + c;
            }
            sB.append(string2);
        }
        object3 = null;
        if (!(bl2 || jmolList.size() != 5 && jmolList.size() != 6)) {
            object3 = this.sortInorganic(jmolNode, jmolList);
        }
        for (n = 0; n < jmolList.size(); ++n) {
            object2 = (JmolEdge)jmolList.get(n);
            if (object2 == jmolEdge) continue;
            object = ((JmolEdge)object2).getOtherAtomNode(jmolNode);
            string = this.getRingCache(n5, object.getIndex(), this.htRings);
            string2 = SmilesBond.getBondOrderString(((JmolEdge)object2).order);
            if (!bl8 && (c = this.getBondStereochemistry((JmolEdge)object2, jmolNode)) != '\u0000') {
                string2 = "" + c;
            }
            sB2.append(string2);
            sB2.append(string);
            if (n10 < 7) {
                jmolNodeArray2[n10++] = object;
            }
            if (jmolNodeArray == null || n7 >= 5) continue;
            jmolNodeArray[n7++] = object;
        }
        if (bl5 && n10 == 2 && n3 == 2 && jmolNode3.getCovalentBondCount() == 3) {
            jmolEdgeArray = jmolNode3.getEdges();
            for (n = 0; n < jmolEdgeArray.length; ++n) {
                if (!jmolEdgeArray[n].isCovalent() || jmolNode3.getBondedAtomIndex(n) == n5) continue;
                jmolNodeArray2[n10++] = this.atoms[jmolNode3.getBondedAtomIndex(n)];
            }
            n7 = 0;
        } else if (jmolNode3 != null && n10 < 7) {
            jmolNodeArray2[n10++] = jmolNode3;
        }
        n = jmolNode.getValence();
        int n15 = jmolNode.getFormalCharge();
        int n16 = jmolNode.getIsotopeNumber();
        string = jmolNode.getAtomName();
        String string3 = jmolNode.getBioStructureTypeName();
        if (Logger.debugging) {
            sB.append("\n//* " + jmolNode + " *//\t");
        }
        if (bl3 && string3.length() != 0 && string.length() != 0) {
            this.addBracketedBioName(sB, jmolNode, "." + string);
        } else {
            sB.append(SmilesAtom.getAtomLabel(n8, n16, n, n15, n9, bl4, (String)(object3 != null ? object3 : this.checkStereoPairs(jmolNode, n5, jmolNodeArray2, n10))));
        }
        sB.appendSB(sB2);
        if (jmolEdge == null) {
            return null;
        }
        if (n3 == 2 && (n7 == 1 || n7 == 2)) {
            if (jmolNodeArray[0] == null) {
                jmolNodeArray[0] = jmolNode;
            }
            if (jmolNodeArray[1] == null) {
                jmolNodeArray[1] = jmolNode;
            }
        } else {
            jmolNodeArray = null;
            n7 = 0;
        }
        this.prevSp2Atoms = jmolNodeArray;
        this.prevAtom = jmolNode;
        return jmolNode3;
    }

    private String sortInorganic(JmolNode jmolNode, JmolList<JmolEdge> jmolList) {
        int n;
        JmolEdge jmolEdge;
        int n2;
        int n3 = jmolNode.getIndex();
        int n4 = jmolList.size();
        JmolList<JmolEdge[]> jmolList2 = new JmolList<JmolEdge[]>();
        JmolList<JmolEdge> jmolList3 = new JmolList<JmolEdge>();
        BS bS = new BS();
        JmolEdge[] jmolEdgeArray = null;
        JmolNode[] jmolNodeArray = new JmolNode[6];
        boolean bl = true;
        String string = "";
        for (n2 = 0; n2 < n4; ++n2) {
            JmolNode jmolNode2;
            jmolEdge = (JmolEdge)jmolList.get(n2);
            jmolNodeArray[0] = jmolNode2 = jmolEdge.getOtherAtomNode(jmolNode);
            if (n2 == 0) {
                string = this.addStereoCheck(n3, jmolNodeArray, 0, "");
            } else if (bl && this.addStereoCheck(n3, jmolNodeArray, 0, string) != null) {
                bl = false;
            }
            if (bS.get(n2)) continue;
            bS.set(n2);
            n = 0;
            for (int i = n2 + 1; i < n4; ++i) {
                JmolEdge jmolEdge2;
                JmolNode jmolNode3;
                if (bS.get(i) || !SmilesSearch.isDiaxial(jmolNode, jmolNode, jmolNode2, jmolNode3 = (jmolEdge2 = (JmolEdge)jmolList.get(i)).getOtherAtomNode(jmolNode), this.vTemp, -0.95f)) continue;
                jmolList2.addLast(new JmolEdge[]{jmolEdge, jmolEdge2});
                n = 1;
                bS.set(i);
                break;
            }
            if (n != 0) continue;
            jmolList3.addLast(jmolEdge);
        }
        n2 = jmolList2.size();
        if (bl || n4 == 6 && n2 != 3 || n4 == 5 && n2 == 0) {
            return "";
        }
        jmolEdgeArray = (JmolEdge[])jmolList2.get(0);
        jmolEdge = jmolEdgeArray[0];
        jmolNodeArray[0] = jmolEdge.getOtherAtomNode(jmolNode);
        jmolList.clear();
        jmolList.addLast(jmolEdge);
        if (n2 > 1) {
            jmolList3.addLast(((JmolEdge[])jmolList2.get(1))[0]);
        }
        if (n2 == 3) {
            jmolList3.addLast(((JmolEdge[])jmolList2.get(2))[0]);
        }
        if (n2 > 1) {
            jmolList3.addLast(((JmolEdge[])jmolList2.get(1))[1]);
        }
        if (n2 == 3) {
            jmolList3.addLast(((JmolEdge[])jmolList2.get(2))[1]);
        }
        for (n = 0; n < jmolList3.size(); ++n) {
            jmolEdge = (JmolEdge)jmolList3.get(n);
            jmolList.addLast(jmolEdge);
            jmolNodeArray[n + 1] = jmolEdge.getOtherAtomNode(jmolNode);
        }
        jmolList.addLast(jmolEdgeArray[1]);
        return SmilesGenerator.getStereoFlag(jmolNode, jmolNodeArray, n4, this.vTemp);
    }

    private String checkStereoPairs(JmolNode jmolNode, int n, JmolNode[] jmolNodeArray, int n2) {
        if (n2 < 4) {
            return "";
        }
        if (n2 == 4 && jmolNode.getElementNumber() == 6) {
            String string = "";
            for (int i = 0; i < 4; ++i) {
                if ((string = this.addStereoCheck(n, jmolNodeArray, i, string)) != null) continue;
                n2 = 10;
                break;
            }
        }
        return n2 > 6 ? "" : SmilesGenerator.getStereoFlag(jmolNode, jmolNodeArray, n2, this.vTemp);
    }

    private static String getStereoFlag(JmolNode jmolNode, JmolNode[] jmolNodeArray, int n, SmilesSearch.VTemp vTemp) {
        JmolNode jmolNode2 = jmolNodeArray[0];
        JmolNode jmolNode3 = jmolNodeArray[1];
        JmolNode jmolNode4 = jmolNodeArray[2];
        JmolNode jmolNode5 = jmolNodeArray[3];
        JmolNode jmolNode6 = jmolNodeArray[4];
        JmolNode jmolNode7 = jmolNodeArray[5];
        int n2 = 4;
        switch (n) {
            default: {
                return SmilesSearch.checkStereochemistryAll(false, jmolNode, n2, 1, jmolNode2, jmolNode3, jmolNode4, jmolNode5, jmolNode6, jmolNode7, vTemp) ? "@" : "@@";
            }
            case 2: 
            case 4: 
        }
        if (jmolNode4 == null || jmolNode5 == null) {
            return "";
        }
        float f = SmilesAromatic.getNormalThroughPoints(jmolNode2, jmolNode3, jmolNode4, vTemp.vTemp, vTemp.vA, vTemp.vB);
        if (Math.abs(SmilesSearch.distanceToPlane(vTemp.vTemp, f, (P3)((Object)jmolNode5))) < 0.2f) {
            n2 = 8;
            if (SmilesSearch.checkStereochemistryAll(false, jmolNode, n2, 1, jmolNode2, jmolNode3, jmolNode4, jmolNode5, jmolNode6, jmolNode7, vTemp)) {
                return "@SP1";
            }
            if (SmilesSearch.checkStereochemistryAll(false, jmolNode, n2, 2, jmolNode2, jmolNode3, jmolNode4, jmolNode5, jmolNode6, jmolNode7, vTemp)) {
                return "@SP2";
            }
            if (SmilesSearch.checkStereochemistryAll(false, jmolNode, n2, 3, jmolNode2, jmolNode3, jmolNode4, jmolNode5, jmolNode6, jmolNode7, vTemp)) {
                return "@SP3";
            }
        } else {
            return SmilesSearch.checkStereochemistryAll(false, jmolNode, n2, 1, jmolNode2, jmolNode3, jmolNode4, jmolNode5, jmolNode6, jmolNode7, vTemp) ? "@" : "@@";
        }
        return "";
    }

    private String addStereoCheck(int n, JmolNode[] jmolNodeArray, int n2, String string) {
        int n3;
        int n4 = jmolNodeArray[n2].getAtomicAndIsotopeNumber();
        int n5 = jmolNodeArray[n2].getCovalentBondCount();
        int n6 = n3 = n4 == 6 ? jmolNodeArray[n2].getCovalentHydrogenCount() : 0;
        if (n4 == 6 ? n5 != 4 || n3 != 3 : n5 > 1) {
            return string;
        }
        String string2 = ";" + n4 + "/" + n3 + "/" + n5 + ",";
        if (string.indexOf(string2) >= 0) {
            if (n3 == 3) {
                int n7 = 0;
                for (int i = 0; i < n5 && n7 < 3; ++i) {
                    int n8 = jmolNodeArray[n2].getBondedAtomIndex(i);
                    if (n8 == n) continue;
                    n7 += this.atoms[n8].getAtomicAndIsotopeNumber();
                }
                if (n7 > 3) {
                    return string;
                }
            }
            return null;
        }
        return string + string2;
    }

    private String getRingCache(int n, int n2, Map<String, Object[]> map) {
        String string;
        String string2 = SmilesGenerator.getRingKey(n, n2);
        Object[] objectArray = map.get(string2);
        String string3 = string = objectArray == null ? null : (String)objectArray[0];
        if (string == null) {
            Object[] objectArray2 = new Object[2];
            string = SmilesParser.getRingPointer(++this.nPairs);
            objectArray2[0] = string;
            objectArray2[1] = n2;
            map.put(string2, objectArray2);
            if (Logger.debugging) {
                Logger.debug("adding for " + n + " ring key " + this.nPairs + ": " + string2);
            }
        } else {
            map.remove(string2);
            if (Logger.debugging) {
                Logger.debug("using ring key " + string2);
            }
        }
        return string;
    }

    private void dumpRingKeys(SB sB, Map<String, Object[]> map) {
        Logger.info(sB.toString() + "\n\n");
        for (String string : map.keySet()) {
            Logger.info("unmatched ring key: " + string);
        }
    }

    protected static String getRingKey(int n, int n2) {
        return Math.min(n, n2) + "_" + Math.max(n, n2);
    }
}

