/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.api.JmolDocument;
import org.jmol.io.JmolBinary;
import org.jmol.jvxl.api.MeshDataServer;
import org.jmol.jvxl.data.JvxlCoder;
import org.jmol.jvxl.data.JvxlData;
import org.jmol.jvxl.data.MeshData;
import org.jmol.jvxl.readers.Parameters;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.shape.Mesh;
import org.jmol.shape.MeshCollection;
import org.jmol.shape.Shape;
import org.jmol.shapesurface.IsosurfaceMesh;
import org.jmol.util.ArrayUtil;
import org.jmol.util.AxisAngle4f;
import org.jmol.util.BS;
import org.jmol.util.C;
import org.jmol.util.ColorEncoder;
import org.jmol.util.ColorUtil;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.MeshSurface;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.P4;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Isosurface
extends MeshCollection
implements MeshDataServer {
    private IsosurfaceMesh[] isomeshes = new IsosurfaceMesh[4];
    protected IsosurfaceMesh thisMesh;
    private String actualID;
    protected boolean iHaveBitSets;
    private boolean explicitContours;
    private int atomIndex;
    private int moNumber;
    private float[] moLinearCombination;
    private short defaultColix;
    private short meshColix;
    private P3 center;
    private float scale3d;
    private boolean isPhaseColored;
    private boolean isColorExplicit;
    private String scriptAppendix = "";
    protected SurfaceGenerator sg;
    protected JvxlData jvxlData;
    private float withinDistance2;
    private boolean isWithinNot;
    private JmolList<P3> withinPoints;
    private float[] cutoffRange;
    boolean allowMesh = true;
    private String script;
    private boolean iHaveModelIndex;
    private int nLCAO = 0;
    private P4 lcaoDir = new P4();
    private double privateKey;
    private boolean associateNormals;
    private static final int MAX_OBJECT_CLICK_DISTANCE_SQUARED = 100;
    private final P3i ptXY = new P3i();
    public int[] keyXy;

    @Override
    public void allocMesh(String string, Mesh mesh) {
        int n = this.meshCount++;
        this.isomeshes = (IsosurfaceMesh[])ArrayUtil.ensureLength(this.isomeshes, this.meshCount * 2);
        this.meshes = this.isomeshes;
        this.isomeshes[n] = mesh == null ? new IsosurfaceMesh(string, this.colix, n) : (IsosurfaceMesh)mesh;
        this.thisMesh = this.isomeshes[n];
        this.currentMesh = this.isomeshes[n];
        this.currentMesh.index = n;
        if (this.sg != null) {
            this.jvxlData = this.thisMesh.jvxlData;
            this.sg.setJvxlData(this.jvxlData);
        }
    }

    @Override
    public void initShape() {
        super.initShape();
        this.myType = "isosurface";
        this.newSg();
    }

    protected void newSg() {
        this.jvxlData = new JvxlData();
        this.sg = new SurfaceGenerator(this.viewer, this, null, this.jvxlData);
        this.sg.getParams().showTiming = this.viewer.getBoolean(603979934);
        this.sg.setVersion("Jmol " + Viewer.getJmolVersion());
    }

    protected void clearSg() {
        this.sg = null;
    }

    @Override
    public void setProperty(String string, Object object, BS bS) {
        this.setPropI(string, object, bS);
    }

    protected void setPropI(String string, Object object, BS bS) {
        if ("cache" == string) {
            if (this.currentMesh == null) {
                return;
            }
            String string2 = this.currentMesh.thisID;
            int n = this.currentMesh.modelIndex;
            this.viewer.cachePut("cache://isosurface_" + string2, this.getPropI("jvxlDataXml"));
            this.deleteMeshI(this.currentMesh.index);
            this.setPropI("init", null, null);
            this.setPropI("thisID", string2, null);
            this.setPropI("modelIndex", n, null);
            this.setPropI("fileName", "cache://isosurface_" + string2, null);
            this.setPropI("readFile", null, null);
            this.setPropI("finalize", "isosurface ID " + Escape.eS(string2) + (n >= 0 ? " modelIndex " + n : "") + " /*file*/" + Escape.eS("cache://isosurface_" + string2), null);
            this.setPropI("clear", null, null);
            return;
        }
        if ("delete" == string) {
            this.setPropertySuper(string, object, bS);
            if (!this.explicitID) {
                this.nUnnamed = 0;
                this.nLCAO = 0;
            }
            this.thisMesh = null;
            this.currentMesh = null;
            return;
        }
        if ("remapInherited" == string) {
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.isomeshes[n] == null || !"#inherit;".equals(this.isomeshes[n].colorCommand)) continue;
                this.isomeshes[n].remapColors(this.viewer, null, Float.NaN);
            }
            return;
        }
        if ("remapColor" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.remapColors(this.viewer, (ColorEncoder)object, this.translucentLevel);
            }
            return;
        }
        if ("thisID" == string) {
            if (this.actualID != null) {
                object = this.actualID;
            }
            this.setPropertySuper("thisID", object, null);
            return;
        }
        if ("params" == string) {
            if (this.thisMesh != null) {
                this.ensureMeshSource();
                this.thisMesh.checkAllocColixes();
                Object[] objectArray = object;
                short[] sArray = (short[])objectArray[0];
                int[] nArray = null;
                if (sArray != null) {
                    int n;
                    int n2;
                    for (n2 = 0; n2 < sArray.length; ++n2) {
                        n = sArray[n2];
                        float f = 0.0f;
                        if (f > 0.01f) {
                            n = C.getColixTranslucent3((short)n, true, f);
                        }
                        sArray[n2] = n;
                    }
                    nArray = new int[bS.length()];
                    n2 = 0;
                    n = bS.nextSetBit(0);
                    while (n >= 0) {
                        nArray[n] = n2++;
                        n = bS.nextSetBit(n + 1);
                    }
                }
                this.thisMesh.setVertexColixesForAtoms(this.viewer, sArray, nArray, bS);
                this.thisMesh.setVertexColorMap();
            }
            return;
        }
        if ("atomcolor" == string) {
            if (this.thisMesh != null) {
                this.ensureMeshSource();
                this.thisMesh.colorVertices(C.getColixO(object), bS, true);
            }
            return;
        }
        if ("pointSize" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.volumeRenderPointSize = ((Float)object).floatValue();
            }
            return;
        }
        if ("vertexcolor" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.colorVertices(C.getColixO(object), bS, false);
            }
            return;
        }
        if ("colorPhase" == string) {
            Object[] objectArray = object;
            if (this.thisMesh != null) {
                this.thisMesh.colorPhased = true;
                this.thisMesh.colix = this.thisMesh.jvxlData.minColorIndex = C.getColix((Integer)objectArray[0]);
                this.thisMesh.jvxlData.maxColorIndex = C.getColix((Integer)objectArray[1]);
                this.thisMesh.jvxlData.isBicolorMap = true;
                this.thisMesh.jvxlData.colorDensity = false;
                this.thisMesh.isColorSolid = false;
                this.thisMesh.remapColors(this.viewer, null, this.translucentLevel);
            }
            return;
        }
        if ("color" == string) {
            String string3 = C.getHexCode(C.getColixO(object));
            if (this.thisMesh != null) {
                this.thisMesh.jvxlData.baseColor = string3;
                this.thisMesh.isColorSolid = true;
                this.thisMesh.polygonColixes = null;
                this.thisMesh.colorEncoder = null;
                this.thisMesh.vertexColorMap = null;
            } else if (!TextFormat.isWild(this.previousMeshID)) {
                int n = this.meshCount;
                while (--n >= 0) {
                    this.isomeshes[n].jvxlData.baseColor = string3;
                    this.isomeshes[n].isColorSolid = true;
                    this.isomeshes[n].polygonColixes = null;
                    this.isomeshes[n].colorEncoder = null;
                    this.isomeshes[n].vertexColorMap = null;
                }
            }
            this.setPropertySuper(string, object, bS);
            return;
        }
        if ("nocontour" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.deleteContours();
            }
            return;
        }
        if ("fixed" == string) {
            this.isFixed = (Boolean)object;
            this.setMeshI();
            return;
        }
        if ("newObject" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.clearType(this.thisMesh.meshType, false);
            }
            return;
        }
        if ("moveIsosurface" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.updateCoordinates((Matrix4f)object, null);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("refreshTrajectories" == string) {
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.meshes[n].connections == null || this.meshes[n].modelIndex != (Integer)((Object[])object)[0]) continue;
                ((IsosurfaceMesh)this.meshes[n]).updateCoordinates((Matrix4f)((Object[])object)[2], (BS)((Object[])object)[1]);
            }
            return;
        }
        if ("modelIndex" == string) {
            if (!this.iHaveModelIndex) {
                this.modelIndex = (Integer)object;
                this.isFixed = this.modelIndex < 0;
                this.sg.setModelIndex(Math.abs(this.modelIndex));
            }
            return;
        }
        if ("lcaoCartoon" == string || "lonePair" == string || "radical" == string) {
            V3[] v3Array = (V3[])object;
            if (!this.explicitID) {
                this.setPropertySuper("thisID", null, null);
            }
            if (!this.sg.setParameter("lcaoCartoonCenter", v3Array[2])) {
                this.drawLcaoCartoon(v3Array[0], v3Array[1], v3Array[3], "lonePair" == string ? 2 : ("radical" == string ? 1 : 0));
            }
            return;
        }
        if ("select" == string && this.iHaveBitSets) {
            return;
        }
        if ("ignore" == string && this.iHaveBitSets) {
            return;
        }
        if ("meshcolor" == string) {
            int n = (Integer)object;
            this.meshColix = C.getColix(n);
            if (this.thisMesh != null) {
                this.thisMesh.meshColix = this.meshColix;
            }
            return;
        }
        if ("offset" == string) {
            P3 p3 = P3.newP((P3)object);
            if (p3.equals(JC.center)) {
                p3 = null;
            }
            if (this.thisMesh != null) {
                this.thisMesh.rotateTranslate(null, p3, true);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("rotate" == string) {
            P4 p4 = (P4)object;
            if (this.thisMesh != null) {
                this.thisMesh.rotateTranslate(Quaternion.newP4(p4), null, true);
                this.thisMesh.altVertices = null;
            }
            return;
        }
        if ("bsDisplay" == string) {
            this.bsDisplay = (BS)object;
            return;
        }
        if ("displayWithin" == string) {
            Object[] objectArray = object;
            this.displayWithinDistance2 = ((Float)objectArray[0]).floatValue();
            this.isDisplayWithinNot = this.displayWithinDistance2 < 0.0f;
            this.displayWithinDistance2 *= this.displayWithinDistance2;
            this.displayWithinPoints = (JmolList)objectArray[3];
            if (this.displayWithinPoints.size() == 0) {
                this.displayWithinPoints = this.viewer.getAtomPointVector((BS)objectArray[2]);
            }
            return;
        }
        if ("finalize" == string) {
            if (this.thisMesh != null) {
                String string4 = (String)object;
                if (string4 != null && !string4.startsWith("; isosurface map")) {
                    this.thisMesh.setDiscreteColixes(this.sg.getParams().contoursDiscrete, this.sg.getParams().contourColixes);
                    this.setJvxlInfo();
                }
                this.setScriptInfo(string4);
            }
            this.clearSg();
            return;
        }
        if ("privateKey" == string) {
            this.privateKey = (Double)object;
            return;
        }
        if ("connections" == string) {
            if (this.currentMesh != null) {
                this.connections = (int[])object;
                if (this.connections[0] >= 0 && this.connections[0] < this.viewer.getAtomCount()) {
                    this.currentMesh.connections = this.connections;
                } else {
                    this.currentMesh.connections = null;
                    this.connections = null;
                }
            }
            return;
        }
        if ("cutoffRange" == string) {
            this.cutoffRange = (float[])object;
            return;
        }
        if ("slab" == string) {
            if (object instanceof Integer) {
                if (this.thisMesh != null) {
                    this.thisMesh.jvxlData.slabValue = (Integer)object;
                }
                return;
            }
            if (this.thisMesh != null) {
                Object[] objectArray = object;
                int n = (Integer)objectArray[0];
                switch (n) {
                    case 1073742018: {
                        Object[] objectArray2 = (Object[])objectArray[1];
                        Mesh mesh = this.getMesh((String)objectArray2[1]);
                        if (mesh == null) {
                            return;
                        }
                        objectArray2[1] = mesh;
                    }
                }
                this.slabPolygons(objectArray);
                return;
            }
        }
        if ("cap" == string && this.thisMesh != null && this.thisMesh.polygonCount != 0) {
            this.thisMesh.slabPolygons((Object[])object, true);
            this.thisMesh.initialize(this.thisMesh.lighting, null, null);
            return;
        }
        if ("map" == string) {
            if (this.sg != null) {
                this.sg.getParams().isMapped = true;
            }
            this.setProperty("squareData", Boolean.FALSE, null);
            if (this.thisMesh == null || this.thisMesh.vertexCount == 0) {
                return;
            }
        }
        if ("deleteVdw" == string) {
            int n = this.meshCount;
            while (--n >= 0) {
                if (this.isomeshes[n].bsVdw == null || bS != null && !bS.intersects(this.isomeshes[n].bsVdw)) continue;
                this.deleteMeshI(n);
            }
            this.thisMesh = null;
            this.currentMesh = null;
            return;
        }
        if ("mapColor" == string || "readFile" == string) {
            if (object == null) {
                object = this.viewer.getBufferedReaderOrErrorMessageFromName(this.sg.getFileName(), null, true);
                if (object instanceof String) {
                    Logger.error("Isosurface: could not open file " + this.sg.getFileName() + " -- " + object);
                    return;
                }
                if (!(object instanceof BufferedReader)) {
                    try {
                        object = JmolBinary.getBufferedReader((BufferedInputStream)object, "ISO-8859-1");
                    }
                    catch (IOException iOException) {}
                }
            }
        } else if ("atomIndex" == string) {
            this.atomIndex = (Integer)object;
            if (this.thisMesh != null) {
                this.thisMesh.atomIndex = this.atomIndex;
            }
        } else if ("center" == string) {
            this.center.setT((P3)object);
        } else if ("colorRGB" == string) {
            int n = (Integer)object;
            this.defaultColix = C.getColix(n);
        } else if ("contour" == string) {
            this.explicitContours = true;
        } else if ("functionXY" == string) {
            if (this.sg.isStateDataRead()) {
                this.setScriptInfo(null);
            }
        } else if ("init" == string) {
            this.newSg();
        } else if ("getSurfaceSets" == string) {
            if (this.thisMesh != null) {
                this.thisMesh.jvxlData.thisSet = (Integer)object;
                this.thisMesh.calculatedVolume = null;
                this.thisMesh.calculatedArea = null;
            }
        } else if ("localName" == string) {
            object = this.viewer.getOutputStream((String)object, null);
            string = "outputStream";
        } else if ("molecularOrbital" == string) {
            if (object instanceof Integer) {
                this.moNumber = (Integer)object;
                this.moLinearCombination = null;
            } else {
                this.moLinearCombination = (float[])object;
                this.moNumber = 0;
            }
            if (!this.isColorExplicit) {
                this.isPhaseColored = true;
            }
        } else if ("phase" == string) {
            this.isPhaseColored = true;
        } else if ("plane" != string && "pocket" != string) {
            if ("scale3d" == string) {
                this.scale3d = ((Float)object).floatValue();
                if (this.thisMesh != null) {
                    this.thisMesh.scale3d = this.thisMesh.jvxlData.scale3d = this.scale3d;
                    this.thisMesh.altVertices = null;
                }
            } else if ("title" == string) {
                if (object instanceof String && "-".equals(object)) {
                    object = null;
                }
                this.setPropertySuper(string, object, bS);
                object = this.title;
            } else if ("withinPoints" == string) {
                Object[] objectArray = object;
                this.withinDistance2 = ((Float)objectArray[0]).floatValue();
                this.isWithinNot = this.withinDistance2 < 0.0f;
                this.withinDistance2 *= this.withinDistance2;
                this.withinPoints = (JmolList)objectArray[3];
                if (this.withinPoints.size() == 0) {
                    this.withinPoints = this.viewer.getAtomPointVector((BS)objectArray[2]);
                }
            } else if (("nci" == string || "orbital" == string) && this.sg != null) {
                int n = this.sg.getParams().testFlags = this.viewer.getTestFlag(2) ? 2 : 0;
            }
        }
        if (this.sg != null && this.sg.setProp(string, object, bS)) {
            if (this.sg.isValid()) {
                return;
            }
            string = "delete";
        }
        if ("init" == string) {
            this.explicitID = false;
            this.scriptAppendix = "";
            String string5 = object instanceof String ? (String)object : null;
            int n = string5 == null ? -1 : string5.indexOf("# ID=");
            this.actualID = n >= 0 ? Parser.getQuotedStringAt(string5, n) : null;
            this.setPropertySuper("thisID", "+PREVIOUS_MESH+", null);
            if (string5 != null && !(this.iHaveBitSets = this.getScriptBitSets(string5, null))) {
                this.sg.setParameter("select", bS);
            }
            this.initializeIsosurface();
            this.sg.setModelIndex(this.isFixed ? -1 : this.modelIndex);
            return;
        }
        if ("clear" == string) {
            this.discardTempData(true);
            return;
        }
        if ("colorDensity" == string) {
            if (object != null && this.currentMesh != null) {
                this.currentMesh.volumeRenderPointSize = ((Float)object).floatValue();
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            int n3 = ((int[])((Object[])object)[2])[1];
            int n4 = ((int[])((Object[])object)[2])[2];
            int n5 = this.meshCount;
            while (--n5 >= 0) {
                Mesh mesh = this.meshes[n5];
                if (mesh == null) continue;
                if (mesh.connections != null) {
                    int n6 = mesh.connections[0];
                    if (n6 >= n3 + n4) {
                        mesh.connections[0] = n6 - n4;
                    } else if (n6 >= n3) {
                        mesh.connections = null;
                    }
                }
                mesh.connections = null;
                if (mesh.modelIndex == n) {
                    --this.meshCount;
                    if (mesh == this.currentMesh) {
                        this.thisMesh = null;
                        this.currentMesh = null;
                    }
                    this.isomeshes = (IsosurfaceMesh[])ArrayUtil.deleteElements(this.meshes, n5, 1);
                    this.meshes = this.isomeshes;
                    continue;
                }
                if (mesh.modelIndex <= n) continue;
                --mesh.modelIndex;
                if (mesh.atomIndex < n3) continue;
                mesh.atomIndex -= n4;
            }
            return;
        }
        this.setPropertySuper(string, object, bS);
    }

    private void ensureMeshSource() {
        boolean bl;
        boolean bl2 = bl = this.thisMesh.vertexSource != null;
        if (bl) {
            int n = this.thisMesh.vertexCount;
            while (--n >= 0) {
                if (this.thisMesh.vertexSource[n] >= 0) continue;
                bl = false;
                break;
            }
        }
        if (!bl) {
            int[] nArray = this.thisMesh.vertexSource;
            short[] sArray = this.thisMesh.vertexColixes;
            short s = this.thisMesh.isColorSolid ? this.thisMesh.colix : (short)0;
            this.setProperty("init", null, null);
            this.setProperty("map", Boolean.FALSE, null);
            this.setProperty("property", new float[this.viewer.getAtomCount()], null);
            if (s != 0) {
                this.thisMesh.colorCommand = "color isosurface " + C.getHexCode(s);
                this.setProperty("color", C.getArgb(s), null);
            }
            if (nArray != null) {
                int n = this.thisMesh.vertexCount;
                while (--n >= 0) {
                    if (nArray[n] >= 0) continue;
                    nArray[n] = this.thisMesh.vertexSource[n];
                }
                this.thisMesh.vertexSource = nArray;
                this.thisMesh.vertexColixes = sArray;
            }
        }
    }

    protected void slabPolygons(Object[] objectArray) {
        this.thisMesh.slabPolygons(objectArray, false);
        this.thisMesh.reinitializeLightingAndColor(this.viewer);
    }

    private void setPropertySuper(String string, Object object, BS bS) {
        if (string == "thisID" && this.currentMesh != null && this.currentMesh.thisID != null && this.currentMesh.thisID.equals(object)) {
            this.checkExplicit((String)object);
            return;
        }
        this.currentMesh = this.thisMesh;
        this.setPropMC(string, object, bS);
        this.thisMesh = (IsosurfaceMesh)this.currentMesh;
        JvxlData jvxlData = this.jvxlData = this.thisMesh == null ? null : this.thisMesh.jvxlData;
        if (this.sg != null) {
            this.sg.setJvxlData(this.jvxlData);
        }
    }

    @Override
    public boolean getPropertyData(String string, Object[] objectArray) {
        int n;
        if (string == "colorEncoder") {
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh((String)objectArray[0]);
            return isosurfaceMesh != null && (objectArray[1] = isosurfaceMesh.colorEncoder) != null;
        }
        if (string == "intersectPlane") {
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh((String)objectArray[0]);
            if (isosurfaceMesh == null) {
                return false;
            }
            objectArray[3] = isosurfaceMesh.modelIndex;
            isosurfaceMesh.getIntersection(0.0f, (P4)objectArray[1], null, (JmolList)objectArray[2], null, null, null, false, false, 135266319, false);
            return true;
        }
        if (string == "getBoundingBox") {
            String string2 = (String)objectArray[0];
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh(string2);
            if (isosurfaceMesh == null || isosurfaceMesh.vertices == null) {
                return false;
            }
            objectArray[2] = isosurfaceMesh.jvxlData.boundingBox;
            if (isosurfaceMesh.mat4 != null) {
                P3[] p3Array = new P3[]{P3.newP(isosurfaceMesh.jvxlData.boundingBox[0]), P3.newP(isosurfaceMesh.jvxlData.boundingBox[1])};
                V3 v3 = new V3();
                isosurfaceMesh.mat4.get(v3);
                p3Array[0].add(v3);
                p3Array[1].add(v3);
                objectArray[2] = p3Array;
            }
            return true;
        }
        if (string == "unitCell") {
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh((String)objectArray[0]);
            return isosurfaceMesh != null && (objectArray[1] = isosurfaceMesh.getUnitCell()) != null;
        }
        if (string == "getCenter" && (n = ((Integer)objectArray[1]).intValue()) == Integer.MIN_VALUE) {
            String string3 = (String)objectArray[0];
            IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.getMesh(string3);
            if (isosurfaceMesh == null || isosurfaceMesh.vertices == null) {
                return false;
            }
            P3 p3 = P3.newP(isosurfaceMesh.jvxlData.boundingBox[0]);
            p3.add(isosurfaceMesh.jvxlData.boundingBox[1]);
            p3.scale(0.5f);
            if (isosurfaceMesh.mat4 != null) {
                V3 v3 = new V3();
                isosurfaceMesh.mat4.get(v3);
                p3.add(v3);
            }
            objectArray[2] = p3;
            return true;
        }
        return this.getPropDataMC(string, objectArray);
    }

    @Override
    public Object getProperty(String string, int n) {
        return this.getPropI(string);
    }

    protected Object getPropI(String string) {
        Object object = this.getPropMC(string);
        if (object != null) {
            return object;
        }
        if (string == "dataRange") {
            float[] fArray;
            if (this.thisMesh == null || this.jvxlData.jvxlPlane != null && this.thisMesh.colorEncoder == null) {
                fArray = null;
            } else {
                float[] fArray2 = new float[4];
                fArray2[0] = this.jvxlData.mappedDataMin;
                fArray2[1] = this.jvxlData.mappedDataMax;
                fArray2[2] = this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToBlue : this.jvxlData.valueMappedToRed;
                fArray = fArray2;
                fArray2[3] = this.jvxlData.isColorReversed ? this.jvxlData.valueMappedToRed : this.jvxlData.valueMappedToBlue;
            }
            return fArray;
        }
        if (string == "moNumber") {
            return this.moNumber;
        }
        if (string == "moLinearCombination") {
            return this.moLinearCombination;
        }
        if (string == "nSets") {
            return this.thisMesh == null ? 0 : this.thisMesh.nSets;
        }
        if (string == "area") {
            return this.thisMesh == null ? Float.valueOf(Float.NaN) : this.calculateVolumeOrArea(true);
        }
        if (string == "volume") {
            return this.thisMesh == null ? Float.valueOf(Float.NaN) : this.calculateVolumeOrArea(false);
        }
        if (this.thisMesh == null) {
            return null;
        }
        if (string == "cutoff") {
            return Float.valueOf(this.jvxlData.cutoff);
        }
        if (string == "minMaxInfo") {
            return new float[]{this.jvxlData.dataMin, this.jvxlData.dataMax};
        }
        if (string == "plane") {
            return this.jvxlData.jvxlPlane;
        }
        if (string == "contours") {
            return this.thisMesh.getContours();
        }
        if (string == "jvxlDataXml" || string == "jvxlMeshXml") {
            MeshData meshData = null;
            this.jvxlData.slabInfo = null;
            if (string == "jvxlMeshXml" || this.jvxlData.vertexDataOnly || this.thisMesh.bsSlabDisplay != null && this.thisMesh.bsSlabGhost == null) {
                meshData = new MeshData();
                this.fillMeshData(meshData, 1, null);
                meshData.polygonColorData = Isosurface.getPolygonColorData(meshData.polygonCount, meshData.polygonColixes, meshData.bsSlabDisplay);
            } else if (this.thisMesh.bsSlabGhost != null) {
                this.jvxlData.slabInfo = this.thisMesh.slabOptions.toString();
            }
            SB sB = new SB();
            this.getMeshCommand(sB, this.thisMesh.index);
            this.thisMesh.setJvxlColorMap(true);
            return JvxlCoder.jvxlGetFile(this.jvxlData, meshData, this.title, "", true, 1, sB.toString(), null);
        }
        if (string == "jvxlFileInfo") {
            this.thisMesh.setJvxlColorMap(false);
            return JvxlCoder.jvxlGetInfo(this.jvxlData);
        }
        if (string == "command") {
            String string2 = this.previousMeshID.toUpperCase();
            boolean bl = TextFormat.isWild(string2);
            SB sB = new SB();
            int n = this.meshCount;
            while (--n >= 0) {
                String string3 = this.meshes[n].thisID.toUpperCase();
                if (!string3.equals(string2) && (!bl || !TextFormat.isMatch(string3, string2, true, true))) continue;
                this.getMeshCommand(sB, n);
            }
            return sB.toString();
        }
        return null;
    }

    private Object calculateVolumeOrArea(boolean bl) {
        if (bl) {
            if (this.thisMesh.calculatedArea != null) {
                return this.thisMesh.calculatedArea;
            }
        } else if (this.thisMesh.calculatedVolume != null) {
            return this.thisMesh.calculatedVolume;
        }
        MeshData meshData = new MeshData();
        this.fillMeshData(meshData, 1, null);
        meshData.nSets = this.thisMesh.nSets;
        meshData.vertexSets = this.thisMesh.vertexSets;
        if (!bl && this.thisMesh.jvxlData.colorDensity) {
            float f = this.thisMesh.jvxlData.voxelVolume;
            this.thisMesh.calculatedVolume = Float.valueOf(f *= (float)(this.thisMesh.bsSlabDisplay == null ? this.thisMesh.vertexCount : this.thisMesh.bsSlabDisplay.cardinality()));
            return this.thisMesh.calculatedVolume;
        }
        Object object = meshData.calculateVolumeOrArea(this.thisMesh.jvxlData.thisSet, bl, false);
        if (bl) {
            this.thisMesh.calculatedArea = object;
        } else {
            this.thisMesh.calculatedVolume = object;
        }
        return object;
    }

    public static String getPolygonColorData(int n, short[] sArray, BS bS) {
        if (sArray == null) {
            return null;
        }
        SB sB = new SB();
        int n2 = 0;
        short s = 0;
        boolean bl = false;
        int n3 = 0;
        while (true) {
            if (n3 >= n) {
                bl = true;
                if (!true) break;
            }
            if (bl || bS == null || bS.get(n3)) {
                if (bl || sArray[n3] != s) {
                    if (n2 != 0) {
                        sB.append(" ").appendI(n2).append(" ").appendI(s == 0 ? 0 : C.getArgb(s));
                    }
                    if (bl) break;
                    s = sArray[n3];
                    n2 = 1;
                } else {
                    ++n2;
                }
            }
            ++n3;
        }
        sB.append("\n");
        return sB.toString();
    }

    @Override
    public String getShapeState() {
        this.clean();
        SB sB = new SB();
        sB.append("\n");
        for (int i = 0; i < this.meshCount; ++i) {
            this.getMeshCommand(sB, i);
        }
        return sB.toString();
    }

    private void getMeshCommand(SB sB, int n) {
        IsosurfaceMesh isosurfaceMesh = (IsosurfaceMesh)this.meshes[n];
        if (isosurfaceMesh == null || isosurfaceMesh.scriptCommand == null) {
            return;
        }
        String string = isosurfaceMesh.scriptCommand;
        int n2 = this.viewer.getModelCount();
        if (n2 > 1) {
            Isosurface.appendCmd(sB, "frame " + this.viewer.getModelNumberDotted(isosurfaceMesh.modelIndex));
        }
        string = TextFormat.simpleReplace(string, ";; isosurface map", " map");
        string = TextFormat.simpleReplace(string, "; isosurface map", " map");
        string = string.replace('\t', ' ');
        int n3 = (string = TextFormat.simpleReplace(string, ";#", "; #")).indexOf("; #");
        if (n3 >= 0) {
            string = string.substring(0, n3);
        }
        if (isosurfaceMesh.connections != null) {
            string = string + " connect " + Escape.eAI(isosurfaceMesh.connections);
        }
        string = TextFormat.trim(string, ";");
        if (isosurfaceMesh.linkedMesh != null) {
            string = string + " LINK";
        }
        if (this.myType == "lcaoCartoon" && isosurfaceMesh.atomIndex >= 0) {
            string = string + " ATOMINDEX " + isosurfaceMesh.atomIndex;
        }
        Isosurface.appendCmd(sB, string);
        String string2 = this.myType + " ID " + Escape.eS(isosurfaceMesh.thisID);
        if (isosurfaceMesh.jvxlData.thisSet >= 0) {
            Isosurface.appendCmd(sB, string2 + " set " + (isosurfaceMesh.jvxlData.thisSet + 1));
        }
        if (isosurfaceMesh.mat4 != null) {
            Isosurface.appendCmd(sB, string2 + " move " + Escape.matrixToScript(isosurfaceMesh.mat4));
        }
        if (isosurfaceMesh.scale3d != 0.0f) {
            Isosurface.appendCmd(sB, string2 + " scale3d " + isosurfaceMesh.scale3d);
        }
        if (isosurfaceMesh.jvxlData.slabValue != Integer.MIN_VALUE) {
            Isosurface.appendCmd(sB, string2 + " slab " + isosurfaceMesh.jvxlData.slabValue);
        }
        if (isosurfaceMesh.slabOptions != null) {
            Isosurface.appendCmd(sB, isosurfaceMesh.slabOptions.toString());
        }
        if (string.charAt(0) != '#') {
            boolean bl;
            if (this.allowMesh) {
                Isosurface.appendCmd(sB, isosurfaceMesh.getState(this.myType));
            }
            if (!isosurfaceMesh.isColorSolid && C.isColixTranslucent(isosurfaceMesh.colix)) {
                Isosurface.appendCmd(sB, "color " + this.myType + " " + Isosurface.getTranslucentLabel(isosurfaceMesh.colix));
            }
            if (isosurfaceMesh.colorCommand != null && !isosurfaceMesh.colorCommand.equals("#inherit;")) {
                Isosurface.appendCmd(sB, isosurfaceMesh.colorCommand);
            }
            boolean bl2 = bl = isosurfaceMesh.isColorSolid && isosurfaceMesh.polygonColixes != null;
            if (isosurfaceMesh.isColorSolid && !bl) {
                Isosurface.appendCmd(sB, Isosurface.getColorCommandUnk(this.myType, isosurfaceMesh.colix, this.translucentAllowed));
            } else if (isosurfaceMesh.jvxlData.isBicolorMap && isosurfaceMesh.colorPhased) {
                Isosurface.appendCmd(sB, "color isosurface phase " + Isosurface.encodeColor(isosurfaceMesh.jvxlData.minColorIndex) + " " + Isosurface.encodeColor(isosurfaceMesh.jvxlData.maxColorIndex));
            }
            if (isosurfaceMesh.vertexColorMap != null) {
                for (Map.Entry entry : isosurfaceMesh.vertexColorMap.entrySet()) {
                    BS bS = (BS)entry.getValue();
                    if (bS.isEmpty()) continue;
                    Isosurface.appendCmd(sB, "color " + this.myType + " " + Escape.eBS(bS) + " " + (String)entry.getKey());
                }
            }
        }
    }

    private boolean getScriptBitSets(String string, BS[] bSArray) {
        BS bS;
        int n;
        int n2;
        this.script = string;
        this.iHaveModelIndex = false;
        this.modelIndex = -1;
        if (string != null && (n2 = string.indexOf("MODEL({")) >= 0 && (n = string.indexOf("})", n2)) > 0) {
            bS = Escape.uB(string.substring(n2 + 3, n + 1));
            this.modelIndex = bS == null ? -1 : bS.nextSetBit(0);
            boolean bl = this.iHaveModelIndex = this.modelIndex >= 0;
        }
        if (string == null) {
            return false;
        }
        this.getCapSlabInfo(string);
        n2 = string.indexOf("# ({");
        if (n2 < 0) {
            return false;
        }
        n = string.indexOf("})", n2);
        if (n < 0) {
            return false;
        }
        bS = Escape.uB(string.substring(n2 + 2, n + 2));
        if (bSArray == null) {
            this.sg.setParameter("select", bS);
        } else {
            bSArray[0] = bS;
        }
        n2 = string.indexOf("({", n);
        if (n2 < 0) {
            return true;
        }
        n = string.indexOf("})", n2);
        if (n < 0) {
            return false;
        }
        bS = Escape.uB(string.substring(n2 + 1, n + 1));
        if (bSArray == null) {
            this.sg.setParameter("ignore", bS);
        } else {
            bSArray[1] = bS;
        }
        n2 = string.indexOf("/({", n);
        if (n2 == n + 2) {
            n = string.indexOf("})", n2);
            if (n < 0) {
                return false;
            }
            bS = Escape.uB(string.substring(n2 + 3, n + 1));
            if (bSArray == null) {
                this.viewer.setTrajectoryBs(bS);
            } else {
                bSArray[2] = bS;
            }
        }
        return true;
    }

    protected void getCapSlabInfo(String string) {
        int n = string.indexOf("# SLAB=");
        if (n >= 0) {
            this.sg.setParameter("slab", MeshSurface.getCapSlabObject(Parser.getQuotedStringAt(string, n), false));
        }
        if ((n = string.indexOf("# CAP=")) >= 0) {
            this.sg.setParameter("slab", MeshSurface.getCapSlabObject(Parser.getQuotedStringAt(string, n), true));
        }
    }

    private void initializeIsosurface() {
        if (!this.iHaveModelIndex) {
            this.modelIndex = this.viewer.getCurrentModelIndex();
        }
        this.atomIndex = -1;
        this.bsDisplay = null;
        this.center = P3.new3(Float.MAX_VALUE, Float.MAX_VALUE, Float.MAX_VALUE);
        this.colix = (short)5;
        this.connections = null;
        this.cutoffRange = null;
        this.meshColix = 0;
        this.defaultColix = 0;
        this.displayWithinPoints = null;
        this.explicitContours = false;
        this.isFixed = this.modelIndex < 0;
        this.isColorExplicit = false;
        this.isPhaseColored = false;
        this.linkedMesh = null;
        if (this.modelIndex < 0) {
            this.modelIndex = 0;
        }
        this.scale3d = 0.0f;
        this.title = null;
        this.translucentLevel = 0.0f;
        this.withinPoints = null;
        this.initState();
    }

    private void initState() {
        this.associateNormals = true;
        this.sg.initState();
    }

    private void setMeshI() {
        this.thisMesh.visible = true;
        this.thisMesh.atomIndex = this.atomIndex;
        this.thisMesh.modelIndex = this.thisMesh.atomIndex >= 0 ? this.viewer.getAtomModelIndex(this.atomIndex) : (this.isFixed ? -1 : (this.modelIndex >= 0 ? this.modelIndex : this.viewer.getCurrentModelIndex()));
        this.thisMesh.scriptCommand = this.script;
        this.thisMesh.ptCenter.setT(this.center);
        this.thisMesh.scale3d = this.thisMesh.jvxlData.jvxlPlane == null ? 0.0f : this.scale3d;
    }

    protected void discardTempData(boolean bl) {
        if (!bl) {
            return;
        }
        this.title = null;
        if (this.thisMesh == null) {
            return;
        }
        this.thisMesh.surfaceSet = null;
    }

    private short getDefaultColix() {
        if (this.defaultColix != 0) {
            return this.defaultColix;
        }
        if (!this.sg.isCubeData()) {
            return this.colix;
        }
        int n = this.sg.getCutoff() >= 0.0f ? -11525984 : -6283184;
        return C.getColix(n);
    }

    private void drawLcaoCartoon(V3 v3, V3 v32, V3 v33, int n) {
        Object object;
        Object object2;
        boolean bl;
        String string = this.sg.setLcao();
        float f = v33.x + v33.y + v33.z;
        this.defaultColix = C.getColix(this.sg.getColor(1));
        short s = C.getColix(this.sg.getColor(-1));
        V3 v34 = new V3();
        boolean bl2 = bl = string.length() > 0 && string.charAt(0) == '-';
        if (bl) {
            string = string.substring(1);
        }
        int n2 = bl ? -1 : 1;
        v34.cross(v3, v32);
        if (f != 0.0f) {
            object2 = new AxisAngle4f();
            if (v33.x != 0.0f) {
                ((AxisAngle4f)object2).setVA(v32, f);
            } else if (v33.y != 0.0f) {
                ((AxisAngle4f)object2).setVA(v34, f);
            } else {
                ((AxisAngle4f)object2).setVA(v3, f);
            }
            object = new Matrix3f();
            ((Matrix3f)object).setAA((AxisAngle4f)object2);
            ((Matrix3f)object).transform(v32);
            ((Matrix3f)object).transform(v34);
            ((Matrix3f)object).transform(v3);
        }
        if (this.thisMesh == null && this.nLCAO == 0) {
            this.nLCAO = this.meshCount;
        }
        Object object3 = this.thisMesh == null ? (n > 0 ? "lp" : "lcao") + ++this.nLCAO + "_" + string : (object2 = this.thisMesh.thisID);
        if (this.thisMesh == null) {
            this.allocMesh((String)object2, null);
        }
        if (string.equals("px")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(v32, n2, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(v32, -n2, n);
            this.thisMesh.colix = s;
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("py")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(v34, n2, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(v34, -n2, n);
            this.thisMesh.colix = s;
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pz")) {
            this.thisMesh.thisID = this.thisMesh.thisID + "a";
            object = this.thisMesh;
            this.createLcaoLobe(v3, n2, n);
            if (n > 0) {
                return;
            }
            this.setProperty("thisID", (String)object2 + "b", null);
            this.createLcaoLobe(v3, -n2, n);
            this.thisMesh.colix = s;
            this.linkedMesh = this.thisMesh.linkedMesh = object;
            return;
        }
        if (string.equals("pza") || string.indexOf("sp") == 0 || string.indexOf("d") == 0 || string.indexOf("lp") == 0) {
            this.createLcaoLobe(v3, n2, n);
            return;
        }
        if (string.equals("pzb")) {
            this.createLcaoLobe(v3, -n2, n);
            return;
        }
        if (string.equals("pxa")) {
            this.createLcaoLobe(v32, n2, n);
            return;
        }
        if (string.equals("pxb")) {
            this.createLcaoLobe(v32, -n2, n);
            return;
        }
        if (string.equals("pya")) {
            this.createLcaoLobe(v34, n2, n);
            return;
        }
        if (string.equals("pyb")) {
            this.createLcaoLobe(v34, -n2, n);
            return;
        }
        if (string.equals("spacefill") || string.equals("cpk")) {
            this.createLcaoLobe(null, 2.0f * this.viewer.getAtomRadius(this.atomIndex), n);
            return;
        }
        this.createLcaoLobe(null, 1.0f, n);
    }

    private void createLcaoLobe(V3 v3, float f, int n) {
        this.initState();
        if (Logger.debugging) {
            Logger.debug("creating isosurface ID " + this.thisMesh.thisID);
        }
        if (v3 == null) {
            this.setProperty("sphere", Float.valueOf(f / 2.0f), null);
        } else {
            this.lcaoDir.x = v3.x * f;
            this.lcaoDir.y = v3.y * f;
            this.lcaoDir.z = v3.z * f;
            this.lcaoDir.w = 0.7f;
            this.setProperty(n == 2 ? "lp" : (n == 1 ? "rad" : "lobe"), this.lcaoDir, null);
        }
        this.thisMesh.colix = this.defaultColix;
        this.setScriptInfo(null);
    }

    @Override
    public void invalidateTriangles() {
        this.thisMesh.invalidatePolygons();
    }

    @Override
    public void setOutputStream(JmolDocument jmolDocument, OutputStream outputStream) {
        jmolDocument.setOutputStream(outputStream, this.viewer, this.privateKey);
    }

    @Override
    public void fillMeshData(MeshData meshData, int n, IsosurfaceMesh isosurfaceMesh) {
        if (meshData == null) {
            if (this.thisMesh == null) {
                this.allocMesh(null, null);
            }
            if (!this.thisMesh.isMerged) {
                this.thisMesh.clearType(this.myType, this.sg.getIAddGridPoints());
            }
            this.thisMesh.connections = this.connections;
            this.thisMesh.colix = this.getDefaultColix();
            this.thisMesh.meshColix = this.meshColix;
            if (this.isPhaseColored || this.thisMesh.jvxlData.isBicolorMap) {
                this.thisMesh.isColorSolid = false;
            }
            return;
        }
        if (isosurfaceMesh == null) {
            isosurfaceMesh = this.thisMesh;
        }
        if (isosurfaceMesh == null) {
            return;
        }
        switch (n) {
            case 1: {
                meshData.mergeVertexCount0 = isosurfaceMesh.mergeVertexCount0;
                meshData.vertices = isosurfaceMesh.vertices;
                meshData.vertexSource = isosurfaceMesh.vertexSource;
                meshData.vertexValues = isosurfaceMesh.vertexValues;
                meshData.vertexCount = isosurfaceMesh.vertexCount;
                meshData.vertexIncrement = isosurfaceMesh.vertexIncrement;
                meshData.polygonCount = isosurfaceMesh.polygonCount;
                meshData.polygonIndexes = isosurfaceMesh.polygonIndexes;
                meshData.polygonColixes = isosurfaceMesh.polygonColixes;
                meshData.bsSlabDisplay = isosurfaceMesh.bsSlabDisplay;
                meshData.bsSlabGhost = isosurfaceMesh.bsSlabGhost;
                meshData.slabColix = isosurfaceMesh.slabColix;
                meshData.slabMeshType = isosurfaceMesh.slabMeshType;
                meshData.polygonCount0 = isosurfaceMesh.polygonCount0;
                meshData.vertexCount0 = isosurfaceMesh.vertexCount0;
                meshData.slabOptions = isosurfaceMesh.slabOptions;
                return;
            }
            case 2: {
                if (isosurfaceMesh.vertexColixes == null || isosurfaceMesh.vertexCount > isosurfaceMesh.vertexColixes.length) {
                    isosurfaceMesh.vertexColixes = new short[isosurfaceMesh.vertexCount];
                }
                meshData.vertexColixes = isosurfaceMesh.vertexColixes;
                return;
            }
            case 3: {
                isosurfaceMesh.surfaceSet = meshData.surfaceSet;
                isosurfaceMesh.vertexSets = meshData.vertexSets;
                isosurfaceMesh.nSets = meshData.nSets;
                return;
            }
            case 4: {
                isosurfaceMesh.vertices = meshData.vertices;
                isosurfaceMesh.vertexValues = meshData.vertexValues;
                isosurfaceMesh.vertexCount = meshData.vertexCount;
                isosurfaceMesh.vertexIncrement = meshData.vertexIncrement;
                isosurfaceMesh.vertexSource = meshData.vertexSource;
                isosurfaceMesh.polygonCount = meshData.polygonCount;
                isosurfaceMesh.polygonIndexes = meshData.polygonIndexes;
                isosurfaceMesh.polygonColixes = meshData.polygonColixes;
                isosurfaceMesh.bsSlabDisplay = meshData.bsSlabDisplay;
                isosurfaceMesh.bsSlabGhost = meshData.bsSlabGhost;
                isosurfaceMesh.slabColix = meshData.slabColix;
                isosurfaceMesh.slabMeshType = meshData.slabMeshType;
                isosurfaceMesh.polygonCount0 = meshData.polygonCount0;
                isosurfaceMesh.vertexCount0 = meshData.vertexCount0;
                isosurfaceMesh.mergeVertexCount0 = meshData.mergeVertexCount0;
                isosurfaceMesh.slabOptions = meshData.slabOptions;
                return;
            }
        }
    }

    @Override
    public void notifySurfaceGenerationCompleted() {
        this.setMeshI();
        this.setBsVdw();
        this.thisMesh.insideOut = this.sg.isInsideOut();
        this.thisMesh.vertexSource = this.sg.getVertexSource();
        this.thisMesh.spanningVectors = this.sg.getSpanningVectors();
        this.thisMesh.calculatedArea = null;
        this.thisMesh.calculatedVolume = null;
        Parameters parameters = this.sg.getParams();
        if (!this.thisMesh.isMerged) {
            this.thisMesh.initialize(this.sg.isFullyLit() ? 1073741964 : 1073741958, null, this.sg.getPlane());
        }
        if (!parameters.allowVolumeRender) {
            this.thisMesh.jvxlData.allowVolumeRender = false;
        }
        this.thisMesh.setColorsFromJvxlData(this.sg.getParams().colorRgb);
        if (this.thisMesh.jvxlData.slabInfo != null) {
            this.viewer.runScript("isosurface " + this.thisMesh.jvxlData.slabInfo);
        }
        if (this.sg.getParams().psi_monteCarloCount > 0) {
            this.thisMesh.diameter = -1;
        }
    }

    @Override
    public void notifySurfaceMappingCompleted() {
        if (!this.thisMesh.isMerged) {
            this.thisMesh.initialize(this.sg.isFullyLit() ? 1073741964 : 1073741958, null, this.sg.getPlane());
            this.thisMesh.setJvxlDataRendering();
        }
        this.setBsVdw();
        this.thisMesh.isColorSolid = false;
        this.thisMesh.colorDensity = this.jvxlData.colorDensity;
        this.thisMesh.volumeRenderPointSize = this.jvxlData.pointSize;
        this.thisMesh.colorEncoder = this.sg.getColorEncoder();
        this.thisMesh.getContours();
        if (this.thisMesh.jvxlData.nContours != 0 && this.thisMesh.jvxlData.nContours != -1) {
            this.explicitContours = true;
        }
        if (this.explicitContours && this.thisMesh.jvxlData.jvxlPlane != null) {
            this.thisMesh.havePlanarContours = true;
        }
        this.setPropertySuper("token", this.explicitContours ? 1073742046 : 1073741938, null);
        this.setPropertySuper("token", this.explicitContours ? 0x4000004A : 1073742039, null);
        JmolList<Object[]> jmolList = this.sg.getSlabInfo();
        if (jmolList != null) {
            this.thisMesh.slabPolygonsList(jmolList, false);
            this.thisMesh.reinitializeLightingAndColor(this.viewer);
        }
        this.thisMesh.setColorCommand();
    }

    private void setBsVdw() {
        BS bS = this.sg.geVdwBitSet();
        if (bS == null) {
            return;
        }
        if (this.thisMesh.bsVdw == null) {
            this.thisMesh.bsVdw = new BS();
        }
        this.thisMesh.bsVdw.or(bS);
    }

    @Override
    public P3[] calculateGeodesicSurface(BS bS, float f) {
        return this.viewer.calculateSurface(bS, f);
    }

    @Override
    public int getSurfacePointIndexAndFraction(float f, boolean bl, int n, int n2, int n3, P3i p3i, int n4, int n5, float f2, float f3, P3 p3, V3 v3, boolean bl2, float[] fArray) {
        return 0;
    }

    @Override
    public int addVertexCopy(P3 p3, float f, int n) {
        if (this.cutoffRange != null && (f < this.cutoffRange[0] || f > this.cutoffRange[1])) {
            return -1;
        }
        return this.withinPoints != null && !Mesh.checkWithin(p3, this.withinPoints, this.withinDistance2, this.isWithinNot) ? -1 : this.thisMesh.addVertexCopy(p3, f, n, this.associateNormals);
    }

    @Override
    public int addTriangleCheck(int n, int n2, int n3, int n4, int n5, boolean bl, int n6) {
        return n < 0 || n2 < 0 || n3 < 0 || bl && !MeshData.checkCutoff(n, n2, n3, this.thisMesh.vertexValues) ? -1 : this.thisMesh.addTriangleCheck(n, n2, n3, n4, n5, n6);
    }

    protected void setScriptInfo(String string) {
        int n;
        String string2 = string == null ? this.sg.getScript() : string;
        int n2 = n = string2 == null ? -1 : string2.indexOf("; isosurface map");
        if (n == 0) {
            if (this.thisMesh.scriptCommand == null) {
                return;
            }
            n = this.thisMesh.scriptCommand.indexOf("; isosurface map");
            if (n >= 0) {
                this.thisMesh.scriptCommand = this.thisMesh.scriptCommand.substring(0, n);
            }
            this.thisMesh.scriptCommand = this.thisMesh.scriptCommand + string2;
            return;
        }
        this.thisMesh.title = this.sg.getTitle();
        this.thisMesh.dataType = this.sg.getParams().dataType;
        this.thisMesh.scale3d = this.sg.getParams().scale3d;
        if (string2 != null && string2.charAt(0) == ' ') {
            string2 = this.myType + " ID " + Escape.eS(this.thisMesh.thisID) + string2;
            n = string2.indexOf("; isosurface map");
        }
        this.thisMesh.scriptCommand = n > 0 && this.scriptAppendix.length() > 0 ? string2.substring(0, n) + this.scriptAppendix + string2.substring(n) : string2 + this.scriptAppendix;
        if (!this.explicitID && string2 != null && (n = string2.indexOf("# ID=")) >= 0) {
            this.thisMesh.thisID = Parser.getQuotedStringAt(string2, n);
        }
    }

    @Override
    public void addRequiredFile(String string) {
        string = " # /*file*/\"" + string + "\"";
        if (this.scriptAppendix.indexOf(string) < 0) {
            this.scriptAppendix = this.scriptAppendix + string;
        }
    }

    private void setJvxlInfo() {
        if (this.sg.getJvxlData() != this.jvxlData || this.sg.getJvxlData() != this.thisMesh.jvxlData) {
            this.jvxlData = this.thisMesh.jvxlData = this.sg.getJvxlData();
        }
    }

    @Override
    public JmolList<Map<String, Object>> getShapeDetail() {
        JmolList<Map<String, Object>> jmolList = new JmolList<Map<String, Object>>();
        for (int i = 0; i < this.meshCount; ++i) {
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            IsosurfaceMesh isosurfaceMesh = this.isomeshes[i];
            if (isosurfaceMesh == null || isosurfaceMesh.vertices == null || isosurfaceMesh.vertexCount == 0 && isosurfaceMesh.polygonCount == 0) continue;
            this.addMeshInfo(isosurfaceMesh, hashtable);
            jmolList.addLast((Map<String, Object>)hashtable);
        }
        return jmolList;
    }

    protected void addMeshInfo(IsosurfaceMesh isosurfaceMesh, Map<String, Object> map) {
        map.put("ID", isosurfaceMesh.thisID == null ? "<noid>" : isosurfaceMesh.thisID);
        map.put("visible", isosurfaceMesh.visible);
        map.put("vertexCount", isosurfaceMesh.vertexCount);
        if (isosurfaceMesh.calculatedVolume != null) {
            map.put("volume", isosurfaceMesh.calculatedVolume);
        }
        if (isosurfaceMesh.calculatedArea != null) {
            map.put("area", isosurfaceMesh.calculatedArea);
        }
        if (isosurfaceMesh.ptCenter.x != Float.MAX_VALUE) {
            map.put("center", isosurfaceMesh.ptCenter);
        }
        if (isosurfaceMesh.mat4 != null) {
            map.put("mat4", isosurfaceMesh.mat4);
        }
        if (isosurfaceMesh.scale3d != 0.0f) {
            map.put("scale3d", Float.valueOf(isosurfaceMesh.scale3d));
        }
        map.put("xyzMin", isosurfaceMesh.jvxlData.boundingBox[0]);
        map.put("xyzMax", isosurfaceMesh.jvxlData.boundingBox[1]);
        String string = JvxlCoder.jvxlGetInfo(isosurfaceMesh.jvxlData);
        if (string != null) {
            map.put("jvxlInfo", string.replace('\n', ' '));
        }
        map.put("modelIndex", isosurfaceMesh.modelIndex);
        map.put("color", ColorUtil.colorPointFromInt2(C.getArgb(isosurfaceMesh.colix)));
        if (isosurfaceMesh.colorEncoder != null) {
            map.put("colorKey", isosurfaceMesh.colorEncoder.getColorKey());
        }
        if (isosurfaceMesh.title != null) {
            map.put("title", isosurfaceMesh.title);
        }
        if (isosurfaceMesh.jvxlData.contourValues != null || isosurfaceMesh.jvxlData.contourValuesUsed != null) {
            map.put("contours", isosurfaceMesh.getContourList(this.viewer));
        }
    }

    @Override
    public float[] getPlane(int n) {
        return null;
    }

    @Override
    public float getValue(int n, int n2, int n3, int n4) {
        return 0.0f;
    }

    @Override
    public boolean checkObjectHovered(int n, int n2, BS bS) {
        if (this.keyXy != null && n >= this.keyXy[0] && n2 >= this.keyXy[1] && n < this.keyXy[2] && n2 < this.keyXy[3]) {
            this.hoverKey(n, n2);
            return true;
        }
        if (!this.viewer.getDrawHover()) {
            return false;
        }
        String string = this.findValue(n, n2, false, bS);
        if (string == null) {
            return false;
        }
        if (this.gdata.isDisplayAntialiased()) {
            n <<= 1;
            n2 <<= 1;
        }
        this.viewer.hoverOnPt(n, n2, string, this.pickedMesh.thisID, this.pickedPt);
        return true;
    }

    private void hoverKey(int n, int n2) {
        try {
            String string;
            float f = 1.0f - 1.0f * (float)(n2 - this.keyXy[1]) / (float)(this.keyXy[3] - this.keyXy[1]);
            if (this.thisMesh.showContourLines) {
                JmolList<Object>[] jmolListArray = this.thisMesh.getContours();
                if (jmolListArray == null) {
                    if (this.thisMesh.jvxlData.contourValues == null) {
                        return;
                    }
                    int n3 = (int)Math.floor(f * (float)this.thisMesh.jvxlData.contourValues.length);
                    if (n3 < 0 || n3 > this.thisMesh.jvxlData.contourValues.length) {
                        return;
                    }
                    string = "" + this.thisMesh.jvxlData.contourValues[n3];
                } else {
                    int n4 = (int)Math.floor(f * (float)jmolListArray.length);
                    if (n4 < 0 || n4 > jmolListArray.length) {
                        return;
                    }
                    string = "" + ((Float)jmolListArray[n4].get(2)).floatValue();
                }
            } else {
                float f2 = this.thisMesh.colorEncoder.quantize(f, true);
                f = this.thisMesh.colorEncoder.quantize(f, false);
                string = "" + f2 + " - " + f;
            }
            if (this.gdata.isAntialiased()) {
                n <<= 1;
                n2 <<= 1;
            }
            this.viewer.hoverOnPt(n, n2, string, null, null);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public Map<String, Object> checkObjectClicked(int n, int n2, int n3, BS bS, boolean bl) {
        Object object;
        int n4;
        if (!bl) {
            return null;
        }
        if (!this.viewer.isBound(n3, 18)) {
            return null;
        }
        int n5 = 100;
        if (this.gdata.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n5 <<= 1;
        }
        int n6 = -1;
        int n7 = -1;
        int n8 = -1;
        int n9 = Integer.MIN_VALUE;
        int n10 = Integer.MAX_VALUE;
        boolean bl2 = true;
        for (n4 = 0; n4 < this.meshCount; ++n4) {
            P3[] p3Array;
            object = this.isomeshes[n4];
            if (!this.isPickable((IsosurfaceMesh)object, bS)) continue;
            P3[] p3Array2 = p3Array = bl2 ? ((IsosurfaceMesh)object).vertices : ((IsosurfaceMesh)object).getCenters();
            if (p3Array == null) continue;
            int n11 = p3Array.length;
            while (--n11 >= 0) {
                int n12;
                P3 p3 = p3Array[n11];
                if (p3 == null || (n12 = this.coordinateInRange(n, n2, p3, n5, this.ptXY)) < 0) continue;
                if (this.ptXY.z < n10) {
                    if (bl2) {
                        n6 = n4;
                    }
                    n10 = this.ptXY.z;
                    n8 = n11;
                }
                if (this.ptXY.z <= n9) continue;
                if (!bl2) {
                    n6 = n4;
                }
                n9 = this.ptXY.z;
                n7 = n11;
            }
        }
        if (n6 < 0) {
            return null;
        }
        this.pickedMesh = this.isomeshes[n6];
        this.setPropertySuper("thisID", this.pickedMesh.thisID, null);
        this.pickedVertex = bl2 ? n8 : n7;
        n4 = this.pickedVertex;
        object = new P3();
        ((Tuple3f)object).setT(bl2 ? this.pickedMesh.vertices[this.pickedVertex] : ((IsosurfaceMesh)this.pickedMesh).centers[n4]);
        this.pickedModel = (short)this.pickedMesh.modelIndex;
        this.setStatusPicked(-4, (P3)object);
        return this.getPickedPoint((P3)object, this.pickedModel);
    }

    private boolean isPickable(IsosurfaceMesh isosurfaceMesh, BS bS) {
        return isosurfaceMesh.visibilityFlags != 0 && (isosurfaceMesh.modelIndex < 0 || bS.get(isosurfaceMesh.modelIndex)) && !C.isColixTranslucent(isosurfaceMesh.colix);
    }

    private String findValue(int n, int n2, boolean bl, BS bS) {
        int n3 = 100;
        if (this.gdata.isAntialiased()) {
            n <<= 1;
            n2 <<= 1;
            n3 <<= 1;
        }
        int n4 = -1;
        JmolList<Object> jmolList = null;
        IsosurfaceMesh isosurfaceMesh = null;
        for (int i = 0; i < this.meshCount; ++i) {
            int n5;
            int n6;
            int n7;
            isosurfaceMesh = this.isomeshes[i];
            if (!this.isPickable(isosurfaceMesh, bS)) continue;
            JmolList<Object>[] jmolListArray = isosurfaceMesh.jvxlData.vContours;
            int n8 = isosurfaceMesh.firstRealVertex < 0 ? 0 : isosurfaceMesh.firstRealVertex;
            int n9 = 0;
            if (jmolListArray != null && jmolListArray.length > 0) {
                for (n7 = 0; n7 < jmolListArray.length; ++n7) {
                    JmolList<Object> jmolList2 = jmolListArray[n7];
                    n6 = jmolList2.size() - 1;
                    for (n5 = 6; n5 < n6; ++n5) {
                        P3 p3 = (P3)jmolList2.get(n5);
                        int n10 = this.coordinateInRange(n, n2, p3, n3, this.ptXY);
                        if (n10 < 0) continue;
                        n3 = n10;
                        jmolList = jmolList2;
                        n9 = n7;
                        this.pickedMesh = isosurfaceMesh;
                        this.pickedPt = p3;
                    }
                }
                if (jmolList == null) continue;
                return jmolList.get(2).toString() + (Logger.debugging ? " " + n9 : "");
            }
            if (isosurfaceMesh.jvxlData.jvxlPlane != null && isosurfaceMesh.vertexValues != null) {
                P3[] p3Array = isosurfaceMesh.mat4 == null && isosurfaceMesh.scale3d == 0.0f ? isosurfaceMesh.vertices : isosurfaceMesh.getOffsetVertices(isosurfaceMesh.jvxlData.jvxlPlane);
                int n11 = isosurfaceMesh.vertexCount;
                while (--n11 >= n8) {
                    P3 p3 = p3Array[n11];
                    n5 = this.coordinateInRange(n, n2, p3, n3, this.ptXY);
                    if (n5 < 0) continue;
                    n3 = n5;
                    n4 = n11;
                    this.pickedMesh = isosurfaceMesh;
                    this.pickedPt = p3;
                }
                if (n4 == -1) continue;
                break;
            }
            if (isosurfaceMesh.vertexValues == null) continue;
            n7 = isosurfaceMesh.vertexCount;
            while (--n7 >= n8) {
                P3 p3 = isosurfaceMesh.vertices[n7];
                n6 = this.coordinateInRange(n, n2, p3, n3, this.ptXY);
                if (n6 < 0) continue;
                n3 = n6;
                n4 = n7;
                this.pickedMesh = isosurfaceMesh;
                this.pickedPt = p3;
            }
            if (n4 != -1) break;
        }
        return n4 == -1 ? null : (Logger.debugging ? "$" + isosurfaceMesh.thisID + "[" + (n4 + 1) + "] " + isosurfaceMesh.vertices[n4] + ": " : isosurfaceMesh.thisID + ": ") + isosurfaceMesh.vertexValues[n4];
    }

    @Override
    public void merge(Shape shape) {
        super.merge(shape);
    }

    public String getCmd(int n) {
        SB sB = new SB().append("\n");
        this.getMeshCommand(sB, n);
        return sB.toString();
    }
}

