/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import org.jmol.shape.Mesh;
import org.jmol.shapespecial.Draw;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.P3;
import org.jmol.util.V3;

public class DrawMesh
extends Mesh {
    public BS modelFlags;
    public Draw.EnumDrawType drawType = Draw.EnumDrawType.NONE;
    Draw.EnumDrawType[] drawTypes;
    P3[] ptCenters;
    V3 axis = V3.new3(1.0f, 0.0f, 0.0f);
    V3[] axes;
    int drawVertexCount;
    int[] drawVertexCounts;
    boolean isFixed;
    public boolean isVector;
    public float drawArrowScale;
    public boolean noHead;
    public boolean isBarb;
    public float scale = 1.0f;
    public boolean isScaleSet;
    public BS bsMeshesVisible = new BS();

    public DrawMesh(String string, short s, int n) {
        this.mesh1(string, s, n);
    }

    public void clear(String string) {
        this.clearMesh(string);
        this.scale = 1.0f;
        this.isScaleSet = false;
    }

    void setCenters() {
        if (this.ptCenters == null) {
            this.setCenter(-1);
        } else {
            int n = this.ptCenters.length;
            while (--n >= 0) {
                this.setCenter(n);
            }
        }
    }

    final void setCenter(int n) {
        P3 p3 = P3.new3(0.0f, 0.0f, 0.0f);
        int n2 = -1;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.polygonCount;
        while (--n5 >= 0) {
            int n6;
            if (n >= 0 && n5 != n || this.polygonIndexes[n5] == null) continue;
            n2 = -1;
            int n7 = n6 = this.drawType == Draw.EnumDrawType.POLYGON ? 3 : this.polygonIndexes[n5].length;
            while (--n6 >= 0) {
                n3 = this.polygonIndexes[n5][n6];
                if (n3 == n2) continue;
                n2 = n3;
                p3.add(this.vertices[n3]);
                ++n4;
            }
            if (n4 <= 0 || n5 != n && n5 != 0) continue;
            p3.scale(1.0f / (float)n4);
            if (this.mat4 == null) break;
            this.mat4.transform(p3);
            break;
        }
        if (n < 0) {
            this.ptCenter.setT(p3);
        } else {
            this.ptCenters[n] = p3;
        }
    }

    void offset(V3 v3) {
        this.rotateTranslate(null, v3, false);
        this.setCenters();
    }

    public void deleteAtoms(int n) {
        if (n >= this.polygonCount) {
            return;
        }
        --this.polygonCount;
        this.polygonIndexes = (int[][])ArrayUtil.deleteElements(this.polygonIndexes, n, 1);
        this.drawTypes = (Draw.EnumDrawType[])ArrayUtil.deleteElements(this.drawTypes, n, 1);
        this.drawVertexCounts = (int[])ArrayUtil.deleteElements(this.drawVertexCounts, n, 1);
        this.ptCenters = (P3[])ArrayUtil.deleteElements(this.ptCenters, n, 1);
        this.axes = (V3[])ArrayUtil.deleteElements(this.axes, n, 1);
        BS bS = BSUtil.newAndSetBit(n);
        BSUtil.deleteBits(this.modelFlags, bS);
    }

    public boolean isRenderScalable() {
        switch (this.drawType) {
            case ARROW: {
                return this.connections != null;
            }
            case ARC: 
            case CIRCLE: 
            case CIRCULARPLANE: {
                return true;
            }
        }
        return this.haveXyPoints;
    }
}

