/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import org.jmol.modelset.Atom;
import org.jmol.quantum.MepCalculation;
import org.jmol.util.BS;
import org.jmol.util.Logger;

public class MlpCalculation
extends MepCalculation {
    public MlpCalculation() {
        this.distanceMode = 3;
    }

    public void assignPotentials(Atom[] atomArray, float[] fArray, BS bS, BS bS2, BS bS3, String string) {
        this.getAtomicPotentials(string, "atomicLipophilicity.txt");
        for (int i = 0; i < atomArray.length; ++i) {
            float f = Math.abs(atomArray[i].getFormalCharge());
            if (f == 0.0f) {
                if (bS3 != null && bS3.get(i)) {
                    f = Float.NaN;
                } else {
                    f = this.getTabulatedPotential(atomArray[i]);
                    if (Float.isNaN(f)) {
                        switch (atomArray[i].getElementNumber()) {
                            case 6: {
                                f = bS.get(i) ? 0.31f : (bS2.get(i) ? -0.54f : 0.45f);
                                break;
                            }
                            case 7: {
                                f = bS.get(i) ? -0.6f : (bS2.get(i) ? -0.44f : -1.0f);
                                break;
                            }
                            case 8: {
                                f = bS2.get(i) ? -0.9f : -0.17f;
                                break;
                            }
                            default: {
                                f = Float.NaN;
                            }
                        }
                    }
                }
            }
            if (Logger.debugging) {
                Logger.debug(atomArray[i].getInfo() + " " + f);
            }
            fArray[i] = f;
        }
    }
}

