/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelset;

import java.util.Map;
import org.jmol.atomdata.RadiusData;
import org.jmol.constant.EnumVdw;
import org.jmol.modelset.Atom;
import org.jmol.modelset.LabelToken;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Text;
import org.jmol.modelset.TickInfo;
import org.jmol.util.AxisAngle4f;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Measure;
import org.jmol.util.P3;
import org.jmol.util.Point3fi;
import org.jmol.util.SB;
import org.jmol.util.V3;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Measurement {
    public String thisID;
    public ModelSet modelSet;
    public int index;
    public boolean isVisible = true;
    public boolean isHidden = false;
    public boolean isDynamic = false;
    public boolean isTrajectory = false;
    public boolean isValid = true;
    public short colix;
    public short labelColix = (short)-1;
    public int mad;
    public TickInfo tickInfo;
    public int traceX = Integer.MIN_VALUE;
    public int traceY;
    protected int count;
    protected int[] countPlusIndices = new int[5];
    protected Point3fi[] pts;
    protected float value;
    public String strFormat;
    private Viewer viewer;
    private String strMeasurement;
    private AxisAngle4f aa;
    private P3 pointArc;
    public Text text;
    private String type;
    public static final int NMR_NOT = 0;
    public static final int NMR_DC = 1;
    public static final int NMR_JC = 2;

    public Measurement setM(ModelSet modelSet, Measurement measurement, float f, short s, String string, int n) {
        this.modelSet = modelSet;
        this.index = n;
        this.viewer = modelSet.viewer;
        this.colix = s;
        this.strFormat = string;
        if (measurement != null) {
            this.tickInfo = measurement.tickInfo;
            this.pts = measurement.pts;
            this.mad = measurement.mad;
            this.thisID = measurement.thisID;
            this.text = measurement.text;
            if (this.thisID != null && this.text != null) {
                this.labelColix = this.text.colix;
            }
        }
        if (this.pts == null) {
            this.pts = new Point3fi[4];
        }
        int[] nArray = measurement == null ? null : measurement.countPlusIndices;
        int n2 = this.count = nArray == null ? 0 : nArray[0];
        if (this.count > 0) {
            System.arraycopy(nArray, 0, this.countPlusIndices, 0, this.count + 1);
            this.isTrajectory = modelSet.isTrajectoryMeasurement(this.countPlusIndices);
        }
        this.value = Float.isNaN(f) || this.isTrajectory ? this.getMeasurement() : f;
        this.formatMeasurement(null);
        return this;
    }

    public Measurement setPoints(ModelSet modelSet, int[] nArray, Point3fi[] point3fiArray, TickInfo tickInfo) {
        this.modelSet = modelSet;
        this.countPlusIndices = nArray;
        this.count = nArray[0];
        this.pts = point3fiArray == null ? new Point3fi[4] : point3fiArray;
        this.viewer = modelSet.viewer;
        this.tickInfo = tickInfo;
        return this;
    }

    public int getCount() {
        return this.count;
    }

    public void setCount(int n) {
        this.setCountM(n);
    }

    protected void setCountM(int n) {
        this.count = this.countPlusIndices[0] = n;
    }

    public int[] getCountPlusIndices() {
        return this.countPlusIndices;
    }

    public Point3fi[] getPoints() {
        return this.pts;
    }

    public int getAtomIndex(int n) {
        return n > 0 && n <= this.count ? this.countPlusIndices[n] : -1;
    }

    public Point3fi getAtom(int n) {
        int n2 = this.countPlusIndices[n];
        return n2 < -1 ? this.pts[-2 - n2] : this.modelSet.atoms[n2];
    }

    public int getLastIndex() {
        return this.count > 0 ? this.countPlusIndices[this.count] : -1;
    }

    public String getString() {
        return this.strMeasurement;
    }

    public String getStringUsing(Viewer viewer, String string, String string2) {
        this.viewer = viewer;
        this.value = this.getMeasurement();
        this.formatMeasurementAs(string, string2, true);
        if (string == null) {
            return this.getInfoAsString(string2);
        }
        return this.strMeasurement;
    }

    public String getStringDetail() {
        return (this.count == 2 ? "Distance" : (this.count == 3 ? "Angle" : "Torsion")) + this.getMeasurementScript(" - ", false) + " : " + this.value;
    }

    public String getStrFormat() {
        return this.strFormat;
    }

    public float getValue() {
        return this.value;
    }

    public AxisAngle4f getAxisAngle() {
        return this.aa;
    }

    public P3 getPointArc() {
        return this.pointArc;
    }

    public void refresh() {
        this.value = this.getMeasurement();
        this.isTrajectory = this.modelSet.isTrajectoryMeasurement(this.countPlusIndices);
        this.formatMeasurement(null);
    }

    public String getMeasurementScript(String string, boolean bl) {
        String string2 = "";
        boolean bl2 = string.equals(" ");
        for (int i = 1; i <= this.count; ++i) {
            string2 = string2 + (i > 1 ? string : " ") + this.getLabel(i, bl2, bl);
        }
        return string2;
    }

    public void formatMeasurementAs(String string, String string2, boolean bl) {
        if (string != null && string.length() == 0) {
            string = null;
        }
        if (!bl && string != null && string.indexOf(this.countPlusIndices[0] + ":") != 0) {
            return;
        }
        this.strFormat = string;
        this.formatMeasurement(string2);
    }

    protected void formatMeasurement(String string) {
        this.strMeasurement = null;
        if (Float.isNaN(this.value) || this.count == 0) {
            return;
        }
        switch (this.count) {
            case 2: {
                this.strMeasurement = this.formatDistance(string);
                return;
            }
            case 3: {
                if (this.value == 180.0f) {
                    this.aa = null;
                    this.pointArc = null;
                } else {
                    V3 v3 = new V3();
                    V3 v32 = new V3();
                    float f = Measure.computeAngle(this.getAtom(1), this.getAtom(2), this.getAtom(3), v3, v32, false);
                    V3 v33 = new V3();
                    v33.cross(v3, v32);
                    this.aa = AxisAngle4f.new4(v33.x, v33.y, v33.z, f);
                    v3.normalize();
                    v3.scale(0.5f);
                    this.pointArc = P3.newP(v3);
                }
            }
            case 4: {
                this.strMeasurement = this.formatAngle(this.value);
                return;
            }
        }
    }

    public void reformatDistanceIfSelected() {
        if (this.count != 2) {
            return;
        }
        if (this.viewer.isSelected(this.countPlusIndices[1]) && this.viewer.isSelected(this.countPlusIndices[2])) {
            this.formatMeasurement(null);
        }
    }

    private String formatDistance(String string) {
        int n;
        String string2 = this.getLabelString();
        if (string2 == null) {
            return "";
        }
        if (string == null) {
            n = this.strFormat.indexOf("//");
            String string3 = string = n >= 0 ? this.strFormat.substring(n + 2) : null;
            if (string == null) {
                string = this.viewer.getMeasureDistanceUnits();
                this.strFormat = this.strFormat + "//" + string;
            }
        }
        string = Measurement.fixUnits(string);
        n = string2.indexOf("//");
        if (n >= 0 && (string2 = string2.substring(0, n)).length() == 0) {
            string2 = "%VALUE";
        }
        float f = this.fixValue(string, string2.indexOf("%V") >= 0);
        return this.formatString(f, string, string2);
    }

    private static String fixUnits(String string) {
        if (string.equals("nanometers")) {
            return "nm";
        }
        if (string.equals("picometers")) {
            return "pm";
        }
        if (string.equals("angstroms")) {
            return "\u00c5";
        }
        if (string.equals("vanderwaals") || string.equals("vdw")) {
            return "%";
        }
        return string;
    }

    public float fixValue(String string, boolean bl) {
        if (this.count != 2) {
            return this.value;
        }
        float f = this.value;
        if (string != null) {
            boolean bl2 = string.equals("%");
            if (bl2 || string.endsWith("hz")) {
                int n = this.getAtomIndex(1);
                int n2 = this.getAtomIndex(2);
                if (n >= 0 && n2 >= 0) {
                    boolean bl3;
                    Atom atom = (Atom)this.getAtom(1);
                    Atom atom2 = (Atom)this.getAtom(2);
                    boolean bl4 = bl3 = !bl2 && Measurement.nmrType(string) == 1;
                    String string2 = bl2 ? "percent" : (this.type = bl3 ? "dipoleCouplingConstant" : "J-CouplingConstant");
                    f = bl2 ? f / (atom.getVanderwaalsRadiusFloat(this.viewer, EnumVdw.AUTO) + atom2.getVanderwaalsRadiusFloat(this.viewer, EnumVdw.AUTO)) : (bl3 ? this.viewer.getNMRCalculation().getDipolarConstantHz(atom, atom2) : this.viewer.getNMRCalculation().getIsoOrAnisoHz(true, atom, atom2, string, null));
                    boolean bl5 = this.isValid = !Float.isNaN(f);
                    if (bl2) {
                        string = "pm";
                    }
                }
            }
            if (string.equals("nm")) {
                return bl ? (float)Math.round(f * 100.0f) / 1000.0f : f / 10.0f;
            }
            if (string.equals("pm")) {
                return bl ? (float)Math.round(f * 1000.0f) / 10.0f : f * 100.0f;
            }
            if (string.equals("au")) {
                return bl ? (float)Math.round(f / 0.5291772f * 1000.0f) / 1000.0f : f / 0.5291772f;
            }
            if (string.endsWith("khz")) {
                return bl ? (float)Math.round(f / 10.0f) / 100.0f : f / 1000.0f;
            }
        }
        return bl ? (float)Math.round(f * 100.0f) / 100.0f : f;
    }

    public static int nmrType(String string) {
        return string.indexOf("hz") < 0 ? 0 : (string.startsWith("dc_") || string.equals("khz") ? 1 : 2);
    }

    private String formatAngle(float f) {
        String string = this.getLabelString();
        if (string.indexOf("%V") >= 0) {
            f = (float)Math.round(f * 10.0f) / 10.0f;
        }
        return this.formatString(f, "\u00b0", string);
    }

    private String getLabelString() {
        String string = this.countPlusIndices[0] + ":";
        String string2 = null;
        if (this.strFormat != null) {
            if (this.strFormat.length() == 0) {
                return null;
            }
            String string3 = string2 = this.strFormat.length() > 2 && this.strFormat.indexOf(string) == 0 ? this.strFormat : null;
        }
        if (string2 == null) {
            this.strFormat = null;
            string2 = this.viewer.getDefaultMeasurementLabel(this.countPlusIndices[0]);
        }
        if (string2.indexOf(string) == 0) {
            string2 = string2.substring(2);
        }
        if (this.strFormat == null) {
            this.strFormat = string + string2;
        }
        return string2;
    }

    private String formatString(float f, String string, String string2) {
        return LabelToken.formatLabelMeasure(this.viewer, this, string2, f, string);
    }

    public boolean sameAsPoints(int[] nArray, Point3fi[] point3fiArray) {
        int n;
        if (this.count != nArray[0]) {
            return false;
        }
        boolean bl = true;
        for (n = 1; n <= this.count && bl; ++n) {
            bl = this.countPlusIndices[n] == nArray[n];
        }
        if (bl) {
            for (n = 0; n < this.count && bl; ++n) {
                if (point3fiArray[n] == null) continue;
                bl = (double)this.pts[n].distance(point3fiArray[n]) < 0.01;
            }
        }
        if (bl) {
            return true;
        }
        switch (this.count) {
            default: {
                return true;
            }
            case 2: {
                return this.sameAsIJ(nArray, point3fiArray, 1, 2) && this.sameAsIJ(nArray, point3fiArray, 2, 1);
            }
            case 3: {
                return this.sameAsIJ(nArray, point3fiArray, 1, 3) && this.sameAsIJ(nArray, point3fiArray, 2, 2) && this.sameAsIJ(nArray, point3fiArray, 3, 1);
            }
            case 4: 
        }
        return this.sameAsIJ(nArray, point3fiArray, 1, 4) && this.sameAsIJ(nArray, point3fiArray, 2, 3) && this.sameAsIJ(nArray, point3fiArray, 3, 2) && this.sameAsIJ(nArray, point3fiArray, 4, 1);
    }

    private boolean sameAsIJ(int[] nArray, Point3fi[] point3fiArray, int n, int n2) {
        int n3 = this.countPlusIndices[n];
        int n4 = nArray[n2];
        return n3 >= 0 || n4 >= 0 ? n3 == n4 : (double)this.pts[-2 - n3].distance(point3fiArray[-2 - n4]) < 0.01;
    }

    public boolean sameAs(int n, int n2) {
        return this.sameAsIJ(this.countPlusIndices, this.pts, n, n2);
    }

    public JmolList<String> toVector(boolean bl) {
        JmolList<String> jmolList = new JmolList<String>();
        for (int i = 1; i <= this.count; ++i) {
            jmolList.addLast(this.getLabel(i, bl, false));
        }
        jmolList.addLast(this.strMeasurement);
        return jmolList;
    }

    public float getMeasurement() {
        if (this.countPlusIndices == null) {
            return Float.NaN;
        }
        if (this.count < 2) {
            return Float.NaN;
        }
        int n = this.count;
        while (--n >= 0) {
            if (this.countPlusIndices[n + 1] != -1) continue;
            return Float.NaN;
        }
        Point3fi point3fi = this.getAtom(1);
        Point3fi point3fi2 = this.getAtom(2);
        switch (this.count) {
            case 2: {
                return point3fi.distance(point3fi2);
            }
            case 3: {
                Point3fi point3fi3 = this.getAtom(3);
                return Measure.computeAngleABC(point3fi, point3fi2, point3fi3, true);
            }
            case 4: {
                Point3fi point3fi4 = this.getAtom(3);
                Point3fi point3fi5 = this.getAtom(4);
                return Measure.computeTorsion(point3fi, point3fi2, point3fi4, point3fi5, true);
            }
        }
        return Float.NaN;
    }

    public String getLabel(int n, boolean bl, boolean bl2) {
        int n2 = this.countPlusIndices[n];
        return n2 < 0 ? (bl2 ? "modelIndex " + this.getAtom((int)n).modelIndex + " " : "") + Escape.eP(this.getAtom(n)) : (bl ? "(({" + n2 + "}))" : this.viewer.getAtomInfo(n2));
    }

    public void setModelIndex(short s) {
        if (this.pts == null) {
            return;
        }
        for (int i = 0; i < this.count; ++i) {
            if (this.pts[i] == null) continue;
            this.pts[i].modelIndex = s;
        }
    }

    public boolean isValid() {
        return !(this.sameAs(1, 2) || this.count > 2 && this.sameAs(1, 3) || this.count == 4 && this.sameAs(2, 4));
    }

    public static int find(JmolList<Measurement> jmolList, Measurement measurement) {
        int[] nArray = measurement.getCountPlusIndices();
        Point3fi[] point3fiArray = measurement.getPoints();
        int n = jmolList.size();
        while (--n >= 0) {
            if (!((Measurement)jmolList.get(n)).sameAsPoints(nArray, point3fiArray)) continue;
            return n;
        }
        return -1;
    }

    public boolean isConnected(Atom[] atomArray, int n) {
        int n2 = -1;
        for (int i = 1; i <= n; ++i) {
            int n3 = this.getAtomIndex(i);
            if (n3 < 0) continue;
            if (n2 >= 0 && !atomArray[n3].isBonded(atomArray[n2])) {
                return false;
            }
            n2 = n3;
        }
        return true;
    }

    public String getInfoAsString(String string) {
        float f = this.fixValue(string, true);
        SB sB = new SB();
        sB.append(this.count == 2 ? (this.type == null ? "distance" : this.type) : (this.count == 3 ? "angle" : "dihedral"));
        sB.append(" \t").appendF(f);
        sB.append(" \t").append(Escape.eS(this.strMeasurement));
        for (int i = 1; i <= this.count; ++i) {
            sB.append(" \t").append(this.getLabel(i, false, false));
        }
        if (this.thisID != null) {
            sB.append(" \t").append(this.thisID);
        }
        return sB.toString();
    }

    public boolean isInRange(RadiusData radiusData, float f) {
        if (radiusData.factorType == RadiusData.EnumType.FACTOR) {
            Atom atom = (Atom)this.getAtom(1);
            Atom atom2 = (Atom)this.getAtom(2);
            float f2 = (atom.getVanderwaalsRadiusFloat(this.viewer, radiusData.vdwType) + atom2.getVanderwaalsRadiusFloat(this.viewer, radiusData.vdwType)) * radiusData.value;
            return f <= f2;
        }
        return radiusData.values[0] == Float.MAX_VALUE || f >= radiusData.values[0] && f <= radiusData.values[1];
    }

    public boolean isIntramolecular(Atom[] atomArray, int n) {
        int n2 = -1;
        for (int i = 1; i <= n; ++i) {
            int n3 = this.getAtomIndex(i);
            if (n3 < 0) continue;
            int n4 = atomArray[n3].getMoleculeNumber(false);
            if (n2 < 0) {
                n2 = n4;
                continue;
            }
            if (n4 == n2) continue;
            return false;
        }
        return true;
    }

    public boolean isMin(Map<String, Integer> map) {
        String string;
        Atom atom = (Atom)this.getAtom(1);
        Atom atom2 = (Atom)this.getAtom(2);
        int n = (int)(atom2.distanceSquared(atom) * 100.0f);
        String string2 = atom.getAtomName();
        String string3 = string2.compareTo(string = atom2.getAtomName()) < 0 ? string2 + string : string + string2;
        Integer n2 = map.get(string3);
        return n2 != null && n == n2;
    }
}

