/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io2;

import org.jmol.io2.CompoundDocument;
import org.jmol.util.Logger;

class CompoundDocHeader {
    private final CompoundDocument cd;
    byte[] magicNumbers = new byte[8];
    byte[] uniqueID16 = new byte[16];
    byte revNumber;
    byte verNumber;
    short sectorPower;
    short shortSectorPower;
    byte[] unused = new byte[10];
    int nSATsectors;
    int SID_DIR_start;
    int minBytesStandardStream;
    int SID_SSAT_start;
    int nSSATsectors;
    int SID_MSAT_next;
    int nAdditionalMATsectors;
    int[] MSAT0 = new int[109];

    CompoundDocHeader(CompoundDocument compoundDocument) {
        this.cd = compoundDocument;
    }

    final boolean readData() {
        try {
            this.cd.readByteArray(this.magicNumbers, 0, 8);
            if (this.magicNumbers[0] != -48 || this.magicNumbers[1] != -49 || this.magicNumbers[2] != 17 || this.magicNumbers[3] != -32 || this.magicNumbers[4] != -95 || this.magicNumbers[5] != -79 || this.magicNumbers[6] != 26 || this.magicNumbers[7] != -31) {
                return false;
            }
            this.cd.readByteArray(this.uniqueID16, 0, 16);
            this.revNumber = this.cd.readByte();
            this.cd.readByte();
            this.verNumber = this.cd.readByte();
            this.cd.readByte();
            byte by = this.cd.readByte();
            byte by2 = this.cd.readByte();
            this.cd.isBigEndian = by == -1 && by2 == -2;
            this.sectorPower = this.cd.readShort();
            this.shortSectorPower = this.cd.readShort();
            this.cd.readByteArray(this.unused, 0, 10);
            this.nSATsectors = this.cd.readInt();
            this.SID_DIR_start = this.cd.readInt();
            this.cd.readByteArray(this.unused, 0, 4);
            this.minBytesStandardStream = this.cd.readInt();
            this.SID_SSAT_start = this.cd.readInt();
            this.nSSATsectors = this.cd.readInt();
            this.SID_MSAT_next = this.cd.readInt();
            this.nAdditionalMATsectors = this.cd.readInt();
            for (int i = 0; i < 109; ++i) {
                this.MSAT0[i] = this.cd.readInt();
            }
        }
        catch (Exception exception) {
            Logger.errorEx(null, exception);
            return false;
        }
        return true;
    }
}

