/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.export.dialog;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Map;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import org.jmol.api.JmolViewer;
import org.jmol.i18n.GT;
import org.jmol.util.TextFormat;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FilePreview
extends JPanel
implements PropertyChangeListener {
    JCheckBox active;
    JCheckBox append;
    JCheckBox cartoons;
    JFileChooser chooser;
    private static boolean pdbCartoonChecked = true;
    private FPPanel display;
    JmolViewer viewer;

    public FilePreview(JmolViewer jmolViewer, JFileChooser jFileChooser, boolean bl, Map<String, Object> map) {
        this.viewer = jmolViewer;
        this.chooser = jFileChooser;
        Box box = Box.createVerticalBox();
        final JmolViewer jmolViewer2 = jmolViewer;
        this.active = new JCheckBox(GT._("Preview"), false);
        this.active.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (FilePreview.this.active.isSelected()) {
                    FilePreview.this.updatePreview(jmolViewer2, FilePreview.this.chooser.getSelectedFile());
                } else {
                    FilePreview.this.updatePreview(null, null);
                }
            }
        });
        box.add(this.active);
        this.display = new FPPanel(map);
        this.display.setPreferredSize(new Dimension(80, 80));
        this.display.setMinimumSize(new Dimension(50, 50));
        box.add(this.display);
        if (bl) {
            this.append = new JCheckBox(GT._("Append models"), false);
            box.add(this.append);
            this.cartoons = new JCheckBox(GT._("PDB cartoons"), pdbCartoonChecked);
            this.cartoons.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (FilePreview.this.active.isSelected()) {
                        FilePreview.this.updatePreview(jmolViewer2, FilePreview.this.chooser.getSelectedFile());
                    }
                }
            });
            box.add(this.cartoons);
        }
        this.add(box);
        jFileChooser.setAccessory(this);
        jFileChooser.addPropertyChangeListener(this);
    }

    public boolean isAppendSelected() {
        return this.append != null && this.append.isSelected();
    }

    public boolean isCartoonsSelected() {
        pdbCartoonChecked = this.cartoons != null && this.cartoons.isSelected();
        return pdbCartoonChecked;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string;
        if (this.active.isSelected() && "SelectedFileChangedProperty".equals(string = propertyChangeEvent.getPropertyName())) {
            this.updatePreview(this.viewer, (File)propertyChangeEvent.getNewValue());
        }
    }

    void updatePreview(JmolViewer jmolViewer, File file) {
        String string;
        if (file == null) {
            string = "zap";
        } else {
            String string2 = file.getAbsolutePath();
            String string3 = FileManager.getLocalUrl(jmolViewer.apiPlatform.newFile(string2));
            if (string3 != null) {
                string2 = string3;
            }
            string = " \"" + string2 + "\"";
            if (string2.indexOf(".spt") >= 0) {
                string = "script " + string;
            } else {
                string = TextFormat.simpleReplace((String)this.display.getViewer().getParameter("defaultdropscript"), "%FILE", string + " 1");
                string = TextFormat.simpleReplace(string, "%ALLOWCARTOONS", "" + this.isCartoonsSelected());
            }
        }
        this.display.getViewer().evalStringQuiet(string);
    }

    public void setPreviewOptions(boolean bl) {
        if (this.append == null) {
            return;
        }
        this.append.setVisible(bl);
        this.cartoons.setVisible(bl);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FPPanel
    extends JPanel {
        JmolViewer viewer;
        final Dimension currentSize = new Dimension();

        FPPanel(Map<String, Object> map) {
            map.put("previewOnly", Boolean.TRUE);
            Object object = map.get("display");
            map.put("display", this);
            this.viewer = new Viewer(map);
            map.put("display", object);
        }

        public JmolViewer getViewer() {
            return this.viewer;
        }

        @Override
        public void paint(Graphics graphics) {
            this.getSize(this.currentSize);
            this.viewer.setScreenDimension(this.currentSize.width, this.currentSize.height);
            Rectangle rectangle = new Rectangle();
            graphics.getClipBounds(rectangle);
            this.viewer.renderScreenImage((Object)graphics, this.currentSize.width, this.currentSize.height);
        }
    }
}

