/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolAdapterStructureIterator;
import org.jmol.constant.EnumStructure;
import org.jmol.util.BS;

public class StructureIterator
extends JmolAdapterStructureIterator {
    private int structureCount;
    private Structure[] structures;
    private Structure structure;
    private int istructure;
    private BS bsModelsDefined;

    StructureIterator(AtomSetCollection atomSetCollection) {
        this.structureCount = atomSetCollection.getStructureCount();
        this.structures = atomSetCollection.getStructures();
        this.istructure = 0;
        this.bsModelsDefined = atomSetCollection.bsStructuredModels;
    }

    public boolean hasNext() {
        if (this.istructure == this.structureCount) {
            return false;
        }
        this.structure = this.structures[this.istructure++];
        return true;
    }

    public EnumStructure getStructureType() {
        return this.structure.structureType;
    }

    public EnumStructure getSubstructureType() {
        return this.structure.substructureType;
    }

    public String getStructureID() {
        return this.structure.structureID;
    }

    public int getSerialID() {
        return this.structure.serialID;
    }

    public int getStartChainID() {
        return this.structure.startChainID;
    }

    public int getStartSequenceNumber() {
        return this.structure.startSequenceNumber;
    }

    public char getStartInsertionCode() {
        return JmolAdapter.canonizeInsertionCode(this.structure.startInsertionCode);
    }

    public int getEndChainID() {
        return this.structure.endChainID;
    }

    public int getEndSequenceNumber() {
        return this.structure.endSequenceNumber;
    }

    public char getEndInsertionCode() {
        return this.structure.endInsertionCode;
    }

    public int getStrandCount() {
        return this.structure.strandCount;
    }

    public BS getStructuredModels() {
        return this.bsModelsDefined;
    }

    public int[] getAtomIndices() {
        return this.structure.atomStartEnd;
    }

    public int[] getModelIndices() {
        return this.structure.modelStartEnd;
    }
}

