/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.smarter;

import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.adapter.smarter.AtomSetObject;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.SmarterJmolAdapter;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.Interface;
import org.jmol.api.SymmetryInterface;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.P3;
import org.jmol.util.P3i;
import org.jmol.util.Parser;
import org.jmol.util.SB;
import org.jmol.util.Tensor;
import org.jmol.util.TextFormat;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AtomSetCollection {
    public BS bsAtoms;
    private String fileTypeName;
    private String collectionName;
    private Map<String, Object> atomSetCollectionAuxiliaryInfo = new Hashtable<String, Object>();
    private static final String[] globalBooleans = new String[]{"someModelsHaveFractionalCoordinates", "someModelsHaveSymmetry", "someModelsHaveUnitcells", "someModelsHaveCONECT", "isPDB"};
    public static final int GLOBAL_FRACTCOORD = 0;
    public static final int GLOBAL_SYMMETRY = 1;
    public static final int GLOBAL_UNITCELLS = 2;
    private static final int GLOBAL_CONECT = 3;
    public static final int GLOBAL_ISPDB = 4;
    public static final String[] notionalUnitcellTags = new String[]{"a", "b", "c", "alpha", "beta", "gamma"};
    private int atomCount;
    private Atom[] atoms = new Atom[256];
    private int bondCount;
    private Bond[] bonds = new Bond[256];
    private int structureCount;
    private Structure[] structures = new Structure[16];
    private int atomSetCount;
    private int currentAtomSetIndex = -1;
    private int[] atomSetNumbers = new int[16];
    private int[] atomSetAtomIndexes = new int[16];
    private int[] atomSetAtomCounts = new int[16];
    private int[] atomSetBondCounts = new int[16];
    private Map<String, Object>[] atomSetAuxiliaryInfo = new Hashtable[16];
    private int[] latticeCells;
    public String errorMessage;
    public boolean coordinatesAreFractional;
    boolean isTrajectory;
    private int trajectoryStepCount = 0;
    private JmolList<P3[]> trajectorySteps;
    private JmolList<V3[]> vibrationSteps;
    private JmolList<String> trajectoryNames;
    boolean doFixPeriodic;
    public float[] notionalUnitCell = new float[6];
    public boolean allowMultiple;
    AtomSetCollectionReader reader;
    private JmolList<AtomSetCollectionReader> readerList;
    JmolList<int[]> vConnect;
    int connectNextAtomIndex = 0;
    int connectNextAtomSet = 0;
    int[] connectLast;
    public BS bsStructuredModels;
    float symmetryRange;
    private boolean doCentroidUnitCell;
    private boolean centroidPacked;
    public P3 ptSupercell;
    public float[] fmatSupercell;
    public SymmetryInterface symmetry;
    boolean haveUnitCell = false;
    boolean doNormalize = true;
    boolean doPackUnitCell = false;
    private float rminx;
    private float rminy;
    private float rminz;
    private float rmaxx;
    private float rmaxy;
    private float rmaxz;
    private final P3 ptOffset = new P3();
    public P3 unitCellOffset;
    private P3i minXYZ;
    private P3i maxXYZ;
    private P3i minXYZ0;
    private P3i maxXYZ0;
    public boolean haveAnisou;
    private int dtype = 3;
    private V3[] unitCellTranslations;
    public int baseSymmetryAtomCount;
    private boolean checkLatticeOnly;
    private int latticeOp;
    private boolean latticeOnly;
    private int bondCount0;
    private int bondIndex0;
    private boolean applySymmetryToBonds = false;
    private boolean checkSpecial = true;
    private boolean checkAll = false;
    private P3 ptTemp;
    private Matrix3f mTemp;
    private Map<Object, Integer> atomSymbolicMap = new Hashtable<Object, Integer>();
    private boolean haveMappedSerials;

    public String getFileTypeName() {
        return this.fileTypeName;
    }

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String string) {
        if (string != null) {
            if ((string = string.trim()).length() == 0) {
                return;
            }
            this.collectionName = string;
        }
    }

    public Map<String, Object> getAtomSetCollectionAuxiliaryInfoMap() {
        return this.atomSetCollectionAuxiliaryInfo;
    }

    public void clearGlobalBoolean(int n) {
        this.atomSetCollectionAuxiliaryInfo.remove(globalBooleans[n]);
    }

    public void setGlobalBoolean(int n) {
        this.setAtomSetCollectionAuxiliaryInfo(globalBooleans[n], Boolean.TRUE);
    }

    boolean getGlobalBoolean(int n) {
        return this.getAtomSetCollectionAuxiliaryInfo(globalBooleans[n]) == Boolean.TRUE;
    }

    public int getAtomCount() {
        return this.atomCount;
    }

    public int getHydrogenAtomCount() {
        int n = 0;
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.atoms[i].elementNumber != 1 && !this.atoms[i].elementSymbol.equals("H")) continue;
            ++n;
        }
        return n;
    }

    public Atom[] getAtoms() {
        return this.atoms;
    }

    public Atom getAtom(int n) {
        return this.atoms[n];
    }

    public int getBondCount() {
        return this.bondCount;
    }

    public Bond[] getBonds() {
        return this.bonds;
    }

    public Bond getBond(int n) {
        return this.bonds[n];
    }

    public int getStructureCount() {
        return this.structureCount;
    }

    public Structure[] getStructures() {
        return this.structures;
    }

    public int getAtomSetCount() {
        return this.atomSetCount;
    }

    public int getCurrentAtomSetIndex() {
        return this.currentAtomSetIndex;
    }

    public void setCurrentAtomSetIndex(int n) {
        this.currentAtomSetIndex = n;
    }

    public void setDoFixPeriodic() {
        this.doFixPeriodic = true;
    }

    public AtomSetCollection(String string, AtomSetCollectionReader atomSetCollectionReader, AtomSetCollection[] atomSetCollectionArray, JmolList<?> jmolList) {
        this.fileTypeName = string;
        this.reader = atomSetCollectionReader;
        this.allowMultiple = atomSetCollectionReader == null || atomSetCollectionReader.desiredVibrationNumber < 0;
        Properties properties = new Properties();
        properties.put("PATH_KEY", ".PATH");
        properties.put("PATH_SEPARATOR", SmarterJmolAdapter.PATH_SEPARATOR);
        this.setAtomSetCollectionAuxiliaryInfo("properties", properties);
        if (atomSetCollectionArray != null) {
            int n = 0;
            this.readerList = new JmolList();
            for (int i = 0; i < atomSetCollectionArray.length; ++i) {
                if (atomSetCollectionArray[i].atomCount <= 0 && (atomSetCollectionArray[i].reader == null || !atomSetCollectionArray[i].reader.mustFinalizeModelSet)) continue;
                this.appendAtomSetCollection(n++, atomSetCollectionArray[i]);
            }
            if (n > 1) {
                this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
            }
        } else if (jmolList != null) {
            this.setAtomSetCollectionAuxiliaryInfo("isMultiFile", Boolean.TRUE);
            this.appendAtomSetCollectionList(jmolList);
        }
    }

    private void appendAtomSetCollectionList(JmolList<?> jmolList) {
        int n = jmolList.size();
        if (n == 0) {
            this.errorMessage = "No file found!";
            return;
        }
        for (int i = 0; i < n; ++i) {
            Object e = jmolList.get(i);
            if (e instanceof JmolList) {
                this.appendAtomSetCollectionList((JmolList)e);
                continue;
            }
            this.appendAtomSetCollection(i, (AtomSetCollection)e);
        }
    }

    public void setTrajectory() {
        if (!this.isTrajectory) {
            this.trajectorySteps = new JmolList();
        }
        this.isTrajectory = true;
        this.addTrajectoryStep();
    }

    public void appendAtomSetCollection(int n, AtomSetCollection atomSetCollection) {
        Object object;
        int n2;
        int n3;
        if (atomSetCollection.reader != null && atomSetCollection.reader.mustFinalizeModelSet) {
            this.readerList.addLast(atomSetCollection.reader);
        }
        int n4 = this.atomCount;
        this.setAtomSetCollectionAuxiliaryInfo("loadState", atomSetCollection.getAtomSetCollectionAuxiliaryInfo("loadState"));
        if (atomSetCollection.bsAtoms != null) {
            if (this.bsAtoms == null) {
                this.bsAtoms = new BS();
            }
            n3 = atomSetCollection.bsAtoms.nextSetBit(0);
            while (n3 >= 0) {
                this.bsAtoms.set(n4 + n3);
                n3 = atomSetCollection.bsAtoms.nextSetBit(n3 + 1);
            }
        }
        n3 = 0;
        int n5 = this.atomSetCount;
        for (n2 = 0; n2 < atomSetCollection.atomSetCount; ++n2) {
            this.newAtomSet();
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex] = atomSetCollection.atomSetAuxiliaryInfo[n2];
            object = this.atomSetAuxiliaryInfo[this.currentAtomSetIndex];
            int[] nArray = (int[])object.get("PDB_CONECT_firstAtom_count_max");
            if (nArray != null) {
                nArray[0] = nArray[0] + n4;
            }
            this.setAtomSetAuxiliaryInfo("title", atomSetCollection.collectionName);
            this.setAtomSetName(atomSetCollection.getAtomSetName(n2));
            for (int i = 0; i < atomSetCollection.atomSetAtomCounts[n2]; ++i) {
                try {
                    if (this.bsAtoms != null) {
                        this.bsAtoms.set(this.atomCount);
                    }
                    this.newCloneAtom(atomSetCollection.atoms[n3]);
                }
                catch (Exception exception) {
                    this.errorMessage = "appendAtomCollection error: " + exception;
                }
                ++n3;
            }
            this.atomSetNumbers[this.currentAtomSetIndex] = n < 0 ? this.currentAtomSetIndex + 1 : (n + 1) * 1000000 + atomSetCollection.atomSetNumbers[n2];
        }
        for (n2 = 0; n2 < atomSetCollection.bondCount; ++n2) {
            object = atomSetCollection.bonds[n2];
            this.addNewBondWithOrder(((Bond)object).atomIndex1 + n4, ((Bond)object).atomIndex2 + n4, ((Bond)object).order);
        }
        n2 = globalBooleans.length;
        while (--n2 >= 0) {
            if (!atomSetCollection.getGlobalBoolean(n2)) continue;
            this.setGlobalBoolean(n2);
        }
        for (n2 = 0; n2 < atomSetCollection.structureCount; ++n2) {
            object = atomSetCollection.structures[n2];
            this.addStructure((Structure)object);
            ((Structure)object).modelStartEnd[0] = ((Structure)object).modelStartEnd[0] + n5;
            ((Structure)object).modelStartEnd[1] = ((Structure)object).modelStartEnd[1] + n5;
        }
    }

    void setNoAutoBond() {
        this.setAtomSetCollectionAuxiliaryInfo("noAutoBond", Boolean.TRUE);
    }

    void freeze(boolean bl) {
        if (this.atomSetCount == 1 && this.collectionName == null) {
            this.collectionName = (String)this.getAtomSetAuxiliaryInfoValue(0, "name");
        }
        if (bl) {
            this.reverseAtomSets();
        }
        if (this.trajectoryStepCount > 1) {
            this.finalizeTrajectory();
        }
        this.getList(true);
        this.getList(false);
        for (int i = 0; i < this.atomSetCount; ++i) {
            this.setAtomSetAuxiliaryInfoForSet("initialAtomCount", this.atomSetAtomCounts[i], i);
            this.setAtomSetAuxiliaryInfoForSet("initialBondCount", this.atomSetBondCounts[i], i);
        }
    }

    private void reverseAtomSets() {
        int n;
        int n2;
        this.reverseArray(this.atomSetAtomIndexes);
        this.reverseArray(this.atomSetNumbers);
        this.reverseArray(this.atomSetAtomCounts);
        this.reverseArray(this.atomSetBondCounts);
        AtomSetCollection.reverseList(this.trajectorySteps);
        AtomSetCollection.reverseList(this.trajectoryNames);
        AtomSetCollection.reverseList(this.vibrationSteps);
        this.reverseObject(this.atomSetAuxiliaryInfo);
        for (n2 = 0; n2 < this.atomCount; ++n2) {
            this.atoms[n2].atomSetIndex = this.atomSetCount - 1 - this.atoms[n2].atomSetIndex;
        }
        for (n2 = 0; n2 < this.structureCount; ++n2) {
            n = this.structures[n2].modelStartEnd[0];
            if (n < 0) continue;
            this.structures[n2].modelStartEnd[0] = this.atomSetCount - 1 - this.structures[n2].modelStartEnd[1];
            this.structures[n2].modelStartEnd[1] = this.atomSetCount - 1 - n;
        }
        for (n2 = 0; n2 < this.bondCount; ++n2) {
            this.bonds[n2].atomSetIndex = this.atomSetCount - 1 - this.atoms[this.bonds[n2].atomIndex1].atomSetIndex;
        }
        this.reverseSets(this.bonds, this.bondCount);
        JmolList<T>[] jmolListArray = ArrayUtil.createArrayOfArrayList(this.atomSetCount);
        for (n = 0; n < this.atomSetCount; ++n) {
            jmolListArray[n] = new JmolList();
        }
        for (n = 0; n < this.atomCount; ++n) {
            jmolListArray[this.atoms[n].atomSetIndex].addLast(this.atoms[n]);
        }
        int[] nArray = new int[this.atomCount];
        int n3 = this.atomCount;
        int n4 = this.atomSetCount;
        while (--n4 >= 0) {
            int n5 = jmolListArray[n4].size();
            while (--n5 >= 0) {
                Atom atom = this.atoms[--n3] = (Atom)jmolListArray[n4].get(n5);
                nArray[atom.index] = n3;
                atom.index = n3;
            }
        }
        for (n4 = 0; n4 < this.bondCount; ++n4) {
            this.bonds[n4].atomIndex1 = nArray[this.bonds[n4].atomIndex1];
            this.bonds[n4].atomIndex2 = nArray[this.bonds[n4].atomIndex2];
        }
        for (n4 = 0; n4 < this.atomSetCount; ++n4) {
            int[] nArray2 = (int[])this.getAtomSetAuxiliaryInfoValue(n4, "PDB_CONECT_firstAtom_count_max");
            if (nArray2 == null) continue;
            nArray2[0] = nArray[nArray2[0]];
            nArray2[1] = this.atomSetAtomCounts[n4];
        }
    }

    private void reverseSets(AtomSetObject[] atomSetObjectArray, int n) {
        int n2;
        int n3;
        JmolList<T>[] jmolListArray = ArrayUtil.createArrayOfArrayList(this.atomSetCount);
        for (n3 = 0; n3 < this.atomSetCount; ++n3) {
            jmolListArray[n3] = new JmolList();
        }
        for (n3 = 0; n3 < n; ++n3) {
            n2 = atomSetObjectArray[n3].atomSetIndex;
            if (n2 < 0) {
                return;
            }
            jmolListArray[atomSetObjectArray[n3].atomSetIndex].addLast(atomSetObjectArray[n3]);
        }
        n3 = this.atomSetCount;
        while (--n3 >= 0) {
            n2 = jmolListArray[n3].size();
            while (--n2 >= 0) {
                atomSetObjectArray[--n] = (AtomSetObject)jmolListArray[n3].get(n2);
            }
        }
    }

    private void reverseObject(Object[] objectArray) {
        int n = this.atomSetCount;
        int n2 = n / 2;
        while (--n2 >= 0) {
            ArrayUtil.swap(objectArray, n2, n - 1 - n2);
        }
    }

    private static void reverseList(JmolList<?> jmolList) {
        if (jmolList == null) {
            return;
        }
        Collections.reverse(jmolList);
    }

    private void reverseArray(int[] nArray) {
        int n = this.atomSetCount;
        int n2 = n / 2;
        while (--n2 >= 0) {
            ArrayUtil.swapInt(nArray, n2, n - 1 - n2);
        }
    }

    private void getList(boolean bl) {
        int n = this.atomCount;
        while (--n >= 0 && (this.atoms[n] == null || (bl ? this.atoms[n].alternateLocationID : this.atoms[n].insertionCode) == '\u0000')) {
        }
        if (n < 0) {
            return;
        }
        String[] stringArray = new String[this.atomSetCount];
        for (n = 0; n < this.atomSetCount; ++n) {
            stringArray[n] = "";
        }
        for (n = 0; n < this.atomCount; ++n) {
            int n2;
            char c;
            if (this.atoms[n] == null) continue;
            char c2 = c = bl ? this.atoms[n].alternateLocationID : this.atoms[n].insertionCode;
            if (c == '\u0000' || stringArray[n2 = this.atoms[n].atomSetIndex].indexOf(c) >= 0) continue;
            int n3 = n2;
            stringArray[n3] = stringArray[n3] + c;
        }
        String string = bl ? "altLocs" : "insertionCodes";
        for (n = 0; n < this.atomSetCount; ++n) {
            if (stringArray[n].length() <= 0) continue;
            this.setAtomSetAuxiliaryInfoForSet(string, stringArray[n], n);
        }
    }

    void finish() {
        if (this.reader != null) {
            this.reader.finalizeModelSet();
        } else if (this.readerList != null) {
            for (int i = 0; i < this.readerList.size(); ++i) {
                ((AtomSetCollectionReader)this.readerList.get(i)).finalizeModelSet();
            }
        }
        this.atoms = null;
        this.atomSetAtomCounts = new int[16];
        this.atomSetAuxiliaryInfo = new Hashtable[16];
        this.atomSetCollectionAuxiliaryInfo = new Hashtable<String, Object>();
        this.atomSetCount = 0;
        this.atomSetNumbers = new int[16];
        this.atomSymbolicMap = new Hashtable<Object, Integer>();
        this.bonds = null;
        this.connectLast = null;
        this.currentAtomSetIndex = -1;
        this.latticeCells = null;
        this.notionalUnitCell = null;
        this.readerList = null;
        this.symmetry = null;
        this.structures = new Structure[16];
        this.structureCount = 0;
        this.trajectorySteps = null;
        this.vibrationSteps = null;
        this.vConnect = null;
    }

    public void discardPreviousAtoms() {
        int n = this.atomCount;
        while (--n >= 0) {
            this.atoms[n] = null;
        }
        this.atomCount = 0;
        this.clearSymbolicMap();
        this.atomSetCount = 0;
        this.currentAtomSetIndex = -1;
        n = this.atomSetAuxiliaryInfo.length;
        while (--n >= 0) {
            this.atomSetAtomCounts[n] = 0;
            this.atomSetBondCounts[n] = 0;
            this.atomSetAuxiliaryInfo[n] = null;
        }
    }

    public void removeAtomSet(int n) {
        int n2;
        int n3;
        if (this.bsAtoms == null) {
            this.bsAtoms = new BS();
            this.bsAtoms.setBits(0, this.atomCount);
        }
        int n4 = this.atomSetAtomIndexes[n];
        int n5 = this.atomSetAtomCounts[n];
        int n6 = n4 + n5;
        this.bsAtoms.clearBits(n4, n6);
        for (n3 = n6; n3 < this.atomCount; ++n3) {
            --this.atoms[n3].atomSetIndex;
        }
        for (n3 = n + 1; n3 < this.atomSetCount; ++n3) {
            this.atomSetAuxiliaryInfo[n3 - 1] = this.atomSetAuxiliaryInfo[n3];
            this.atomSetAtomIndexes[n3 - 1] = this.atomSetAtomIndexes[n3];
            this.atomSetBondCounts[n3 - 1] = this.atomSetBondCounts[n3];
            this.atomSetAtomCounts[n3 - 1] = this.atomSetAtomCounts[n3];
            this.atomSetNumbers[n3 - 1] = this.atomSetNumbers[n3];
        }
        n3 = 0;
        for (n2 = 0; n2 < this.structureCount; ++n2) {
            Structure structure = this.structures[n2];
            if (structure.modelStartEnd[0] != n || structure.modelStartEnd[1] != n) continue;
            this.structures[n2] = null;
            ++n3;
        }
        if (n3 > 0) {
            Structure[] structureArray = new Structure[this.structureCount - n3];
            int n7 = 0;
            for (int i = 0; i < this.structureCount; ++i) {
                if (this.structures[i] == null) continue;
                structureArray[n7++] = this.structures[i];
            }
            this.structures = structureArray;
        }
        for (n2 = 0; n2 < this.bondCount; ++n2) {
            this.bonds[n2].atomSetIndex = this.atoms[this.bonds[n2].atomIndex1].atomSetIndex;
        }
        this.atomSetAuxiliaryInfo[--this.atomSetCount] = null;
    }

    public void removeCurrentAtomSet() {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        --this.currentAtomSetIndex;
        --this.atomSetCount;
    }

    Atom newCloneAtom(Atom atom) throws Exception {
        Atom atom2 = atom.getClone();
        this.addAtom(atom2);
        return atom2;
    }

    public void cloneFirstAtomSet(int n) throws Exception {
        if (!this.allowMultiple) {
            return;
        }
        this.newAtomSet();
        if (n == 0) {
            n = this.atomSetAtomCounts[0];
        }
        for (int i = 0; i < n; ++i) {
            this.newCloneAtom(this.atoms[i]);
        }
    }

    public void cloneFirstAtomSetWithBonds(int n) throws Exception {
        if (!this.allowMultiple) {
            return;
        }
        this.cloneFirstAtomSet(0);
        int n2 = this.atomSetAtomCounts[0];
        for (int i = 0; i < n; ++i) {
            Bond bond = this.bonds[this.bondCount - n];
            this.addNewBondWithOrder(bond.atomIndex1 + n2, bond.atomIndex2 + n2, bond.order);
        }
    }

    public void cloneLastAtomSet() throws Exception {
        this.cloneLastAtomSetFromPoints(0, null);
    }

    public void cloneLastAtomSetFromPoints(int n, P3[] p3Array) throws Exception {
        if (!this.allowMultiple) {
            return;
        }
        int n2 = n > 0 ? n : this.getLastAtomSetAtomCount();
        int n3 = this.getLastAtomSetAtomIndex();
        this.newAtomSet();
        for (int i = 0; i < n2; ++i) {
            Atom atom = this.newCloneAtom(this.atoms[n3++]);
            if (p3Array == null) continue;
            atom.setT(p3Array[i]);
        }
    }

    public int getFirstAtomSetAtomCount() {
        return this.atomSetAtomCounts[0];
    }

    public int getLastAtomSetAtomCount() {
        return this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public int getLastAtomSetAtomIndex() {
        return this.atomCount - this.atomSetAtomCounts[this.currentAtomSetIndex];
    }

    public Atom addNewAtom() {
        Atom atom = new Atom();
        this.addAtom(atom);
        return atom;
    }

    public void addAtom(Atom atom) {
        if (this.atomCount == this.atoms.length) {
            this.atoms = this.atomCount > 200000 ? (Atom[])ArrayUtil.ensureLength(this.atoms, this.atomCount + 50000) : (Atom[])ArrayUtil.doubleLength(this.atoms);
        }
        if (this.atomSetCount == 0) {
            this.newAtomSet();
        }
        atom.index = this.atomCount;
        this.atoms[this.atomCount++] = atom;
        atom.atomSetIndex = this.currentAtomSetIndex;
        int n = this.currentAtomSetIndex;
        int n2 = this.atomSetAtomCounts[n];
        this.atomSetAtomCounts[n] = n2 + 1;
        atom.atomSite = n2;
    }

    public void addAtomWithMappedName(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomName();
    }

    public void addAtomWithMappedSerialNumber(Atom atom) {
        this.addAtom(atom);
        this.mapMostRecentAtomSerialNumber();
    }

    public Bond addNewBondWithOrder(int n, int n2, int n3) {
        if (n < 0 || n >= this.atomCount || n2 < 0 || n2 >= this.atomCount) {
            return null;
        }
        Bond bond = new Bond(n, n2, n3);
        this.addBond(bond);
        return bond;
    }

    public Bond addNewBondFromNames(String string, String string2, int n) {
        return this.addNewBondWithOrder(this.getAtomIndexFromName(string), this.getAtomIndexFromName(string2), n);
    }

    public Bond addNewBondWithMappedSerialNumbers(int n, int n2, int n3) {
        return this.addNewBondWithOrder(this.getAtomIndexFromSerial(n), this.getAtomIndexFromSerial(n2), n3);
    }

    public void addConnection(int[] nArray) {
        if (this.vConnect == null) {
            this.connectLast = null;
            this.vConnect = new JmolList();
        }
        if (this.connectLast != null && nArray[0] == this.connectLast[0] && nArray[1] == this.connectLast[1] && nArray[2] != 2048) {
            this.connectLast[2] = this.connectLast[2] + 1;
            return;
        }
        this.connectLast = nArray;
        this.vConnect.addLast(nArray);
    }

    private void connectAllBad(int n) {
        int n2 = this.connectNextAtomIndex;
        for (int i = this.connectNextAtomSet; i < this.atomSetCount; ++i) {
            this.setAtomSetAuxiliaryInfoForSet("PDB_CONECT_firstAtom_count_max", new int[]{n2, this.atomSetAtomCounts[i], n}, i);
            if (this.vConnect != null) {
                this.setAtomSetAuxiliaryInfoForSet("PDB_CONECT_bonds", this.vConnect, i);
                this.setGlobalBoolean(3);
            }
            n2 += this.atomSetAtomCounts[i];
        }
        this.vConnect = null;
        this.connectNextAtomSet = this.currentAtomSetIndex + 1;
        this.connectNextAtomIndex = n2;
    }

    public void connectAll(int n, boolean bl) {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        if (bl) {
            this.connectAllBad(n);
            return;
        }
        this.setAtomSetAuxiliaryInfo("PDB_CONECT_firstAtom_count_max", new int[]{this.atomSetAtomIndexes[this.currentAtomSetIndex], this.atomSetAtomCounts[this.currentAtomSetIndex], n});
        if (this.vConnect == null) {
            return;
        }
        int n2 = this.connectNextAtomIndex;
        for (int i = this.connectNextAtomSet; i < this.atomSetCount; ++i) {
            this.setAtomSetAuxiliaryInfoForSet("PDB_CONECT_bonds", this.vConnect, i);
            this.setGlobalBoolean(3);
            n2 += this.atomSetAtomCounts[i];
        }
        this.vConnect = null;
        this.connectNextAtomSet = this.currentAtomSetIndex + 1;
        this.connectNextAtomIndex = n2;
    }

    public void addBond(Bond bond) {
        if (this.trajectoryStepCount > 0) {
            return;
        }
        if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0 || bond.order < 0 || this.atoms[bond.atomIndex1].atomSetIndex != this.atoms[bond.atomIndex2].atomSetIndex) {
            if (Logger.debugging) {
                Logger.debug(">>>>>>BAD BOND:" + bond.atomIndex1 + "-" + bond.atomIndex2 + " order=" + bond.order);
            }
            return;
        }
        if (this.bondCount == this.bonds.length) {
            this.bonds = (Bond[])ArrayUtil.arrayCopyObject(this.bonds, this.bondCount + 1024);
        }
        this.bonds[this.bondCount++] = bond;
        int n = this.currentAtomSetIndex;
        this.atomSetBondCounts[n] = this.atomSetBondCounts[n] + 1;
    }

    public void finalizeStructures() {
        Structure structure;
        int n;
        if (this.structureCount == 0) {
            return;
        }
        this.bsStructuredModels = new BS();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (n = 0; n < this.structureCount; ++n) {
            structure = this.structures[n];
            if (structure.modelStartEnd[0] == -1) {
                structure.modelStartEnd[0] = 0;
                structure.modelStartEnd[1] = this.atomSetCount - 1;
            }
            this.bsStructuredModels.setBits(structure.modelStartEnd[0], structure.modelStartEnd[1] + 1);
            if (structure.strandCount == 0) continue;
            String string = structure.structureID + " " + structure.modelStartEnd[0];
            Integer n2 = (Integer)hashtable.get(string);
            int n3 = (n2 == null ? 0 : n2) + 1;
            hashtable.put(string, n3);
        }
        for (n = 0; n < this.structureCount; ++n) {
            structure = this.structures[n];
            if (structure.strandCount != 1) continue;
            structure.strandCount = (Integer)hashtable.get(structure.structureID + " " + structure.modelStartEnd[0]);
        }
    }

    public void addStructure(Structure structure) {
        if (this.structureCount == this.structures.length) {
            this.structures = (Structure[])ArrayUtil.arrayCopyObject(this.structures, this.structureCount + 32);
        }
        this.structures[this.structureCount++] = structure;
    }

    public void addVibrationVectorWithSymmetry(int n, float f, float f2, float f3, boolean bl) {
        if (!bl) {
            this.addVibrationVector(n, f, f2, f3);
            return;
        }
        int n2 = this.atoms[n].atomSite;
        int n3 = this.atoms[n].atomSetIndex;
        for (int i = n; i < this.atomCount && this.atoms[i].atomSetIndex == n3; ++i) {
            if (this.atoms[i].atomSite != n2) continue;
            this.addVibrationVector(i, f, f2, f3);
        }
    }

    public void addVibrationVector(int n, float f, float f2, float f3) {
        if (!this.allowMultiple) {
            n %= this.atomCount;
        }
        this.atoms[n].vib = V3.new3(f, f2, f3);
    }

    void setAtomSetSpaceGroupName(String string) {
        this.setAtomSetAuxiliaryInfo("spaceGroup", string + "");
    }

    public void setCoordinatesAreFractional(boolean bl) {
        this.coordinatesAreFractional = bl;
        this.setAtomSetAuxiliaryInfo("coordinatesAreFractional", bl);
        if (bl) {
            this.setGlobalBoolean(0);
        }
    }

    void setSymmetryRange(float f) {
        this.symmetryRange = f;
        this.setAtomSetCollectionAuxiliaryInfo("symmetryRange", Float.valueOf(f));
    }

    void setLatticeCells(int[] nArray, boolean bl, boolean bl2, boolean bl3, boolean bl4, String string, P3 p3) {
        this.latticeCells = nArray;
        boolean bl5 = nArray[0] <= 555 && nArray[1] >= 555 && (nArray[2] == 0 || nArray[2] == 1 || nArray[2] == -1);
        this.doNormalize = nArray[0] != 0 && (!bl5 || nArray[2] == 1);
        this.applySymmetryToBonds = bl;
        this.doPackUnitCell = bl2;
        this.doCentroidUnitCell = bl3;
        this.centroidPacked = bl4;
        if (string != null) {
            this.setSuperCell(string);
        } else {
            this.ptSupercell = p3;
        }
    }

    public void setSupercellFromPoint(P3 p3) {
        this.ptSupercell = p3;
        Logger.info("Using supercell " + Escape.eP(p3));
    }

    private void setSuperCell(String string) {
        if (this.fmatSupercell != null) {
            return;
        }
        this.fmatSupercell = new float[16];
        if (this.getSymmetry().getMatrixFromString(string, this.fmatSupercell, true) == null) {
            this.fmatSupercell = null;
            return;
        }
        Logger.info("Using supercell \n" + Matrix4f.newA(this.fmatSupercell));
    }

    public SymmetryInterface getSymmetry() {
        if (this.symmetry == null) {
            this.symmetry = (SymmetryInterface)Interface.getOptionInterface("symmetry.Symmetry");
        }
        return this.symmetry;
    }

    public void setNotionalUnitCell(float[] fArray, Matrix3f matrix3f, P3 p3) {
        this.notionalUnitCell = new float[fArray.length];
        this.unitCellOffset = p3;
        for (int i = 0; i < fArray.length; ++i) {
            this.notionalUnitCell[i] = fArray[i];
        }
        this.haveUnitCell = true;
        this.setAtomSetAuxiliaryInfo("notionalUnitcell", this.notionalUnitCell);
        this.setGlobalBoolean(2);
        this.getSymmetry().setUnitCell(this.notionalUnitCell);
        if (p3 != null) {
            this.symmetry.setOffsetPt(p3);
            this.setAtomSetAuxiliaryInfo("unitCellOffset", p3);
        }
        if (matrix3f != null) {
            this.symmetry.setUnitCellOrientation(matrix3f);
            this.setAtomSetAuxiliaryInfo("matUnitCellOrientation", matrix3f);
        }
    }

    int addSpaceGroupOperation(String string) {
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        return this.symmetry.addSpaceGroupOperation(string, 0);
    }

    public void setLatticeParameter(int n) {
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.symmetry.setLattice(n);
    }

    void applySymmetry(SymmetryInterface symmetryInterface) throws Exception {
        if (symmetryInterface != null) {
            this.getSymmetry().setSpaceGroupS(symmetryInterface);
        }
        this.applySymmetryLattice(this.latticeCells[0], this.latticeCells[1], Math.abs(this.latticeCells[2]));
    }

    private void applySymmetryLattice(int n, int n2, int n3) throws Exception {
        if (!this.coordinatesAreFractional || !this.getSymmetry().haveSpaceGroup()) {
            return;
        }
        if (this.fmatSupercell != null) {
            int n4;
            int n5;
            this.rminx = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminz = Float.MAX_VALUE;
            this.rmaxx = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
            P3 p3 = this.setSym(0, 1, 2);
            P3 p32 = this.setSym(4, 5, 6);
            P3 p33 = this.setSym(8, 9, 10);
            this.minXYZ = P3i.new3((int)this.rminx, (int)this.rminy, (int)this.rminz);
            this.maxXYZ = P3i.new3((int)this.rmaxx, (int)this.rmaxy, (int)this.rmaxz);
            this.applyAllSymmetry();
            for (n5 = n4 = this.getLastAtomSetAtomIndex(); n5 < this.atomCount; ++n5) {
                this.symmetry.toCartesian(this.atoms[n5], true);
            }
            this.symmetry = null;
            this.setNotionalUnitCell(new float[]{0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, p3.x, p3.y, p3.z, p32.x, p32.y, p32.z, p33.x, p33.y, p33.z}, null, (P3)this.getAtomSetAuxiliaryInfoValue(-1, "unitCellOffset"));
            this.setAtomSetSpaceGroupName("P1");
            this.getSymmetry().setSpaceGroup(this.doNormalize);
            this.symmetry.addSpaceGroupOperation("x,y,z", 0);
            for (n5 = n4; n5 < this.atomCount; ++n5) {
                this.symmetry.toFractional(this.atoms[n5], true);
            }
            this.haveAnisou = false;
            this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].remove("matUnitCellOrientation");
            this.doPackUnitCell = false;
        }
        this.minXYZ = new P3i();
        this.maxXYZ = P3i.new3(n, n2, n3);
        this.applyAllSymmetry();
        this.fmatSupercell = null;
    }

    private P3 setSym(int n, int n2, int n3) {
        P3 p3 = new P3();
        p3.set(this.fmatSupercell[n], this.fmatSupercell[n2], this.fmatSupercell[n3]);
        this.setSymmetryMinMax(p3);
        this.symmetry.toCartesian(p3, false);
        return p3;
    }

    private void setSymmetryMinMax(P3 p3) {
        if (this.rminx > p3.x) {
            this.rminx = p3.x;
        }
        if (this.rminy > p3.y) {
            this.rminy = p3.y;
        }
        if (this.rminz > p3.z) {
            this.rminz = p3.z;
        }
        if (this.rmaxx < p3.x) {
            this.rmaxx = p3.x;
        }
        if (this.rmaxy < p3.y) {
            this.rmaxy = p3.y;
        }
        if (this.rmaxz < p3.z) {
            this.rmaxz = p3.z;
        }
    }

    private boolean isInSymmetryRange(P3 p3) {
        return p3.x >= this.rminx && p3.y >= this.rminy && p3.z >= this.rminz && p3.x <= this.rmaxx && p3.y <= this.rmaxy && p3.z <= this.rmaxz;
    }

    private static boolean isWithinCell(int n, P3 p3, int n2, int n3, int n4, int n5, int n6, int n7) {
        float f = 0.02f;
        return p3.x > (float)n2 - f && p3.x < (float)n3 + f && (n < 2 || p3.y > (float)n4 - f && p3.y < (float)n5 + f) && (n < 3 || p3.z > (float)n6 - f && p3.z < (float)n7 + f);
    }

    public void setAnisoBorU(Atom atom, float[] fArray, int n) {
        this.haveAnisou = true;
        atom.anisoBorU = fArray;
        fArray[6] = n;
    }

    public float[] getAnisoBorU(Atom atom) {
        return atom.anisoBorU;
    }

    public void setTensors() {
        if (!this.haveAnisou) {
            return;
        }
        this.getSymmetry();
        for (int i = this.getLastAtomSetAtomIndex(); i < this.atomCount; ++i) {
            this.atoms[i].addTensor(this.symmetry.getTensor(this.atoms[i].anisoBorU), null, false);
        }
    }

    public void setLatticeOnly(boolean bl) {
        this.checkLatticeOnly = bl;
    }

    public void setBaseSymmetryAtomCount(int n) {
        this.baseSymmetryAtomCount = n;
    }

    private void applyAllSymmetry() throws Exception {
        int n;
        int n2;
        int n3;
        boolean bl;
        int n4;
        int n5 = this.baseSymmetryAtomCount == 0 ? this.getLastAtomSetAtomCount() : this.baseSymmetryAtomCount;
        int n6 = this.getLastAtomSetAtomIndex();
        this.setTensors();
        this.bondCount0 = this.bondCount;
        this.finalizeSymmetry(n6, n5);
        int n7 = this.symmetry.getSpaceGroupOperationCount();
        this.getSymmetry().setMinMaxLatticeParameters(this.minXYZ, this.maxXYZ);
        this.dtype = (int)this.getSymmetry().getUnitCellInfoType(6);
        if (this.doCentroidUnitCell) {
            this.setAtomSetCollectionAuxiliaryInfo("centroidMinMax", new int[]{this.minXYZ.x, this.minXYZ.y, this.minXYZ.z, this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z, this.centroidPacked ? 1 : 0});
        }
        if (this.ptSupercell != null) {
            this.setAtomSetAuxiliaryInfo("supercell", this.ptSupercell);
            switch (this.dtype) {
                case 3: {
                    this.minXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                    this.maxXYZ.z *= (int)Math.abs(this.ptSupercell.z);
                }
                case 2: {
                    this.minXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                    this.maxXYZ.y *= (int)Math.abs(this.ptSupercell.y);
                }
                case 1: {
                    this.minXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                    this.maxXYZ.x *= (int)Math.abs(this.ptSupercell.x);
                }
            }
        }
        if (this.doCentroidUnitCell || this.doPackUnitCell || this.symmetryRange != 0.0f && this.maxXYZ.x - this.minXYZ.x == 1 && this.maxXYZ.y - this.minXYZ.y == 1 && this.maxXYZ.z - this.minXYZ.z == 1) {
            this.minXYZ0 = P3i.new3(this.minXYZ.x, this.minXYZ.y, this.minXYZ.z);
            this.maxXYZ0 = P3i.new3(this.maxXYZ.x, this.maxXYZ.y, this.maxXYZ.z);
            switch (this.dtype) {
                case 3: {
                    --this.minXYZ.z;
                    ++this.maxXYZ.z;
                }
                case 2: {
                    --this.minXYZ.y;
                    ++this.maxXYZ.y;
                }
                case 1: {
                    --this.minXYZ.x;
                    ++this.maxXYZ.x;
                }
            }
        }
        int n8 = (this.maxXYZ.x - this.minXYZ.x) * (this.maxXYZ.y - this.minXYZ.y) * (this.maxXYZ.z - this.minXYZ.z);
        int n9 = this.checkSpecial ? n5 * n7 * n8 : (this.symmetryRange > 0.0f ? n5 * n7 : (this.symmetryRange < 0.0f ? 1 : 1));
        P3[] p3Array = new P3[n9];
        for (n4 = 0; n4 < n5; ++n4) {
            this.atoms[n4 + n6].bsSymmetry = BSUtil.newBitSet(n7 * (n8 + 1));
        }
        n4 = 0;
        int[] nArray = new int[n8];
        this.unitCellTranslations = new V3[n8];
        int n10 = 0;
        int n11 = 0;
        float f = Math.abs(this.symmetryRange);
        boolean bl2 = this.symmetryRange != 0.0f;
        boolean bl3 = this.symmetryRange < 0.0f;
        boolean bl4 = bl = this.symmetryRange > 0.0f;
        if (bl2) {
            this.rminx = Float.MAX_VALUE;
            this.rminy = Float.MAX_VALUE;
            this.rminz = Float.MAX_VALUE;
            this.rmaxx = -3.4028235E38f;
            this.rmaxy = -3.4028235E38f;
            this.rmaxz = -3.4028235E38f;
        }
        this.latticeOp = this.symmetry.getLatticeOp();
        this.checkAll = this.atomSetCount == 1 && this.checkSpecial && this.latticeOp >= 0;
        this.latticeOnly = this.checkLatticeOnly && this.latticeOp >= 0;
        Matrix4f matrix4f = this.symmetry.getSpaceGroupOperation(0);
        if (this.doPackUnitCell) {
            this.ptOffset.set(0.0f, 0.0f, 0.0f);
        }
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    this.unitCellTranslations[n10] = V3.new3(n3, n2, n);
                    nArray[n10++] = 555 + n3 * 100 + n2 * 10 + n;
                    if (n3 != 0 || n2 != 0 || n != 0 || p3Array.length == 0) continue;
                    for (n4 = 0; n4 < n5; ++n4) {
                        Atom atom = this.atoms[n6 + n4];
                        P3 p3 = P3.newP(atom);
                        matrix4f.transform(p3);
                        this.symmetry.toCartesian(p3, false);
                        if (this.doPackUnitCell) {
                            this.symmetry.toUnitCell(p3, this.ptOffset);
                            atom.setT(p3);
                            this.symmetry.toFractional(atom, false);
                        }
                        atom.bsSymmetry.set(n10 * n7);
                        atom.bsSymmetry.set(0);
                        if (bl2) {
                            this.setSymmetryMinMax(p3);
                        }
                        if (n4 >= n9) continue;
                        p3Array[n4] = p3;
                    }
                    if (bl3) {
                        this.rminx -= f;
                        this.rminy -= f;
                        this.rminz -= f;
                        this.rmaxx += f;
                        this.rmaxy += f;
                        this.rmaxz += f;
                    }
                    n11 = n4 = this.symmetryAddAtoms(n6, n5, 0, 0, 0, 0, n4, n10 * n7, p3Array);
                }
            }
        }
        if (bl) {
            this.rminx -= f;
            this.rminy -= f;
            this.rminz -= f;
            this.rmaxx += f;
            this.rmaxy += f;
            this.rmaxz += f;
        }
        n10 = 0;
        for (n3 = this.minXYZ.x; n3 < this.maxXYZ.x; ++n3) {
            for (n2 = this.minXYZ.y; n2 < this.maxXYZ.y; ++n2) {
                for (n = this.minXYZ.z; n < this.maxXYZ.z; ++n) {
                    ++n10;
                    if (n3 == 0 && n2 == 0 && n == 0) continue;
                    n4 = this.symmetryAddAtoms(n6, n5, n3, n2, n, n11, n4, n10 * n7, p3Array);
                }
            }
        }
        if (n10 * n5 == this.atomCount - n6) {
            this.appendAtomProperties(n10);
        }
        this.setSymmetryOps();
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", n6);
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", n5);
        this.setAtomSetAuxiliaryInfo("latticeDesignation", this.symmetry.getLatticeDesignation());
        this.setAtomSetAuxiliaryInfo("unitCellRange", nArray);
        this.setAtomSetAuxiliaryInfo("unitCellTranslations", this.unitCellTranslations);
        this.notionalUnitCell = new float[6];
        this.coordinatesAreFractional = false;
        this.setAtomSetAuxiliaryInfo("hasSymmetry", Boolean.TRUE);
        this.setGlobalBoolean(1);
    }

    private void finalizeSymmetry(int n, int n2) {
        this.symmetry.setFinalOperations(this.atoms, n, n2, this.doNormalize);
        String string = (String)this.getAtomSetAuxiliaryInfoValue(-1, "spaceGroup");
        if (string == null || string.equals("unspecified!")) {
            this.setAtomSetSpaceGroupName(this.symmetry.getSpaceGroupName());
        }
    }

    private void setSymmetryOps() {
        int n = this.symmetry.getSpaceGroupOperationCount();
        if (n > 0) {
            String[] stringArray = new String[n];
            for (int i = 0; i < n; ++i) {
                stringArray[i] = "" + this.symmetry.getSpaceGroupXyz(i, this.doNormalize);
            }
            this.setAtomSetAuxiliaryInfo("symmetryOperations", stringArray);
        }
        this.setAtomSetAuxiliaryInfo("symmetryCount", n);
    }

    public void setCheckSpecial(boolean bl) {
        this.checkSpecial = bl;
    }

    private int symmetryAddAtoms(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, P3[] p3Array) throws Exception {
        boolean bl;
        int[] nArray;
        boolean bl2 = n6 == 0;
        boolean bl3 = this.bondCount0 > this.bondIndex0 && this.applySymmetryToBonds;
        int[] nArray2 = nArray = bl3 ? new int[n2] : null;
        if (this.doPackUnitCell) {
            this.ptOffset.set(n3, n4, n5);
        }
        float f = this.symmetryRange * this.symmetryRange;
        boolean bl4 = this.symmetryRange < 0.0f;
        boolean bl5 = this.symmetryRange > 0.0f;
        boolean bl6 = bl2 && bl5;
        bl5 &= !bl2;
        int n9 = this.symmetry.getSpaceGroupOperationCount();
        if (n9 == 1) {
            this.checkSpecial = false;
        }
        boolean bl7 = bl4 || bl5;
        boolean bl8 = this.checkSpecial || bl7;
        boolean bl9 = bl = this.checkSpecial || bl6;
        if (bl4) {
            n6 = n2;
        }
        int n10 = n + n2;
        P3 p3 = new P3();
        for (int i = 0; i < n9; ++i) {
            int n11;
            int n12;
            P3 p32;
            Object object;
            int n13;
            if (bl2 && i == 0 || this.latticeOnly && i > 0 && i != this.latticeOp) continue;
            int n14 = this.checkSpecial ? n7 : (bl5 ? n6 : 0);
            for (n13 = n; n13 < n10; ++n13) {
                if (this.atoms[n13].ignoreSymmetry || this.bsAtoms != null && !this.bsAtoms.get(n13)) continue;
                this.symmetry.newSpaceGroupPoint(i, this.atoms[n13], p3, n3, n4, n5);
                object = null;
                p32 = P3.newP(p3);
                this.symmetry.toCartesian(p32, false);
                if (this.doPackUnitCell) {
                    this.symmetry.toUnitCell(p32, this.ptOffset);
                    p3.setT(p32);
                    this.symmetry.toFractional(p3, false);
                    if (!AtomSetCollection.isWithinCell(this.dtype, p3, this.minXYZ0.x, this.maxXYZ0.x, this.minXYZ0.y, this.maxXYZ0.y, this.minXYZ0.z, this.maxXYZ0.z)) continue;
                }
                if (bl6) {
                    this.setSymmetryMinMax(p32);
                }
                if (bl8) {
                    float f2 = Float.MAX_VALUE;
                    if (bl7 && !this.isInSymmetryRange(p32)) continue;
                    n11 = n12 = this.checkAll ? this.atomCount : n14;
                    while (--n11 >= 0) {
                        float f3 = p32.distanceSquared(p3Array[n11]);
                        if (this.checkSpecial && (double)f3 < 1.0E-4) {
                            object = this.atoms[n + n11];
                            if (((Atom)object).atomName == null || ((Atom)object).atomName.equals(this.atoms[n13].atomName)) break;
                            object = null;
                        }
                        if (!bl5 || n11 >= n6 || !(f3 < f2)) continue;
                        f2 = f3;
                    }
                    if (bl5 && f2 > f) continue;
                }
                int n15 = this.atoms[n13].atomSite;
                if (object != null) {
                    if (bl3) {
                        nArray[n15] = ((Atom)object).index;
                    }
                    ((Atom)object).bsSymmetry.set(n8 + i);
                    ((Atom)object).bsSymmetry.set(i);
                    continue;
                }
                if (bl3) {
                    nArray[n15] = this.atomCount;
                }
                Atom atom = this.newCloneAtom(this.atoms[n13]);
                atom.setT(p3);
                atom.atomSite = n15;
                atom.bsSymmetry = BSUtil.newAndSetBit(n8 + i);
                atom.bsSymmetry.set(i);
                if (bl) {
                    p3Array[n7++] = p32;
                }
                if (this.atoms[n13].tensors == null) continue;
                atom.tensors = null;
                n11 = this.atoms[n13].tensors.size();
                while (--n11 >= 0) {
                    Tensor tensor = (Tensor)this.atoms[n13].tensors.get(n11);
                    if (tensor == null) continue;
                    if (n9 == 1) {
                        atom.addTensor(Tensor.copyTensor(tensor), null, false);
                        continue;
                    }
                    this.addRotatedTensor(atom, tensor, i, false);
                }
            }
            if (!bl3) continue;
            for (n13 = this.bondIndex0; n13 < this.bondCount0; ++n13) {
                object = this.bonds[n13];
                p32 = this.atoms[((Bond)object).atomIndex1];
                Atom atom = this.atoms[((Bond)object).atomIndex2];
                if (p32 == null || atom == null) continue;
                n12 = nArray[((Atom)p32).atomSite];
                n11 = nArray[atom.atomSite];
                if (n12 < n10 && n11 < n10) continue;
                this.addNewBondWithOrder(n12, n11, ((Bond)object).order);
            }
        }
        return n7;
    }

    public Tensor addRotatedTensor(Atom atom, Tensor tensor, int n, boolean bl) {
        if (this.ptTemp == null) {
            this.ptTemp = new P3();
            this.mTemp = new Matrix3f();
        }
        return atom.addTensor(Tensor.getTensorFromEigenVectors(this.symmetry.rotateAxes(n, tensor.eigenVectors, this.ptTemp, this.mTemp), tensor.eigenValues, tensor.isIsotropic ? "iso" : tensor.type, tensor.id), null, bl);
    }

    public void applySymmetryBio(JmolList<Matrix4f> jmolList, float[] fArray, boolean bl, String string) {
        int n;
        if (this.latticeCells != null && this.latticeCells[0] != 0) {
            Logger.error("Cannot apply biomolecule when lattice cells are indicated");
            return;
        }
        this.doNormalize = false;
        this.symmetry = null;
        this.getSymmetry();
        this.setNotionalUnitCell(fArray, null, this.unitCellOffset);
        this.getSymmetry().setSpaceGroup(this.doNormalize);
        this.addSpaceGroupOperation("x,y,z");
        this.setAtomSetSpaceGroupName("biomolecule");
        int n2 = jmolList.size();
        this.applySymmetryToBonds = bl;
        this.bondCount0 = this.bondCount;
        boolean bl2 = this.bondCount0 > this.bondIndex0 && bl;
        int[] nArray = bl2 ? new int[this.atomCount] : null;
        int n3 = this.getLastAtomSetAtomIndex();
        int n4 = this.atomCount;
        if (string.indexOf("#<") >= 0) {
            n2 = Math.min(n2, Parser.parseInt(string.substring(string.indexOf("#<") + 2)) - 1);
            string = TextFormat.simpleReplace(string, "#<", "_<");
        }
        for (n = n3; n < n4; ++n) {
            this.atoms[n].bsSymmetry = BSUtil.newAndSetBit(0);
        }
        for (n = 1; n < n2; ++n) {
            if (string.indexOf("!#") >= 0 ? string.indexOf("!#" + (n + 1) + ";") >= 0 : string.indexOf("#") >= 0 && string.indexOf("#" + (n + 1) + ";") < 0) continue;
            Matrix4f matrix4f = (Matrix4f)jmolList.get(n);
            for (int i = n3; i < n4; ++i) {
                if (this.bsAtoms != null && !this.bsAtoms.get(i)) continue;
                try {
                    int n5 = this.atoms[i].atomSite;
                    if (bl2) {
                        nArray[n5] = this.atomCount;
                    }
                    Atom atom = this.newCloneAtom(this.atoms[i]);
                    if (this.bsAtoms != null) {
                        this.bsAtoms.set(atom.index);
                    }
                    atom.atomSite = n5;
                    matrix4f.transform(atom);
                    atom.bsSymmetry = BSUtil.newAndSetBit(n);
                    if (!bl2) continue;
                    for (int j = this.bondIndex0; j < this.bondCount0; ++j) {
                        Bond bond = this.bonds[j];
                        int n6 = nArray[this.atoms[bond.atomIndex1].atomSite];
                        int n7 = nArray[this.atoms[bond.atomIndex2].atomSite];
                        if (n6 < n4 && n7 < n4) continue;
                        this.addNewBondWithOrder(n6, n7, bond.order);
                    }
                    continue;
                }
                catch (Exception exception) {
                    this.errorMessage = "appendAtomCollection error: " + exception;
                }
            }
            matrix4f.m03 /= fArray[0];
            matrix4f.m13 /= fArray[1];
            matrix4f.m23 /= fArray[2];
            if (this.symmetry == null || n <= 0) continue;
            this.symmetry.addSpaceGroupOperationM(matrix4f);
        }
        n = n4 - n3;
        this.setAtomSetAuxiliaryInfo("presymmetryAtomIndex", n3);
        this.setAtomSetAuxiliaryInfo("presymmetryAtomCount", n);
        this.setAtomSetAuxiliaryInfo("biosymmetryCount", n2);
        if (this.symmetry != null) {
            this.finalizeSymmetry(n3, n);
            this.setSymmetryOps();
        }
        this.symmetry = null;
        this.coordinatesAreFractional = false;
        this.setAtomSetAuxiliaryInfo("hasSymmetry", Boolean.TRUE);
        this.setGlobalBoolean(1);
    }

    private void mapMostRecentAtomName() {
        if (this.atomCount > 0) {
            int n = this.atomCount - 1;
            String string = this.atoms[n].atomName;
            if (string != null) {
                this.atomSymbolicMap.put(string, n);
            }
        }
    }

    public void clearSymbolicMap() {
        this.atomSymbolicMap.clear();
        this.haveMappedSerials = false;
    }

    private void mapMostRecentAtomSerialNumber() {
        if (this.atomCount == 0) {
            return;
        }
        int n = this.atomCount - 1;
        int n2 = this.atoms[n].atomSerial;
        if (n2 != Integer.MIN_VALUE) {
            this.atomSymbolicMap.put(n2, n);
        }
        this.haveMappedSerials = true;
    }

    public void createAtomSerialMap() {
        if (this.haveMappedSerials || this.currentAtomSetIndex < 0) {
            return;
        }
        for (int i = this.getLastAtomSetAtomCount(); i < this.atomCount; ++i) {
            int n = this.atoms[i].atomSerial;
            if (n == Integer.MIN_VALUE) continue;
            this.atomSymbolicMap.put(n, i);
        }
        this.haveMappedSerials = true;
    }

    public int getAtomIndexFromName(String string) {
        return this.getMapIndex(string);
    }

    public int getAtomIndexFromSerial(int n) {
        return this.getMapIndex(n);
    }

    private int getMapIndex(Object object) {
        Integer n = this.atomSymbolicMap.get(object);
        return n == null ? -1 : n;
    }

    public void setAtomSetCollectionAuxiliaryInfo(String string, Object object) {
        if (object == null) {
            this.atomSetCollectionAuxiliaryInfo.remove(string);
        } else {
            this.atomSetCollectionAuxiliaryInfo.put(string, object);
        }
    }

    public boolean setAtomSetCollectionPartialCharges(String string) {
        if (!this.atomSetCollectionAuxiliaryInfo.containsKey(string)) {
            return false;
        }
        JmolList jmolList = (JmolList)this.atomSetCollectionAuxiliaryInfo.get(string);
        int n = jmolList.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)jmolList.get(n)).floatValue();
        }
        Logger.info("Setting partial charges type " + string);
        return true;
    }

    public void mapPartialCharge(String string, float f) {
        this.atoms[this.getAtomIndexFromName((String)string)].partialCharge = f;
    }

    public Object getAtomSetCollectionAuxiliaryInfo(String string) {
        return this.atomSetCollectionAuxiliaryInfo.get(string);
    }

    private void addTrajectoryStep() {
        int n;
        P3[] p3Array = new P3[this.atomCount];
        boolean bl = this.atomCount > 0 && this.atoms[0] != null && !Float.isNaN(this.atoms[0].z);
        V3[] v3Array = bl ? new V3[this.atomCount] : null;
        P3[] p3Array2 = this.trajectoryStepCount == 0 ? null : (P3[])this.trajectorySteps.get(this.trajectoryStepCount - 1);
        for (n = 0; n < this.atomCount; ++n) {
            P3 p3 = P3.newP(this.atoms[n]);
            if (this.doFixPeriodic && p3Array2 != null) {
                p3 = AtomSetCollection.fixPeriodic(p3, p3Array2[n]);
            }
            p3Array[n] = p3;
            if (!bl) continue;
            v3Array[n] = this.atoms[n].vib;
        }
        if (bl) {
            if (this.vibrationSteps == null) {
                this.vibrationSteps = new JmolList();
                for (n = 0; n < this.trajectoryStepCount; ++n) {
                    this.vibrationSteps.addLast(null);
                }
            }
            this.vibrationSteps.addLast(v3Array);
        }
        this.trajectorySteps.addLast(p3Array);
        ++this.trajectoryStepCount;
    }

    private static P3 fixPeriodic(P3 p3, P3 p32) {
        p3.x = AtomSetCollection.fixPoint(p3.x, p32.x);
        p3.y = AtomSetCollection.fixPoint(p3.y, p32.y);
        p3.z = AtomSetCollection.fixPoint(p3.z, p32.z);
        return p3;
    }

    private static float fixPoint(float f, float f2) {
        while ((double)(f - f2) > 0.9) {
            f -= 1.0f;
        }
        while ((double)(f - f2) < -0.9) {
            f += 1.0f;
        }
        return f;
    }

    public void finalizeTrajectoryAs(JmolList<P3[]> jmolList, JmolList<V3[]> jmolList2) {
        this.trajectorySteps = jmolList;
        this.vibrationSteps = jmolList2;
        this.trajectoryStepCount = jmolList.size();
        this.finalizeTrajectory();
    }

    private void finalizeTrajectory() {
        if (this.trajectoryStepCount == 0) {
            return;
        }
        P3[] p3Array = (P3[])this.trajectorySteps.get(0);
        V3[] v3Array = this.vibrationSteps == null ? null : (V3[])this.vibrationSteps.get(0);
        V3 v3 = new V3();
        if (this.vibrationSteps != null && v3Array != null && v3Array.length < this.atomCount || p3Array.length < this.atomCount) {
            this.errorMessage = "File cannot be loaded as a trajectory";
            return;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            if (this.vibrationSteps != null) {
                V3 v32 = this.atoms[i].vib = v3Array == null ? v3 : v3Array[i];
            }
            if (p3Array[i] == null) continue;
            this.atoms[i].setT(p3Array[i]);
        }
        this.setAtomSetCollectionAuxiliaryInfo("trajectorySteps", this.trajectorySteps);
        if (this.vibrationSteps != null) {
            this.setAtomSetCollectionAuxiliaryInfo("vibrationSteps", this.vibrationSteps);
        }
    }

    public void newAtomSet() {
        this.newAtomSetClear(true);
    }

    public void newAtomSetClear(boolean bl) {
        if (!this.allowMultiple && this.currentAtomSetIndex >= 0) {
            this.discardPreviousAtoms();
        }
        this.bondIndex0 = this.bondCount;
        if (this.isTrajectory) {
            this.discardPreviousAtoms();
        }
        this.currentAtomSetIndex = this.atomSetCount++;
        if (this.atomSetCount > this.atomSetNumbers.length) {
            this.atomSetAtomIndexes = ArrayUtil.doubleLengthI(this.atomSetAtomIndexes);
            this.atomSetAtomCounts = ArrayUtil.doubleLengthI(this.atomSetAtomCounts);
            this.atomSetBondCounts = ArrayUtil.doubleLengthI(this.atomSetBondCounts);
            this.atomSetAuxiliaryInfo = (Map[])ArrayUtil.doubleLength(this.atomSetAuxiliaryInfo);
        }
        this.atomSetAtomIndexes[this.currentAtomSetIndex] = this.atomCount;
        if (this.atomSetCount + this.trajectoryStepCount > this.atomSetNumbers.length) {
            this.atomSetNumbers = ArrayUtil.doubleLengthI(this.atomSetNumbers);
        }
        if (this.isTrajectory) {
            this.atomSetNumbers[this.currentAtomSetIndex + this.trajectoryStepCount] = this.atomSetCount + this.trajectoryStepCount;
        } else {
            this.atomSetNumbers[this.currentAtomSetIndex] = this.atomSetCount;
        }
        if (bl) {
            this.atomSymbolicMap.clear();
        }
        this.setAtomSetAuxiliaryInfo("title", this.collectionName);
    }

    public int getAtomSetAtomIndex(int n) {
        return this.atomSetAtomIndexes[n];
    }

    public int getAtomSetAtomCount(int n) {
        return this.atomSetAtomCounts[n];
    }

    public int getAtomSetBondCount(int n) {
        return this.atomSetBondCounts[n];
    }

    public void setAtomSetName(String string) {
        if (this.isTrajectory) {
            this.setTrajectoryName(string);
            return;
        }
        this.setAtomSetAuxiliaryInfoForSet("name", string, this.currentAtomSetIndex);
        if (!this.allowMultiple) {
            this.setCollectionName(string);
        }
    }

    private void setTrajectoryName(String string) {
        if (this.trajectoryStepCount == 0) {
            return;
        }
        if (this.trajectoryNames == null) {
            this.trajectoryNames = new JmolList();
        }
        for (int i = this.trajectoryNames.size(); i < this.trajectoryStepCount; ++i) {
            this.trajectoryNames.addLast(null);
        }
        this.trajectoryNames.set(this.trajectoryStepCount - 1, string);
    }

    public void setAtomSetNames(String string, int n, BS bS) {
        for (int i = this.currentAtomSetIndex; --n >= 0 && i >= 0; --i) {
            if (bS != null && bS.get(i)) continue;
            this.setAtomSetAuxiliaryInfoForSet("name", string, i);
        }
    }

    public void setCurrentAtomSetNumber(int n) {
        this.setAtomSetNumber(this.currentAtomSetIndex + (this.isTrajectory ? this.trajectoryStepCount : 0), n);
    }

    public void setAtomSetNumber(int n, int n2) {
        this.atomSetNumbers[n] = n2;
    }

    public void setAtomSetModelProperty(String string, String string2) {
        this.setAtomSetModelPropertyForSet(string, string2, this.currentAtomSetIndex);
    }

    public void setAtomSetModelPropertyForSet(String string, String string2, int n) {
        Properties properties = (Properties)this.getAtomSetAuxiliaryInfoValue(n, "modelProperties");
        if (properties == null) {
            properties = new Properties();
            this.setAtomSetAuxiliaryInfoForSet("modelProperties", properties, n);
        }
        properties.put(string, string2);
    }

    public void setAtomSetAtomProperty(String string, String string2, int n) {
        Hashtable<String, String> hashtable;
        if (!string2.endsWith("\n")) {
            string2 = string2 + "\n";
        }
        if (n < 0) {
            n = this.currentAtomSetIndex;
        }
        if ((hashtable = (Hashtable<String, String>)this.getAtomSetAuxiliaryInfoValue(n, "atomProperties")) == null) {
            hashtable = new Hashtable<String, String>();
            this.setAtomSetAuxiliaryInfoForSet("atomProperties", hashtable, n);
        }
        hashtable.put(string, string2);
    }

    private void appendAtomProperties(int n) {
        Map map = (Map)this.getAtomSetAuxiliaryInfoValue(-1, "atomProperties");
        if (map == null) {
            return;
        }
        for (Map.Entry entry : map.entrySet()) {
            String string = (String)entry.getKey();
            String string2 = (String)entry.getValue();
            SB sB = new SB();
            int n2 = n;
            while (--n2 >= 0) {
                sB.append(string2);
            }
            map.put(string, sB.toString());
        }
    }

    boolean setAtomSetPartialCharges(String string) {
        if (!this.atomSetAuxiliaryInfo[this.currentAtomSetIndex].containsKey(string)) {
            return false;
        }
        JmolList jmolList = (JmolList)this.getAtomSetAuxiliaryInfoValue(this.currentAtomSetIndex, string);
        int n = jmolList.size();
        while (--n >= 0) {
            this.atoms[n].partialCharge = ((Float)jmolList.get(n)).floatValue();
        }
        return true;
    }

    public Object getAtomSetAuxiliaryInfoValue(int n, String string) {
        return this.atomSetAuxiliaryInfo[n >= 0 ? n : this.currentAtomSetIndex].get(string);
    }

    public void setAtomSetAuxiliaryInfo(String string, Object object) {
        this.setAtomSetAuxiliaryInfoForSet(string, object, this.currentAtomSetIndex);
    }

    public void setAtomSetAuxiliaryInfoForSet(String string, Object object, int n) {
        if (n < 0) {
            return;
        }
        if (this.atomSetAuxiliaryInfo[n] == null) {
            this.atomSetAuxiliaryInfo[n] = new Hashtable<String, Object>();
        }
        if (object == null) {
            this.atomSetAuxiliaryInfo[n].remove(string);
        } else {
            this.atomSetAuxiliaryInfo[n].put(string, object);
        }
    }

    public void setAtomSetPropertyForSets(String string, String string2, int n) {
        for (int i = this.currentAtomSetIndex; --n >= 0 && i >= 0; --i) {
            this.setAtomSetModelPropertyForSet(string, string2, i);
        }
    }

    public void cloneLastAtomSetProperties() {
        this.cloneAtomSetProperties(this.currentAtomSetIndex - 1);
    }

    void cloneAtomSetProperties(int n) {
        Properties properties = (Properties)this.getAtomSetAuxiliaryInfoValue(n, "modelProperties");
        if (properties != null) {
            this.setAtomSetAuxiliaryInfoForSet("modelProperties", properties.clone(), this.currentAtomSetIndex);
        }
    }

    int getAtomSetNumber(int n) {
        return this.atomSetNumbers[n >= this.atomSetCount ? 0 : n];
    }

    String getAtomSetName(int n) {
        if (this.trajectoryNames != null && n < this.trajectoryNames.size()) {
            return (String)this.trajectoryNames.get(n);
        }
        if (n >= this.atomSetCount) {
            n = this.atomSetCount - 1;
        }
        return (String)this.getAtomSetAuxiliaryInfoValue(n, "name");
    }

    Map<String, Object> getAtomSetAuxiliaryInfo(int n) {
        return this.atomSetAuxiliaryInfo[n >= this.atomSetCount ? this.atomSetCount - 1 : n];
    }

    public Properties setAtomNames(Properties properties) {
        if (properties == null) {
            return null;
        }
        for (int i = 0; i < this.atomCount; ++i) {
            String string = properties.getProperty(this.atoms[i].atomName);
            if (string == null) continue;
            this.atoms[i].atomName = string;
        }
        return null;
    }

    public void setAtomSetEnergy(String string, float f) {
        if (this.currentAtomSetIndex < 0) {
            return;
        }
        Logger.info("Energy for model " + (this.currentAtomSetIndex + 1) + " = " + string);
        this.setAtomSetAuxiliaryInfo("EnergyString", string);
        this.setAtomSetAuxiliaryInfo("Energy", Float.valueOf(f));
        this.setAtomSetModelProperty("Energy", "" + f);
    }

    public String setAtomSetFrequency(String string, String string2, String string3, String string4) {
        string3 = string3 + " " + (string4 == null ? "cm^-1" : string4);
        String string5 = (string2 == null ? "" : string2 + " ") + string3;
        this.setAtomSetName(string5);
        this.setAtomSetModelProperty("Frequency", string3);
        if (string2 != null) {
            this.setAtomSetModelProperty("FrequencyLabel", string2);
        }
        this.setAtomSetModelProperty(".PATH", (string == null ? "" : string + SmarterJmolAdapter.PATH_SEPARATOR + "Frequencies") + "Frequencies");
        return string5;
    }

    void toCartesian(SymmetryInterface symmetryInterface) {
        for (int i = this.getLastAtomSetAtomIndex(); i < this.atomCount; ++i) {
            symmetryInterface.toCartesian(this.atoms[i], true);
        }
    }

    public String[][] getBondList() {
        String[][] stringArray = new String[this.bondCount][];
        for (int i = 0; i < this.bondCount; ++i) {
            stringArray[i] = new String[]{this.atoms[this.bonds[i].atomIndex1].atomName, this.atoms[this.bonds[i].atomIndex2].atomName, "" + this.bonds[i].order};
        }
        return stringArray;
    }

    public void centralize() {
        P3 p3 = new P3();
        for (int i = 0; i < this.atomSetCount; ++i) {
            int n = this.atomSetAtomCounts[i];
            int n2 = this.atomSetAtomIndexes[i];
            p3.set(0.0f, 0.0f, 0.0f);
            int n3 = n2 + n;
            while (--n3 >= n2) {
                p3.x += this.atoms[n3].x;
                p3.y += this.atoms[n3].y;
                p3.z += this.atoms[n3].z;
            }
            p3.scale(1.0f / (float)n);
            n3 = n2 + n;
            while (--n3 >= n2) {
                this.atoms[n3].x -= p3.x;
                this.atoms[n3].y -= p3.y;
                this.atoms[n3].z -= p3.z;
            }
        }
    }

    void mergeTrajectories(AtomSetCollection atomSetCollection) {
        if (!this.isTrajectory || !atomSetCollection.isTrajectory || this.vibrationSteps != null) {
            return;
        }
        for (int i = 0; i < atomSetCollection.trajectoryStepCount; ++i) {
            this.trajectorySteps.add(this.trajectoryStepCount++, atomSetCollection.trajectorySteps.get(i));
        }
        this.setAtomSetCollectionAuxiliaryInfo("trajectorySteps", this.trajectorySteps);
    }
}

