/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Hashtable;
import org.jmol.adapter.readers.quantum.MOReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.ArrayUtil;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;

public class JaguarReader
extends MOReader {
    private int moCount = 0;
    private float lumoEnergy = Float.MAX_VALUE;
    private static final float ROOT3 = 1.7320508f;
    private boolean haveLine;

    protected boolean checkLine() throws Exception {
        if (this.line.startsWith(" Input geometry:") || this.line.startsWith(" Symmetrized geometry:") || this.line.startsWith("  final geometry:")) {
            this.readAtoms();
            return true;
        }
        if (this.line.startsWith("  Atomic charges from electrostatic potential:")) {
            this.readCharges();
            return true;
        }
        if (this.line.startsWith("  number of basis functions....")) {
            this.moCount = this.parseIntStr(this.line.substring(32).trim());
            return true;
        }
        if (this.line.startsWith("  basis set:")) {
            this.moData.put("energyUnits", "");
            this.calculationType = this.line.substring(13).trim();
            this.moData.put("calculationType", this.calculationType);
            return true;
        }
        if (this.line.indexOf("XXXXXShell information") >= 0) {
            this.readUnnormalizedBasis();
            return true;
        }
        if (this.line.indexOf("Normalized coefficients") >= 0) {
            this.readBasisNormalized();
            return true;
        }
        if (this.line.startsWith(" LUMO energy:")) {
            this.lumoEnergy = this.parseFloatStr(this.line.substring(13));
            return true;
        }
        if (this.line.indexOf("final wvfn") >= 0) {
            this.readJaguarMolecularOrbitals();
            return true;
        }
        if (this.line.startsWith("  harmonic frequencies in")) {
            this.readFrequencies();
            this.continuing = false;
            return false;
        }
        return this.checkNboLine();
    }

    private void readAtoms() throws Exception {
        this.atomSetCollection.discardPreviousAtoms();
        this.readLines(2);
        int n = 0;
        while (this.readLine() != null && this.line.length() >= 60 && this.line.charAt(2) != ' ') {
            String[] stringArray = this.getTokens();
            String string = stringArray[0];
            float f = this.parseFloatStr(stringArray[1]);
            float f2 = this.parseFloatStr(stringArray[2]);
            float f3 = this.parseFloatStr(stringArray[3]);
            if (Float.isNaN(f) || Float.isNaN(f2) || Float.isNaN(f3) || string.length() < 2) {
                return;
            }
            char c = string.charAt(1);
            String string2 = c >= 'a' && c <= 'z' ? string.substring(0, 2) : string.substring(0, 1);
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.elementSymbol = string2;
            atom.atomName = string;
            this.setAtomCoordXYZ(atom, f, f2, f3);
            ++n;
        }
    }

    private void readCharges() throws Exception {
        int n = 0;
        while (this.readLine() != null && this.line.indexOf("sum") < 0) {
            if (this.line.indexOf("Charge") < 0) continue;
            String[] stringArray = this.getTokens();
            for (int i = 1; i < stringArray.length; ++i) {
                this.atomSetCollection.getAtom((int)n++).partialCharge = this.parseFloatStr(stringArray[i]);
            }
        }
    }

    private void readUnnormalizedBasis() throws Exception {
        int n;
        int n2;
        String[] stringArray;
        String string = "";
        int n3 = -1;
        int[][] nArray = new int[this.moCount][4];
        JmolList<T>[] jmolListArray = ArrayUtil.createArrayOfArrayList(this.moCount);
        this.gaussianCount = 0;
        this.discardLinesUntilContains("--------");
        while (this.readLine() != null && (stringArray = this.getTokens()).length == 9) {
            int n4 = this.parseIntStr(stringArray[2]);
            if (n4 <= 0) continue;
            if (!stringArray[0].equals(string)) {
                ++n3;
            }
            string = stringArray[0];
            int n5 = this.parseIntStr(stringArray[5]);
            n2 = this.parseIntStr(stringArray[4]);
            if (n2 <= 2) {
                --n2;
            }
            if (jmolListArray[n5] == null) {
                nArray[n5][0] = n3;
                nArray[n5][1] = n2;
                nArray[n5][2] = 0;
                nArray[n5][3] = 0;
                jmolListArray[n5] = new JmolList();
            }
            float f = 1.0f;
            jmolListArray[n5].addLast(new float[]{this.parseFloatStr(stringArray[6]), this.parseFloatStr(stringArray[8]) * f});
            this.gaussianCount += n4;
            n = n4 - 1;
            while (--n >= 0) {
                stringArray = JaguarReader.getTokensStr(this.readLine());
                jmolListArray[n5].addLast(new float[]{this.parseFloatStr(stringArray[6]), this.parseFloatStr(stringArray[8]) * f});
            }
        }
        float[][] fArray = ArrayUtil.newFloat2(this.gaussianCount);
        JmolList<int[]> jmolList = new JmolList<int[]>();
        this.gaussianCount = 0;
        for (n2 = 0; n2 < this.moCount; ++n2) {
            if (jmolListArray[n2] == null) continue;
            int n6 = jmolListArray[n2].size();
            nArray[n2][2] = this.gaussianCount;
            nArray[n2][3] = n6;
            for (n = 0; n < n6; ++n) {
                fArray[this.gaussianCount++] = (float[])jmolListArray[n2].get(n);
            }
            jmolList.addLast(nArray[n2]);
        }
        this.moData.put("shells", jmolList);
        this.moData.put("gaussians", fArray);
        if (Logger.debugging) {
            Logger.debug(jmolList.size() + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
    }

    private void readBasisNormalized() throws Exception {
        int n;
        Object object;
        Object object2 = "";
        int n2 = -1;
        int n3 = 0;
        int n4 = -1;
        JmolList<int[]> jmolList = new JmolList<int[]>();
        JmolList<float[]> jmolList2 = new JmolList<float[]>();
        this.gaussianCount = 0;
        int[] nArray = null;
        this.discardLinesUntilContains("--------");
        while (this.readLine() != null && this.line.length() > 3) {
            float[] fArray;
            object = this.getTokens();
            if (((float[][])object).length == 4) {
                fArray = object[0];
                continue;
            }
            if (!object[0].equals(object2)) {
                ++n2;
            }
            object2 = object[0];
            fArray = object[2];
            n = JmolAdapter.getQuantumShellTagID((String)fArray);
            n3 = this.parseIntStr((String)object[3]) - 1;
            if (n3 != n4) {
                nArray = new int[]{n2, n, this.gaussianCount, 0};
                jmolList.addLast(nArray);
                n4 = n3;
            }
            ++this.gaussianCount;
            nArray[3] = nArray[3] + true;
            float f = this.parseFloatStr((String)object[4]);
            float f2 = this.parseFloatStr((String)object[5]);
            if (fArray.equals("XX")) {
                f2 *= 1.7320508f;
            }
            jmolList2.addLast(new float[]{f, f2});
        }
        object = ArrayUtil.newFloat2(this.gaussianCount);
        n = jmolList2.size();
        while (--n >= 0) {
            object[n] = (float[])jmolList2.get(n);
        }
        this.moData.put("shells", jmolList);
        this.moData.put("gaussians", object);
        if (Logger.debugging) {
            Logger.debug(jmolList.size() + " slater shells read");
            Logger.debug(this.gaussianCount + " gaussian primitives read");
        }
        this.moData.put("isNormalized", Boolean.TRUE);
    }

    private void readJaguarMolecularOrbitals() throws Exception {
        String[][] stringArray = new String[this.moCount][];
        this.readLine();
        this.readLine();
        this.readLine();
        int n = 0;
        while (this.line != null) {
            this.readLine();
            this.readLine();
            this.readLine();
            if (this.line == null || this.line.indexOf("eigenvalues-") < 0) break;
            String[] stringArray2 = this.getTokens();
            int n2 = stringArray2.length - 1;
            this.fillDataBlock(stringArray, 0);
            for (int i = 0; i < n2; ++i) {
                float[] fArray = new float[this.moCount];
                Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
                float f = this.parseFloatStr(stringArray2[i + 1]);
                hashtable.put("energy", Float.valueOf(f));
                if ((double)Math.abs(f - this.lumoEnergy) < 1.0E-4) {
                    this.moData.put("HOMO", n);
                    this.lumoEnergy = Float.MAX_VALUE;
                }
                ++n;
                int n3 = 0;
                for (int j = 0; j < this.moCount; ++j) {
                    fArray[n3++] = this.parseFloatStr(stringArray[j][i + 3]);
                }
                hashtable.put("coefficients", fArray);
                this.setMO(hashtable);
            }
        }
        this.moData.put("mos", this.orbitals);
        this.finalizeMOData(this.moData);
    }

    private void readFrequencies() throws Exception {
        int n = this.atomSetCollection.getLastAtomSetAtomCount();
        this.discardLinesUntilStartsWith("  frequencies ");
        while (this.line != null && this.line.startsWith("  frequencies ")) {
            int n2 = this.atomSetCollection.getAtomCount();
            String[] stringArray = this.getTokens();
            int n3 = stringArray.length - 1;
            boolean[] blArray = new boolean[n3];
            String[] stringArray2 = null;
            String[] stringArray3 = null;
            while (this.line != null && this.line.charAt(2) != ' ') {
                if (this.line.indexOf("symmetries") >= 0) {
                    stringArray2 = this.getTokens();
                } else if (this.line.indexOf("intensities") >= 0) {
                    stringArray3 = this.getTokens();
                }
                this.readLine();
            }
            for (int i = 0; i < n3; ++i) {
                boolean bl = blArray[i] = !this.doGetVibration(++this.vibrationNumber);
                if (blArray[i]) continue;
                this.atomSetCollection.cloneFirstAtomSet(0);
                this.atomSetCollection.setAtomSetFrequency(null, stringArray2 == null ? null : stringArray2[i + 1], stringArray[i + 1], null);
                if (stringArray3 == null) continue;
                this.atomSetCollection.setAtomSetModelProperty("IRIntensity", stringArray3[i + 1] + " km/mol");
            }
            this.haveLine = true;
            this.fillFrequencyData(n2, n, n, blArray, false, 0, 0, null, 0);
            this.readLine();
            this.readLine();
        }
    }

    public String readLine() throws Exception {
        if (!this.haveLine) {
            return super.readLine();
        }
        this.haveLine = false;
        return this.line;
    }
}

