/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.pymol;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.readers.pdb.PdbReader;
import org.jmol.adapter.readers.pymol.PickleReader;
import org.jmol.adapter.readers.pymol.PyMOL;
import org.jmol.adapter.readers.pymol.PyMOLGroup;
import org.jmol.adapter.readers.pymol.PyMOLScene;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Bond;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolDocument;
import org.jmol.api.PymolAtomReader;
import org.jmol.constant.EnumStructure;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.BoxInfo;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.P3;
import org.jmol.util.TextFormat;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PyMOLReader
extends PdbReader
implements PymolAtomReader {
    private static final int MIN_RESNO = -1000;
    private static String nucleic = " A C G T U ADE THY CYT GUA URI DA DC DG DT DU ";
    private boolean allowSurface = true;
    private boolean doResize;
    private boolean doCache;
    private boolean isStateScript;
    private boolean sourcePNGJ;
    private int atomCount0;
    private int atomCount;
    private int stateCount;
    private int structureCount;
    private boolean isHidden;
    private BS bsStructureDefined = new BS();
    private BS bsBytesExcluded;
    private int[] atomMap;
    private Map<String, BS> ssMapSeq;
    private PyMOLScene pymolScene;
    private P3 xyzMin = P3.new3(1000000.0f, 1000000.0f, 1000000.0f);
    private P3 xyzMax = P3.new3(-1000000.0f, -1000000.0f, -1000000.0f);
    private int nModels;
    private boolean logging;
    private BS[] reps = new BS[23];
    private boolean isMovie;
    private int pymolFrame;
    private boolean allStates;
    private int totalAtomCount;
    private int pymolVersion;
    private P3[] trajectoryStep;
    private int trajectoryPtr;
    private String objectName;
    private Map<String, JmolList<Object>> volumeData;
    private JmolList<JmolList<Object>> mapObjects;
    private boolean haveMeasurements;
    private int[] frames;
    private Hashtable<Integer, JmolList<Object>> uniqueSettings;
    private Atom[] atoms;
    private boolean haveScenes;
    private int baseAtomIndex;
    private int baseModelIndex;
    private JmolList<Object> sceneOrder;
    private int bondCount;

    @Override
    protected void setup(String string, Map<String, Object> map, Object object) {
        this.mustFinalizeModelSet = true;
        this.isBinary = true;
        this.setupASCR(string, map, object);
    }

    @Override
    protected void initializeReader() throws Exception {
        this.baseAtomIndex = (Integer)this.htParams.get("baseAtomIndex");
        this.baseModelIndex = (Integer)this.htParams.get("baseModelIndex");
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("noAutoBond", Boolean.TRUE);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("pdbNoHydrogens", Boolean.TRUE);
        this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("isPyMOL", Boolean.TRUE);
        if (this.isTrajectory) {
            this.trajectorySteps = new JmolList();
        }
        this.isStateScript = this.htParams.containsKey("isStateScript");
        this.sourcePNGJ = this.htParams.containsKey("sourcePNGJ");
        this.doResize = this.checkFilterKey("DORESIZE");
        this.allowSurface = !this.checkFilterKey("NOSURFACE");
        this.doCache = this.checkFilterKey("DOCACHE");
        if (this.doCache && this.sourcePNGJ) {
            this.doCache = false;
        } else if (this.sourcePNGJ && !this.doCache) {
            this.sourcePNGJ = false;
        }
        if (this.doCache) {
            this.bsBytesExcluded = new BS();
        }
        this.logging = false;
        super.initializeReader();
    }

    @Override
    public void processBinaryDocument(JmolDocument jmolDocument) throws Exception {
        PickleReader pickleReader = new PickleReader(jmolDocument, this.viewer);
        Map<String, Object> map = pickleReader.getMap(this.logging);
        pickleReader = null;
        this.process(map);
    }

    @Override
    protected void setAdditionalAtomParameters(Atom atom) {
    }

    @Override
    protected void finalizeReader() throws Exception {
        this.finalizeReaderPDB();
        this.atomSetCollection.setTensors();
    }

    @Override
    public void finalizeModelSet() {
        Object object;
        this.pymolScene.setReaderObjects();
        if (this.haveMeasurements) {
            this.appendLoadNote(this.viewer.getMeasurementInfoAsString());
            this.setLoadNote();
        }
        if (this.haveScenes) {
            String[] stringArray = new String[this.sceneOrder.size()];
            int n = stringArray.length;
            while (--n >= 0) {
                stringArray[n] = (String)this.sceneOrder.get(n);
            }
            object = this.viewer.getModelSetAuxiliaryInfo();
            object.put((String)"scenes", (Object)stringArray);
        }
        this.viewer.setTrajectoryBs(BSUtil.newBitSet2(this.baseModelIndex, this.viewer.modelSet.modelCount));
        if (!this.isStateScript) {
            this.pymolScene.setFrameObject(0, null);
        }
        if (this.bsBytesExcluded != null) {
            int n = this.bsBytesExcluded.cardinality();
            object = (byte[])this.viewer.getFileAsBytes(this.filePath, null);
            byte[] byArray = new byte[((Object)object).length - n];
            int n2 = this.bsBytesExcluded.nextClearBit(0);
            int n3 = ((Object)object).length;
            int n4 = 0;
            while (n2 < n3) {
                byArray[n4++] = (byte)object[n2];
                n2 = this.bsBytesExcluded.nextClearBit(n2 + 1);
            }
            object = null;
            String string = this.filePath;
            this.viewer.cachePut(string, byArray);
        }
    }

    private void process(Map<String, Object> map) {
        int n;
        int n2;
        JmolList<Object> jmolList;
        String string;
        this.pymolVersion = (Integer)map.get("version");
        this.appendLoadNote("PyMOL version: " + this.pymolVersion);
        JmolList<Object> jmolList2 = PyMOLReader.getMapList(map, "settings");
        this.sceneOrder = PyMOLReader.getMapList(map, "scene_order");
        this.haveScenes = this.getFrameScenes(map);
        JmolList<Object> jmolList3 = this.listAt(jmolList2, 440);
        if (jmolList3 != null) {
            Logger.info("PyMOL session file: " + jmolList3.get(2));
        }
        this.setUniqueSettings(PyMOLReader.getMapList(map, "unique_settings"));
        this.pymolScene = new PyMOLScene(this, this.viewer, jmolList2, this.uniqueSettings, this.pymolVersion, this.haveScenes, this.baseAtomIndex, this.baseModelIndex, this.doCache, this.filePath);
        this.logging = this.viewer.getLogFileName().length() > 0;
        JmolList<Object> jmolList4 = PyMOLReader.getMapList(map, "names");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            string = entry.getKey();
            Logger.info(string);
            if (!string.equals("names")) continue;
            for (int i = 1; i < jmolList4.size(); ++i) {
                JmolList<Object> jmolList5 = this.listAt(jmolList4, i);
                Logger.info("  " + PyMOLReader.stringAt(jmolList5, 0));
            }
        }
        if (this.logging) {
            if (this.logging) {
                this.viewer.log("$CLEAR$");
            }
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                string = entry.getKey();
                if ("names".equals(string)) continue;
                this.viewer.log("\n===" + string + "===");
                this.viewer.log(TextFormat.simpleReplace(entry.getValue().toString(), "[", "\n["));
            }
            this.viewer.log("\n===names===");
            for (int i = 1; i < jmolList4.size(); ++i) {
                Map.Entry<String, Object> entry;
                this.viewer.log("");
                entry = (JmolList)jmolList4.get(i);
                this.viewer.log(" =" + ((ArrayList)((Object)entry)).get(0).toString() + "=");
                try {
                    this.viewer.log(TextFormat.simpleReplace(((AbstractCollection)((Object)entry)).toString(), "[", "\n["));
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
        this.addColors(PyMOLReader.getMapList(map, "colors"), this.pymolScene.globalSetting(214) != 0.0f);
        this.allStates = this.pymolScene.globalSetting(49) != 0.0f;
        this.pymolFrame = (int)this.pymolScene.globalSetting(194);
        this.getAtomAndStateCount(jmolList4);
        this.pymolScene.setStateCount(this.stateCount);
        int n3 = (int)this.pymolScene.globalSetting(193);
        if (!this.isMovie) {
            this.pymolScene.setFrameObject(4115, this.allStates ? Integer.valueOf(-1) : Integer.valueOf(n3 - 1));
        }
        this.appendLoadNote("frame=" + this.pymolFrame + " state=" + n3 + " all_states=" + this.allStates);
        if (!this.isStateScript && this.doResize) {
            String string2;
            int n4 = 0;
            int n5 = 0;
            try {
                n4 = PyMOLReader.intAt(PyMOLReader.getMapList(map, "main"), 0);
                n5 = PyMOLReader.intAt(PyMOLReader.getMapList(map, "main"), 1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (n4 > 0 && n5 > 0) {
                string2 = "PyMOL dimensions width=" + n4 + " height=" + n5;
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("perferredWidthHeight", new int[]{n4, n5});
                this.viewer.resizeInnerPanel(n4, n5);
            } else {
                string2 = "PyMOL dimensions?";
            }
            this.appendLoadNote(string2);
        }
        if (!this.isStateScript && !this.allStates && (jmolList = PyMOLReader.getMapList(map, "movie")) != null && (n2 = PyMOLReader.intAt(jmolList, 0)) > 0) {
            this.processMovie(jmolList, n2);
        }
        if (this.totalAtomCount == 0) {
            this.atomSetCollection.newAtomSet();
        }
        if (!this.allStates || this.desiredModelNumber != Integer.MIN_VALUE) {
            if (this.isMovie) {
                switch (this.desiredModelNumber) {
                    case -2147483648: {
                        break;
                    }
                    default: {
                        this.desiredModelNumber = this.frames[(this.desiredModelNumber > 0 && this.desiredModelNumber <= this.frames.length ? this.desiredModelNumber : this.pymolFrame) - 1];
                        this.pymolScene.setFrameObject(4115, this.desiredModelNumber - 1);
                        break;
                    }
                }
            } else if (this.desiredModelNumber == 0) {
                this.desiredModelNumber = n3;
            }
        }
        int n6 = jmolList4.size();
        for (n = 0; n < this.stateCount; ++n) {
            if (!this.doGetModel(++this.nModels, null)) continue;
            this.model(this.nModels);
            this.pymolScene.currentAtomSetIndex = this.atomSetCollection.getCurrentAtomSetIndex();
            if (this.isTrajectory) {
                this.trajectoryStep = new P3[this.totalAtomCount];
                this.trajectorySteps.addLast(this.trajectoryStep);
                this.trajectoryPtr = 0;
            }
            for (int i = 1; i < n6; ++i) {
                this.processObject(this.listAt(jmolList4, i), true, n);
            }
        }
        for (n = 1; n < n6; ++n) {
            this.processObject(this.listAt(jmolList4, n), false, 0);
        }
        this.pymolScene.setReaderObjectInfo(null, 0, null, false, null, null, null);
        if (this.mapObjects != null && this.allowSurface) {
            this.processMeshes();
        }
        if (this.isTrajectory) {
            this.appendLoadNote("PyMOL trajectories read: " + this.trajectorySteps.size());
            this.atomSetCollection.finalizeTrajectoryAs(this.trajectorySteps, null);
        }
        this.processDefinitions();
        this.processSelectionsAndScenes(map);
        this.pymolScene.finalizeVisibility();
        if (!this.isStateScript) {
            this.viewer.initialize(true);
            this.addJmolScript(this.pymolScene.getViewScript(PyMOLReader.getMapList(map, "view")).toString());
        }
        if (this.atomCount == 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("dataOnly", Boolean.TRUE);
        }
        this.pymolScene.offsetObjects();
    }

    private boolean getFrameScenes(Map<String, Object> map) {
        if (this.sceneOrder == null) {
            return false;
        }
        Map map2 = (Map)map.get("scene_dict");
        for (int i = 0; i < this.sceneOrder.size(); ++i) {
            String string = PyMOLReader.stringAt(this.sceneOrder, i);
            JmolList<Object> jmolList = PyMOLReader.getMapList(map2, string);
            if (jmolList != null && jmolList.get(2) != null) continue;
            this.sceneOrder.remove(i--);
        }
        return this.sceneOrder != null && this.sceneOrder.size() != 0;
    }

    private int setUniqueSettings(JmolList<Object> jmolList) {
        this.uniqueSettings = new Hashtable();
        int n = 0;
        if (jmolList != null && jmolList.size() != 0) {
            int n2 = jmolList.size();
            while (--n2 >= 0) {
                JmolList jmolList2 = (JmolList)jmolList.get(n2);
                int n3 = PyMOLReader.intAt(jmolList2, 0);
                if (n3 > n) {
                    n = n3;
                }
                JmolList jmolList3 = (JmolList)jmolList2.get(1);
                int n4 = jmolList3.size();
                while (--n4 >= 0) {
                    JmolList jmolList4 = (JmolList)jmolList3.get(n4);
                    int n5 = (n3 << 10) + PyMOLReader.intAt(jmolList4, 0);
                    this.uniqueSettings.put(n5, jmolList4);
                    Logger.info("PyMOL unique setting " + n3 + " " + jmolList4);
                }
            }
        }
        return n;
    }

    private void addColors(JmolList<Object> jmolList, boolean bl) {
        if (jmolList == null || jmolList.size() == 0) {
            return;
        }
        int n = jmolList.size();
        while (--n >= 0) {
            JmolList<Object> jmolList2 = this.listAt(jmolList, n);
            PyMOL.addColor((Integer)jmolList2.get(1), bl ? PyMOLScene.colorSettingClamped(jmolList2) : PyMOLScene.colorSetting(jmolList2));
        }
    }

    private void getAtomAndStateCount(JmolList<Object> jmolList) {
        int n = 0;
        for (int i = 1; i < jmolList.size(); ++i) {
            JmolList<Object> jmolList2 = this.listAt(jmolList, i);
            int n2 = PyMOLReader.intAt(jmolList2, 4);
            if (!this.checkObject(jmolList2) || n2 != 1) continue;
            JmolList<Object> jmolList3 = this.listAt(jmolList2, 5);
            JmolList<Object> jmolList4 = this.listAt(jmolList3, 4);
            int n3 = jmolList4.size();
            if (n3 > this.stateCount) {
                this.stateCount = n3;
            }
            int n4 = this.listAt(jmolList3, 7).size();
            for (int j = 0; j < n3; ++j) {
                JmolList<Object> jmolList5 = this.listAt(jmolList4, j);
                JmolList<Object> jmolList6 = this.listAt(jmolList5, 3);
                if (jmolList6 == null) {
                    this.isTrajectory = false;
                    continue;
                }
                int n5 = jmolList6.size();
                n += n5;
                if (!this.isTrajectory || n5 == n4) continue;
                this.isTrajectory = false;
            }
        }
        this.totalAtomCount = n;
        Logger.info("PyMOL total atom count = " + this.totalAtomCount);
        Logger.info("PyMOL state count = " + this.stateCount);
    }

    private boolean checkObject(JmolList<Object> jmolList) {
        this.objectName = PyMOLReader.stringAt(jmolList, 0);
        this.isHidden = PyMOLReader.intAt(jmolList, 2) != 1;
        return this.objectName.indexOf("_") != 0;
    }

    private void processMovie(JmolList<Object> jmolList, int n) {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("frameCount", n);
        hashtable.put("currentFrame", this.pymolFrame - 1);
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        JmolList<Object> jmolList2 = this.listAt(jmolList, 4);
        int n2 = jmolList2.size();
        while (--n2 >= 0) {
            if (PyMOLReader.intAt(jmolList2, n2) == 0) continue;
            this.frames = new int[jmolList2.size()];
            int n3 = this.frames.length;
            while (--n3 >= 0) {
                this.frames[n3] = PyMOLReader.intAt(jmolList2, n3) + 1;
            }
            hashtable.put("frames", this.frames);
            bl3 = true;
            break;
        }
        JmolList<Object> jmolList3 = this.listAt(jmolList, 5);
        int n4 = jmolList3.size();
        while (--n4 >= 0) {
            String string = PyMOLReader.stringAt(jmolList3, n4);
            if (string == null || string.length() <= 1 || (jmolList3 = PyMOLReader.fixMovieCommands(jmolList3)) == null) continue;
            hashtable.put("commands", jmolList3);
            bl = true;
            break;
        }
        JmolList<Object> jmolList4 = this.listAt(jmolList, 6);
        int n5 = jmolList4.size();
        while (--n5 >= 0) {
            JmolList<Object> jmolList5 = this.listAt(jmolList4, n5);
            if (jmolList5 == null || jmolList5.size() < 12 || jmolList5.get(1) == null) continue;
            bl2 = true;
            if ((jmolList4 = PyMOLReader.fixMovieViews(jmolList4)) == null) continue;
            hashtable.put("views", jmolList4);
            break;
        }
        this.appendLoadNote("PyMOL movie frameCount = " + n);
        if (bl3 && !bl && !bl2) {
            this.isMovie = true;
            this.pymolScene.setReaderObjectInfo(null, 0, null, false, null, null, null);
            this.pymolScene.setFrameObject(0x400000D0, hashtable);
        }
    }

    private static JmolList<Object> fixMovieViews(JmolList<Object> jmolList) {
        return jmolList;
    }

    private static JmolList<Object> fixMovieCommands(JmolList<Object> jmolList) {
        return jmolList;
    }

    private void processObject(JmolList<Object> jmolList, boolean bl, int n) {
        Cloneable cloneable;
        Object object;
        JmolList<Object> jmolList2;
        if (jmolList == null) {
            return;
        }
        int n2 = PyMOLReader.intAt(jmolList, 4);
        JmolList jmolList3 = (JmolList)jmolList.get(jmolList.size() - 1);
        if (n2 == 1 != bl || !this.checkObject(jmolList)) {
            return;
        }
        JmolList<Object> jmolList4 = this.listAt(jmolList, 5);
        JmolList<Object> jmolList5 = null;
        if (n2 == 1) {
            jmolList2 = this.listAt(jmolList4, 4);
            object = this.listAt(jmolList2, n);
            cloneable = this.listAt((JmolList<Object>)object, 3);
            if (n > 0 && (cloneable == null || cloneable.size() == 0)) {
                return;
            }
            jmolList5 = this.listAt((JmolList<Object>)object, 7);
        } else if (n > 0) {
            return;
        }
        Logger.info("PyMOL model " + this.nModels + " Object " + this.objectName + (this.isHidden ? " (hidden)" : " (visible)"));
        jmolList2 = this.listAt(jmolList4, 0);
        Object object2 = object = jmolList.size() < 8 ? null : PyMOLReader.stringAt(jmolList, 6);
        if (" ".equals(object)) {
            object = null;
        }
        this.pymolScene.setReaderObjectInfo(this.objectName, n2, (String)object, this.isHidden, this.listAt(jmolList2, 8), jmolList5, bl ? "_" + (n + 1) : "");
        cloneable = null;
        boolean bl2 = this.bsBytesExcluded != null;
        String string = null;
        switch (n2) {
            default: {
                string = "" + n2;
                break;
            }
            case -1: {
                break;
            }
            case 1: {
                bl2 = false;
                cloneable = this.processMolecule(jmolList4, n);
                break;
            }
            case 4: {
                bl2 = false;
                this.processMeasure(jmolList4);
                break;
            }
            case 2: 
            case 3: {
                this.processMap(jmolList4, n2 == 3, false);
                break;
            }
            case 8: {
                this.processGadget(jmolList4);
                break;
            }
            case 12: {
                if (object != null) break;
                object = "";
                break;
            }
            case 6: {
                string = "CGO";
                this.processCGO(jmolList4);
                break;
            }
            case 11: {
                string = "ALIGNEMENT";
                break;
            }
            case 9: {
                string = "CALCULATOR";
                break;
            }
            case 5: {
                string = "CALLBACK";
                break;
            }
            case 10: {
                string = "SLICE";
                break;
            }
            case 7: {
                string = "SURFACE";
            }
        }
        if (object != null || cloneable != null) {
            PyMOLGroup pyMOLGroup = this.pymolScene.addGroup(jmolList, (String)object, n2);
            if (cloneable != null) {
                cloneable = pyMOLGroup.addGroupAtoms((BS)cloneable);
            }
        }
        if (bl2) {
            int n3 = PyMOLReader.intAt(jmolList3, 0);
            int n4 = PyMOLReader.intAt(jmolList3, 1);
            this.bsBytesExcluded.setBits(n3, n3 + n4);
            Logger.info("cached PSE file excludes PyMOL object type " + n2 + " name=" + this.objectName + " len=" + n4);
        }
        if (string != null) {
            Logger.error("Unprocessed object type " + string + " " + this.objectName);
        }
    }

    private void processCGO(JmolList<Object> jmolList) {
        int n;
        if (this.isStateScript) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        JmolList<Object> jmolList2 = this.listAt(this.listAt(jmolList, 2), 0);
        String string = this.pymolScene.addCGO(jmolList2, n = PyMOL.getRGB(PyMOLReader.intAt(this.listAt(jmolList, 0), 2)));
        if (string != null) {
            this.appendLoadNote("CGO " + string);
        }
    }

    private void processGadget(JmolList<Object> jmolList) {
        if (this.objectName.endsWith("_e_pot")) {
            this.processMap(jmolList, true, true);
        }
    }

    private void processMap(JmolList<Object> jmolList, boolean bl, boolean bl2) {
        if (bl) {
            if (this.sourcePNGJ) {
                return;
            }
            if (this.isHidden && !bl2) {
                return;
            }
            if (this.mapObjects == null) {
                this.mapObjects = new JmolList();
            }
            this.mapObjects.addLast(jmolList);
        } else {
            if (this.volumeData == null) {
                this.volumeData = new Hashtable<String, JmolList<Object>>();
            }
            this.volumeData.put(this.objectName, jmolList);
            if (!this.isHidden && !this.isStateScript) {
                this.pymolScene.addIsosurface(this.objectName);
            }
        }
        jmolList.addLast(this.objectName);
    }

    private void processMeasure(JmolList<Object> jmolList) {
        int n;
        int n2;
        if (this.isStateScript) {
            return;
        }
        if (this.isHidden) {
            return;
        }
        Logger.info("PyMOL measure " + this.objectName);
        JmolList<Object> jmolList2 = this.listAt(this.listAt(jmolList, 2), 0);
        int n3 = 1;
        if (jmolList2.get(1) instanceof JmolList) {
            n2 = 2;
        } else {
            n3 = 4;
            if (jmolList2.get(4) instanceof JmolList) {
                n2 = 3;
            } else {
                n3 = 6;
                n2 = n = jmolList2.get(6) instanceof JmolList ? 4 : 0;
            }
        }
        if (n == 0) {
            return;
        }
        JmolList<Object> jmolList3 = this.listAt(jmolList, 0);
        BS bS = PyMOLReader.getBsReps(this.listAt(jmolList3, 3));
        JmolList<Object> jmolList4 = this.listAt(jmolList2, n3);
        JmolList<Object> jmolList5 = this.listAt(jmolList2, 8);
        boolean bl = jmolList2.size() > 8;
        int n4 = PyMOLReader.intAt(jmolList3, 2);
        if (this.pymolScene.addMeasurements(null, n, jmolList4, bS, n4, jmolList5, bl)) {
            this.haveMeasurements = true;
        }
    }

    private BS processMolecule(JmolList<Object> jmolList, int n) {
        int n2;
        JmolList<Object> jmolList2 = this.listAt(jmolList, 4);
        JmolList<Object> jmolList3 = this.listAt(jmolList2, n);
        JmolList<Object> jmolList4 = this.listAt(jmolList3, 3);
        int n3 = n2 = jmolList4 == null ? 0 : jmolList4.size();
        if (n2 == 0) {
            return null;
        }
        this.atomCount = this.atomCount0 = this.atomSetCollection.getAtomCount();
        int n4 = PyMOLReader.intAt(jmolList, 3);
        if (n4 == 0) {
            return null;
        }
        this.ssMapSeq = new Hashtable<String, BS>();
        if (n == 0) {
            this.processMolCryst(this.listAt(jmolList, 10));
        }
        JmolList<Bond> jmolList5 = this.getBondList(this.listAt(jmolList, 6));
        JmolList<Object> jmolList6 = this.listAt(jmolList, 7);
        this.atomMap = new int[n4];
        BS bS = this.pymolScene.setAtomMap(this.atomMap, this.atomCount0);
        for (int i = 0; i < 23; ++i) {
            this.reps[i] = BS.newN(1000);
        }
        JmolList<Object> jmolList7 = this.listAt(jmolList3, 2);
        JmolList<Object> jmolList8 = this.listAt(jmolList3, 8);
        if (n == 0 || !this.isTrajectory) {
            for (int i = 0; i < n2; ++i) {
                P3 p3 = this.addAtom(jmolList6, PyMOLReader.intAt(jmolList4, i), i, jmolList7, jmolList8, bS, n);
                if (p3 == null) continue;
                this.trajectoryStep[this.trajectoryPtr++] = p3;
            }
        }
        this.addBonds(jmolList5);
        this.addMolStructures();
        this.atoms = this.atomSetCollection.getAtoms();
        if (!this.isStateScript) {
            this.createShapeObjects();
        }
        this.ssMapSeq = null;
        Logger.info("reading " + (this.atomCount - this.atomCount0) + " atoms");
        Logger.info("----------");
        return bS;
    }

    private void processMolCryst(JmolList<Object> jmolList) {
        if (jmolList == null || jmolList.size() == 0) {
            return;
        }
        JmolList<Object> jmolList2 = this.listAt(this.listAt(jmolList, 0), 0);
        JmolList<Object> jmolList3 = this.listAt(this.listAt(jmolList, 0), 1);
        this.setUnitCell(this.floatAt(jmolList2, 0), this.floatAt(jmolList2, 1), this.floatAt(jmolList2, 2), this.floatAt(jmolList3, 0), this.floatAt(jmolList3, 1), this.floatAt(jmolList3, 2));
        this.setSpaceGroupName(PyMOLReader.stringAt(jmolList, 1));
    }

    private JmolList<Bond> getBondList(JmolList<Object> jmolList) {
        JmolList<Bond> jmolList2 = new JmolList<Bond>();
        int n = this.pymolScene.booleanSetting(64) ? 0 : 65536;
        int n2 = jmolList.size();
        for (int i = 0; i < n2; ++i) {
            JmolList<Object> jmolList3 = this.listAt(jmolList, i);
            int n3 = PyMOLReader.intAt(jmolList3, 2);
            if (n3 < 1 || n3 > 3) {
                n3 = 1;
            }
            int n4 = PyMOLReader.intAt(jmolList3, 0);
            int n5 = PyMOLReader.intAt(jmolList3, 1);
            Bond bond = new Bond(n4, n5, n3 | n);
            bond.uniqueID = jmolList3.size() > 6 && PyMOLReader.intAt(jmolList3, 6) != 0 ? PyMOLReader.intAt(jmolList3, 5) : -1;
            jmolList2.addLast(bond);
        }
        return jmolList2;
    }

    private P3 addAtom(JmolList<Object> jmolList, int n, int n2, JmolList<Object> jmolList2, JmolList<Object> jmolList3, BS bS, int n3) {
        Object object;
        boolean bl;
        String string;
        this.atomMap[n] = -1;
        JmolList<Object> jmolList4 = this.listAt(jmolList, n);
        int n4 = PyMOLReader.intAt(jmolList4, 0);
        String string2 = PyMOLReader.stringAt(jmolList4, 1);
        String string3 = PyMOLReader.stringAt(jmolList4, 2);
        String string4 = " ";
        String string5 = PyMOLReader.stringAt(jmolList4, 6);
        String string6 = PyMOLReader.stringAt(jmolList4, 5);
        if (string6.length() > 3) {
            string6 = string6.substring(0, 3);
        }
        if (string6.equals(" ")) {
            string6 = "UNK";
        }
        if ((string = PyMOLReader.stringAt(jmolList4, 7)).equals("A")) {
            string = "C";
        }
        boolean bl2 = PyMOLReader.intAt(jmolList4, 19) != 0;
        int n5 = this.viewer.getChainID(string2);
        Atom atom = this.processAtom(new Atom(), string5, string3.charAt(0), string6, n5, n4, string4.charAt(0), bl2, string);
        if (!this.filterPDBAtom(atom, this.fileAtomIndex++)) {
            return null;
        }
        float f = this.floatAt(jmolList2, n2 *= 3);
        float f2 = this.floatAt(jmolList2, ++n2);
        float f3 = this.floatAt(jmolList2, ++n2);
        BoxInfo.addPointXYZ(f, f2, f3, this.xyzMin, this.xyzMax, 0.0f);
        if (this.isTrajectory && n3 > 0) {
            return null;
        }
        boolean bl3 = bl = nucleic.indexOf(string6) >= 0;
        if (bS != null) {
            bS.set(this.atomCount);
        }
        String string7 = PyMOLReader.stringAt(jmolList4, 9);
        String string8 = PyMOLReader.stringAt(jmolList4, 10);
        if (n4 >= -1000 && (!string8.equals(" ") || string5.equals("CA") || bl)) {
            BS bS2 = this.ssMapSeq.get(string8);
            if (bS2 == null) {
                bS2 = new BS();
                this.ssMapSeq.put(string8, bS2);
            }
            bS2.set(n4 - -1000);
            string8 = string8 + n5;
            bS2 = this.ssMapSeq.get(string8);
            if (bS2 == null) {
                bS2 = new BS();
                this.ssMapSeq.put(string8, bS2);
            }
            bS2.set(n4 - -1000);
        }
        atom.bfactor = this.floatAt(jmolList4, 14);
        atom.foccupancy = this.floatAt(jmolList4, 15);
        atom.radius = this.floatAt(jmolList4, 16);
        if (atom.radius == 0.0f) {
            atom.radius = 1.0f;
        }
        atom.partialCharge = this.floatAt(jmolList4, 17);
        int n6 = PyMOLReader.intAt(jmolList4, 18);
        BS bS3 = PyMOLReader.getBsReps(this.listAt(jmolList4, 20));
        int n7 = PyMOLReader.intAt(jmolList4, 21);
        int n8 = PyMOLReader.intAt(jmolList4, 22);
        int n9 = PyMOLReader.intAt(jmolList4, 23);
        int n10 = PyMOLReader.intAt(jmolList4, 24);
        boolean bl4 = PyMOLReader.intAt(jmolList4, 25) != 0;
        int n11 = jmolList4.size() > 40 && PyMOLReader.intAt(jmolList4, 40) == 1 ? PyMOLReader.intAt(jmolList4, 32) : -1;
        atom.vib = V3.new3(n11, n9, Float.NaN);
        if (jmolList4.size() > 46) {
            object = PyMOLScene.floatsAt(jmolList4, 41, new float[8], 6);
            this.atomSetCollection.setAnisoBorU(atom, (float[])object, 12);
        }
        this.pymolScene.setAtomColor(n7);
        this.processAtom2(atom, n8, f, f2, f3, n6);
        if (!bl4) {
            this.pymolScene.bsNonbonded.set(this.atomCount);
        }
        if (!string7.equals(" ")) {
            this.pymolScene.bsLabeled.set(this.atomCount);
            object = this.listAt(jmolList3, n);
            this.pymolScene.addLabel(this.atomCount, n11, n7, (JmolList<Object>)object, string7);
        }
        if (this.isHidden) {
            this.pymolScene.bsHidden.set(this.atomCount);
        }
        if (bl) {
            this.pymolScene.bsNucleic.set(this.atomCount);
        }
        for (int i = 0; i < 21; ++i) {
            if (!bS3.get(i)) continue;
            this.reps[i].set(this.atomCount);
        }
        if (atom.elementSymbol.equals("H")) {
            this.pymolScene.bsHydrogen.set(this.atomCount);
        }
        if ((n10 & PyMOL.FLAG_NOSURFACE) != 0) {
            this.pymolScene.bsNoSurface.set(this.atomCount);
        }
        ++this.atomCount;
        return null;
    }

    private void addBonds(JmolList<Bond> jmolList) {
        int n = jmolList.size();
        for (int i = 0; i < n; ++i) {
            Bond bond = (Bond)jmolList.get(i);
            bond.atomIndex1 = this.atomMap[bond.atomIndex1];
            bond.atomIndex2 = this.atomMap[bond.atomIndex2];
            if (bond.atomIndex1 < 0 || bond.atomIndex2 < 0) continue;
            this.pymolScene.setUniqueBond(this.bondCount++, bond.uniqueID);
            this.atomSetCollection.addBond(bond);
        }
    }

    private void addMolStructures() {
        this.addMolSS("H", EnumStructure.HELIX);
        this.addMolSS("S", EnumStructure.SHEET);
        this.addMolSS("L", EnumStructure.TURN);
        this.addMolSS(" ", EnumStructure.NONE);
    }

    private void addMolSS(String string, EnumStructure enumStructure) {
        if (this.ssMapSeq.get(string) == null) {
            return;
        }
        int n = -1;
        int n2 = -1;
        int n3 = 0;
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        BS bS = null;
        BS bS2 = this.pymolScene.getSSMapAtom(string);
        int n4 = this.atomCount + 1;
        int n5 = -1;
        int n6 = 0;
        int n7 = -1;
        int n8 = -1;
        for (int i = this.atomCount0; i < n4; ++i) {
            if (i == this.atomCount) {
                n6 = 0;
            } else {
                n5 = atomArray[i].sequenceNumber;
                n6 = atomArray[i].chainID;
                n8 = atomArray[i].atomSetIndex;
            }
            if (n6 != n3 || n8 != n7) {
                n3 = n6;
                n7 = n8;
                bS = this.ssMapSeq.get(string + n6);
                --i;
                if (n < 0) {
                    continue;
                }
            } else {
                if (bS != null && n5 >= -1000 && bS.get(n5 - -1000)) {
                    n2 = i;
                    if (n >= 0) continue;
                    n = i;
                    continue;
                }
                if (n < 0) continue;
            }
            if (enumStructure != EnumStructure.NONE) {
                int n9 = this.bsStructureDefined.nextSetBit(n);
                if (n9 >= 0 && n9 <= n2) continue;
                this.bsStructureDefined.setBits(n, n2 + 1);
                Structure structure = new Structure(n7, enumStructure, enumStructure, enumStructure.toString(), ++this.structureCount, enumStructure == EnumStructure.SHEET ? 1 : 0);
                Atom atom = atomArray[n];
                Atom atom2 = atomArray[n2];
                int n10 = this.atomSetCollection.getAtomSetAtomIndex(n8);
                structure.set(atom.chainID, atom.sequenceNumber, atom.insertionCode, atom2.chainID, atom2.sequenceNumber, atom2.insertionCode, n - n10, n2 - n10);
                this.atomSetCollection.addStructure(structure);
            }
            bS2.setBits(n, n2 + 1);
            n = -1;
        }
    }

    private void createShapeObjects() {
        this.pymolScene.createShapeObjects(this.reps, this.allowSurface && !this.isHidden, this.atomCount0, this.atomCount);
    }

    private void processMeshes() {
        this.viewer.cachePut(this.pymolScene.surfaceInfoName, this.volumeData);
        int n = this.mapObjects.size();
        while (--n >= 0) {
            String string;
            Object object;
            int n2;
            JmolList jmolList = (JmolList)this.mapObjects.get(n);
            String string2 = jmolList.get(jmolList.size() - 1).toString();
            boolean bl = string2.endsWith("_e_pot");
            if (bl) {
                n2 = 0x400000C0;
                object = string2.substring(0, string2.length() - 3);
                string = (String)object + "map";
                String string3 = this.pymolScene.getObjectID((String)object + "chg");
                if (string3 == null) continue;
                jmolList.addLast(string3);
                this.pymolScene.mepList = this.pymolScene.mepList + ";" + string3 + ";";
            } else {
                n2 = 1073742018;
                string = PyMOLReader.stringAt(this.listAt(this.listAt(jmolList, 2), 0), 1);
            }
            object = this.volumeData.get(string);
            if (object == null) continue;
            jmolList.addLast(string);
            this.volumeData.put(string2, jmolList);
            this.volumeData.put("__pymolSurfaceData__", jmolList);
            if (!this.isStateScript) {
                this.pymolScene.addMesh(n2, jmolList, string2, bl);
            }
            this.appendLoadNote("PyMOL object " + string2 + " references map " + string);
        }
    }

    private void processDefinitions() {
        String string = this.viewer.getAtomDefs(this.pymolScene.setAtomDefs());
        if (string.length() > 2) {
            string = string.substring(0, string.length() - 2);
        }
        this.appendLoadNote(string);
    }

    private void processSelectionsAndScenes(Map<String, Object> map) {
        if (!this.pymolScene.needSelections()) {
            return;
        }
        Map<String, JmolList<Object>> map2 = PyMOLScene.listToMap(PyMOLReader.getMapList(map, "names"));
        if (this.haveScenes) {
            Map map3 = (Map)map.get("scene_dict");
            this.finalizeSceneData();
            Map<String, JmolList<Object>> map4 = PyMOLScene.listToMap(PyMOLReader.getMapList(map, "selector_secrets"));
            for (int i = 0; i < this.sceneOrder.size(); ++i) {
                String string = PyMOLReader.stringAt(this.sceneOrder, i);
                JmolList<Object> jmolList = PyMOLReader.getMapList(map3, string);
                if (jmolList == null) continue;
                this.pymolScene.buildScene(string, jmolList, map2, map4);
                this.appendLoadNote("scene: " + string);
            }
        }
        this.pymolScene.setCarveSets(map2);
    }

    private void finalizeSceneData() {
        int[] nArray = new int[this.atomCount];
        int[] nArray2 = new int[this.atomCount];
        int[] nArray3 = new int[this.atomCount];
        boolean[] blArray = new boolean[this.atomCount];
        float[] fArray = new float[this.atomCount];
        int n = Integer.MIN_VALUE;
        int n2 = Integer.MIN_VALUE;
        for (int i = 0; i < this.atomCount; ++i) {
            nArray[i] = this.getCartoonType(i);
            nArray2[i] = this.getUniqueID(i);
            nArray3[i] = this.getSequenceNumber(i);
            fArray[i] = this.getVDW(i);
            if (n == this.atoms[i].chainID && n2 == this.atoms[i].atomSetIndex) continue;
            blArray[i] = true;
            n = this.atoms[i].chainID;
            n2 = this.atoms[i].atomSetIndex;
        }
        this.pymolScene.setAtomInfo(nArray2, nArray, nArray3, blArray, fArray);
    }

    private static int intAt(JmolList<Object> jmolList, int n) {
        return ((Number)jmolList.get(n)).intValue();
    }

    private static String stringAt(JmolList<Object> jmolList, int n) {
        String string = jmolList.get(n).toString();
        return string.length() == 0 ? " " : string;
    }

    private static JmolList<Object> getMapList(Map<String, Object> map, String string) {
        return (JmolList)map.get(string);
    }

    private static BS getBsReps(JmolList<Object> jmolList) {
        BS bS = new BS();
        int n = Math.min(jmolList.size(), 21);
        for (int i = 0; i < n; ++i) {
            if (PyMOLReader.intAt(jmolList, i) != 1) continue;
            bS.set(i);
        }
        return bS;
    }

    private float floatAt(JmolList<Object> jmolList, int n) {
        return PyMOLScene.floatAt(jmolList, n);
    }

    private JmolList<Object> listAt(JmolList<Object> jmolList, int n) {
        return PyMOLScene.listAt(jmolList, n);
    }

    @Override
    public int getUniqueID(int n) {
        return (int)this.atoms[n].vib.x;
    }

    @Override
    public int getCartoonType(int n) {
        return (int)this.atoms[n].vib.y;
    }

    @Override
    public float getVDW(int n) {
        return this.atoms[n].radius;
    }

    @Override
    public int getSequenceNumber(int n) {
        return this.atoms[n].sequenceNumber;
    }

    @Override
    public boolean compareAtoms(int n, int n2) {
        return this.atoms[n].chainID != this.atoms[n2].chainID;
    }
}

