/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.io.BufferedReader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.readers.cif.ModulationReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.Structure;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolLineReader;
import org.jmol.api.SymmetryInterface;
import org.jmol.constant.EnumStructure;
import org.jmol.io.CifDataReader;
import org.jmol.util.BS;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Matrix4f;
import org.jmol.util.P3;
import org.jmol.util.TextFormat;
import org.jmol.util.V3;

public class CifReader
extends ModulationReader
implements JmolLineReader {
    protected boolean isPDBX;
    private CifDataReader tokenizer = new CifDataReader(this);
    private boolean isMolecular;
    private boolean filterAssembly;
    private int configurationPtr = Integer.MIN_VALUE;
    private String thisDataSetName = "";
    private String chemicalName = "";
    private String thisStructuralFormula = "";
    private String thisFormula = "";
    private boolean iHaveDesiredModel;
    private boolean isPDB = false;
    private Map<String, String> htHetero;
    private String molecularType = "GEOM_BOND default";
    private char lastAltLoc = '\u0000';
    private boolean haveAromatic;
    private int conformationIndex;
    private int nMolecular = 0;
    private JmolList<Matrix4f> vBiomts;
    private JmolList<Map<String, Object>> vBiomolecules;
    private Map<String, Matrix4f> htBiomts;
    private Map<String, Map<String, Object>> htSites;
    private Map<String, BS> assemblyIdAtoms;
    private String appendedData;
    private boolean skipping;
    private boolean haveChainsLC;
    private int nAtoms;
    private String auditBlockCode;
    private String lastSpaceGroupName;
    private Hashtable<String, Object> htAudit;
    private JmolList<String> symops;
    private static final String[] TransformFields = new String[]{"x[1][1]", "x[1][2]", "x[1][3]", "r[1]", "x[2][1]", "x[2][2]", "x[2][3]", "r[2]", "x[3][1]", "x[3][2]", "x[3][3]", "r[3]"};
    private String key;
    private String data;
    private String field;
    private char firstChar = '\u0000';
    private int[] propertyOf = new int[100];
    private byte[] fieldOf = new byte[100];
    private String[] fields;
    private int propertyCount;
    private Map<String, Float> atomTypes;
    private JmolList<Object[]> bondTypes = new JmolList();
    private String disorderAssembly = ".";
    private String lastDisorderAssembly;
    private static final byte ATOM_TYPE_SYMBOL = 0;
    private static final byte ATOM_TYPE_OXIDATION_NUMBER = 1;
    private static final String[] atomTypeFields = new String[]{"_atom_type_symbol", "_atom_type_oxidation_number"};
    private static final byte NONE = -1;
    private static final byte TYPE_SYMBOL = 0;
    private static final byte LABEL = 1;
    private static final byte AUTH_ATOM = 2;
    private static final byte FRACT_X = 3;
    private static final byte FRACT_Y = 4;
    private static final byte FRACT_Z = 5;
    private static final byte CARTN_X = 6;
    private static final byte CARTN_Y = 7;
    private static final byte CARTN_Z = 8;
    private static final byte OCCUPANCY = 9;
    private static final byte B_ISO = 10;
    private static final byte COMP_ID = 11;
    private static final byte AUTH_ASYM_ID = 12;
    private static final byte SEQ_ID = 13;
    private static final byte INS_CODE = 14;
    private static final byte ALT_ID = 15;
    private static final byte GROUP_PDB = 16;
    private static final byte MODEL_NO = 17;
    private static final byte DUMMY_ATOM = 18;
    private static final byte DISORDER_GROUP = 19;
    private static final byte ANISO_LABEL = 20;
    private static final byte ANISO_MMCIF_ID = 21;
    private static final byte ANISO_U11 = 22;
    private static final byte ANISO_U22 = 23;
    private static final byte ANISO_U33 = 24;
    private static final byte ANISO_U12 = 25;
    private static final byte ANISO_U13 = 26;
    private static final byte ANISO_U23 = 27;
    private static final byte ANISO_MMCIF_U11 = 28;
    private static final byte ANISO_MMCIF_U22 = 29;
    private static final byte ANISO_MMCIF_U33 = 30;
    private static final byte ANISO_MMCIF_U12 = 31;
    private static final byte ANISO_MMCIF_U13 = 32;
    private static final byte ANISO_MMCIF_U23 = 33;
    private static final byte U_ISO_OR_EQUIV = 34;
    private static final byte ANISO_B11 = 35;
    private static final byte ANISO_B22 = 36;
    private static final byte ANISO_B33 = 37;
    private static final byte ANISO_B12 = 38;
    private static final byte ANISO_B13 = 39;
    private static final byte ANISO_B23 = 40;
    private static final byte ANISO_BETA_11 = 41;
    private static final byte ANISO_BETA_22 = 42;
    private static final byte ANISO_BETA_33 = 43;
    private static final byte ANISO_BETA_12 = 44;
    private static final byte ANISO_BETA_13 = 45;
    private static final byte ANISO_BETA_23 = 46;
    private static final byte ADP_TYPE = 47;
    private static final byte CHEM_COMP_AC_ID = 48;
    private static final byte CHEM_COMP_AC_NAME = 49;
    private static final byte CHEM_COMP_AC_SYM = 50;
    private static final byte CHEM_COMP_AC_CHARGE = 51;
    private static final byte CHEM_COMP_AC_X = 52;
    private static final byte CHEM_COMP_AC_Y = 53;
    private static final byte CHEM_COMP_AC_Z = 54;
    private static final byte CHEM_COMP_AC_X_IDEAL = 55;
    private static final byte CHEM_COMP_AC_Y_IDEAL = 56;
    private static final byte CHEM_COMP_AC_Z_IDEAL = 57;
    private static final byte DISORDER_ASSEMBLY = 58;
    private static final byte ASYM_ID = 59;
    private static final byte SUBSYS_ID = 60;
    private static final byte SITE_MULT = 61;
    private static final String[] atomFields = new String[]{"_atom_site_type_symbol", "_atom_site_label", "_atom_site_auth_atom_id", "_atom_site_fract_x", "_atom_site_fract_y", "_atom_site_fract_z", "_atom_site_cartn_x", "_atom_site_cartn_y", "_atom_site_cartn_z", "_atom_site_occupancy", "_atom_site_b_iso_or_equiv", "_atom_site_auth_comp_id", "_atom_site_auth_asym_id", "_atom_site_auth_seq_id", "_atom_site_pdbx_pdb_ins_code", "_atom_site_label_alt_id", "_atom_site_group_pdb", "_atom_site_pdbx_pdb_model_num", "_atom_site_calc_flag", "_atom_site_disorder_group", "_atom_site_aniso_label", "_atom_site_anisotrop_id", "_atom_site_aniso_u_11", "_atom_site_aniso_u_22", "_atom_site_aniso_u_33", "_atom_site_aniso_u_12", "_atom_site_aniso_u_13", "_atom_site_aniso_u_23", "_atom_site_anisotrop_u[1][1]", "_atom_site_anisotrop_u[2][2]", "_atom_site_anisotrop_u[3][3]", "_atom_site_anisotrop_u[1][2]", "_atom_site_anisotrop_u[1][3]", "_atom_site_anisotrop_u[2][3]", "_atom_site_u_iso_or_equiv", "_atom_site_aniso_b_11", "_atom_site_aniso_b_22", "_atom_site_aniso_b_33", "_atom_site_aniso_b_12", "_atom_site_aniso_b_13", "_atom_site_aniso_b_23", "_atom_site_aniso_beta_11", "_atom_site_aniso_beta_22", "_atom_site_aniso_beta_33", "_atom_site_aniso_beta_12", "_atom_site_aniso_beta_13", "_atom_site_aniso_beta_23", "_atom_site_adp_type", "_chem_comp_atom_comp_id", "_chem_comp_atom_atom_id", "_chem_comp_atom_type_symbol", "_chem_comp_atom_charge", "_chem_comp_atom_model_cartn_x", "_chem_comp_atom_model_cartn_y", "_chem_comp_atom_model_cartn_z", "_chem_comp_atom_pdbx_model_cartn_x_ideal", "_chem_comp_atom_pdbx_model_cartn_y_ideal", "_chem_comp_atom_pdbx_model_cartn_z_ideal", "_atom_site_disorder_assembly", "_atom_site_label_asym_id", "_atom_site_subsystem_code", "_atom_site_symmetry_multiplicity"};
    private static final byte OPER_ID = 12;
    private static final byte OPER_XYZ = 13;
    private static final String[] operFields = new String[]{"_pdbx_struct_oper_list_matrix[1][1]", "_pdbx_struct_oper_list_matrix[1][2]", "_pdbx_struct_oper_list_matrix[1][3]", "_pdbx_struct_oper_list_vector[1]", "_pdbx_struct_oper_list_matrix[2][1]", "_pdbx_struct_oper_list_matrix[2][2]", "_pdbx_struct_oper_list_matrix[2][3]", "_pdbx_struct_oper_list_vector[2]", "_pdbx_struct_oper_list_matrix[3][1]", "_pdbx_struct_oper_list_matrix[3][2]", "_pdbx_struct_oper_list_matrix[3][3]", "_pdbx_struct_oper_list_vector[3]", "_pdbx_struct_oper_list_id", "_pdbx_struct_oper_list_symmetry_operation"};
    private static final byte ASSEM_ID = 0;
    private static final byte ASSEM_OPERS = 1;
    private static final byte ASSEM_LIST = 2;
    private static final String[] assemblyFields = new String[]{"_pdbx_struct_assembly_gen_assembly_id", "_pdbx_struct_assembly_gen_oper_expression", "_pdbx_struct_assembly_gen_asym_id_list"};
    private String[] assem = null;
    private static final byte NONPOLY_ENTITY_ID = 0;
    private static final byte NONPOLY_NAME = 1;
    private static final byte NONPOLY_COMP_ID = 2;
    private static final String[] nonpolyFields = new String[]{"_pdbx_entity_nonpoly_entity_id", "_pdbx_entity_nonpoly_name", "_pdbx_entity_nonpoly_comp_id"};
    private String[] hetatmData;
    private static final byte CHEM_COMP_ID = 0;
    private static final byte CHEM_COMP_NAME = 1;
    private static final String[] chemCompFields = new String[]{"_chem_comp_id", "_chem_comp_name"};
    private static final byte CONF_TYPE_ID = 0;
    private static final byte BEG_ASYM_ID = 1;
    private static final byte BEG_SEQ_ID = 2;
    private static final byte BEG_INS_CODE = 3;
    private static final byte END_ASYM_ID = 4;
    private static final byte END_SEQ_ID = 5;
    private static final byte END_INS_CODE = 6;
    private static final byte STRUCT_ID = 7;
    private static final byte SERIAL_NO = 8;
    private static final byte HELIX_CLASS = 9;
    private static final String[] structConfFields = new String[]{"_struct_conf_conf_type_id", "_struct_conf_beg_auth_asym_id", "_struct_conf_beg_auth_seq_id", "_struct_conf_pdbx_beg_pdb_ins_code", "_struct_conf_end_auth_asym_id", "_struct_conf_end_auth_seq_id", "_struct_conf_pdbx_end_pdb_ins_code", "_struct_conf_id", "_struct_conf_pdbx_pdb_helix_id", "_struct_conf_pdbx_pdb_helix_class"};
    private static final byte SHEET_ID = 0;
    private static final byte STRAND_ID = 7;
    private static final String[] structSheetRangeFields = new String[]{"_struct_sheet_range_sheet_id", "_struct_sheet_range_beg_auth_asym_id", "_struct_sheet_range_beg_auth_seq_id", "_struct_sheet_range_pdbx_beg_pdb_ins_code", "_struct_sheet_range_end_auth_asym_id", "_struct_sheet_range_end_auth_seq_id", "_struct_sheet_range_pdbx_end_pdb_ins_code", "_struct_sheet_range_id"};
    private static final byte SITE_ID = 0;
    private static final byte SITE_COMP_ID = 1;
    private static final byte SITE_ASYM_ID = 2;
    private static final byte SITE_SEQ_ID = 3;
    private static final byte SITE_INS_CODE = 4;
    private static final String[] structSiteRangeFields = new String[]{"_struct_site_gen_site_id", "_struct_site_gen_auth_comp_id", "_struct_site_gen_auth_asym_id", "_struct_site_gen_auth_seq_id", "_struct_site_gen_label_alt_id"};
    private static final byte SYMOP_XYZ = 0;
    private static final byte SYM_EQUIV_XYZ = 1;
    private static final byte SYM_SSG_XYZ = 2;
    private static final byte SYM_SSG_OP = 3;
    private static final String[] symmetryOperationsFields = new String[]{"_space_group_symop_operation_xyz", "_symmetry_equiv_pos_as_xyz", "_symmetry_ssg_equiv_pos_as_xyz", "_space_group_symop_ssg_operation_algebraic"};
    private static final byte CHEM_COMP_BOND_ATOM_ID_1 = 0;
    private static final byte CHEM_COMP_BOND_ATOM_ID_2 = 1;
    private static final byte CHEM_COMP_BOND_VALUE_ORDER = 2;
    private static final byte CHEM_COMP_BOND_AROMATIC_FLAG = 3;
    private static final String[] chemCompBondFields = new String[]{"_chem_comp_bond_atom_id_1", "_chem_comp_bond_atom_id_2", "_chem_comp_bond_value_order", "_chem_comp_bond_pdbx_aromatic_flag"};
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_1 = 0;
    private static final byte GEOM_BOND_ATOM_SITE_LABEL_2 = 1;
    private static final byte GEOM_BOND_DISTANCE = 2;
    private static final byte CCDC_GEOM_BOND_TYPE = 3;
    private static final String[] geomBondFields = new String[]{"_geom_bond_atom_site_label_1", "_geom_bond_atom_site_label_2", "_geom_bond_distance", "_ccdc_geom_bond_type"};
    private float[] atomRadius;
    private BS[] bsConnected;
    private BS[] bsSets;
    private final P3 ptOffset = new P3();
    private BS bsMolecule;
    private BS bsExclude;
    private int firstAtom;
    private int atomCount;
    private static final int WV_ID = 0;
    private static final int WV_X = 1;
    private static final int WV_Y = 2;
    private static final int WV_Z = 3;
    private static final int FWV_ID = 4;
    private static final int FWV_X = 5;
    private static final int FWV_Y = 6;
    private static final int FWV_Z = 7;
    private static final int FWV_Q1_COEF = 8;
    private static final int FWV_Q2_COEF = 9;
    private static final int FWV_Q3_COEF = 10;
    private static final int FWV_DISP_LABEL = 11;
    private static final int FWV_DISP_AXIS = 12;
    private static final int FWV_DISP_ID = 13;
    private static final int FWV_DISP_COS = 14;
    private static final int FWV_DISP_SIN = 15;
    private static final int FWV_DISP_MODULUS = 16;
    private static final int FWV_DISP_PHASE = 17;
    private static final int FWV_OCC_LABEL = 18;
    private static final int FWV_OCC_ID = 19;
    private static final int FWV_OCC_COS = 20;
    private static final int FWV_OCC_SIN = 21;
    private static final int FWV_OCC_MODULUS = 22;
    private static final int FWV_OCC_PHASE = 23;
    private static final int DISP_SPEC_LABEL = 24;
    private static final int DISP_SAW_AX = 25;
    private static final int DISP_SAW_AY = 26;
    private static final int DISP_SAW_AZ = 27;
    private static final int DISP_SAW_C = 28;
    private static final int DISP_SAW_W = 29;
    private static final int OCC_SPECIAL_LABEL = 30;
    private static final int OCC_CRENEL_C = 31;
    private static final int OCC_CRENEL_W = 32;
    private static final int FWV_U_LABEL = 33;
    private static final int FWV_U_TENS = 34;
    private static final int FWV_U_ID = 35;
    private static final int FWV_U_COS = 36;
    private static final int FWV_U_SIN = 37;
    private static final int FWV_U_MODULUS = 38;
    private static final int FWV_U_PHASE = 39;
    private static final int FA_ID = 40;
    private static final int FO_ID = 41;
    private static final int FU_ID = 42;
    private static final int FP_DISP_ID = 43;
    private static final int FP_OCC_ID = 44;
    private static final int FP_U_ID = 45;
    private static final int JANA_OCC_ABS_LABEL = 46;
    private static final int JANA_OCC_ABS_O_0 = 47;
    private static final String[] modulationFields = new String[]{"_cell_wave_vector_seq_id", "_cell_wave_vector_x", "_cell_wave_vector_y", "_cell_wave_vector_z", "_atom_site_fourier_wave_vector_seq_id", "_atom_site_fourier_wave_vector_x", "_atom_site_fourier_wave_vector_y", "_atom_site_fourier_wave_vector_z", "_jana_atom_site_fourier_wave_vector_q1_coeff", "_jana_atom_site_fourier_wave_vector_q2_coeff", "_jana_atom_site_fourier_wave_vector_q3_coeff", "_atom_site_displace_fourier_atom_site_label", "_atom_site_displace_fourier_axis", "_atom_site_displace_fourier_wave_vector_seq_id", "_atom_site_displace_fourier_param_cos", "_atom_site_displace_fourier_param_sin", "_atom_site_displace_fourier_param_modulus", "_atom_site_displace_fourier_param_phase", "_atom_site_occ_fourier_atom_site_label", "_atom_site_occ_fourier_wave_vector_seq_id", "_atom_site_occ_fourier_param_cos", "_atom_site_occ_fourier_param_sin", "_atom_site_occ_fourier_param_modulus", "_atom_site_occ_fourier_param_phase", "_atom_site_displace_special_func_atom_site_label", "_atom_site_displace_special_func_sawtooth_ax", "_atom_site_displace_special_func_sawtooth_ay", "_atom_site_displace_special_func_sawtooth_az", "_atom_site_displace_special_func_sawtooth_c", "_atom_site_displace_special_func_sawtooth_w", "_atom_site_occ_special_func_atom_site_label", "_atom_site_occ_special_func_crenel_c", "_atom_site_occ_special_func_crenel_w", "_atom_site_u_fourier_atom_site_label", "_atom_site_u_fourier_tens_elem", "_atom_site_u_fourier_wave_vector_seq_id", "_atom_site_u_fourier_param_cos", "_atom_site_u_fourier_param_sin", "_atom_site_u_fourier_param_modulus", "_atom_site_u_fourier_param_phase", "_atom_site_displace_fourier_id", "_atom_site_occ_fourier_id", "_atom_site_u_fourier_id", "_atom_site_displace_fourier_param_id", "_atom_site_occ_fourier_param_id", "_atom_site_u_fourier_param_id", "_jana_atom_site_occ_fourier_absolute_site_label", "_jana_atom_site_occ_fourier_absolute"};

    public void initializeReader() throws Exception {
        this.initializeReaderCif();
    }

    protected void initializeReaderCif() throws Exception {
        this.appendedData = (String)this.htParams.get("appendedData");
        String string = this.getFilter("CONF ");
        if (string != null) {
            this.configurationPtr = this.parseIntStr(string);
        }
        this.isMolecular = this.checkFilterKey("MOLECUL");
        this.filterAssembly = this.checkFilterKey("$");
        if (this.isMolecular) {
            if (!this.doApplySymmetry) {
                this.doApplySymmetry = true;
                this.latticeCells[0] = 1;
                this.latticeCells[1] = 1;
                this.latticeCells[2] = 1;
            }
            this.molecularType = "filter \"MOLECULAR\"";
        }
        this.initializeModulation();
        this.readCifData();
        this.continuing = false;
    }

    private void readCifData() throws Exception {
        block2: {
            this.line = "";
            while ((this.key = this.tokenizer.peekToken()) != null && this.readAllData()) {
            }
            if (this.appendedData == null) break block2;
            this.tokenizer = new CifDataReader(new BufferedReader(new StringReader(this.appendedData)));
            while ((this.key = this.tokenizer.peekToken()) != null && this.readAllData()) {
            }
        }
    }

    public String readNextLine() throws Exception {
        if (this.readLine() != null && this.line.indexOf("#jmolscript:") >= 0) {
            this.checkCurrentLineForScript();
        }
        return this.line;
    }

    private boolean readAllData() throws Exception {
        if (this.key.startsWith("data_")) {
            if (this.isPDBX) {
                this.tokenizer.getTokenPeeked();
                return true;
            }
            if (this.iHaveDesiredModel) {
                return false;
            }
            this.newModel(++this.modelNumber);
            if (!this.skipping) {
                this.processDataParameter();
            }
            this.nAtoms = this.atomSetCollection.getAtomCount();
            return true;
        }
        if (this.key.startsWith("loop_")) {
            if (this.skipping) {
                this.tokenizer.getTokenPeeked();
                this.skipLoop();
            } else {
                this.processLoopBlock();
            }
            return true;
        }
        if (this.key.indexOf("_") != 0) {
            Logger.warn("CIF ERROR ? should be an underscore: " + this.key);
            this.tokenizer.getTokenPeeked();
        } else if (!this.getData()) {
            return true;
        }
        if (!this.skipping) {
            this.key = this.fixKey(this.key);
            if (this.key.startsWith("_chemical_name") || this.key.equals("_chem_comp_name")) {
                this.processChemicalInfo("name");
            } else if (this.key.startsWith("_chemical_formula_structural")) {
                this.processChemicalInfo("structuralFormula");
            } else if (this.key.startsWith("_chemical_formula_sum") || this.key.equals("_chem_comp_formula")) {
                this.processChemicalInfo("formula");
            } else if (this.key.equals("_cell_modulation_dimension") && !this.modAverage) {
                this.setModDim(this.parseIntStr(this.data));
            } else if (this.key.startsWith("_cell_")) {
                this.processCellParameter();
            } else if (this.key.startsWith("_symmetry_space_group_name_h-m") || this.key.startsWith("_symmetry_space_group_name_hall") || this.key.contains("_ssg_name")) {
                this.processSymmetrySpaceGroupName();
            } else if (this.key.startsWith("_atom_sites_fract_tran")) {
                this.processUnitCellTransformMatrix();
            } else if (this.key.startsWith("_pdbx_entity_nonpoly")) {
                this.processNonpolyData();
            } else if (this.key.startsWith("_pdbx_struct_assembly_gen")) {
                this.processAssemblyGen();
            } else if (this.key.equals("_audit_block_code")) {
                this.auditBlockCode = this.tokenizer.fullTrim(this.data).toUpperCase();
                this.appendLoadNote(this.auditBlockCode);
                if (this.htAudit != null && this.auditBlockCode.contains("_MOD_")) {
                    String string = TextFormat.simpleReplace(this.auditBlockCode, "_MOD_", "_REFRNCE_");
                    this.atomSetCollection.symmetry = (SymmetryInterface)this.htAudit.get(string);
                    if (this.atomSetCollection.symmetry != null) {
                        this.notionalUnitCell = this.atomSetCollection.symmetry.getNotionalUnitCell();
                        this.iHaveUnitCell = true;
                    }
                } else if (this.htAudit != null && this.symops != null) {
                    for (int i = 0; i < this.symops.size(); ++i) {
                        this.setSymmetryOperator((String)this.symops.get(i));
                    }
                }
                if (this.lastSpaceGroupName != null) {
                    this.setSpaceGroupName(this.lastSpaceGroupName);
                }
            }
        }
        return true;
    }

    private String fixKey(String string) {
        return TextFormat.simpleReplace(string, ".", "_").toLowerCase();
    }

    protected void newModel(int n) throws Exception {
        if (this.isPDB) {
            this.setIsPDB();
        }
        boolean bl = this.skipping = !this.doGetModel(this.modelNumber = n, null);
        if (this.skipping) {
            this.tokenizer.getTokenPeeked();
        } else {
            this.chemicalName = "";
            this.thisStructuralFormula = "";
            this.thisFormula = "";
            if (this.nAtoms == this.atomSetCollection.getAtomCount()) {
                this.atomSetCollection.removeCurrentAtomSet();
            } else {
                this.applySymmetryAndSetTrajectory();
            }
            this.iHaveDesiredModel = this.isLastModel(this.modelNumber);
        }
    }

    protected void finalizeReader() throws Exception {
        int n;
        if (this.atomSetCollection.getAtomCount() == this.nAtoms) {
            this.atomSetCollection.removeCurrentAtomSet();
        } else {
            this.applySymmetryAndSetTrajectory();
        }
        this.finalizeModulation();
        if (this.htSites != null) {
            this.addSites(this.htSites);
        }
        if ((n = this.atomSetCollection.getAtomSetCount()) > 1) {
            this.atomSetCollection.setCollectionName("<collection of " + n + " models>");
        }
        if (this.vBiomolecules != null && this.vBiomolecules.size() == 1 && this.atomSetCollection.getAtomCount() > 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("biomolecules", this.vBiomolecules);
            this.setBiomolecules();
            if (this.vBiomts != null && this.vBiomts.size() > 1) {
                this.atomSetCollection.applySymmetryBio(this.vBiomts, this.notionalUnitCell, this.applySymmetryToBonds, this.filter);
            }
        }
        this.finalizeReaderASCR();
        String string = this.tokenizer.getFileHeader();
        if (string.length() > 0) {
            this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("fileHeader", string);
        }
        if (this.haveAromatic) {
            this.addJmolScript("calculate aromatic");
        }
    }

    private void setBiomolecules() {
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.setIdentity();
        if (this.assemblyIdAtoms == null) {
            return;
        }
        int n = this.vBiomolecules.size();
        while (--n >= 0) {
            Map map = (Map)this.vBiomolecules.get(n);
            String[] stringArray = TextFormat.split((String)map.get("operators"), ',');
            String string = (String)map.get("assemblies");
            this.vBiomts = new JmolList();
            map.put("biomts", this.vBiomts);
            this.vBiomts.addLast(matrix4f);
            for (int i = 0; i < stringArray.length; ++i) {
                Matrix4f matrix4f2 = this.htBiomts.get(stringArray[i]);
                if (matrix4f2 == null || matrix4f2.equals(matrix4f)) continue;
                this.vBiomts.addLast(matrix4f2);
            }
            if (this.vBiomts.size() < 2) {
                return;
            }
            BS bS = new BS();
            int n2 = string.length() - 1;
            while (--n2 >= 0) {
                BS bS2;
                if (string.charAt(n2) != '$' || (bS2 = this.assemblyIdAtoms.get("" + string.charAt(n2 + 1))) == null) continue;
                bS.or(bS2);
            }
            n2 = bS.cardinality();
            if (n2 < this.atomSetCollection.getAtomCount()) {
                this.atomSetCollection.bsAtoms = bS;
            }
            map.put("atomCount", n2 * stringArray.length);
        }
    }

    public void applySymmetryAndSetTrajectory() throws Exception {
        if (this.isPDB) {
            this.atomSetCollection.setCheckSpecial(false);
        }
        boolean bl = this.doCheckUnitCell && !this.isPDB;
        SymmetryInterface symmetryInterface = this.applySymTrajASCR();
        if (this.auditBlockCode != null && this.auditBlockCode.contains("REFRNCE") && symmetryInterface != null) {
            if (this.htAudit == null) {
                this.htAudit = new Hashtable();
            }
            this.htAudit.put(this.auditBlockCode, symmetryInterface);
        }
        if (bl && (this.bondTypes.size() > 0 || this.isMolecular)) {
            this.setBondingAndMolecules();
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("fileHasUnitCell", Boolean.TRUE);
        this.setModulation();
        this.atomSetCollection.symmetry = null;
    }

    private void processDataParameter() {
        this.bondTypes.clear();
        this.tokenizer.getTokenPeeked();
        String string = this.thisDataSetName = this.key.length() < 6 ? "" : this.key.substring(5);
        if (this.thisDataSetName.length() > 0) {
            this.nextAtomSet();
        }
        if (Logger.debugging) {
            Logger.debug(this.key);
        }
    }

    private void nextAtomSet() {
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isCIF", Boolean.TRUE);
        if (this.atomSetCollection.getCurrentAtomSetIndex() >= 0) {
            this.atomSetCollection.newAtomSet();
        } else {
            this.atomSetCollection.setCollectionName(this.thisDataSetName);
        }
    }

    private String processChemicalInfo(String string) throws Exception {
        if (string.equals("name")) {
            this.chemicalName = this.data = this.tokenizer.fullTrim(this.data);
            if (!this.data.equals("?")) {
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("modelLoadNote", this.data);
            }
        } else if (string.equals("structuralFormula")) {
            this.thisStructuralFormula = this.data = this.tokenizer.fullTrim(this.data);
        } else if (string.equals("formula")) {
            this.thisFormula = this.data = this.tokenizer.fullTrim(this.data);
        }
        if (Logger.debugging) {
            Logger.debug(string + " = " + this.data);
        }
        return this.data;
    }

    private void processSymmetrySpaceGroupName() throws Exception {
        if (this.key.indexOf("_ssg_name") >= 0) {
            this.incommensurate = true;
        } else if (this.incommensurate) {
            return;
        }
        this.lastSpaceGroupName = (this.key.indexOf("h-m") > 0 ? "HM:" : (this.incommensurate ? "SSG:" : "Hall:")) + this.data;
        this.setSpaceGroupName(this.lastSpaceGroupName);
    }

    private void processCellParameter() throws Exception {
        int n = JmolAdapter.cellParamNames.length;
        while (--n >= 0) {
            if (!this.key.equals(JmolAdapter.cellParamNames[n])) continue;
            this.setUnitCellItem(n, this.parseFloatStr(this.data));
            return;
        }
    }

    private void processUnitCellTransformMatrix() throws Exception {
        float f = this.parseFloatStr(this.data);
        if (Float.isNaN(f)) {
            return;
        }
        for (int i = 0; i < TransformFields.length; ++i) {
            if (this.key.indexOf(TransformFields[i]) < 0) continue;
            this.setUnitCellItem(6 + i, f);
            return;
        }
    }

    private boolean getData() throws Exception {
        this.key = this.tokenizer.getTokenPeeked();
        this.data = this.tokenizer.getNextToken();
        if (Logger.debugging) {
            Logger.debug(this.key + " " + this.data);
        }
        if (this.data == null) {
            Logger.warn("CIF ERROR ? end of file; data missing: " + this.key);
            return false;
        }
        return this.data.length() == 0 || this.data.charAt(0) != '\u0000';
    }

    private void processLoopBlock() throws Exception {
        this.tokenizer.getTokenPeeked();
        String string = this.tokenizer.peekToken();
        if (string == null) {
            return;
        }
        boolean bl = false;
        string = this.fixKey(string);
        if (this.incommensurate && (string.startsWith("_cell_wave") || string.contains("fourier") || string.contains("_special_func"))) {
            if (this.modAverage) {
                this.skipLoop();
            } else {
                this.processModulationLoopBlock();
            }
            return;
        }
        if (string.startsWith("_atom_site_") || (bl = string.equals("_chem_comp_atom_comp_id"))) {
            if (!this.processAtomSiteLoopBlock(bl)) {
                return;
            }
            this.atomSetCollection.setAtomSetName(this.thisDataSetName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("chemicalName", this.chemicalName);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("structuralFormula", this.thisStructuralFormula);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", this.thisFormula);
            return;
        }
        if (string.startsWith("_atom_type")) {
            this.processAtomTypeLoopBlock();
            return;
        }
        if (string.startsWith("_chem_comp_bond")) {
            this.processLigandBondLoopBlock();
            return;
        }
        if (string.equals("_cell_subsystem_code")) {
            this.processSubsystemLoopBlock();
            return;
        }
        if (string.startsWith("_geom_bond")) {
            if (!this.doApplySymmetry) {
                this.isMolecular = true;
                this.doApplySymmetry = true;
                this.latticeCells[2] = 1;
                this.latticeCells[1] = 1;
                this.latticeCells[0] = 1;
            }
            if (this.isMolecular) {
                this.processGeomBondLoopBlock();
            } else {
                this.skipLoop();
            }
            return;
        }
        if (string.startsWith("_pdbx_entity_nonpoly")) {
            this.processNonpolyLoopBlock();
            return;
        }
        if (string.startsWith("_chem_comp")) {
            this.processChemCompLoopBlock();
            return;
        }
        if (string.startsWith("_struct_conf") && !string.startsWith("_struct_conf_type")) {
            this.processStructConfLoopBlock();
            return;
        }
        if (string.startsWith("_struct_sheet_range")) {
            this.processStructSheetRangeLoopBlock();
            return;
        }
        if (string.startsWith("_symmetry_equiv_pos") || string.startsWith("_space_group_symop") || string.startsWith("_symmetry_ssg_equiv")) {
            if (this.ignoreFileSymmetryOperators) {
                Logger.warn("ignoring file-based symmetry operators");
                this.skipLoop();
            } else {
                this.processSymmetryOperationsLoopBlock();
            }
            return;
        }
        if (string.startsWith("_struct_site")) {
            this.processStructSiteBlock();
            return;
        }
        if (string.startsWith("_pdbx_struct_oper_list")) {
            this.processStructOperListBlock();
            return;
        }
        if (string.startsWith("_pdbx_struct_assembly_gen")) {
            this.processAssemblyGenBlock();
            return;
        }
        this.skipLoop();
    }

    private int fieldProperty(int n) {
        this.field = this.tokenizer.loopData[n];
        return this.field.length() > 0 && (this.firstChar = this.field.charAt(0)) != '\u0000' ? this.propertyOf[n] : -1;
    }

    private void parseLoopParameters(String[] stringArray) throws Exception {
        if (stringArray == null) {
            this.fields = new String[100];
            stringArray = this.fields;
        }
        this.tokenizer.fieldCount = 0;
        int n = stringArray.length;
        while (--n >= 0) {
            this.fieldOf[n] = -1;
        }
        this.propertyCount = stringArray.length;
        while (true) {
            String string;
            if ((string = this.tokenizer.peekToken()) == null) {
                this.tokenizer.fieldCount = 0;
                break;
            }
            if (string.charAt(0) != '_') break;
            this.tokenizer.getTokenPeeked();
            this.propertyOf[this.tokenizer.fieldCount] = -1;
            string = this.fixKey(string);
            int n2 = stringArray.length;
            while (--n2 >= 0) {
                if (stringArray[n2] != null && !string.equals(stringArray[n2])) continue;
                this.propertyOf[this.tokenizer.fieldCount] = n2;
                this.fieldOf[n2] = (byte)this.tokenizer.fieldCount;
                if (stringArray[n2] != null) break;
                stringArray[n2] = string;
                break;
            }
            ++this.tokenizer.fieldCount;
        }
        if (this.tokenizer.fieldCount > 0) {
            this.tokenizer.loopData = new String[this.tokenizer.fieldCount];
        }
    }

    private void disableField(int n) {
        byte by = this.fieldOf[n];
        if (by != -1) {
            this.propertyOf[by] = -1;
        }
    }

    private void skipLoop() throws Exception {
        String string;
        while ((string = this.tokenizer.peekToken()) != null && string.charAt(0) == '_') {
            string = this.tokenizer.getTokenPeeked();
        }
        while (this.tokenizer.getNextDataToken() != null) {
        }
    }

    private void processAtomTypeLoopBlock() throws Exception {
        this.parseLoopParameters(atomTypeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            String string = null;
            float f = Float.NaN;
            block7: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block7;
                    }
                    case 0: {
                        string = this.field;
                        continue block7;
                    }
                    case 1: {
                        f = this.parseFloatStr(this.field);
                    }
                }
            }
            if (string == null || Float.isNaN(f)) continue;
            if (this.atomTypes == null) {
                this.atomTypes = new Hashtable<String, Float>();
            }
            this.atomTypes.put(string, Float.valueOf(f));
        }
    }

    boolean processAtomSiteLoopBlock(boolean bl) throws Exception {
        int n = -1;
        boolean bl2 = false;
        char c = '\u0000';
        this.parseLoopParameters(atomFields);
        if (this.fieldOf[55] != -1) {
            this.isPDB = false;
            this.setFractionalCoordinates(false);
        } else if (this.fieldOf[6] != -1 || this.fieldOf[52] != -1) {
            this.setFractionalCoordinates(false);
            this.disableField(3);
            this.disableField(4);
            this.disableField(5);
        } else if (this.fieldOf[3] != -1) {
            this.setFractionalCoordinates(true);
            this.disableField(6);
            this.disableField(7);
            this.disableField(8);
        } else if (this.fieldOf[20] != -1) {
            bl2 = true;
        } else if (this.fieldOf[21] != -1) {
            bl2 = true;
        } else {
            this.skipLoop();
            return false;
        }
        int n2 = -1;
        int n3 = -1;
        String string = null;
        int n4 = 0;
        while (this.tokenizer.getData()) {
            int n5;
            int n6;
            Atom atom = new Atom();
            c = '\u0000';
            if (this.isPDBX) {
                if (n3 == -1) {
                    for (n6 = 0; n6 < this.tokenizer.fieldCount; ++n6) {
                        if (this.fieldProperty(n6) != 17) continue;
                        n3 = n6;
                        break;
                    }
                    if (n3 == -1) {
                        n3 = -2;
                    }
                }
                if (n3 >= 0) {
                    this.fieldProperty(n3);
                    n6 = this.parseIntStr(this.field);
                    if (n6 != n) {
                        if (this.iHaveDesiredModel) {
                            this.skipLoop();
                            this.skipping = false;
                            this.continuing = true;
                            break;
                        }
                        n = n6;
                        this.newModel(n6);
                        if (!this.skipping) {
                            this.nextAtomSet();
                        }
                    }
                    if (this.skipping) continue;
                }
            }
            block34: for (n6 = 0; n6 < this.tokenizer.fieldCount; ++n6) {
                n5 = this.fieldProperty(n6);
                switch (n5) {
                    case -1: 
                    case 17: {
                        continue block34;
                    }
                    case 0: 
                    case 50: {
                        char c2;
                        String string2 = this.field.length() < 2 ? this.field : (Atom.isValidElementSymbol2(this.firstChar, c2 = Character.toLowerCase(this.field.charAt(1))) ? "" + this.firstChar + c2 : "" + this.firstChar);
                        atom.elementSymbol = string2;
                        if (this.atomTypes == null || !this.atomTypes.containsKey(this.field)) continue block34;
                        float f = this.atomTypes.get(this.field).floatValue();
                        atom.formalCharge = Math.round(f);
                        if (!((double)Math.abs((float)atom.formalCharge - f) > 0.1) || !Logger.debugging) continue block34;
                        Logger.debug("CIF charge on " + this.field + " was " + f + "; rounded to " + atom.formalCharge);
                        continue block34;
                    }
                    case 1: 
                    case 2: 
                    case 49: {
                        atom.atomName = this.field;
                        continue block34;
                    }
                    case 55: {
                        float f = this.parseFloatStr(this.field);
                        if (Float.isNaN(f)) continue block34;
                        atom.x = f;
                        continue block34;
                    }
                    case 56: {
                        float f = this.parseFloatStr(this.field);
                        if (Float.isNaN(f)) continue block34;
                        atom.y = f;
                        continue block34;
                    }
                    case 57: {
                        float f = this.parseFloatStr(this.field);
                        if (Float.isNaN(f)) continue block34;
                        atom.z = f;
                        continue block34;
                    }
                    case 3: 
                    case 6: 
                    case 52: {
                        atom.x = this.parseFloatStr(this.field);
                        continue block34;
                    }
                    case 4: 
                    case 7: 
                    case 53: {
                        atom.y = this.parseFloatStr(this.field);
                        continue block34;
                    }
                    case 5: 
                    case 8: 
                    case 54: {
                        atom.z = this.parseFloatStr(this.field);
                        continue block34;
                    }
                    case 51: {
                        atom.formalCharge = this.parseIntStr(this.field);
                        continue block34;
                    }
                    case 9: {
                        float f = this.parseFloatStr(this.field);
                        if (Float.isNaN(f)) continue block34;
                        atom.foccupancy = f;
                        continue block34;
                    }
                    case 10: {
                        atom.bfactor = this.parseFloatStr(this.field) * (this.isPDB ? 1.0f : 100.0f);
                        continue block34;
                    }
                    case 11: 
                    case 48: {
                        atom.group3 = this.field;
                        continue block34;
                    }
                    case 59: {
                        c = this.firstChar;
                        continue block34;
                    }
                    case 12: {
                        if (!this.haveChainsLC && !this.field.toUpperCase().equals(this.field)) {
                            this.haveChainsLC = this.viewer.getChainID("lc") != 0;
                        }
                        atom.chainID = this.viewer.getChainID(this.field);
                        continue block34;
                    }
                    case 13: {
                        atom.sequenceNumber = this.parseIntStr(this.field);
                        continue block34;
                    }
                    case 14: {
                        atom.insertionCode = this.firstChar;
                        continue block34;
                    }
                    case 15: {
                        atom.alternateLocationID = this.firstChar;
                        continue block34;
                    }
                    case 58: {
                        this.disorderAssembly = this.field;
                        continue block34;
                    }
                    case 19: {
                        if (this.firstChar == '-' && this.field.length() > 1) {
                            atom.alternateLocationID = this.field.charAt(1);
                            atom.ignoreSymmetry = true;
                            continue block34;
                        }
                        atom.alternateLocationID = this.firstChar;
                        continue block34;
                    }
                    case 16: {
                        this.isPDB = true;
                        if (!"HETATM".equals(this.field)) continue block34;
                        atom.isHetero = true;
                        continue block34;
                    }
                    case 18: {
                        if (!"dum".equals(this.field)) continue block34;
                        atom.x = Float.NaN;
                        continue block34;
                    }
                    case 47: {
                        byte by;
                        if (!this.field.equalsIgnoreCase("Uiso") || (by = this.fieldOf[34]) == -1) continue block34;
                        this.setU(atom, 7, this.parseFloatStr(this.tokenizer.loopData[by]));
                        continue block34;
                    }
                    case 20: {
                        n2 = this.atomSetCollection.getAtomIndexFromName(this.field);
                        if (n2 < 0) continue block34;
                        atom = this.atomSetCollection.getAtom(n2);
                        continue block34;
                    }
                    case 21: {
                        atom = this.atomSetCollection.getAtom(++n2);
                        continue block34;
                    }
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 27: 
                    case 28: 
                    case 29: 
                    case 30: 
                    case 31: 
                    case 32: 
                    case 33: {
                        this.setU(atom, (this.propertyOf[n6] - 22) % 6, this.parseFloatStr(this.field));
                        continue block34;
                    }
                    case 35: 
                    case 36: 
                    case 37: 
                    case 38: 
                    case 39: 
                    case 40: {
                        this.setU(atom, 6, 4.0f);
                        this.setU(atom, (this.propertyOf[n6] - 35) % 6, this.parseFloatStr(this.field));
                        continue block34;
                    }
                    case 41: 
                    case 42: 
                    case 43: 
                    case 44: 
                    case 45: 
                    case 46: {
                        this.setU(atom, 6, 0.0f);
                        this.setU(atom, (this.propertyOf[n6] - 41) % 6, this.parseFloatStr(this.field));
                        continue block34;
                    }
                    case 60: {
                        string = this.field;
                        continue block34;
                    }
                    case 61: {
                        if (!this.incommensurate) continue block34;
                        n4 = this.parseIntStr(this.field);
                    }
                }
            }
            if (bl2) continue;
            if (Float.isNaN(atom.x) || Float.isNaN(atom.y) || Float.isNaN(atom.z)) {
                Logger.warn("atom " + atom.atomName + " has invalid/unknown coordinates");
                continue;
            }
            if (!this.filterCIFAtom(atom, n2, c)) continue;
            this.setAtomCoord(atom);
            if (atom.elementSymbol == null && atom.atomName != null) {
                String string3 = atom.atomName;
                for (n5 = 0; n5 < string3.length() && Character.isLetter(string3.charAt(n5)); ++n5) {
                }
                atom.elementSymbol = n5 == 0 || n5 > 2 ? "Xx" : string3.substring(0, n5);
            }
            this.atomSetCollection.addAtomWithMappedName(atom);
            if (c != '\u0000') {
                BS bS;
                if (this.assemblyIdAtoms == null) {
                    this.assemblyIdAtoms = new Hashtable<String, BS>();
                }
                if ((bS = this.assemblyIdAtoms.get("" + c)) == null) {
                    bS = new BS();
                    this.assemblyIdAtoms.put("" + c, bS);
                }
                bS.set(atom.index);
            }
            if (atom.isHetero && this.htHetero != null) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("hetNames", this.htHetero);
                this.atomSetCollection.setAtomSetCollectionAuxiliaryInfo("hetNames", this.htHetero);
                this.htHetero = null;
            }
            if (string != null) {
                this.addSubsystem(string, null, atom.atomName);
            }
            if (n4 == 0) continue;
            atom.vib = V3.new3(n4, 0.0f, Float.NaN);
        }
        if (this.isPDB) {
            this.setIsPDB();
        }
        this.atomSetCollection.setAtomSetAuxiliaryInfo("isCIF", Boolean.TRUE);
        if (this.isPDBX && this.skipping) {
            this.skipping = false;
        }
        return true;
    }

    protected boolean filterCIFAtom(Atom atom, int n, char c) {
        if (!this.filterAtom(atom, n)) {
            return false;
        }
        if (this.filterAssembly && this.filterReject(this.filter, "$", "" + c)) {
            return false;
        }
        if (this.configurationPtr > 0) {
            if (!this.disorderAssembly.equals(this.lastDisorderAssembly)) {
                this.lastDisorderAssembly = this.disorderAssembly;
                this.lastAltLoc = '\u0000';
                this.conformationIndex = this.configurationPtr;
            }
            if (atom.alternateLocationID != '\u0000') {
                if (this.conformationIndex >= 0 && atom.alternateLocationID != this.lastAltLoc) {
                    this.lastAltLoc = atom.alternateLocationID;
                    --this.conformationIndex;
                }
                if (this.conformationIndex != 0) {
                    Logger.info("ignoring " + atom.atomName);
                    return false;
                }
            }
        }
        return true;
    }

    private void processAssemblyGen() throws Exception {
        if (this.assem == null) {
            this.assem = new String[3];
        }
        if (this.key.indexOf("assembly_id") >= 0) {
            this.assem[0] = this.data = this.tokenizer.fullTrim(this.data);
        } else if (this.key.indexOf("oper_expression") >= 0) {
            this.assem[1] = this.data = this.tokenizer.fullTrim(this.data);
        } else if (this.key.indexOf("asym_id_list") >= 0) {
            this.assem[2] = this.data = this.tokenizer.fullTrim(this.data);
        }
        if (this.assem[0] != null && this.assem[1] != null && this.assem[2] != null) {
            this.addAssembly();
        }
    }

    private void processAssemblyGenBlock() throws Exception {
        this.parseLoopParameters(assemblyFields);
        this.assem = new String[3];
        while (this.tokenizer.getData()) {
            int n = 0;
            for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                int n2 = this.fieldProperty(i);
                switch (n2) {
                    case 0: 
                    case 1: 
                    case 2: {
                        ++n;
                        this.assem[n2] = this.field;
                    }
                }
            }
            if (n != 3) continue;
            this.addAssembly();
        }
        this.assem = null;
    }

    private void addAssembly() throws Exception {
        int n = this.parseIntStr(this.assem[0]);
        if (!this.checkFilterKey("ASSEMBLY " + n + ";")) {
            return;
        }
        if (this.vBiomolecules == null) {
            this.vBiomolecules = new JmolList();
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("molecule", n);
        hashtable.put("assemblies", "$" + this.assem[2].replace(',', '$'));
        hashtable.put("operators", this.assem[1]);
        hashtable.put("biomts", new JmolList());
        Logger.info("assembly " + n + " operators " + this.assem[1] + " ASYM_IDs " + this.assem[2]);
        this.vBiomolecules.addLast((Map<String, Object>)hashtable);
        this.assem = null;
    }

    private void processStructOperListBlock() throws Exception {
        this.parseLoopParameters(operFields);
        float[] fArray = new float[16];
        fArray[15] = 1.0f;
        while (this.tokenizer.getData()) {
            int n = 0;
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                int n2 = this.fieldProperty(i);
                switch (n2) {
                    case -1: {
                        continue block6;
                    }
                    case 12: {
                        string = this.field;
                        continue block6;
                    }
                    case 13: {
                        string2 = this.field;
                        continue block6;
                    }
                    default: {
                        fArray[n2] = this.parseFloatStr(this.field);
                        ++n;
                    }
                }
            }
            if (string == null || n != 12 && (string2 == null || this.symmetry == null)) continue;
            Logger.info("assembly operator " + string + " " + string2);
            Matrix4f matrix4f = new Matrix4f();
            if (n != 12) {
                this.symmetry.getMatrixFromString(string2, fArray, false);
                fArray[3] = fArray[3] * (this.symmetry.getUnitCellInfoType(0) / 12.0f);
                fArray[7] = fArray[7] * (this.symmetry.getUnitCellInfoType(1) / 12.0f);
                fArray[11] = fArray[11] * (this.symmetry.getUnitCellInfoType(2) / 12.0f);
            }
            matrix4f.setA(fArray, 0);
            if (this.htBiomts == null) {
                this.htBiomts = new Hashtable<String, Matrix4f>();
            }
            this.htBiomts.put(string, matrix4f);
        }
    }

    private void processNonpolyData() {
        if (this.hetatmData == null) {
            this.hetatmData = new String[3];
        }
        int n = nonpolyFields.length;
        while (--n >= 0) {
            if (!this.key.equals(nonpolyFields[n])) continue;
            this.hetatmData[n] = this.data;
            break;
        }
        if (this.hetatmData[1] == null || this.hetatmData[2] == null) {
            return;
        }
        this.addHetero(this.hetatmData[2], this.hetatmData[1]);
        this.hetatmData = null;
    }

    private void processChemCompLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompFields);
        while (this.tokenizer.getData()) {
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block6;
                    }
                    case 0: {
                        string = this.field;
                        continue block6;
                    }
                    case 1: {
                        string2 = this.field;
                    }
                }
            }
            if (string == null || string2 == null) continue;
            this.addHetero(string, string2);
        }
    }

    private void processNonpolyLoopBlock() throws Exception {
        this.parseLoopParameters(nonpolyFields);
        while (this.tokenizer.getData()) {
            String string = null;
            String string2 = null;
            block6: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: 
                    case 0: {
                        continue block6;
                    }
                    case 2: {
                        string = this.field;
                        continue block6;
                    }
                    case 1: {
                        string2 = this.field;
                    }
                }
            }
            if (string == null || string2 == null) {
                return;
            }
            this.addHetero(string, string2);
        }
    }

    private void addHetero(String string, String string2) {
        if (!JmolAdapter.isHetero(string)) {
            return;
        }
        if (this.htHetero == null) {
            this.htHetero = new Hashtable<String, String>();
        }
        this.htHetero.put(string, string2);
        if (Logger.debugging) {
            Logger.debug("hetero: " + string + " = " + string2);
        }
    }

    private void processStructConfLoopBlock() throws Exception {
        this.parseLoopParameters(structConfFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _struct_conf property:" + n);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure(-1, EnumStructure.HELIX, EnumStructure.HELIX, null, 0, 0);
            block15: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block15;
                    }
                    case 0: {
                        if (this.field.startsWith("TURN")) {
                            structure.structureType = structure.substructureType = EnumStructure.TURN;
                            continue block15;
                        }
                        if (this.field.startsWith("HELX")) continue block15;
                        structure.structureType = structure.substructureType = EnumStructure.NONE;
                        continue block15;
                    }
                    case 1: {
                        structure.startChainStr = this.field;
                        structure.startChainID = this.viewer.getChainID(this.field);
                        continue block15;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseIntStr(this.field);
                        continue block15;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block15;
                    }
                    case 4: {
                        structure.endChainStr = this.field;
                        structure.endChainID = this.viewer.getChainID(this.field);
                        continue block15;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseIntStr(this.field);
                        continue block15;
                    }
                    case 9: {
                        structure.substructureType = Structure.getHelixType(this.parseIntStr(this.field));
                        continue block15;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                        continue block15;
                    }
                    case 7: {
                        structure.structureID = this.field;
                        continue block15;
                    }
                    case 8: {
                        structure.serialID = this.parseIntStr(this.field);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    private void processStructSheetRangeLoopBlock() throws Exception {
        this.parseLoopParameters(structSheetRangeFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _struct_conf property:" + n);
            this.skipLoop();
            return;
        }
        while (this.tokenizer.getData()) {
            Structure structure = new Structure(-1, EnumStructure.SHEET, EnumStructure.SHEET, null, 0, 0);
            block12: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 1: {
                        structure.startChainID = this.viewer.getChainID(this.field);
                        continue block12;
                    }
                    case 2: {
                        structure.startSequenceNumber = this.parseIntStr(this.field);
                        continue block12;
                    }
                    case 3: {
                        structure.startInsertionCode = this.firstChar;
                        continue block12;
                    }
                    case 4: {
                        structure.endChainID = this.viewer.getChainID(this.field);
                        continue block12;
                    }
                    case 5: {
                        structure.endSequenceNumber = this.parseIntStr(this.field);
                        continue block12;
                    }
                    case 6: {
                        structure.endInsertionCode = this.firstChar;
                        continue block12;
                    }
                    case 0: {
                        structure.strandCount = 1;
                        structure.structureID = this.field;
                        continue block12;
                    }
                    case 7: {
                        structure.serialID = this.parseIntStr(this.field);
                    }
                }
            }
            this.atomSetCollection.addStructure(structure);
        }
    }

    private void processStructSiteBlock() throws Exception {
        this.parseLoopParameters(structSiteRangeFields);
        int n = 3;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _struct_site property:" + n);
            this.skipLoop();
            return;
        }
        String string = "";
        String string2 = "";
        String string3 = "";
        String string4 = "";
        String string5 = "";
        String string6 = "";
        Map<String, Object> map = null;
        this.htSites = new Hashtable<String, Map<String, Object>>();
        while (this.tokenizer.getData()) {
            for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: {
                        if (string6 != "") {
                            String string7 = (String)map.get("groups");
                            string7 = string7 + (string7.length() == 0 ? "" : ",") + string6;
                            string6 = "";
                            map.put("groups", string7);
                        }
                        if ((map = this.htSites.get(string = this.field)) == null) {
                            map = new Hashtable<String, Object>();
                            map.put("groups", "");
                            this.htSites.put(string, map);
                        }
                        string2 = "";
                        string3 = "";
                        string4 = "";
                        string5 = "";
                        break;
                    }
                    case 1: {
                        string5 = this.field;
                        break;
                    }
                    case 2: {
                        string4 = this.field;
                        break;
                    }
                    case 3: {
                        string2 = this.field;
                        break;
                    }
                    case 4: {
                        string3 = this.field;
                    }
                }
                if (string2 == "" || string5 == "") continue;
                string6 = "[" + string5 + "]" + string2 + (string3.length() > 0 ? "^" + string3 : "") + (string4.length() > 0 ? ":" + string4 : "");
            }
        }
        if (string6 != "") {
            String string8 = (String)map.get("groups");
            string8 = string8 + (string8.length() == 0 ? "" : ",") + string6;
            string6 = "";
            map.put("groups", string8);
        }
    }

    private void processSymmetryOperationsLoopBlock() throws Exception {
        this.parseLoopParameters(symmetryOperationsFields);
        int n = 0;
        this.symops = new JmolList();
        int n2 = this.propertyCount;
        while (--n2 >= 0) {
            if (this.fieldOf[n2] == -1) continue;
            ++n;
        }
        if (n != 1) {
            Logger.warn("?que? _symmetry_equiv or _space_group_symop property not found");
            this.skipLoop();
            return;
        }
        n2 = 0;
        while (this.tokenizer.getData()) {
            boolean bl = false;
            block7: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 2: {
                        if (this.field.indexOf(126) >= 0) {
                            this.field = TextFormat.simpleReplace(this.field, "~", "");
                        }
                    }
                    case 3: {
                        this.incommensurate = true;
                        bl = true;
                    }
                    case 0: 
                    case 1: {
                        if (!this.allowRotations && ++n2 != 1 || this.incommensurate && !bl) continue block7;
                        this.symops.addLast(this.field);
                        this.setSymmetryOperator(this.field);
                    }
                }
            }
        }
    }

    private void processLigandBondLoopBlock() throws Exception {
        this.parseLoopParameters(chemCompBondFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _chem_comp_bond property:" + n);
            this.skipLoop();
            return;
        }
        n = 0;
        boolean bl = false;
        while (this.tokenizer.getData()) {
            int n2 = -1;
            int n3 = -1;
            n = 0;
            bl = false;
            block12: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case 0: {
                        n2 = this.atomSetCollection.getAtomIndexFromName(this.field);
                        continue block12;
                    }
                    case 1: {
                        n3 = this.atomSetCollection.getAtomIndexFromName(this.field);
                        continue block12;
                    }
                    case 3: {
                        bl = this.field.charAt(0) == 'Y';
                        continue block12;
                    }
                    case 2: {
                        n = this.getBondOrder(this.field);
                    }
                }
            }
            if (n2 < 0 || n3 < 0) continue;
            if (bl) {
                switch (n) {
                    case 1: {
                        n = 513;
                        break;
                    }
                    case 2: {
                        n = 514;
                    }
                }
            }
            this.atomSetCollection.addNewBondWithOrder(n2, n3, n);
        }
    }

    private int getBondOrder(String string) {
        switch (string.charAt(0)) {
            default: {
                Logger.warn("unknown CIF bond order: " + string);
            }
            case 'S': {
                return 1;
            }
            case 'D': {
                return 2;
            }
            case 'T': {
                return 3;
            }
            case 'A': 
        }
        this.haveAromatic = true;
        return 515;
    }

    private void processGeomBondLoopBlock() throws Exception {
        this.parseLoopParameters(geomBondFields);
        int n = this.propertyCount;
        while (--n >= 0) {
            if (this.propertyOf[n] == 3 || this.fieldOf[n] != -1) continue;
            Logger.warn("?que? missing _geom_bond property:" + n);
            this.skipLoop();
            return;
        }
        String string = null;
        String string2 = null;
        Integer n2 = 1;
        while (this.tokenizer.getData()) {
            int n3 = -1;
            int n4 = -1;
            float f = 0.0f;
            float f2 = 0.0f;
            block9: for (int i = 0; i < this.tokenizer.fieldCount; ++i) {
                switch (this.fieldProperty(i)) {
                    case -1: {
                        continue block9;
                    }
                    case 0: {
                        string = this.field;
                        n3 = this.atomSetCollection.getAtomIndexFromName(string);
                        continue block9;
                    }
                    case 1: {
                        string2 = this.field;
                        n4 = this.atomSetCollection.getAtomIndexFromName(string2);
                        continue block9;
                    }
                    case 2: {
                        f = this.parseFloatStr(this.field);
                        int n5 = this.field.indexOf(40);
                        if (n5 >= 0) {
                            char[] cArray = this.field.toCharArray();
                            String string3 = this.field.substring(n5 + 1, this.field.length() - 1);
                            int n6 = string3.length();
                            int n7 = n5;
                            while (--n7 >= 0) {
                                if (cArray[n7] == '.') {
                                    --n7;
                                }
                                cArray[n7] = --n6 < 0 ? 48 : (int)string3.charAt(n6);
                            }
                            f2 = this.parseFloatStr(String.valueOf(cArray));
                            if (!Float.isNaN(f2)) continue block9;
                            Logger.info("error reading uncertainty for " + this.line);
                            f2 = 0.015f;
                            continue block9;
                        }
                        f2 = 0.015f;
                        continue block9;
                    }
                    case 3: {
                        n2 = this.getBondOrder(this.field);
                    }
                }
            }
            if (n3 < 0 || n4 < 0 || !(f > 0.0f)) continue;
            this.bondTypes.addLast(new Object[]{string, string2, Float.valueOf(f), Float.valueOf(f2), n2});
        }
    }

    private void setBondingAndMolecules() {
        int n;
        int n2;
        Logger.info("CIF creating molecule " + (this.bondTypes.size() > 0 ? " using GEOM_BOND records" : ""));
        this.atoms = this.atomSetCollection.getAtoms();
        this.firstAtom = this.atomSetCollection.getLastAtomSetAtomIndex();
        int n3 = this.atomSetCollection.getLastAtomSetAtomCount();
        this.atomCount = this.firstAtom + n3;
        this.bsSets = new BS[n3];
        this.symmetry = this.atomSetCollection.getSymmetry();
        for (n2 = this.firstAtom; n2 < this.atomCount; ++n2) {
            n = this.atomSetCollection.getAtomIndexFromName(this.atoms[n2].atomName) - this.firstAtom;
            if (this.bsSets[n] == null) {
                this.bsSets[n] = new BS();
            }
            this.bsSets[n].set(n2 - this.firstAtom);
        }
        if (this.isMolecular) {
            this.atomRadius = new float[this.atomCount];
            for (n2 = this.firstAtom; n2 < this.atomCount; ++n2) {
                int n4;
                n = JmolAdapter.getElementNumber(this.atoms[n2].getElementSymbol());
                this.atoms[n2].elementNumber = (short)n;
                int n5 = n4 = this.atoms[n2].formalCharge == Integer.MIN_VALUE ? 0 : this.atoms[n2].formalCharge;
                if (n <= 0) continue;
                this.atomRadius[n2] = JmolAdapter.getBondingRadiusFloat(n, n4);
            }
            this.bsConnected = new BS[this.atomCount];
            for (n2 = this.firstAtom; n2 < this.atomCount; ++n2) {
                this.bsConnected[n2] = new BS();
            }
            this.bsMolecule = new BS();
            this.bsExclude = new BS();
        }
        n2 = 1;
        while (this.createBonds(n2 != 0)) {
            n2 = 0;
        }
        if (this.isMolecular) {
            if (this.atomSetCollection.bsAtoms == null) {
                this.atomSetCollection.bsAtoms = new BS();
            }
            this.atomSetCollection.bsAtoms.clearBits(this.firstAtom, this.atomCount);
            this.atomSetCollection.bsAtoms.or(this.bsMolecule);
            this.atomSetCollection.bsAtoms.andNot(this.bsExclude);
            for (n = this.firstAtom; n < this.atomCount; ++n) {
                if (this.atomSetCollection.bsAtoms.get(n)) {
                    this.symmetry.toCartesian(this.atoms[n], true);
                    continue;
                }
                if (!Logger.debugging) continue;
                Logger.debug(this.molecularType + " removing " + n + " " + this.atoms[n].atomName + " " + this.atoms[n]);
            }
            this.atomSetCollection.setAtomSetAuxiliaryInfo("notionalUnitcell", null);
            if (this.nMolecular++ == this.atomSetCollection.getCurrentAtomSetIndex()) {
                this.atomSetCollection.clearGlobalBoolean(0);
                this.atomSetCollection.clearGlobalBoolean(1);
                this.atomSetCollection.clearGlobalBoolean(2);
            }
        }
        if (this.bondTypes.size() > 0) {
            this.atomSetCollection.setAtomSetAuxiliaryInfo("hasBonds", Boolean.TRUE);
        }
        this.bondTypes.clear();
        this.atomRadius = null;
        this.bsSets = null;
        this.bsConnected = null;
        this.bsMolecule = null;
        this.bsExclude = null;
    }

    private boolean createBonds(boolean bl) {
        int n;
        BS bS;
        int n2;
        int n3;
        int n4;
        int n5 = this.bondTypes.size();
        while (--n5 >= 0) {
            Object[] objectArray = (Object[])this.bondTypes.get(n5);
            float f = ((Float)objectArray[2]).floatValue();
            float f2 = ((Float)objectArray[3]).floatValue();
            n4 = (Integer)objectArray[4];
            n3 = this.atomSetCollection.getAtomIndexFromName((String)objectArray[0]);
            n2 = this.atomSetCollection.getAtomIndexFromName((String)objectArray[1]);
            BS bS2 = this.bsSets[n3 - this.firstAtom];
            bS = this.bsSets[n2 - this.firstAtom];
            if (bS2 == null || bS == null) continue;
            n = bS2.nextSetBit(0);
            while (n >= 0) {
                int n6 = bS.nextSetBit(0);
                while (n6 >= 0) {
                    if (!(this.isMolecular && this.bsConnected[n + this.firstAtom].get(n6) || !this.symmetry.checkDistance(this.atoms[n + this.firstAtom], this.atoms[n6 + this.firstAtom], f, f2, 0, 0, 0, this.ptOffset))) {
                        this.addNewBond(n + this.firstAtom, n6 + this.firstAtom, n4);
                    }
                    n6 = bS.nextSetBit(n6 + 1);
                }
                n = bS2.nextSetBit(n + 1);
            }
        }
        if (this.bondTypes.size() > 0) {
            for (n5 = this.firstAtom; n5 < this.atomCount; ++n5) {
                if (this.atoms[n5].elementNumber != 1) continue;
                boolean bl2 = this.atoms[n5].alternateLocationID != '\u0000';
                for (int i = this.firstAtom; i < this.atomCount; ++i) {
                    if (i == n5 || this.atoms[i].elementNumber == 1 || bl2 && this.atoms[i].alternateLocationID != '\u0000' && this.atoms[i].alternateLocationID != this.atoms[n5].alternateLocationID || this.bsConnected[n5].get(i) || !this.symmetry.checkDistance(this.atoms[n5], this.atoms[i], 1.1f, 0.0f, 0, 0, 0, this.ptOffset)) continue;
                    this.addNewBond(n5, i, 1);
                }
            }
        }
        if (!this.isMolecular) {
            return false;
        }
        if (bl) {
            for (n5 = this.firstAtom; n5 < this.atomCount; ++n5) {
                if (this.atoms[n5].atomSite + this.firstAtom != n5 || this.bsMolecule.get(n5)) continue;
                this.setBs(this.atoms, n5, this.bsConnected, this.bsMolecule);
            }
        }
        float f = this.viewer.getFloat(0x22000004);
        BS bS3 = new BS();
        P3 p3 = new P3();
        P3 p32 = new P3();
        n4 = 2;
        for (n3 = this.firstAtom; n3 < this.atomCount; ++n3) {
            if (this.bsMolecule.get(n3) || this.bsExclude.get(n3)) continue;
            n2 = this.bsMolecule.nextSetBit(0);
            while (n2 >= 0) {
                if (this.symmetry.checkDistance(this.atoms[n2], this.atoms[n3], this.atomRadius[n3] + this.atomRadius[n2] + f, 0.0f, n4, n4, n4, this.ptOffset)) {
                    this.setBs(this.atoms, n3, this.bsConnected, bS3);
                    int n7 = bS3.nextSetBit(0);
                    while (n7 >= 0) {
                        this.atoms[n7].add(this.ptOffset);
                        p3.setT(this.atoms[n7]);
                        this.symmetry.toCartesian(p3, true);
                        bS = this.bsSets[this.atomSetCollection.getAtomIndexFromName(this.atoms[n7].atomName) - this.firstAtom];
                        if (bS != null) {
                            n = bS.nextSetBit(0);
                            while (n >= 0) {
                                if (n + this.firstAtom != n7) {
                                    p32.setT(this.atoms[n + this.firstAtom]);
                                    this.symmetry.toCartesian(p32, true);
                                    if (p32.distance(p3) < 0.1f) {
                                        this.bsExclude.set(n7);
                                        break;
                                    }
                                }
                                n = bS.nextSetBit(n + 1);
                            }
                        }
                        this.bsMolecule.set(n7);
                        n7 = bS3.nextSetBit(n7 + 1);
                    }
                    return true;
                }
                n2 = this.bsMolecule.nextSetBit(n2 + 1);
            }
        }
        return false;
    }

    private void addNewBond(int n, int n2, int n3) {
        this.atomSetCollection.addNewBondWithOrder(n, n2, n3);
        if (!this.isMolecular) {
            return;
        }
        this.bsConnected[n].set(n2);
        this.bsConnected[n2].set(n);
    }

    private void setBs(Atom[] atomArray, int n, BS[] bSArray, BS bS) {
        BS bS2 = bSArray[n];
        bS.set(n);
        int n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            if (!bS.get(n2)) {
                this.setBs(atomArray, n2, bSArray, bS);
            }
            n2 = bS2.nextSetBit(n2 + 1);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void processModulationLoopBlock() throws Exception {
        if (this.atomSetCollection.getCurrentAtomSetIndex() < 0) {
            this.atomSetCollection.newAtomSet();
        }
        this.parseLoopParameters(CifReader.modulationFields);
        while (this.tokenizer.getData()) {
            var2_2 = false;
            var3_3 = null;
            var4_4 = null;
            var5_5 = null;
            var6_6 = P3.new3(NaNf, NaNf, NaNf);
            var7_7 = NaNf;
            var8_8 = NaNf;
            var9_9 = null;
            block35: for (var10_10 = 0; var10_10 < this.tokenizer.fieldCount; ++var10_10) {
                var1_1 = this.fieldProperty(var10_10);
                switch (var1_1) {
                    case 40: 
                    case 41: 
                    case 42: {
                        var9_9 = "#=P" + Character.toUpperCase(CifReader.modulationFields[var1_1].charAt(11)) + "_" + this.field;
                        var6_6.z = 0.0f;
                        var6_6.y = 0.0f;
                        var6_6.x = 0.0f;
                        break;
                    }
                    case 0: 
                    case 4: {
                        var6_6.z = 0.0f;
                        var6_6.y = 0.0f;
                        var6_6.x = 0.0f;
                    }
                    case 13: 
                    case 19: 
                    case 35: 
                    case 43: 
                    case 44: 
                    case 45: {
                        switch (var1_1) {
                            case 0: {
                                var3_3 = "W_";
                                break;
                            }
                            case 4: {
                                var3_3 = "F_";
                                break;
                            }
                            case 13: 
                            case 19: 
                            case 35: {
                                var3_3 = "" + Character.toUpperCase(CifReader.modulationFields[var1_1].charAt(11)) + "_";
                                break;
                            }
                            case 43: 
                            case 44: 
                            case 45: {
                                var3_3 = "P" + Character.toUpperCase(CifReader.modulationFields[var1_1].charAt(11)) + "_";
                            }
                        }
                        var3_3 = var3_3 + this.field;
                        break;
                    }
                    case 46: {
                        var3_3 = "J_O";
                        var6_6.z = 1.0f;
                        var6_6.x = 1.0f;
                    }
                    case 24: {
                        if (var3_3 == null) {
                            var3_3 = "D_S";
                        }
                    }
                    case 30: {
                        if (var3_3 == null) {
                            var3_3 = "O_0";
                        }
                        var5_5 = "0";
                    }
                    case 11: 
                    case 18: 
                    case 33: {
                        var4_4 = this.field;
                        break;
                    }
                    case 12: {
                        if (this.modAxes != null && this.modAxes.indexOf(var5_5.toUpperCase()) < 0) {
                            var2_2 = true;
                        }
                        var5_5 = this.field;
                        break;
                    }
                    case 34: {
                        var5_5 = this.field.toUpperCase();
                        break;
                    }
                    case 14: 
                    case 20: 
                    case 31: 
                    case 36: {
                        var6_6.z = 0.0f;
                    }
                    case 1: 
                    case 5: 
                    case 25: {
                        var6_6.x = this.parseFloatStr(this.field);
                        break;
                    }
                    case 8: {
                        var3_3 = var3_3 + "_q_";
                        var6_6.x = this.parseFloatStr(this.field);
                        switch (this.modDim) {
                            case 1: {
                                var6_6.y = 0.0f;
                            }
                            case 2: {
                                var6_6.z = 0.0f;
                            }
                        }
                        break;
                    }
                    case 16: 
                    case 22: 
                    case 38: {
                        var6_6.x = this.parseFloatStr(this.field);
                        var6_6.z = 1.0f;
                        break;
                    }
                    case 21: {
                        var6_6.y = this.parseFloatStr(this.field);
                        var5_5 = "0";
                        break;
                    }
                    case 2: 
                    case 6: 
                    case 9: 
                    case 15: 
                    case 17: 
                    case 23: 
                    case 26: 
                    case 32: 
                    case 37: 
                    case 39: 
                    case 47: {
                        var6_6.y = this.parseFloatStr(this.field);
                        break;
                    }
                    case 3: 
                    case 7: 
                    case 10: 
                    case 27: {
                        var6_6.z = this.parseFloatStr(this.field);
                        break;
                    }
                    case 28: {
                        var7_7 = this.parseFloatStr(this.field);
                        break;
                    }
                    case 29: {
                        var8_8 = this.parseFloatStr(this.field);
                    }
                }
                if (var2_2 || Float.isNaN(var6_6.x + var6_6.y + var6_6.z) || var6_6.x == 0.0f && var6_6.y == 0.0f && var6_6.z == 0.0f || var3_3 == null || var4_4 != null && this.rejectAtomName(var4_4)) continue;
                switch (var3_3.charAt(0)) {
                    case 'F': 
                    case 'W': {
                        ** GOTO lbl112
                    }
                    case 'D': 
                    case 'J': 
                    case 'O': 
                    case 'U': {
                        if (var4_4 == null || var5_5 == null) continue block35;
                        if (var3_3.equals("D_S")) {
                            if (Float.isNaN(var7_7) || Float.isNaN(var8_8)) continue block35;
                            if (var6_6.x != 0.0f) {
                                this.addMod("D_S#x;" + var4_4, var9_9, P3.new3(var7_7, var8_8, var6_6.x));
                            }
                            if (var6_6.y != 0.0f) {
                                this.addMod("D_S#y;" + var4_4, var9_9, P3.new3(var7_7, var8_8, var6_6.y));
                            }
                            if (var6_6.z == 0.0f) continue block35;
                            this.addMod("D_S#z;" + var4_4, var9_9, P3.new3(var7_7, var8_8, var6_6.z));
                            continue block35;
                        }
                        var3_3 = var3_3 + "#" + var5_5 + ";" + var4_4;
                    }
lbl112:
                    // 3 sources

                    default: {
                        this.addMod(var3_3, var9_9, var6_6);
                    }
                }
            }
        }
    }

    private void addMod(String string, String string2, P3 p3) {
        if (string2 != null) {
            string = string + string2;
        }
        this.addModulation(null, string, p3, -1);
    }

    private void processSubsystemLoopBlock() throws Exception {
        this.parseLoopParameters(null);
        while (this.tokenizer.getData()) {
            this.fieldProperty(0);
            this.addSubsystem(this.field, this.getMatrix4(1), null);
        }
    }

    private Matrix4f getMatrix4(int n) {
        Matrix4f matrix4f = new Matrix4f();
        float[] fArray = new float[16];
        while (n < this.tokenizer.fieldCount) {
            String string = this.fields[this.fieldProperty(n)];
            if (string.contains("_w_")) {
                int n2 = string.charAt(string.length() - 3) - 49;
                int n3 = string.charAt(string.length() - 1) - 49;
                fArray[n2 * 4 + n3] = this.parseFloatStr(this.field);
            }
            ++n;
        }
        matrix4f.setA(fArray, 0);
        return matrix4f;
    }
}

