/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.io.FileWriter;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import jspecview.export.FormContext;
import jspecview.util.JSVFileManager;
import jspecview.util.JSVLogger;

abstract class FormExporter {
    FormContext context = new FormContext();
    String errMsg;
    String outputFile;
    FileWriter writer;
    Calendar now;
    SimpleDateFormat formatter;
    String currentTime;

    FormExporter() {
    }

    protected void initForm(String fileName) {
        this.outputFile = fileName;
        Calendar now = Calendar.getInstance();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss.SSSS ZZZZ");
        this.currentTime = formatter.format(now.getTime());
    }

    protected String writeForm(String templateFile) throws IOException {
        String[] error = new String[1];
        String template = JSVFileManager.getResourceString(this, templateFile, error);
        if (template == null) {
            JSVLogger.error(error[0]);
            return error[0];
        }
        this.errMsg = this.context.setTemplate(template);
        if (this.errMsg != null) {
            JSVLogger.error(this.errMsg);
            return this.errMsg;
        }
        FileWriter writer = this.outputFile == null ? null : new FileWriter(this.outputFile);
        this.errMsg = this.context.merge(writer);
        if (writer == null) {
            return this.errMsg;
        }
        if (this.errMsg != null) {
            JSVLogger.error(this.errMsg);
            throw new IOException(this.errMsg);
        }
        try {
            writer.flush();
            writer.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return " OK";
    }
}

