/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.List;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.common.ScaleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ViewData {
    private ScaleData[] scaleData;
    private ScaleData thisScale;
    private int nSpectra;
    private int iThisScale;

    ScaleData[] getScaleData() {
        return this.scaleData;
    }

    ScaleData getScale() {
        return this.thisScale;
    }

    ViewData(List<JDXSpectrum> spectra, double yPt1, double yPt2, int[] startList, int[] endList, boolean isContinuous, boolean is2D) {
        this.nSpectra = is2D ? 1 : spectra.size();
        this.scaleData = new ScaleData[this.nSpectra];
        int j = 0;
        while (j < this.nSpectra) {
            this.scaleData[j] = new ScaleData(startList[j], endList[j]);
            ++j;
        }
        this.init(spectra, yPt1, yPt2, isContinuous);
    }

    ViewData(List<JDXSpectrum> spectra, double yPt1, double yPt2, boolean isContinuous) {
        this.nSpectra = spectra.size();
        int n = spectra.get(0).getXYCoords().length;
        this.scaleData = new ScaleData[1];
        this.scaleData[0] = new ScaleData(0, n - 1);
        this.init(spectra, yPt1, yPt2, isContinuous);
    }

    private void init(List<JDXSpectrum> spectra, double yPt1, double yPt2, boolean isContinuous) {
        this.iThisScale = 0;
        this.thisScale = this.scaleData[0];
        int i = 0;
        while (i < this.scaleData.length) {
            this.scaleData[i].userYFactor = spectra.get(i).getUserYFactor();
            this.scaleData[i].spectrumYRef = spectra.get(i).getYRef();
            ++i;
        }
        this.resetScaleFactors();
        double minX = Coordinate.getMinX(spectra, this);
        double maxX = Coordinate.getMaxX(spectra, this);
        double minY = Coordinate.getMinYUser(spectra, this);
        double maxY = Coordinate.getMaxYUser(spectra, this);
        if (yPt1 != yPt2 && (minY = yPt1) > (maxY = yPt2)) {
            double t = minY;
            minY = maxY;
            maxY = t;
        }
        boolean isInverted = spectra.get(0).isInverted();
        int i2 = 0;
        while (i2 < this.scaleData.length) {
            this.scaleData[i2].setMinMax(minX, maxX, minY, maxY);
            this.scaleData[i2].setScale(isContinuous, isInverted);
            ++i2;
        }
    }

    void newSpectrum(List<JDXSpectrum> spectra) {
        this.init(spectra, 0.0, 0.0, false);
    }

    void setXRangeForSubSpectrum(Coordinate[] xyCoords) {
        this.setXRange(0, xyCoords, this.scaleData[0].minX, this.scaleData[0].maxX, 0, xyCoords.length - 1);
    }

    private int setXRange(int i, Coordinate[] xyCoords, double initX, double finalX, int iStart, int iEnd) {
        double x;
        int index = 0;
        int ptCount = 0;
        index = iStart;
        while (index <= iEnd) {
            x = xyCoords[index].getXVal();
            if (x >= initX) {
                this.scaleData[i % this.scaleData.length].startDataPointIndex = index;
                break;
            }
            ++index;
        }
        while (index <= iEnd) {
            x = xyCoords[index].getXVal();
            ++ptCount;
            if (x >= finalX) break;
            ++index;
        }
        this.scaleData[i % this.scaleData.length].endDataPointIndex = index - 1;
        return ptCount;
    }

    int getStartingPointIndex(int i) {
        return this.scaleData[i % this.scaleData.length].startDataPointIndex;
    }

    int getEndingPointIndex(int i) {
        return this.scaleData[i % this.scaleData.length].endDataPointIndex;
    }

    boolean areYScalesSame(int i, int j) {
        return this.scaleData[i %= this.scaleData.length].minYOnScale == this.scaleData[j %= this.scaleData.length].minYOnScale && this.scaleData[i].maxYOnScale == this.scaleData[j].maxYOnScale;
    }

    void setScale(int i, int xPixels, int yPixels, boolean isInverted) {
        this.iThisScale = i % this.scaleData.length;
        this.thisScale = this.scaleData[this.iThisScale];
        this.thisScale.setScale(xPixels, yPixels, isInverted);
    }

    void resetScaleFactors() {
        int i = 0;
        while (i < this.scaleData.length) {
            this.scaleData[i].spectrumScaleFactor = 1.0;
            ++i;
        }
    }

    void scaleSpectrum(int i, double f) {
        if (f <= 0.0 || i >= this.nSpectra) {
            return;
        }
        if (i == -2) {
            this.thisScale.scale2D(f);
            return;
        }
        if (i < 0) {
            i = 0;
            while (i < this.scaleData.length) {
                this.scaleData[i].scaleBy(f);
                ++i;
            }
        } else {
            this.scaleData[i % this.scaleData.length].scaleBy(f);
        }
    }

    ScaleData[] getNewScales(int iSelected, boolean isXOnly, double y1, double y2) {
        if (isXOnly) {
            return this.scaleData;
        }
        iSelected %= this.scaleData.length;
        double f1 = (y1 - this.thisScale.minYOnScale) / (this.thisScale.maxYOnScale - this.thisScale.minYOnScale);
        double f2 = (y2 - this.thisScale.minYOnScale) / (this.thisScale.maxYOnScale - this.thisScale.minYOnScale);
        ScaleData[] sd = new ScaleData[this.scaleData.length];
        int i = 0;
        while (i < this.scaleData.length) {
            sd[i] = iSelected >= 0 && i != iSelected ? this.scaleData[i] : new ScaleData();
            ++i;
        }
        ScaleData.copyScaleFactors(this.scaleData, sd);
        ScaleData.copyYScales(this.scaleData, sd);
        i = 0;
        while (i < this.scaleData.length) {
            if (iSelected < 0 || i == iSelected) {
                sd[i].isShiftZoomedY = true;
                sd[i].minYOnScale = this.scaleData[i].minYOnScale * (1.0 - f1) + f1 * this.scaleData[i].maxYOnScale;
                sd[i].maxYOnScale = this.scaleData[i].minYOnScale * (1.0 - f2) + f2 * this.scaleData[i].maxYOnScale;
            }
            ++i;
        }
        return sd;
    }
}

