/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jspecview.common.ScriptTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ScriptToken {
    UNKNOWN,
    APPLETID,
    APPLETREADYCALLBACKFUNCTIONNAME,
    AUTOINTEGRATE("TF"),
    BACKGROUNDCOLOR("C"),
    CLOSE("spectrumId or fileName or ALL"),
    COMPOUNDMENUON("TF"),
    COORDCALLBACKFUNCTIONNAME,
    COORDINATESCOLOR("C"),
    COORDINATESON("T"),
    DEBUG("TF"),
    DISPLAYFONTNAME("fontName"),
    DISPLAY1D("T"),
    DISPLAY2D("T"),
    ENABLEZOOM("T"),
    ENDINDEX,
    EXPORT("[XY,DIF,DIFDUP,PAC,FIX,SQZ,AML,CML,JPG,PNG,SVG,SVGI] \"filename\""),
    FINDX("x-value"),
    GETPROPERTY("[ALL] [propertyName]"),
    GETSOLUTIONCOLOR,
    GRIDCOLOR("C"),
    GRIDON("T"),
    HIDDEN("TF"),
    HIGHLIGHTCOLOR("C"),
    INTEGRALOFFSET("percent"),
    INTEGRALRANGE("percent"),
    INTEGRATE,
    INTEGRATION("ON/OFF/AUTO/TOGGLE/MIN value/MARK ppm1-ppm2:norm,ppm3-ppm4,... (start with 0-0 to clear)"),
    INTEGRALPLOTCOLOR,
    INTEGRATIONRATIOS,
    INTERFACE,
    IRMODE("A or T or TOGGLE"),
    JMOL("...Jmol command..."),
    JSV,
    LABEL("x y [color and/or \"text\"]"),
    LINK("AB or ABC or NONE or ALL"),
    LOAD("[APPEND] \"fileName\" [first] [last]; use \"\" to reload current file"),
    LOADFILECALLBACKFUNCTIONNAME,
    LOADIMAGINARY("T/F - default is to NOT load imaginary spectra"),
    MENUON,
    OBSCURE,
    OVERLAY,
    OVERLAYSTACKED("TF"),
    PEAK("<type(IR,CNMR,HNMR,MS, etc)> id=xxx or \"match\" [ALL], for example: PEAK HNMR id=3"),
    PEAKCALLBACKFUNCTIONNAME,
    PEAKLIST(" Example: PEAKLIST threshold=20 [%, or include=10] skip=0 interpolate=parabolic [or NONE]"),
    PEAKTABCOLOR("C"),
    PLOTAREACOLOR("C"),
    PLOTCOLOR("C"),
    PLOTCOLORS("color,color,color,..."),
    PRINT,
    REVERSEPLOT("T"),
    SCALEBY("factor"),
    SCALECOLOR("C"),
    SCRIPT("filename.jsv"),
    SELECT("spectrumID, spectrumID,..."),
    SETPEAK("x (ppm) or NONE does peak search, unlike SETX -- NMR only"),
    SETX("x (ppm) does no peak search, unlike SETPEAK -- NMR only"),
    SHIFTX("dx (ppm) or NONE -- NMR only"),
    SHOWINTEGRATION("T"),
    SHOWMEASUREMENTS("T"),
    SHOWPEAKLIST("T"),
    SPECTRUM("spectrumID"),
    SPECTRUMNUMBER,
    STACKOFFSETY("percent"),
    STARTINDEX,
    SYNCCALLBACKFUNCTIONNAME,
    SYNCID,
    TEST,
    TITLEON("T"),
    TITLEBOLDON("T"),
    TITLECOLOR("C"),
    TITLEFONTNAME("fontName"),
    UNITSCOLOR("C"),
    VERSION,
    VIEW("spectrumID, spectrumID, ... Example: VIEW 3.1, 3.2  or  VIEW \"acetophenone\""),
    XSCALEON("T"),
    XUNITSON("T"),
    YSCALE("[ALL] lowValue highValue"),
    YSCALEON("T"),
    YUNITSON("T"),
    ZOOM("OUT or x1,x2 or x1,y1 x2,y2"),
    ZOOMBOXCOLOR,
    ZOOMBOXCOLOR2;

    private String tip;
    public static Map<String, ScriptToken> htParams;

    public String getTip() {
        return "  " + (this.tip == "T" ? "TRUE/FALSE/TOGGLE" : (this.tip == "TF" ? "TRUE or FALSE" : (this.tip == "C" ? "<color>" : this.tip)));
    }

    private ScriptToken() {
    }

    private ScriptToken(String tip) {
        this.tip = tip;
    }

    public static ScriptToken getScriptToken(String name) {
        ScriptToken st;
        if (htParams == null) {
            htParams = new Hashtable<String, ScriptToken>();
            ScriptToken[] scriptTokenArray = ScriptToken.values();
            int n = scriptTokenArray.length;
            int n2 = 0;
            while (n2 < n) {
                ScriptToken item = scriptTokenArray[n2];
                htParams.put(item.name(), item);
                ++n2;
            }
        }
        return (st = htParams.get(name.toUpperCase())) == null ? UNKNOWN : st;
    }

    public static List<ScriptToken> getScriptTokenList(String name, boolean isExact) {
        name = name.toUpperCase();
        ArrayList<ScriptToken> list = new ArrayList<ScriptToken>();
        ScriptToken st = ScriptToken.getScriptToken(name);
        if (isExact) {
            if (st != null) {
                list.add(st);
            }
        } else {
            for (Map.Entry<String, ScriptToken> entry : htParams.entrySet()) {
                if (!entry.getKey().startsWith(name) || entry.getValue().tip == null) continue;
                list.add(entry.getValue());
            }
        }
        return list;
    }

    public static String getValue(ScriptToken st, ScriptTokenizer params, String cmd) {
        if (!params.hasMoreTokens()) {
            return "";
        }
        switch (st) {
            default: {
                return ScriptTokenizer.nextStringToken(params, true);
            }
            case CLOSE: 
            case EXPORT: 
            case GETPROPERTY: 
            case INTEGRATE: 
            case INTEGRATION: 
            case JMOL: 
            case LABEL: 
            case LOAD: 
            case PEAK: 
            case PLOTCOLORS: 
            case YSCALE: {
                return ScriptToken.removeCommandName(cmd);
            }
            case OVERLAY: 
            case SELECT: 
            case VIEW: 
            case ZOOM: 
        }
        return ScriptToken.removeCommandName(cmd).replace(',', ' ').trim();
    }

    private static String removeCommandName(String cmd) {
        int pt = cmd.indexOf(" ");
        if (pt < 0) {
            return "";
        }
        return cmd.substring(pt).trim();
    }

    public static String getKey(ScriptTokenizer eachParam) {
        String key = eachParam.nextToken();
        if (key.startsWith("#") || key.startsWith("//")) {
            return null;
        }
        if (key.equalsIgnoreCase("SET")) {
            key = eachParam.nextToken();
        }
        return key.toUpperCase();
    }

    public static List<String> getTokens(String value) {
        ArrayList<String> tokens = new ArrayList<String>();
        ScriptTokenizer st = new ScriptTokenizer(value, false);
        while (st.hasMoreTokens()) {
            String s = ScriptTokenizer.nextStringToken(st, false);
            if (s.startsWith("//") || s.startsWith("#")) break;
            tokens.add(s);
        }
        return tokens;
    }

    public static String getNameList(List<ScriptToken> list) {
        if (list.size() == 0) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < list.size()) {
            sb.append(",").append((Object)list.get(i));
            ++i;
        }
        return sb.toString().substring(1);
    }
}

