/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.Integral;
import jspecview.common.IntegralComparator;
import jspecview.common.JDXSpectrum;
import jspecview.common.Measurement;
import jspecview.common.MeasurementData;
import jspecview.common.Parameters;
import jspecview.common.ScriptToken;
import jspecview.util.JSVTextFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IntegralData
extends MeasurementData {
    private static final long serialVersionUID = 1L;
    public static final double DEFAULT_OFFSET = 30.0;
    public static final double DEFAULT_RANGE = 50.0;
    public static final double DEFAULT_MINY = 0.1;
    private double percentMinY;
    private double percentOffset;
    private double intRange;
    private double normalizationFactor = 1.0;
    private double percentRange;
    private double offset;
    private double integralTotal;
    boolean haveRegions;
    private Coordinate[] xyCoords;
    private static Comparator<Measurement> c = new IntegralComparator();
    private static final String[] HEADER = new String[]{"peak", "start/ppm", "end/ppm", "value"};

    public double getPercentMinimumY() {
        return this.percentMinY;
    }

    public double getPercentOffset() {
        return this.percentOffset;
    }

    public double getIntegralFactor() {
        return this.intRange;
    }

    public IntegralData(double integralMinY, double integralOffset, double integralRange, JDXSpectrum spec) {
        super(Annotation.AType.Integration, spec);
        this.percentMinY = integralMinY;
        this.percentOffset = integralOffset;
        this.percentRange = integralRange;
        this.calculateIntegral();
    }

    public IntegralData(JDXSpectrum spec, Parameters p) {
        super(Annotation.AType.Integration, spec);
        if (p == null) {
            this.autoIntegrate();
            return;
        }
        this.percentOffset = p.integralOffset;
        this.percentRange = p.integralRange;
        this.calculateIntegral();
    }

    public void update(Parameters parameters) {
        this.update(parameters.integralMinY, parameters.integralOffset, parameters.integralRange);
    }

    public void update(double integralMinY, double integralOffset, double integralRange) {
        double percentRange0 = this.percentRange;
        if (integralRange <= 0.0 || integralRange == this.percentRange && integralOffset == this.percentOffset) {
            return;
        }
        this.percentOffset = integralOffset;
        this.percentRange = integralRange;
        this.checkRange();
        double intRangeNew = integralRange / 100.0 / this.integralTotal;
        double offsetNew = integralOffset / 100.0;
        int i = 0;
        while (i < this.xyCoords.length) {
            double y = this.xyCoords[i].getYVal();
            y = (y - this.offset) / this.intRange;
            this.xyCoords[i].setYVal(y * intRangeNew + offsetNew);
            ++i;
        }
        if (this.normalizationFactor != 1.0) {
            this.normalizationFactor *= percentRange0 / integralRange;
        }
        if (this.haveRegions) {
            i = this.size();
            while (--i >= 0) {
                Measurement ir = (Measurement)this.get(i);
                double y1 = this.getYValueAt(ir.getXVal());
                double y2 = this.getYValueAt(ir.getXVal2());
                ir.setYVal(y1);
                ir.setYVal2(y2);
                ir.setValue(Math.abs(y2 - y1) * 100.0 * this.normalizationFactor);
            }
        }
        this.intRange = intRangeNew;
        this.offset = offsetNew;
    }

    double getYValueAt(double x) {
        return Coordinate.getYValueAt(this.xyCoords, x);
    }

    public Integral addIntegralRegion(double x1, double x2) {
        if (Double.isNaN(x1)) {
            this.haveRegions = false;
            this.clear();
            return null;
        }
        if (x1 == x2) {
            return null;
        }
        double y1 = this.getYValueAt(x1);
        double y2 = this.getYValueAt(x2);
        this.haveRegions = true;
        Integral in = new Integral(this.spec, Math.abs(y2 - y1) * 100.0 * this.normalizationFactor, x1, x2, y1, y2);
        this.clear(x1, x2);
        this.add(in);
        Collections.sort(this, c);
        return in;
    }

    @Override
    public void addSpecShift(double dx) {
        Coordinate.shiftX(this.xyCoords, dx);
        int i = this.size();
        while (--i >= 1) {
            ((Measurement)this.get(i)).addSpecShift(dx);
        }
    }

    public void addMarks(String ppms) {
        ppms = JSVTextFormat.simpleReplace(" " + ppms, ",", " ");
        ppms = JSVTextFormat.simpleReplace(ppms, " -", " #");
        ppms = JSVTextFormat.simpleReplace(ppms, "--", "-#");
        ppms = ppms.replace('-', '^');
        ppms = ppms.replace('#', '-');
        List<String> tokens = ScriptToken.getTokens(ppms);
        int i = 0;
        while (i < tokens.size()) {
            try {
                String s = tokens.get(i);
                double norm = 0.0;
                int pt = s.indexOf(94);
                if (pt >= 0) {
                    Integral m;
                    int pt2 = s.indexOf(58);
                    if (pt2 > pt) {
                        norm = Double.valueOf(s.substring(pt2 + 1).trim());
                        s = s.substring(0, pt2).trim();
                    }
                    double x2 = Double.valueOf(s.substring(0, pt).trim());
                    double x1 = Double.valueOf(s.substring(pt + 1).trim());
                    if (x1 == 0.0 && x2 == 0.0) {
                        this.clear();
                    }
                    if (x1 != x2 && (m = this.addIntegralRegion(Math.max(x1, x2), Math.min(x1, x2))) != null && norm > 0.0) {
                        this.setSelectedIntegral(m, norm);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++i;
        }
    }

    public Coordinate[] calculateIntegral() {
        double y;
        Coordinate[] specXyCoords = this.spec.getXYCoords();
        this.xyCoords = new Coordinate[specXyCoords.length];
        double minYForIntegral = -1.7976931348623157E308;
        this.integralTotal = 0.0;
        this.checkRange();
        double minY = 1.0E100;
        int i = 0;
        while (i < specXyCoords.length) {
            y = specXyCoords[i].getYVal();
            if (y < minY && y >= 0.0) {
                minY = y;
            }
            ++i;
        }
        i = 0;
        while (i < specXyCoords.length) {
            y = specXyCoords[i].getYVal();
            if (y > minYForIntegral) {
                this.integralTotal += y - minY;
            }
            ++i;
        }
        this.intRange = this.percentRange / 100.0 / this.integralTotal;
        this.offset = this.percentOffset / 100.0;
        double integral = 0.0;
        int i2 = specXyCoords.length;
        while (--i2 >= 0) {
            double y2 = specXyCoords[i2].getYVal();
            if (y2 > minYForIntegral) {
                integral += y2 - minY;
            }
            this.xyCoords[i2] = new Coordinate(specXyCoords[i2].getXVal(), integral * this.intRange + this.offset);
        }
        return this.xyCoords;
    }

    private void checkRange() {
        this.percentOffset = Math.max(5.0, this.percentOffset);
        this.percentRange = Math.max(10.0, this.percentRange);
    }

    public static ArrayList<Annotation> getIntegrationRatiosFromString(JDXSpectrum spec, String value) {
        ArrayList<Annotation> ratios = new ArrayList<Annotation>();
        StringTokenizer allParamTokens = new StringTokenizer(value, ",");
        while (allParamTokens.hasMoreTokens()) {
            String token = allParamTokens.nextToken();
            StringTokenizer eachParam = new StringTokenizer(token, ":");
            Annotation ratio = new Annotation(spec, Double.parseDouble(eachParam.nextToken()), 0.0, eachParam.nextToken(), true, false, 0, 0);
            ratios.add(ratio);
        }
        return ratios;
    }

    public Coordinate[] getXYCoords() {
        return this.xyCoords;
    }

    public double getPercentYValueAt(double x) {
        return this.getYValueAt(x) * 100.0;
    }

    public void dispose() {
        this.spec = null;
        this.xyCoords = null;
    }

    public void setSelectedIntegral(Measurement integral, double val) {
        double val0 = integral.getValue();
        double factor = val <= 0.0 ? 1.0 / this.normalizationFactor : val / val0;
        this.factorAllIntegrals(factor, val <= 0.0);
    }

    private void factorAllIntegrals(double factor, boolean isReset) {
        int i = 0;
        while (i < this.size()) {
            Measurement m = (Measurement)this.get(i);
            m.setValue(factor * m.getValue());
            ++i;
        }
        this.normalizationFactor = isReset ? 1.0 : this.normalizationFactor * factor;
    }

    @Override
    public void clear() {
        super.clear();
    }

    @Override
    public Measurement remove(int i) {
        return (Measurement)super.remove(i);
    }

    public BitSet getBitSet() {
        BitSet bs = new BitSet(this.xyCoords.length);
        if (this.size() == 0) {
            bs.set(0, this.xyCoords.length);
            return bs;
        }
        int i = this.size();
        while (--i >= 0) {
            Measurement m = (Measurement)this.get(i);
            int x1 = Coordinate.getNearestIndexForX(this.xyCoords, m.getXVal());
            int x2 = Coordinate.getNearestIndexForX(this.xyCoords, m.getXVal2());
            bs.set(Math.min(x1, x2), Math.max(x1, x2));
        }
        return bs;
    }

    @Override
    public String[][] getMeasurementListArray(String units) {
        DecimalFormat df2 = JSVTextFormat.getDecimalFormat("#0.00");
        String[][] data = new String[this.size()][];
        int pt = 0;
        int i = this.size();
        while (--i >= 0) {
            data[pt++] = new String[]{"" + pt, df2.format(((Measurement)this.get(i)).getXVal()), df2.format(((Measurement)this.get(i)).getXVal2()), ((Measurement)this.get(i)).getText()};
        }
        return data;
    }

    @Override
    public double[][] getMeasurementListArrayReal(String units) {
        double[][] data = new double[this.size()][];
        int pt = 0;
        int i = this.size();
        while (--i >= 0) {
            data[pt] = new double[]{((Measurement)this.get(i)).getXVal(), ((Measurement)this.get(i)).getXVal2(), ((Measurement)this.get(i)).getValue()};
            ++pt;
        }
        return data;
    }

    @Override
    public String[] getDataHeader() {
        return HEADER;
    }

    public void shiftY(int yOld, int yNew, int yPixel0, int yPixels) {
        double pt = (int)(100.0 * (double)(yPixel0 + yPixels - yNew) / (double)yPixels);
        if (yOld < 0) {
            pt -= this.percentOffset;
        }
        if (yOld < 0) {
            this.update(0.0, this.percentOffset, pt);
        } else {
            this.update(0.0, pt, this.percentRange);
        }
    }

    public void autoIntegrate() {
        if (this.xyCoords == null) {
            this.calculateIntegral();
        }
        if (this.xyCoords.length == 0) {
            return;
        }
        this.clear();
        int iStart = -1;
        double cutoff = 1.0E-4;
        int nCount = 0;
        int nMin = 20;
        double y0 = this.xyCoords[this.xyCoords.length - 1].getYVal();
        int i = this.xyCoords.length - 1;
        while (--i >= 0) {
            double y = this.xyCoords[i].getYVal();
            ++nCount;
            if (y - y0 < cutoff && iStart < 0) {
                if (!(y < y0)) continue;
                y0 = y;
                nCount = 0;
                continue;
            }
            if (iStart < 0) {
                iStart = i + Math.min(nCount, nMin);
                y0 = y;
                nCount = 0;
                continue;
            }
            if (y - y0 < cutoff) {
                if (nCount == 1) {
                    y0 = y;
                }
                if (nCount < nMin) continue;
                this.addIntegralRegion(this.xyCoords[iStart].getXVal(), this.xyCoords[i].getXVal());
                iStart = -1;
                y0 = y;
                nCount = 0;
                continue;
            }
            nCount = 0;
            y0 = y;
        }
        if (this.spec.nH > 0) {
            this.factorAllIntegrals((double)this.spec.nH / this.percentRange, false);
        }
    }

    @Override
    public void getInfo(Map<String, Object> info) {
        info.put("offset", this.myParams.integralOffset);
        info.put("range", this.myParams.integralRange);
        info.put("normalizationFactor", this.normalizationFactor);
        info.put("integralTotal", this.integralTotal);
        super.getInfo(info);
    }

    void setMinimumIntegral(double val) {
        int i = this.size();
        while (--i >= 0) {
            if (!(((Measurement)this.get(i)).getValue() < val)) continue;
            this.remove(i);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IntMode {
        OFF,
        ON,
        TOGGLE,
        AUTO,
        LIST,
        MARK,
        MIN,
        UPDATE;


        static IntMode getMode(String value) {
            IntMode[] intModeArray = IntMode.values();
            int n = intModeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IntMode mode = intModeArray[n2];
                if (value.startsWith(mode.name())) {
                    return mode;
                }
                ++n2;
            }
            return ON;
        }
    }
}

