/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.border.MatteBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import jspecview.common.JDXSpectrum;
import jspecview.common.JSVDialog;
import jspecview.common.JSVPanel;
import jspecview.common.PanelData;
import jspecview.util.JSVFileManager;

public class AwtOverlayLegendDialog
extends JDialog
implements JSVDialog {
    private static final long serialVersionUID = 1L;
    JSVPanel jsvp;

    public AwtOverlayLegendDialog(Frame frame, JSVPanel jsvp) {
        super(frame, jsvp.getPanelData().getViewTitle(), false);
        this.jsvp = jsvp;
        this.init();
        this.pack();
        this.setVisible(false);
    }

    private void init() {
        LegendTableModel tableModel = new LegendTableModel();
        JTable table = new JTable(tableModel);
        table.setSelectionMode(0);
        ListSelectionModel specSelection = table.getSelectionModel();
        specSelection.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                ListSelectionModel lsm = (ListSelectionModel)e.getSource();
                AwtOverlayLegendDialog.this.jsvp.getPanelData().setSpectrum(lsm.getMinSelectionIndex(), false);
            }
        });
        table.setDefaultRenderer(Color.class, new ColorRenderer());
        table.setDefaultRenderer(String.class, new TitleRenderer());
        table.setPreferredScrollableViewportSize(new Dimension(350, 95));
        TableColumn column = null;
        column = table.getColumnModel().getColumn(0);
        column.setPreferredWidth(30);
        column = table.getColumnModel().getColumn(1);
        column.setPreferredWidth(60);
        column = table.getColumnModel().getColumn(2);
        column.setPreferredWidth(250);
        JScrollPane scrollPane = new JScrollPane(table);
        this.getContentPane().add((Component)scrollPane, "Center");
    }

    class ColorRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ColorRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object color, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground((Color)color);
            if (isSelected) {
                MatteBorder border = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getSelectionBackground());
                this.setBorder(border);
            } else {
                MatteBorder border = BorderFactory.createMatteBorder(2, 5, 2, 5, table.getBackground());
                this.setBorder(border);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LegendTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        String[] columnNames = new String[]{"No.", "Plot Color", "Title"};
        Object[][] data;

        public LegendTableModel() {
            this.init();
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public String getColumnName(int col) {
            return this.columnNames[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return this.data[row][col];
        }

        @Override
        public Class<?> getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        private void init() {
            String f2;
            int numSpectra = AwtOverlayLegendDialog.this.jsvp.getPanelData().getNumberOfSpectraInCurrentSet();
            this.data = new Object[numSpectra][];
            PanelData pd = AwtOverlayLegendDialog.this.jsvp.getPanelData();
            String f1 = pd.getSpectrumAt(0).getFilePath();
            boolean useFileName = !f1.equals(f2 = pd.getSpectrumAt(numSpectra - 1).getFilePath());
            int index = 0;
            while (index < numSpectra) {
                Object[] cols = new Object[3];
                JDXSpectrum spectrum = pd.getSpectrumAt(index);
                String title = spectrum.getTitle();
                if (useFileName) {
                    title = String.valueOf(JSVFileManager.getName(spectrum.getFilePath())) + " - " + title;
                }
                Color plotColor = (Color)AwtOverlayLegendDialog.this.jsvp.getPlotColor(index);
                cols[0] = new Integer(index + 1);
                cols[1] = plotColor;
                cols[2] = " " + title;
                this.data[index] = cols;
                ++index;
            }
        }
    }

    class TitleRenderer
    extends JLabel
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public TitleRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable table, Object title, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(2);
            this.setText(title.toString());
            if (isSelected) {
                this.setBackground(table.getSelectionBackground());
            } else {
                this.setBackground(table.getBackground());
            }
            return this;
        }
    }
}

