/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapespecial;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.jmol.api.JmolStateCreator;
import org.jmol.constant.EnumPalette;
import org.jmol.modelset.Atom;
import org.jmol.shape.Shape;
import org.jmol.shapespecial.Ellipsoid;
import org.jmol.util.BS;
import org.jmol.util.BSUtil;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.P3;
import org.jmol.util.SB;
import org.jmol.util.Tensor;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ellipsoids
extends Shape {
    public Map<String, Ellipsoid> simpleEllipsoids = new Hashtable<String, Ellipsoid>();
    public Map<Tensor, Ellipsoid> atomEllipsoids = new Hashtable<Tensor, Ellipsoid>();
    private String typeSelected = "1";
    private Ellipsoid ellipsoidSelected;
    private BS selectedAtoms;

    public boolean isActive() {
        return !this.atomEllipsoids.isEmpty() || !this.simpleEllipsoids.isEmpty();
    }

    public int getIndexFromName(String string) {
        this.ellipsoidSelected = this.simpleEllipsoids.get(string);
        return this.ellipsoidSelected == null ? -1 : 1;
    }

    protected void setSize(int n, BS bS) {
        JmolList jmolList;
        boolean bl;
        if (this.modelSet.atoms == null || n == 0 && this.modelSet.atomTensors == null) {
            return;
        }
        boolean bl2 = bl = bS == null;
        if (!bl && this.selectedAtoms != null) {
            bS = this.selectedAtoms;
        }
        if ((jmolList = this.viewer.modelSet.getAllAtomTensors(this.typeSelected)) == null) {
            return;
        }
        Atom[] atomArray = this.modelSet.atoms;
        int n2 = jmolList.size();
        while (--n2 >= 0) {
            boolean bl3;
            Tensor tensor = (Tensor)jmolList.get(n2);
            if (!bl && !tensor.isSelected(bS, -1)) continue;
            Ellipsoid ellipsoid = this.atomEllipsoids.get(tensor);
            boolean bl4 = bl3 = n != 0 && ellipsoid == null;
            if (bl3) {
                ellipsoid = Ellipsoid.getEllipsoidForAtomTensor(tensor, (P3)atomArray[tensor.atomIndex1]);
                this.atomEllipsoids.put(tensor, ellipsoid);
            }
            if (ellipsoid == null || !bl3 && n == Integer.MAX_VALUE) continue;
            ellipsoid.setScale(n, true);
        }
    }

    public void setProperty(String string, Object object, BS bS) {
        Object object2;
        if (string == "thisID") {
            if (this.initEllipsoids(object) && this.ellipsoidSelected == null) {
                String string2 = (String)object;
                this.ellipsoidSelected = Ellipsoid.getEmptyEllipsoid(string2, this.viewer.getCurrentModelIndex());
                this.simpleEllipsoids.put(string2, this.ellipsoidSelected);
            }
            return;
        }
        if (string == "deleteModelAtoms") {
            int n = ((int[])((Object[])object)[2])[0];
            Iterator<Ellipsoid> iterator = this.simpleEllipsoids.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().tensor.modelIndex != n) continue;
                iterator.remove();
            }
            iterator = this.atomEllipsoids.values().iterator();
            while (iterator.hasNext()) {
                if (iterator.next().modelIndex != n) continue;
                iterator.remove();
            }
            this.ellipsoidSelected = null;
            return;
        }
        if ("atoms" == string) {
            this.selectedAtoms = (BS)object;
            return;
        }
        if (this.ellipsoidSelected != null) {
            if ("delete" == string) {
                this.simpleEllipsoids.remove(this.ellipsoidSelected.id);
                return;
            }
            if ("modelindex" == string) {
                this.ellipsoidSelected.tensor.modelIndex = (Integer)object;
                return;
            }
            if ("on" == string) {
                this.ellipsoidSelected.isOn = (Boolean)object;
                return;
            }
            if ("options" == string) {
                this.ellipsoidSelected.options = ((String)object).toLowerCase();
            }
            if ("points" == string) {
                return;
            }
            if ("axes" == string) {
                this.ellipsoidSelected.setAxes((V3[])object);
                return;
            }
            if ("equation" == string) {
                this.ellipsoidSelected.setEquation((double[])object);
                return;
            }
            if ("center" == string) {
                this.ellipsoidSelected.setCenter((P3)object);
                return;
            }
            if ("scale" == string) {
                this.ellipsoidSelected.setScale(((Float)object).floatValue(), false);
                return;
            }
            if ("color" == string) {
                this.ellipsoidSelected.colix = C.getColixO((Object)object);
                return;
            }
            if ("translucentLevel" == string) {
                this.setPropS(string, object, bS);
                return;
            }
            if ("translucency" == string) {
                boolean bl = object.equals("translucent");
                this.ellipsoidSelected.colix = C.getColixTranslucent3((short)this.ellipsoidSelected.colix, (boolean)bl, (float)this.translucentLevel);
                return;
            }
        }
        if ("select" == string) {
            this.typeSelected = ((String)object).toLowerCase();
            return;
        }
        if ("scale" == string) {
            this.setSize((int)(((Float)object).floatValue() * 100.0f), bS);
            return;
        }
        if ("params" == string) {
            object2 = (Object[])object;
            object2[2] = null;
            this.typeSelected = "0";
            this.setSize(50, bS);
        }
        if ("on" == string) {
            boolean bl = (Boolean)object;
            if (this.selectedAtoms != null) {
                bS = this.selectedAtoms;
            }
            if (bl) {
                this.setSize(Integer.MAX_VALUE, bS);
            }
            for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
                Tensor tensor = ellipsoid.tensor;
                if (!tensor.type.equals(this.typeSelected) && !this.typeSelected.equals(tensor.altType) || !tensor.isSelected(bS, -1)) continue;
                ellipsoid.isOn = bl;
            }
            return;
        }
        if ("options" == string) {
            object2 = ((String)object).toLowerCase().trim();
            if (((String)object2).length() == 0) {
                object2 = null;
            }
            if (this.selectedAtoms != null) {
                bS = this.selectedAtoms;
            }
            if (object2 != null) {
                this.setSize(Integer.MAX_VALUE, bS);
            }
            for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
                if (!ellipsoid.tensor.type.equals(this.typeSelected) || !ellipsoid.tensor.isSelected(bS, -1)) continue;
                ellipsoid.options = object2;
            }
            return;
        }
        if ("color" == string) {
            short s = C.getColixO((Object)object);
            byte by = EnumPalette.pidOf((Object)object);
            if (this.selectedAtoms != null) {
                bS = this.selectedAtoms;
            }
            for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
                if (!ellipsoid.tensor.type.equals(this.typeSelected) || !ellipsoid.tensor.isSelected(bS, -1)) continue;
                ellipsoid.colix = this.getColixI(s, by, ellipsoid.tensor.atomIndex1);
                ellipsoid.pid = by;
            }
            return;
        }
        if ("translucency" == string) {
            boolean bl = object.equals("translucent");
            for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
                if (!ellipsoid.tensor.type.equals(this.typeSelected) || !ellipsoid.tensor.isSelected(bS, -1)) continue;
                ellipsoid.colix = C.getColixTranslucent3((short)ellipsoid.colix, (boolean)bl, (float)this.translucentLevel);
            }
            return;
        }
        this.setPropS(string, object, bS);
    }

    private boolean initEllipsoids(Object object) {
        boolean bl = object != null;
        Ellipsoid ellipsoid = this.ellipsoidSelected = bl ? this.simpleEllipsoids.get(object) : null;
        if (bl) {
            this.typeSelected = null;
        }
        this.selectedAtoms = null;
        return bl;
    }

    public String getShapeState() {
        JmolStateCreator jmolStateCreator = this.viewer.getStateCreator();
        if (jmolStateCreator == null || !this.isActive()) {
            return "";
        }
        SB sB = new SB();
        sB.append("\n");
        if (!this.simpleEllipsoids.isEmpty()) {
            this.getStateID(sB);
        }
        if (!this.atomEllipsoids.isEmpty()) {
            this.getStateAtoms(sB, jmolStateCreator);
        }
        return sB.toString();
    }

    private void getStateID(SB sB) {
        V3 v3 = new V3();
        for (Ellipsoid ellipsoid : this.simpleEllipsoids.values()) {
            Tensor tensor = ellipsoid.tensor;
            if (!ellipsoid.isValid || tensor == null) continue;
            sB.append("  Ellipsoid ID ").append(ellipsoid.id).append(" modelIndex ").appendI(tensor.modelIndex).append(" center ").append(Escape.eP((Tuple3f)ellipsoid.center)).append(" axes");
            for (int i = 0; i < 3; ++i) {
                v3.setT((Tuple3f)tensor.eigenVectors[i]);
                v3.scale(ellipsoid.lengths[i]);
                sB.append(" ").append(Escape.eP((Tuple3f)v3));
            }
            sB.append(" " + Ellipsoids.getColorCommandUnk((String)"", (short)ellipsoid.colix, (boolean)this.translucentAllowed));
            if (ellipsoid.options != null) {
                sB.append(" options ").append(Escape.eS((String)ellipsoid.options));
            }
            if (!ellipsoid.isOn) {
                sB.append(" off");
            }
            sB.append(";\n");
        }
    }

    private void getStateAtoms(SB sB, JmolStateCreator jmolStateCreator) {
        BS bS = new BS();
        Hashtable hashtable = new Hashtable();
        Hashtable hashtable2 = new Hashtable();
        for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
            int n = ellipsoid.tensor.iType;
            if (bS.get(n + 1)) continue;
            bS.set(n + 1);
            boolean bl = ellipsoid.tensor.iType == 1;
            String string = bl ? null : "Ellipsoids set " + Escape.eS((String)ellipsoid.tensor.type);
            for (Ellipsoid ellipsoid2 : this.atomEllipsoids.values()) {
                if (ellipsoid2.tensor.iType != n || bl && !ellipsoid2.isOn) continue;
                int n2 = ellipsoid2.tensor.atomIndex1;
                BSUtil.setMapBitSet(hashtable, (int)n2, (int)n2, (String)(bl ? "Ellipsoids " + ellipsoid2.percent : string + " scale " + ellipsoid2.scale + (ellipsoid2.options == null ? "" : " options " + Escape.eS((String)ellipsoid2.options)) + (ellipsoid2.isOn ? " ON" : " OFF")));
                if (ellipsoid2.colix == 0) continue;
                BSUtil.setMapBitSet(hashtable2, (int)n2, (int)n2, (String)Ellipsoids.getColorCommand((String)string, (byte)ellipsoid2.pid, (short)ellipsoid2.colix, (boolean)this.translucentAllowed));
            }
        }
        sB.append(jmolStateCreator.getCommands(hashtable, hashtable2, "select"));
    }

    public void setVisibilityFlags(BS bS) {
        if (!this.isActive()) {
            return;
        }
        Atom[] atomArray = this.viewer.modelSet.atoms;
        this.setVis(this.simpleEllipsoids, bS, atomArray);
        if (this.atomEllipsoids != null) {
            int n = atomArray.length;
            while (--n >= 0) {
                atomArray[n].setShapeVisibility(this.myVisibilityFlag, false);
            }
        }
        this.setVis(this.atomEllipsoids, bS, atomArray);
    }

    private void setVis(Map<?, Ellipsoid> map, BS bS, Atom[] atomArray) {
        for (Ellipsoid ellipsoid : map.values()) {
            Tensor tensor = ellipsoid.tensor;
            boolean bl = true;
            if (tensor.atomIndex1 >= 0) {
                if (tensor.iType == 1) {
                    boolean bl2 = tensor.isModulated;
                    boolean bl3 = tensor.isUnmodulated;
                    boolean bl4 = this.modelSet.isModulated(tensor.atomIndex1);
                    bl = !bl2 && !bl3 || bl2 == bl4;
                }
                atomArray[tensor.atomIndex1].setShapeVisibility(this.myVisibilityFlag, true);
            }
            ellipsoid.visible = bl && ellipsoid.isValid && ellipsoid.isOn && (ellipsoid.modelIndex < 0 || bS.get(ellipsoid.modelIndex));
        }
    }

    public void setModelClickability() {
        if (this.atomEllipsoids.isEmpty()) {
            return;
        }
        for (Ellipsoid ellipsoid : this.atomEllipsoids.values()) {
            int n = ellipsoid.tensor.atomIndex1;
            Atom atom = this.modelSet.atoms[n];
            if ((atom.getShapeVisibilityFlags() & this.myVisibilityFlag) == 0 || this.modelSet.isAtomHidden(n)) continue;
            atom.setClickable(this.myVisibilityFlag);
        }
    }
}

