/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import org.jmol.util.BS;
import org.jmol.util.Eigen;
import org.jmol.util.EigenSort;
import org.jmol.util.Escape;
import org.jmol.util.Matrix3f;
import org.jmol.util.P3;
import org.jmol.util.Parser;
import org.jmol.util.Quaternion;
import org.jmol.util.TextFormat;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tensor {
    private static final float ADP_FACTOR = (float)(Math.sqrt(0.5) / Math.PI);
    private static final float MAGNETIC_SUSCEPTIBILITY_FACTOR = 0.01f;
    private static final float INTERACTION_FACTOR = 0.04f;
    private static EigenSort tSort;
    public String id;
    public String type;
    public int iType = -1;
    private static final String KNOWN_TYPES = ";iso........;adp........;tls-u......;tls-r......;ms.........;efg........;isc........;charge.....;quadrupole.";
    public static final int TYPE_OTHER = -1;
    public static final int TYPE_ISO = 0;
    public static final int TYPE_ADP = 1;
    public static final int TYPE_TLS_U = 2;
    public static final int TYPE_TLS_R = 3;
    public static final int TYPE_MS = 4;
    public static final int TYPE_EFG = 5;
    public static final int TYPE_ISC = 6;
    public static final int TYPE_CHARGE = 7;
    public static final int TYPE_QUADRUPOLE = 8;
    public double[][] asymMatrix;
    public double[][] symMatrix;
    public V3[] eigenVectors;
    public float[] eigenValues;
    public String altType;
    public boolean isIsotropic;
    public boolean forThermalEllipsoid;
    public int eigenSignMask = 7;
    private float typeFactor = 1.0f;
    private boolean sortIso;
    public int modelIndex;
    public int atomIndex1 = -1;
    public int atomIndex2 = -1;
    public boolean isModulated;
    public boolean isUnmodulated;
    private static final String infoList = ";.............;eigenvalues..;eigenvectors.;asymmatrix...;symmatrix....;value........;isotropy.....;anisotropy...;asymmetry....;eulerzyz.....;eulerzxz.....;quaternion...;indices......;string.......;type.........;id...........;span.........;skew.........";

    private static int getType(String string) {
        int n = string.indexOf("_");
        if (n >= 0) {
            string = string.substring(0, n);
        }
        return (n = KNOWN_TYPES.indexOf(";" + string.toLowerCase() + ".")) < 0 ? -1 : n / 11;
    }

    public Object getInfo(String string) {
        if (string.charAt(0) != ';') {
            string = ";" + string + ".";
        }
        switch (infoList.indexOf(string) / 14) {
            default: {
                Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>();
                Object[] objectArray = Parser.getTokens(TextFormat.replaceAllCharacter(infoList, ";.", ' ').trim());
                Arrays.sort(objectArray);
                for (int i = 0; i < objectArray.length; ++i) {
                    Object object = this.getInfo((String)objectArray[i]);
                    if (object == null) continue;
                    hashtable.put(objectArray[i], object);
                }
                return hashtable;
            }
            case 1: {
                return this.eigenValues;
            }
            case 2: {
                P3[] p3Array = new P3[3];
                for (int i = 0; i < 3; ++i) {
                    p3Array[i] = P3.newP(this.eigenVectors[i]);
                }
                return p3Array;
            }
            case 3: {
                if (this.asymMatrix == null) {
                    return null;
                }
                float[] fArray = new float[9];
                int n = 0;
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        fArray[n++] = (float)this.asymMatrix[i][j];
                    }
                }
                return Matrix3f.newA(fArray);
            }
            case 4: {
                if (this.symMatrix == null) {
                    return null;
                }
                float[] fArray = new float[9];
                int n = 0;
                for (int i = 0; i < 3; ++i) {
                    for (int j = 0; j < 3; ++j) {
                        fArray[n++] = (float)this.symMatrix[i][j];
                    }
                }
                return Matrix3f.newA(fArray);
            }
            case 5: {
                return Float.valueOf(this.eigenValues[2]);
            }
            case 6: {
                return Float.valueOf(this.isotropy());
            }
            case 7: {
                return Float.valueOf(this.anisotropy());
            }
            case 8: {
                return Float.valueOf(this.asymmetry());
            }
            case 9: {
                return ((Quaternion)this.getInfo("quaternion")).getEulerZYZ();
            }
            case 10: {
                return ((Quaternion)this.getInfo("quaternion")).getEulerZXZ();
            }
            case 11: {
                return Quaternion.getQuaternionFrame(null, this.eigenVectors[0], this.eigenVectors[1]);
            }
            case 12: {
                return new int[]{this.modelIndex, this.atomIndex1, this.atomIndex2};
            }
            case 13: {
                return this.toString();
            }
            case 14: {
                return this.type;
            }
            case 15: {
                return this.id;
            }
            case 16: {
                return Float.valueOf(this.span());
            }
            case 17: 
        }
        return Float.valueOf(this.skew());
    }

    public float isotropy() {
        return (this.eigenValues[0] + this.eigenValues[1] + this.eigenValues[2]) / 3.0f;
    }

    public float span() {
        return Math.abs(this.eigenValues[2] - this.eigenValues[0]);
    }

    public float skew() {
        return this.span() == 0.0f ? 0.0f : 3.0f * (this.eigenValues[1] - this.isotropy()) / this.span();
    }

    public float anisotropy() {
        return this.eigenValues[2] - (this.eigenValues[0] + this.eigenValues[1]) / 2.0f;
    }

    public float reducedAnisotropy() {
        return this.anisotropy() * 2.0f / 3.0f;
    }

    public float asymmetry() {
        return this.span() == 0.0f ? 0.0f : (this.eigenValues[1] - this.eigenValues[0]) / this.reducedAnisotropy();
    }

    public static Tensor copyTensor(Tensor tensor) {
        Tensor tensor2 = new Tensor();
        tensor2.setType(tensor.type);
        tensor2.eigenValues = tensor.eigenValues;
        tensor2.eigenVectors = tensor.eigenVectors;
        tensor2.asymMatrix = tensor.asymMatrix;
        tensor2.symMatrix = tensor.symMatrix;
        tensor2.eigenSignMask = tensor.eigenSignMask;
        tensor2.modelIndex = tensor.modelIndex;
        tensor2.atomIndex1 = tensor.atomIndex1;
        tensor2.atomIndex2 = tensor.atomIndex2;
        tensor2.id = tensor.id;
        return tensor2;
    }

    private Tensor() {
    }

    public static Tensor getTensorFromAsymmetricTensor(double[][] dArray, String string, String string2) {
        double[][] dArray2 = new double[3][3];
        int n = 3;
        while (--n >= 0) {
            int n2 = 3;
            while (--n2 >= 0) {
                dArray2[n][n2] = dArray[n][n2];
            }
        }
        if (dArray2[0][1] != dArray2[1][0]) {
            double d = (dArray2[0][1] + dArray2[1][0]) / 2.0;
            dArray2[1][0] = d;
            dArray2[0][1] = d;
        }
        if (dArray2[1][2] != dArray2[2][1]) {
            double d = (dArray2[1][2] + dArray2[2][1]) / 2.0;
            dArray2[2][1] = d;
            dArray2[1][2] = d;
        }
        if (dArray2[0][2] != dArray2[2][0]) {
            double d = (dArray2[0][2] + dArray2[2][0]) / 2.0;
            dArray2[2][0] = d;
            dArray2[0][2] = d;
        }
        Eigen eigen = new Eigen(3);
        eigen.calc(dArray2);
        Matrix3f matrix3f = new Matrix3f();
        float[] fArray = new float[9];
        int n3 = 0;
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 3; ++j) {
                fArray[n3++] = (float)dArray2[i][j];
            }
        }
        matrix3f.setA(fArray);
        V3[] v3Array = eigen.getEigenVectors3();
        V3 v3 = new V3();
        V3 v32 = new V3();
        for (int i = 0; i < 3; ++i) {
            v3.setT(v3Array[i]);
            matrix3f.transform(v3);
            v32.cross(v3, v3Array[i]);
            v3.setT(v3Array[i]);
            v3.normalize();
            v32.cross(v3Array[i], v3Array[(i + 1) % 3]);
        }
        V3[] v3Array2 = new V3[3];
        float[] fArray2 = new float[3];
        eigen.fillArrays(v3Array2, fArray2);
        Tensor tensor = Tensor.newTensorType(v3Array2, fArray2, string, string2);
        tensor.asymMatrix = dArray;
        tensor.symMatrix = dArray2;
        tensor.id = string2;
        return tensor;
    }

    public static Tensor getTensorFromEigenVectors(V3[] v3Array, float[] fArray, String string, String string2) {
        float[] fArray2 = new float[3];
        V3[] v3Array2 = new V3[3];
        for (int i = 0; i < 3; ++i) {
            v3Array2[i] = V3.newV(v3Array[i]);
            fArray2[i] = fArray[i];
        }
        return Tensor.newTensorType(v3Array2, fArray2, string, string2);
    }

    public static Tensor getTensorFromAxes(V3[] v3Array) {
        Tensor tensor = new Tensor();
        tensor.eigenValues = new float[3];
        tensor.eigenVectors = new V3[3];
        for (int i = 0; i < 3; ++i) {
            tensor.eigenVectors[i] = V3.newV(v3Array[i]);
            tensor.eigenValues[i] = v3Array[i].length();
            if (tensor.eigenValues[i] == 0.0f) {
                return null;
            }
            tensor.eigenVectors[i].normalize();
        }
        if (Math.abs(tensor.eigenVectors[0].dot(tensor.eigenVectors[1])) > 1.0E-4f || Math.abs(tensor.eigenVectors[1].dot(tensor.eigenVectors[2])) > 1.0E-4f || Math.abs(tensor.eigenVectors[2].dot(tensor.eigenVectors[0])) > 1.0E-4f) {
            return null;
        }
        tensor.setType("other");
        tensor.sortAndNormalize();
        return tensor;
    }

    public static Tensor getTensorFromThermalEquation(double[] dArray, String string) {
        Tensor tensor = new Tensor();
        tensor.eigenValues = new float[3];
        tensor.eigenVectors = new V3[3];
        tensor.id = string == null ? "coefs=" + Escape.eAD(dArray) : string;
        double[][] dArray2 = new double[3][3];
        dArray2[0][0] = dArray[0];
        dArray2[1][1] = dArray[1];
        dArray2[2][2] = dArray[2];
        double d = dArray[3] / 2.0;
        dArray2[1][0] = d;
        dArray2[0][1] = d;
        double d2 = dArray[4] / 2.0;
        dArray2[2][0] = d2;
        dArray2[0][2] = d2;
        double d3 = dArray[5] / 2.0;
        dArray2[2][1] = d3;
        dArray2[1][2] = d3;
        Eigen.getUnitVectors(dArray2, tensor.eigenVectors, tensor.eigenValues);
        tensor.setType("adp");
        tensor.sortAndNormalize();
        return tensor;
    }

    public Tensor setType(String string) {
        if (this.type == null || string == null) {
            this.type = string;
        }
        if (string != null) {
            this.processType();
        }
        return this;
    }

    public float getFactoredValue(int n) {
        float f = Math.abs(this.eigenValues[n]);
        return (this.forThermalEllipsoid ? (float)Math.sqrt(f) : f) * this.typeFactor;
    }

    public void setAtomIndexes(int n, int n2) {
        this.atomIndex1 = n;
        this.atomIndex2 = n2;
    }

    public boolean isSelected(BS bS, int n) {
        return n >= 0 ? this.atomIndex1 == n || this.atomIndex2 == n : bS.get(this.atomIndex1) && (this.atomIndex2 < 0 || bS.get(this.atomIndex2));
    }

    private static Tensor newTensorType(V3[] v3Array, float[] fArray, String string, String string2) {
        Tensor tensor = new Tensor();
        tensor.eigenValues = fArray;
        tensor.eigenVectors = v3Array;
        for (int i = 0; i < 3; ++i) {
            tensor.eigenVectors[i].normalize();
        }
        tensor.setType(string);
        tensor.id = string2;
        tensor.sortAndNormalize();
        tensor.eigenSignMask = (tensor.eigenValues[0] >= 0.0f ? 1 : 0) + (tensor.eigenValues[1] >= 0.0f ? 2 : 0) + (tensor.eigenValues[2] >= 0.0f ? 4 : 0);
        return tensor;
    }

    private void processType() {
        this.forThermalEllipsoid = false;
        this.isIsotropic = false;
        this.altType = null;
        this.typeFactor = 1.0f;
        this.sortIso = false;
        this.iType = Tensor.getType(this.type);
        switch (this.iType) {
            case 0: {
                this.forThermalEllipsoid = true;
                this.isIsotropic = true;
                this.altType = "1";
                this.type = "adp";
                break;
            }
            case 1: {
                this.forThermalEllipsoid = true;
                this.typeFactor = ADP_FACTOR;
                this.altType = "1";
                break;
            }
            case 4: {
                this.sortIso = true;
                this.typeFactor = 0.01f;
                break;
            }
            case 5: {
                this.sortIso = true;
                break;
            }
            case 6: {
                this.sortIso = true;
                this.typeFactor = 0.04f;
                break;
            }
            case 3: {
                this.altType = "2";
                break;
            }
            case 2: {
                this.altType = "3";
                break;
            }
        }
    }

    private void sortAndNormalize() {
        int n;
        Object[][] objectArrayArray = new Object[][]{{V3.newV(this.eigenVectors[0]), Float.valueOf(this.eigenValues[0])}, {V3.newV(this.eigenVectors[1]), Float.valueOf(this.eigenValues[1])}, {V3.newV(this.eigenVectors[2]), Float.valueOf(this.eigenValues[2])}};
        Arrays.sort(objectArrayArray, Tensor.getEigenSort());
        for (n = 0; n < 3; ++n) {
            int n2 = n;
            this.eigenVectors[n] = (V3)objectArrayArray[n2][0];
            this.eigenValues[n] = ((Float)objectArrayArray[n2][1]).floatValue();
        }
        if (this.sortIso && this.eigenValues[2] - this.eigenValues[1] < this.eigenValues[1] - this.eigenValues[0]) {
            V3 v3 = this.eigenVectors[0];
            this.eigenVectors[0] = this.eigenVectors[2];
            this.eigenVectors[2] = v3;
            float f = this.eigenValues[0];
            this.eigenValues[0] = this.eigenValues[2];
            this.eigenValues[2] = f;
        }
        for (n = 0; n < 3; ++n) {
            this.eigenVectors[n].normalize();
        }
    }

    public boolean isEquiv(Tensor tensor) {
        if (tensor.iType != this.iType) {
            return false;
        }
        float f = Math.abs(this.eigenValues[0] + this.eigenValues[1] + this.eigenValues[2]);
        for (int i = 0; i < 3; ++i) {
            if (!(Math.abs(tensor.eigenValues[i] - this.eigenValues[i]) / f > 3.0E-4f)) continue;
            return false;
        }
        return true;
    }

    private static Comparator<? super Object[]> getEigenSort() {
        return tSort == null ? (tSort = new EigenSort()) : tSort;
    }

    public String toString() {
        return this.type + " " + this.modelIndex + " " + this.atomIndex1 + " " + this.atomIndex2 + "\n" + (this.eigenVectors == null ? "" + this.eigenValues[0] : this.eigenVectors[0] + "\t" + this.eigenValues[0] + "\t" + "\n" + this.eigenVectors[1] + "\t" + this.eigenValues[1] + "\t" + "\n" + this.eigenVectors[2] + "\t" + this.eigenValues[2] + "\t" + "\n");
    }
}

