/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.Modulation;
import org.jmol.util.P3;
import org.jmol.util.V3;
import org.jmol.util.Vibration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModulationSet
extends Vibration {
    public float vOcc = Float.NaN;
    public Map<String, Float> htUij;
    public boolean enabled = false;
    public String id;
    public V3 prevSetting;
    public float vOcc0;
    private JmolList<Modulation> mods;
    private Matrix3f gammaE;
    private int t = Integer.MAX_VALUE;
    private double[] qlen;
    int modDim;
    V3 x456;

    public ModulationSet(String string, P3 p3, int n, JmolList<Modulation> jmolList, Matrix3f matrix3f, Matrix4f matrix4f, Matrix4f matrix4f2, double[] dArray) {
        this.id = string;
        this.modDim = n;
        this.mods = jmolList;
        this.gammaE = matrix3f;
        Matrix3f matrix3f2 = new Matrix3f();
        matrix4f.getRotationScale(matrix3f2);
        V3 v3 = new V3();
        matrix4f.get(v3);
        matrix3f2.invert();
        this.x456 = V3.newV(p3);
        Matrix3f matrix3f3 = new Matrix3f();
        matrix4f2.transform(this.x456);
        this.x456.sub(v3);
        matrix3f2.transform(this.x456);
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET create r=" + Escape.eP(p3) + " si=" + Escape.eP(v3) + " ginv=" + matrix3f2.toString().replace('\n', ' ') + " x4=" + this.x456.x);
        }
        this.qlen = dArray;
    }

    public void calculate() {
        this.z = 0.0f;
        this.y = 0.0f;
        this.x = 0.0f;
        this.htUij = null;
        this.vOcc = Float.NaN;
        double d = this.t == Integer.MAX_VALUE ? 0.0 : this.qlen[0] * (double)this.t;
        int n = this.mods.size();
        while (--n >= 0) {
            ((Modulation)this.mods.get(n)).apply(this, d);
        }
        this.gammaE.transform(this);
    }

    public void addUTens(String string, float f) {
        if (this.htUij == null) {
            this.htUij = new Hashtable<String, Float>();
        }
        Float f2 = this.htUij.get(string);
        if (Logger.debuggingHigh) {
            Logger.debug("MODSET " + this.id + " utens=" + string + " f=" + f2 + " v=" + f);
        }
        if (f2 != null) {
            f += f2.floatValue();
        }
        this.htUij.put(string, Float.valueOf(f));
    }

    public int setModT(boolean bl, int n) {
        if (n == Integer.MAX_VALUE) {
            if (this.enabled == bl) {
                return 0;
            }
            this.enabled = bl;
            this.scale(-1.0f);
            return this.enabled ? 2 : 1;
        }
        if (this.modDim > 1 || n == this.t) {
            return 4;
        }
        if (this.prevSetting == null) {
            this.prevSetting = new V3();
        }
        this.prevSetting.setT(this);
        this.t = n;
        this.calculate();
        this.enabled = false;
        return 3;
    }

    public String getState() {
        return "modulation " + (!this.enabled ? "OFF" : (this.t == Integer.MAX_VALUE ? "ON" : "" + this.t));
    }
}

