/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.shapesurface;

import org.jmol.shape.Shape;
import org.jmol.shapesurface.Isosurface;
import org.jmol.util.BS;
import org.jmol.util.C;
import org.jmol.util.Escape;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.util.V3;

public class LcaoCartoon
extends Isosurface {
    private String thisType;
    private int myColorPt;
    private String lcaoID;
    private BS thisSet;
    private boolean isMolecular;
    private V3 rotationAxis;
    private Float lcaoScale;
    private boolean isTranslucent;
    private float translucentLevel;
    private Integer lcaoColorPos;
    private Integer lcaoColorNeg;
    boolean isLonePair;
    boolean isRadical;
    private Object cappingObject;
    private Object slabbingObject;
    private String fullCommand;

    public void initShape() {
        super.initShape();
        this.myType = "lcaoCartoon";
        this.allowMesh = false;
    }

    public void setProperty(String string, Object object, BS bS) {
        boolean bl = false;
        if ("init" == string) {
            this.myColorPt = 0;
            this.lcaoID = null;
            this.thisSet = bS;
            this.isRadical = false;
            this.isLonePair = false;
            this.isMolecular = false;
            this.thisType = null;
            this.rotationAxis = null;
            this.fullCommand = (String)object;
            this.setPropI("init", null, null);
            return;
        }
        if ("lcaoID" == string) {
            this.lcaoID = (String)object;
            return;
        }
        if ("thisID" == string) {
            this.lcaoID = (String)object;
        }
        if ("selectType" == string) {
            this.thisType = (String)object;
            return;
        }
        if ("rotationAxis" == string) {
            this.rotationAxis = (V3)object;
            return;
        }
        if ("scale" == string) {
            this.lcaoScale = (Float)object;
        }
        if ("colorRGB" == string) {
            this.lcaoColorPos = (Integer)object;
            if (this.myColorPt++ == 0) {
                this.lcaoColorNeg = this.lcaoColorPos;
            }
        }
        if ("select" == string) {
            this.thisSet = (BS)object;
        }
        if ("translucentLevel" == string) {
            this.translucentLevel = ((Float)object).floatValue();
        }
        if ("settranslucency" == string) {
            this.isTranslucent = ((String)object).equals("translucent");
            return;
        }
        if ("translucency" == string) {
            this.isTranslucent = ((String)object).equals("translucent");
            if (this.lcaoID == null) {
                return;
            }
        }
        if ("molecular" == string) {
            this.isMolecular = true;
            if (object == null) {
                return;
            }
            string = "create";
        }
        if ("create" == string) {
            this.myColorPt = 0;
            this.thisType = (String)object;
            this.createLcaoCartoon();
            return;
        }
        if ("lonePair" == string) {
            this.isLonePair = true;
            return;
        }
        if ("lp" == string) {
            bl = true;
            this.isLonePair = true;
        }
        if ("radical" == string) {
            this.isRadical = true;
            return;
        }
        if ("rad" == string) {
            bl = true;
            this.isRadical = true;
        }
        if ("delete" == string) {
            this.deleteLcaoCartoon();
            return;
        }
        if ("on" == string) {
            this.setLcaoOn(true);
            return;
        }
        if ("off" == string) {
            this.setLcaoOn(false);
            return;
        }
        if ("slab" == string) {
            this.slabbingObject = object;
        }
        if ("cap" == string) {
            this.cappingObject = object;
        }
        if ("lobe" == string || "sphere" == string) {
            this.getCapSlabInfo(this.fullCommand);
        }
        this.setPropI(string, object, bS);
        if (bl || "lobe" == string || "sphere" == string) {
            this.setScriptInfo(null);
        }
    }

    private void setLcaoOn(boolean bl) {
        int n;
        if (TextFormat.isWild(this.lcaoID)) {
            String string = this.lcaoID.toLowerCase();
            int n2 = this.meshCount;
            while (--n2 >= 0) {
                if (!TextFormat.isMatch(this.meshes[n2].thisID.toLowerCase(), string, true, true)) continue;
                this.meshes[n2].visible = bl;
            }
            return;
        }
        int n3 = n = this.viewer.getAtomCount();
        while (--n3 >= 0) {
            if (this.lcaoID == null && !this.thisSet.get(n3)) continue;
            this.setLcaoOn(n3, bl);
        }
    }

    private void setLcaoOn(int n, boolean bl) {
        String string = this.getID(this.lcaoID, n);
        int n2 = this.meshCount;
        while (--n2 >= 0) {
            if (this.meshes[n2].thisID.indexOf(string) != 0) continue;
            this.meshes[n2].visible = bl;
        }
    }

    private void deleteLcaoCartoon() {
        int n;
        if (TextFormat.isWild(this.lcaoID)) {
            this.deleteMeshKey(this.lcaoID);
            return;
        }
        int n2 = n = this.viewer.getAtomCount();
        while (--n2 >= 0) {
            if (this.lcaoID == null && !this.thisSet.get(n2)) continue;
            this.deleteLcaoCartoon(n2);
        }
    }

    private void deleteLcaoCartoon(int n) {
        String string = this.getID(this.lcaoID, n);
        int n2 = this.meshCount;
        while (--n2 >= 0) {
            if (this.meshes[n2].thisID.indexOf(string) != 0) continue;
            this.deleteMeshI(n2);
        }
    }

    private void createLcaoCartoon() {
        this.isMolecular = this.isMolecular && (this.thisType.indexOf("px") >= 0 || this.thisType.indexOf("py") >= 0 || this.thisType.indexOf("pz") >= 0);
        String string = this.lcaoID;
        int n = this.thisSet.nextSetBit(0);
        while (n >= 0) {
            this.createLcaoCartoon(n);
            this.lcaoID = string;
            n = this.thisSet.nextSetBit(n + 1);
        }
    }

    private void createLcaoCartoon(int n) {
        String string = this.getID(this.lcaoID, n);
        boolean bl = this.thisType.equals("cpk");
        int n2 = this.meshCount;
        while (--n2 >= 0) {
            if (this.meshes[n2].thisID.indexOf(string) != 0) continue;
            this.deleteMeshI(n2);
        }
        this.setPropI("init", null, null);
        this.setPropI("thisID", string, null);
        if (this.lcaoScale != null) {
            this.setPropI("scale", this.lcaoScale, null);
        }
        if (bl) {
            this.setPropI("colorRGB", this.viewer.getAtomArgb(n), null);
        } else if (this.lcaoColorNeg != null) {
            this.setPropI("colorRGB", this.lcaoColorNeg, null);
            this.setPropI("colorRGB", this.lcaoColorPos, null);
        }
        if (this.slabbingObject != null) {
            this.setPropI("slab", this.slabbingObject, null);
        }
        if (this.cappingObject != null) {
            this.setPropI("cap", this.cappingObject, null);
        }
        this.setPropI("lcaoType", this.thisType, null);
        this.setPropI("atomIndex", n, null);
        V3[] v3Array = new V3[]{new V3(), new V3(), V3.newV(this.modelSet.atoms[n]), new V3()};
        if (this.rotationAxis != null) {
            v3Array[3].setT(this.rotationAxis);
        }
        if (this.isMolecular) {
            if (this.thisType.indexOf("px") >= 0) {
                v3Array[0].set(0.0f, -1.0f, 0.0f);
                v3Array[1].set(1.0f, 0.0f, 0.0f);
            } else if (this.thisType.indexOf("py") >= 0) {
                v3Array[0].set(-1.0f, 0.0f, 0.0f);
                v3Array[1].set(0.0f, 0.0f, 1.0f);
            } else if (this.thisType.indexOf("pz") >= 0) {
                v3Array[0].set(0.0f, 0.0f, 1.0f);
                v3Array[1].set(1.0f, 0.0f, 0.0f);
            }
            if (this.thisType.indexOf("-") == 0) {
                v3Array[0].scale(-1.0f);
            }
        }
        if (this.isMolecular || bl || this.thisType.equalsIgnoreCase("s") || this.viewer.getHybridizationAndAxes(n, v3Array[0], v3Array[1], this.thisType) != null) {
            this.setPropI(this.isRadical ? "radical" : (this.isLonePair ? "lonePair" : "lcaoCartoon"), v3Array, null);
        }
        if (bl) {
            short s = this.viewer.getModelSet().getAtomColix(n);
            if (C.isColixTranslucent(s)) {
                this.setPropI("translucentLevel", Float.valueOf(C.getColixTranslucencyLevel(s)), null);
                this.setPropI("translucency", "translucent", null);
            }
        } else if (this.isTranslucent) {
            int n3 = this.meshCount;
            while (--n3 >= 0) {
                if (this.meshes[n3].thisID.indexOf(string) != 0) continue;
                this.meshes[n3].setTranslucent(true, this.translucentLevel);
            }
        }
    }

    private String getID(String string, int n) {
        return (string != null ? string : (this.isLonePair || this.isRadical ? "lp_" : "lcao_") + (n + 1) + "_") + (this.thisType == null ? "" : TextFormat.simpleReplace(this.thisType, "-", this.thisType.indexOf("-p") == 0 ? "" : "_"));
    }

    public String getShapeState() {
        SB sB = new SB();
        if (this.lcaoScale != null) {
            LcaoCartoon.appendCmd(sB, "lcaoCartoon scale " + this.lcaoScale.floatValue());
        }
        if (this.lcaoColorNeg != null) {
            LcaoCartoon.appendCmd(sB, "lcaoCartoon color " + Escape.escapeColor(this.lcaoColorNeg) + " " + Escape.escapeColor(this.lcaoColorPos));
        }
        if (this.isTranslucent) {
            LcaoCartoon.appendCmd(sB, "lcaoCartoon translucent " + this.translucentLevel);
        }
        int n = this.meshCount;
        while (--n >= 0) {
            if (this.meshes[n].visible) continue;
            LcaoCartoon.appendCmd(sB, "lcaoCartoon ID " + this.meshes[n].thisID + " off");
        }
        return super.getShapeState() + sB.toString();
    }

    public void merge(Shape shape) {
        LcaoCartoon lcaoCartoon = (LcaoCartoon)shape;
        this.lcaoScale = lcaoCartoon.lcaoScale;
        this.lcaoColorNeg = lcaoCartoon.lcaoColorNeg;
        this.isTranslucent = lcaoCartoon.isTranslucent;
        super.merge(shape);
    }
}

