/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.quantum;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.api.JmolNMRInterface;
import org.jmol.io.JmolBinary;
import org.jmol.modelset.Atom;
import org.jmol.modelset.MeasurementData;
import org.jmol.modelset.Model;
import org.jmol.util.BS;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.SB;
import org.jmol.util.Tensor;
import org.jmol.util.V3;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NMRCalculation
implements JmolNMRInterface {
    private static final int MAGNETOGYRIC_RATIO = 1;
    private static final int QUADRUPOLE_MOMENT = 2;
    private static final double e_charge = 1.60217646E-19;
    private static final double h_planck = 6.62606957E-34;
    private static final double h_bar_planck = 1.0545717253362894E-34;
    private static final double DIPOLAR_FACTOR = 1054.5717253362893;
    private static final double J_FACTOR = 0.0167840302932219;
    private static final double Q_FACTOR = 2.349647144641375E8;
    private Viewer viewer;
    private Map<String, double[]> isotopeData;
    private static final String resource = "org/jmol/quantum/nmr_data.txt";
    private Map<String, Float> shiftRefsPPM = new Hashtable<String, Float>();

    public NMRCalculation() {
        this.getData();
    }

    @Override
    public JmolNMRInterface setViewer(Viewer viewer) {
        this.viewer = viewer;
        return this;
    }

    @Override
    public float getQuadrupolarConstant(Tensor tensor) {
        if (tensor == null) {
            return 0.0f;
        }
        Atom atom = this.viewer.modelSet.atoms[tensor.atomIndex1];
        return (float)(this.getIsotopeData(atom, 2) * (double)tensor.eigenValues[2] * 2.349647144641375E8);
    }

    private JmolList<Tensor> getInteractionTensorList(String string, BS bS) {
        if (string != null) {
            string = string.toLowerCase();
        }
        BS bS2 = this.viewer.getModelBitSet(bS, false);
        BS bS3 = this.getAtomSiteBS(bS);
        int n = bS3.cardinality() == 1 ? bS3.nextSetBit(0) : -1;
        JmolList<Tensor> jmolList = new JmolList<Tensor>();
        int n2 = bS2.nextSetBit(0);
        while (n2 >= 0) {
            JmolList jmolList2 = (JmolList)this.viewer.getModelAuxiliaryInfoValue(n2, "interactionTensors");
            if (jmolList2 != null) {
                int n3 = jmolList2.size();
                for (int i = 0; i < n3; ++i) {
                    Tensor tensor = (Tensor)jmolList2.get(i);
                    if (string != null && (!tensor.type.equals(string) || !tensor.isSelected(bS3, n))) continue;
                    jmolList.addLast(tensor);
                }
            }
            n2 = bS2.nextSetBit(n2 + 1);
        }
        return jmolList;
    }

    private BS getAtomSiteBS(BS bS) {
        if (bS == null) {
            return null;
        }
        BS bS2 = new BS();
        Atom[] atomArray = this.viewer.modelSet.atoms;
        Model[] modelArray = this.viewer.modelSet.models;
        int n = bS.nextSetBit(0);
        while (n >= 0) {
            if (bS.get(n)) {
                Atom atom = atomArray[n];
                bS2.set(modelArray[atom.modelIndex].firstAtomIndex - 1 + atom.atomSite);
            }
            n = bS.nextSetBit(n + 1);
        }
        return bS2;
    }

    @Override
    public BS getUniqueTensorSet(BS bS) {
        BS bS2 = new BS();
        Atom[] atomArray = this.viewer.modelSet.atoms;
        int n = this.viewer.getModelCount();
        while (--n >= 0) {
            BS bS3 = this.viewer.getModelUndeletedAtomsBitSet(n);
            bS3.and(bS);
            if (this.viewer.getModelUnitCell(n) == null) continue;
            int n2 = bS3.nextSetBit(0);
            while (n2 >= 0) {
                if (atomArray[n2].atomSite != atomArray[n2].index + 1) {
                    bS3.clear(n2);
                }
                n2 = bS3.nextSetBit(n2 + 1);
            }
            bS2.or(bS3);
            n2 = bS3.nextSetBit(0);
            while (n2 >= 0) {
                Tensor[] tensorArray = atomArray[n2].getTensors();
                if (tensorArray != null) {
                    int n3 = tensorArray.length;
                    while (--n3 >= 0) {
                        Tensor tensor = tensorArray[n3];
                        if (tensor == null) continue;
                        int n4 = bS3.nextSetBit(n2 + 1);
                        while (n4 >= 0) {
                            Tensor[] tensorArray2 = atomArray[n4].getTensors();
                            if (tensorArray2 != null) {
                                int n5 = tensorArray2.length;
                                while (--n5 >= 0) {
                                    if (!tensor.isEquiv(tensorArray2[n5])) continue;
                                    bS3.clear(n4);
                                    bS2.clear(n4);
                                    break;
                                }
                            }
                            n4 = bS3.nextSetBit(n4 + 1);
                        }
                    }
                }
                n2 = bS3.nextSetBit(n2 + 1);
            }
        }
        return bS2;
    }

    public float getJCouplingHz(Atom atom, Atom atom2, String string, Tensor tensor) {
        return this.getIsoOrAnisoHz(true, atom, atom2, string, tensor);
    }

    @Override
    public float getIsoOrAnisoHz(boolean bl, Atom atom, Atom atom2, String string, Tensor tensor) {
        if (tensor == null) {
            if ((string = this.getISCtype(atom, string)) == null || atom.modelIndex != atom2.modelIndex) {
                return 0.0f;
            }
            BS bS = new BS();
            bS.set(atom.index);
            bS.set(atom2.index);
            JmolList<Tensor> jmolList = this.getInteractionTensorList(string, bS);
            if (jmolList.size() == 0) {
                return Float.NaN;
            }
            tensor = (Tensor)jmolList.get(0);
        } else {
            atom = this.viewer.modelSet.atoms[tensor.atomIndex1];
            atom2 = this.viewer.modelSet.atoms[tensor.atomIndex2];
        }
        return (float)(this.getIsotopeData(atom, 1) * this.getIsotopeData(atom2, 1) * (double)(bl ? tensor.isotropy() : tensor.anisotropy()) * 0.0167840302932219);
    }

    private String getISCtype(Atom atom, String string) {
        JmolList jmolList = (JmolList)this.viewer.getModelAuxiliaryInfoValue(atom.modelIndex, "interactionTensors");
        if (jmolList == null) {
            return null;
        }
        string = string == null ? "" : string.toLowerCase();
        int n = -1;
        n = string.indexOf("_hz");
        if (n >= 0 || (n = string.indexOf("_khz")) >= 0 || (n = string.indexOf("hz")) >= 0 || (n = string.indexOf("khz")) >= 0) {
            string = string.substring(0, n);
        }
        if (string.length() == 0) {
            string = "isc";
        }
        return string;
    }

    @Override
    public float getDipolarConstantHz(Atom atom, Atom atom2) {
        float f;
        if (Logger.debugging) {
            Logger.debug(atom + " g=" + this.getIsotopeData(atom, 1) + "; " + atom2 + " g=" + this.getIsotopeData(atom2, 1));
        }
        return (f = (float)(-this.getIsotopeData(atom, 1) * this.getIsotopeData(atom2, 1) / Math.pow(atom.distance(atom2), 3.0) * 1054.5717253362893)) == 0.0f || atom == atom2 ? Float.NaN : f;
    }

    @Override
    public float getDipolarCouplingHz(Atom atom, Atom atom2, V3 v3) {
        V3 v32 = V3.newVsub(atom2, atom);
        double d = v32.length();
        double d2 = (double)v32.dot(v3) / d / (double)v3.length();
        return (float)((double)this.getDipolarConstantHz(atom, atom2) * (3.0 * d2 - 1.0) / 2.0);
    }

    private double getIsotopeData(Atom atom, int n) {
        int n2 = atom.getIsotopeNumber();
        String string = atom.getElementSymbolIso(false);
        double[] dArray = this.isotopeData.get(n2 == 0 ? string : "" + n2 + string);
        return dArray == null ? 0.0 : dArray[n];
    }

    private void getData() {
        BufferedReader bufferedReader = null;
        boolean bl = Logger.debugging;
        try {
            String string;
            URL uRL = null;
            uRL = this.getClass().getResource("nmr_data.txt");
            if (uRL == null) {
                Logger.error("Couldn't find file: org/jmol/quantum/nmr_data.txt");
                return;
            }
            InputStream inputStream = (InputStream)uRL.getContent();
            bufferedReader = JmolBinary.getBufferedReader(new BufferedInputStream(inputStream), null);
            this.isotopeData = new Hashtable<String, double[]>();
            while ((string = bufferedReader.readLine()) != null) {
                if (bl) {
                    Logger.info(string);
                }
                if (string.indexOf("#") >= 0) continue;
                String[] stringArray = Parser.getTokens(string);
                String string2 = stringArray[0];
                String string3 = stringArray[2] + string2;
                if (bl) {
                    Logger.info(string2 + " default isotope " + string3);
                }
                for (int i = 3; i < stringArray.length; i += 3) {
                    int n = Integer.parseInt(stringArray[i]);
                    String string4 = n + string2;
                    double[] dArray = new double[]{n, Double.parseDouble(stringArray[i + 1]), Double.parseDouble(stringArray[i + 2])};
                    if (bl) {
                        Logger.info(string4 + "  " + Escape.eAD(dArray));
                    }
                    this.isotopeData.put(string4, dArray);
                }
                double[] dArray = this.isotopeData.get(string3);
                if (dArray == null) {
                    Logger.error("Cannot find default NMR data in nmr_data.txt for " + string3);
                    throw new NullPointerException();
                }
                dArray[0] = -dArray[0];
                this.isotopeData.put(string2, dArray);
            }
            bufferedReader.close();
        }
        catch (Exception exception) {
            Logger.error("Exception " + exception.toString() + " reading " + resource);
            try {
                bufferedReader.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    @Override
    public Object getInfo(String string) {
        if (string.equals("all")) {
            Hashtable<String, Map<String, Object>> hashtable = new Hashtable<String, Map<String, Object>>();
            hashtable.put("isotopes", this.isotopeData);
            hashtable.put("shiftRefsPPM", this.shiftRefsPPM);
            return hashtable;
        }
        if (Character.isDigit(string.charAt(0))) {
            return this.isotopeData.get(string);
        }
        JmolList<double[]> jmolList = new JmolList<double[]>();
        for (Map.Entry<String, double[]> entry : this.isotopeData.entrySet()) {
            String string2 = entry.getKey();
            if (!Character.isDigit(string2.charAt(0)) || !string2.endsWith(string)) continue;
            jmolList.addLast(entry.getValue());
        }
        return jmolList;
    }

    @Override
    public float getChemicalShift(Atom atom) {
        float f = this.getMagneticShielding(atom);
        if (Float.isNaN(f)) {
            return f;
        }
        Float f2 = this.shiftRefsPPM.get(atom.getElementSymbol());
        return (f2 == null ? 0.0f : f2.floatValue()) - f;
    }

    @Override
    public float getMagneticShielding(Atom atom) {
        Tensor tensor = this.viewer.modelSet.getAtomTensor(atom.index, "ms");
        return tensor == null ? Float.NaN : tensor.isotropy();
    }

    @Override
    public boolean getState(SB sB) {
        if (this.shiftRefsPPM.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, Float> entry : this.shiftRefsPPM.entrySet()) {
            sB.append("  set shift_").append(entry.getKey()).append(" ").appendO(entry.getValue()).append("\n");
        }
        return true;
    }

    @Override
    public boolean setChemicalShiftReference(String string, float f) {
        if (string == null) {
            this.shiftRefsPPM.clear();
            return false;
        }
        string = string.substring(0, 1).toUpperCase() + string.substring(1);
        this.shiftRefsPPM.put(string, Float.valueOf(f));
        return true;
    }

    @Override
    public JmolList<Object> getTensorInfo(String string, String string2, BS bS) {
        int n;
        Object object;
        int n2;
        boolean bl;
        if ("".equals(string)) {
            string = null;
        }
        string2 = string2 == null ? ";all." : ";" + string2 + ".";
        JmolList<Object> jmolList = new JmolList<Object>();
        if (";dc.".equals(string2)) {
            Atom[] atomArray = this.viewer.modelSet.atoms;
            int n3 = bS.nextSetBit(0);
            while (n3 >= 0) {
                int n4 = bS.nextSetBit(n3 + 1);
                while (n4 >= 0) {
                    JmolList<Number> jmolList2 = new JmolList<Number>();
                    jmolList2.addLast(atomArray[n3].index);
                    jmolList2.addLast(atomArray[n4].index);
                    jmolList2.addLast(Float.valueOf(this.getDipolarConstantHz(atomArray[n3], atomArray[n4])));
                    jmolList.addLast(jmolList2);
                    n4 = bS.nextSetBit(n4 + 1);
                }
                n3 = bS.nextSetBit(n3 + 1);
            }
            return jmolList;
        }
        if (string == null || string.startsWith("isc")) {
            bl = string2.equals(";j.");
            n2 = string2.equals(";eta.");
            object = this.getInteractionTensorList(string, bS);
            n = object == null ? 0 : ((ArrayList)object).size();
            for (int i = 0; i < n; ++i) {
                Tensor tensor = (Tensor)((ArrayList)object).get(i);
                JmolList<Object> jmolList3 = new JmolList<Object>();
                jmolList3.addLast(Integer.valueOf(tensor.atomIndex1));
                jmolList3.addLast(Integer.valueOf(tensor.atomIndex2));
                jmolList3.addLast(n2 != 0 || bl ? Float.valueOf(this.getIsoOrAnisoHz(bl, null, null, null, tensor)) : tensor.getInfo(string2));
                jmolList.addLast(jmolList3);
            }
            if (string != null) {
                return jmolList;
            }
        }
        bl = string != null && string.startsWith("efg") && string2.equals(";chi.");
        n2 = bS.nextSetBit(0);
        while (n2 >= 0) {
            if (string == null) {
                object = this.viewer.modelSet.getAtomTensorList(n2);
                if (object != null) {
                    for (n = 0; n < ((Object)object).length; ++n) {
                        jmolList.addLast(((Tensor)object[n]).getInfo(string2));
                    }
                }
            } else {
                object = this.viewer.modelSet.getAtomTensor(n2, string);
                if (object != null) {
                    jmolList.addLast(bl ? Float.valueOf(this.getQuadrupolarConstant((Tensor)object)) : ((Tensor)object).getInfo(string2));
                }
            }
            n2 = bS.nextSetBit(n2 + 1);
        }
        return jmolList;
    }

    @Override
    public Map<String, Integer> getMinDistances(MeasurementData measurementData) {
        BS bS = (BS)measurementData.points.get(0);
        int n = bS.cardinality();
        if (n == 0 || !(measurementData.points.get(1) instanceof BS)) {
            return null;
        }
        BS bS2 = (BS)measurementData.points.get(1);
        int n2 = bS2.cardinality();
        if (n < 2 && n2 < 2) {
            return null;
        }
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Atom[] atomArray = this.viewer.modelSet.atoms;
        int n3 = bS.nextSetBit(0);
        while (n3 >= 0) {
            Atom atom = atomArray[n3];
            String string = atom.getAtomName();
            int n4 = bS2.nextSetBit(0);
            while (n4 >= 0) {
                Atom atom2 = atomArray[n4];
                int n5 = (int)(atom2.distanceSquared(atom) * 100.0f);
                if (n5 != 0) {
                    String string2 = atom2.getAtomName();
                    String string3 = string.compareTo(string2) < 0 ? string + string2 : string2 + string;
                    Integer n6 = (Integer)hashtable.get(string3);
                    if (n6 == null) {
                        n6 = n5;
                        hashtable.put(string3, n6);
                    } else if (n5 < n6) {
                        hashtable.put(string3, n5);
                    }
                }
                n4 = bS2.nextSetBit(n4 + 1);
            }
            n3 = bS.nextSetBit(n3 + 1);
        }
        return hashtable;
    }
}

