/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.jvxl.readers;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import org.jmol.api.Interface;
import org.jmol.api.JmolDocument;
import org.jmol.jvxl.readers.SurfaceGenerator;
import org.jmol.jvxl.readers.SurfaceReader;
import org.jmol.util.Parser;

abstract class SurfaceFileReader
extends SurfaceReader {
    protected BufferedReader br;
    protected JmolDocument binarydoc;
    protected OutputStream os;
    protected String line;
    protected int[] next = new int[1];

    SurfaceFileReader() {
    }

    void init(SurfaceGenerator surfaceGenerator) {
        this.initSR(surfaceGenerator);
    }

    void init2(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init2SFR(surfaceGenerator, bufferedReader);
    }

    void init2SFR(SurfaceGenerator surfaceGenerator, BufferedReader bufferedReader) {
        this.init(surfaceGenerator);
        this.br = bufferedReader;
    }

    JmolDocument newBinaryDocument() {
        return (JmolDocument)Interface.getOptionInterface("io2.BinaryDocument");
    }

    protected void setOutputStream(OutputStream outputStream) {
        if (this.binarydoc == null) {
            this.os = outputStream;
        } else {
            this.sg.setOutputStream(this.binarydoc, outputStream);
        }
    }

    protected void closeReader() {
        this.closeReaderSFR();
    }

    protected void closeReaderSFR() {
        if (this.br != null) {
            try {
                this.br.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.os != null) {
            try {
                this.os.flush();
                this.os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.binarydoc != null) {
            this.binarydoc.close();
        }
    }

    void discardTempData(boolean bl) {
        this.closeReader();
        this.discardTempDataSR(bl);
    }

    protected String[] getTokens() {
        return Parser.getTokensAt(this.line, 0);
    }

    protected float parseFloat() {
        return Parser.parseFloatNext(this.line, this.next);
    }

    protected float parseFloatStr(String string) {
        this.next[0] = 0;
        return Parser.parseFloatNext(string, this.next);
    }

    protected float parseFloatRange(String string, int n, int n2) {
        this.next[0] = n;
        return Parser.parseFloatRange(string, n2, this.next);
    }

    protected int parseInt() {
        return Parser.parseIntNext(this.line, this.next);
    }

    protected int parseIntStr(String string) {
        this.next[0] = 0;
        return Parser.parseIntNext(string, this.next);
    }

    protected int parseIntNext(String string) {
        return Parser.parseIntNext(string, this.next);
    }

    protected float[] parseFloatArrayStr(String string) {
        this.next[0] = 0;
        return Parser.parseFloatArrayNext(string, this.next, null, null, null);
    }

    protected float[] parseFloatArray(float[] fArray, String string, String string2) {
        return Parser.parseFloatArrayNext(this.line, this.next, fArray, string, string2);
    }

    protected String getQuotedStringNext() {
        return Parser.getQuotedStringNext(this.line, this.next);
    }

    protected void skipTo(String string, String string2) throws Exception {
        if (string != null) {
            while (this.readLine().indexOf(string) < 0) {
            }
        }
        if (string2 != null) {
            this.next[0] = this.line.indexOf(string2) + string2.length() + 2;
        }
    }

    protected String readLine() throws Exception {
        this.line = this.br.readLine();
        if (this.line != null) {
            this.nBytes += (long)this.line.length();
            if (this.os != null) {
                byte[] byArray = this.line.getBytes();
                this.os.write(byArray, 0, byArray.length);
                this.os.write(10);
            }
        }
        return this.line;
    }
}

