/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.io2;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.zip.CRC32;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.jmol.adapter.smarter.AtomSetCollection;
import org.jmol.api.Interface;
import org.jmol.api.JmolAdapter;
import org.jmol.api.JmolDocument;
import org.jmol.api.JmolZipUtility;
import org.jmol.api.ZInputStream;
import org.jmol.io.JmolBinary;
import org.jmol.io2.JmolZipInputStream;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.SB;
import org.jmol.util.TextFormat;
import org.jmol.viewer.FileManager;
import org.jmol.viewer.JC;
import org.jmol.viewer.Viewer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ZipUtil
implements JmolZipUtility {
    private static final String SCENE_TAG = "###scene.spt###";

    @Override
    public ZInputStream newZipInputStream(InputStream inputStream) {
        return ZipUtil.newZIS(inputStream);
    }

    private static ZInputStream newZIS(InputStream inputStream) {
        return inputStream instanceof ZInputStream ? (ZInputStream)((Object)inputStream) : (inputStream instanceof BufferedInputStream ? new JmolZipInputStream(inputStream) : new JmolZipInputStream(new BufferedInputStream(inputStream)));
    }

    @Override
    public void getAllZipData(InputStream inputStream, String[] stringArray, String string, String string2, Map<String, String> map) {
        ZipUtil.getAllZipDataStatic(inputStream, stringArray, string, string2, map);
    }

    private static void getAllZipDataStatic(InputStream inputStream, String[] stringArray, String string, String string2, Map<String, String> map) {
        ZipInputStream zipInputStream = (ZipInputStream)((Object)ZipUtil.newZIS(inputStream));
        SB sB = new SB();
        string2 = "|" + string2 + "|";
        String string3 = TextFormat.join(stringArray, '/', 1);
        String string4 = null;
        if (string3 != null && (string4 = string3.substring(0, string3.indexOf("/") + 1)).length() == 0) {
            string4 = null;
        }
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string5;
                String string6 = zipEntry.getName();
                if (string3 != null && string4 != null && !string6.equals(string3) && !string6.startsWith(string4)) continue;
                sB.append(string6).appendC('\n');
                String string7 = "|" + string6.substring(string6.lastIndexOf("/") + 1) + "|";
                boolean bl = string2.indexOf(string7) >= 0;
                byte[] byArray = JmolBinary.getStreamBytes(zipInputStream, zipEntry.getSize());
                if (bl) {
                    string5 = ZipUtil.getBinaryStringForBytes(byArray);
                    string6 = string6 + ":asBinaryString";
                } else {
                    string5 = JmolBinary.fixUTF(byArray);
                }
                string5 = "BEGIN Directory Entry " + string6 + "\n" + string5 + "\nEND Directory Entry " + string6 + "\n";
                map.put(string + "|" + string6, string5);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        map.put("#Directory_Listing", sB.toString());
    }

    private static String getBinaryStringForBytes(byte[] byArray) {
        SB sB = new SB();
        for (int i = 0; i < byArray.length; ++i) {
            sB.append(Integer.toHexString(byArray[i] & 0xFF)).appendC(' ');
        }
        return sB.toString();
    }

    @Override
    public Object getZipFileContents(BufferedInputStream bufferedInputStream, String[] stringArray, int n, boolean bl) {
        if (stringArray == null || n >= stringArray.length) {
            return this.getZipDirectoryAsStringAndClose(bufferedInputStream);
        }
        String string = stringArray[n];
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        try {
            ZipEntry zipEntry;
            boolean bl2 = string.equals(".");
            if (bl2 || string.lastIndexOf("/") == string.length() - 1) {
                String string2;
                ZipEntry zipEntry2;
                SB sB = new SB();
                while ((zipEntry2 = zipInputStream.getNextEntry()) != null) {
                    string2 = zipEntry2.getName();
                    if (!bl2 && !string2.startsWith(string)) continue;
                    sB.append(string2).appendC('\n');
                }
                string2 = sB.toString();
                if (bl) {
                    return new BufferedInputStream(new ByteArrayInputStream(string2.getBytes()));
                }
                return string2;
            }
            boolean bl3 = false;
            if (string.indexOf(":asBinaryString") > 0) {
                string = string.substring(0, string.indexOf(":asBinaryString"));
                bl3 = true;
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray = JmolBinary.getStreamBytes(zipInputStream, zipEntry.getSize());
                if (JmolBinary.isZipB(byArray)) {
                    return this.getZipFileContents(new BufferedInputStream(new ByteArrayInputStream(byArray)), stringArray, ++n, bl);
                }
                if (bl) {
                    return new BufferedInputStream(new ByteArrayInputStream(byArray));
                }
                if (bl3) {
                    SB sB = new SB();
                    for (int i = 0; i < byArray.length; ++i) {
                        sB.append(Integer.toHexString(byArray[i] & 0xFF)).appendC(' ');
                    }
                    return sB.toString();
                }
                return JmolBinary.fixUTF(byArray);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "";
    }

    public byte[] getZipFileContentsAsBytes(BufferedInputStream bufferedInputStream, String[] stringArray, int n) {
        byte[] byArray = new byte[]{};
        String string = stringArray[n];
        if (string.lastIndexOf("/") == string.length() - 1) {
            return byArray;
        }
        try {
            ZipEntry zipEntry;
            bufferedInputStream = JmolBinary.checkPngZipStream(bufferedInputStream);
            ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                if (!string.equals(zipEntry.getName())) continue;
                byte[] byArray2 = JmolBinary.getStreamBytes(zipInputStream, zipEntry.getSize());
                if (JmolBinary.isZipB(byArray2) && ++n < stringArray.length) {
                    return this.getZipFileContentsAsBytes(new BufferedInputStream(new ByteArrayInputStream(byArray2)), stringArray, n);
                }
                return byArray2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return byArray;
    }

    @Override
    public String getZipDirectoryAsStringAndClose(BufferedInputStream bufferedInputStream) {
        SB sB = new SB();
        String[] stringArray = new String[]{};
        try {
            stringArray = this.getZipDirectoryOrErrorAndClose(bufferedInputStream, false);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
        }
        for (int i = 0; i < stringArray.length; ++i) {
            sB.append(stringArray[i]).appendC('\n');
        }
        return sB.toString();
    }

    @Override
    public String[] getZipDirectoryAndClose(BufferedInputStream bufferedInputStream, boolean bl) {
        String[] stringArray = new String[]{};
        try {
            stringArray = this.getZipDirectoryOrErrorAndClose(bufferedInputStream, bl);
            bufferedInputStream.close();
        }
        catch (Exception exception) {
            Logger.error(exception.toString());
        }
        return stringArray;
    }

    private String[] getZipDirectoryOrErrorAndClose(BufferedInputStream bufferedInputStream, boolean bl) throws IOException {
        ZipEntry zipEntry;
        bufferedInputStream = JmolBinary.checkPngZipStream(bufferedInputStream);
        JmolList<String> jmolList = new JmolList<String>();
        ZipInputStream zipInputStream = new ZipInputStream(bufferedInputStream);
        String string = null;
        while ((zipEntry = zipInputStream.getNextEntry()) != null) {
            String string2 = zipEntry.getName();
            if (bl && ZipUtil.isJmolManifest(string2)) {
                string = ZipUtil.getZipEntryAsString(zipInputStream);
                continue;
            }
            if (string2.startsWith("__MACOS")) continue;
            jmolList.addLast(string2);
        }
        zipInputStream.close();
        if (bl) {
            jmolList.add(0, string == null ? "" : string + "\n############\n");
        }
        return jmolList.toArray(new String[jmolList.size()]);
    }

    private static String getZipEntryAsString(InputStream inputStream) throws IOException {
        return JmolBinary.fixUTF(JmolBinary.getStreamBytes(inputStream, -1L));
    }

    private static boolean isJmolManifest(String string) {
        return string.startsWith("JmolManifest");
    }

    @Override
    public String cacheZipContents(BufferedInputStream bufferedInputStream, String string, Map<String, byte[]> map) {
        ZipInputStream zipInputStream = (ZipInputStream)((Object)this.newZipInputStream(bufferedInputStream));
        SB sB = new SB();
        long l = 0L;
        try {
            ZipEntry zipEntry;
            while ((zipEntry = zipInputStream.getNextEntry()) != null) {
                String string2 = zipEntry.getName();
                sB.append(string2).appendC('\n');
                long l2 = zipEntry.getSize();
                byte[] byArray = JmolBinary.getStreamBytes(zipInputStream, l2);
                l += (long)byArray.length;
                map.put(string + "|" + string2, byArray);
            }
            zipInputStream.close();
        }
        catch (Exception exception) {
            try {
                zipInputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return null;
        }
        if (l == 0L) {
            return null;
        }
        Logger.info("ZipUtil cached " + l + " bytes from " + string);
        return sB.toString();
    }

    @Override
    public String getGzippedBytesAsString(byte[] byArray) {
        return ZipUtil.staticGetGzippedBytesAsString(byArray);
    }

    static String staticGetGzippedBytesAsString(byte[] byArray) {
        try {
            InputStream inputStream = new ByteArrayInputStream(byArray);
            while (JmolBinary.isGzipS(inputStream = new BufferedInputStream(new GZIPInputStream(inputStream, 512)))) {
            }
            String string = ZipUtil.getZipEntryAsString(inputStream);
            inputStream.close();
            return string;
        }
        catch (Exception exception) {
            return "";
        }
    }

    public InputStream getUnGzippedInputStream(byte[] byArray) {
        try {
            InputStream inputStream = new ByteArrayInputStream(byArray);
            while (JmolBinary.isGzipS(inputStream = new BufferedInputStream(new GZIPInputStream(inputStream, 512)))) {
            }
            return inputStream;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public InputStream newGZIPInputStream(BufferedInputStream bufferedInputStream) throws IOException {
        return new GZIPInputStream((InputStream)bufferedInputStream, 512);
    }

    private String addPngFileBytes(String string, byte[] byArray, int n, Hashtable<Object, String> hashtable, boolean bl, String string2, int n2, JmolList<Object> jmolList) {
        CRC32 cRC32 = new CRC32();
        cRC32.update(byArray, 0, byArray.length);
        Long l = cRC32.getValue();
        if (hashtable.containsKey(l)) {
            string2 = hashtable.get(l);
        } else {
            if (bl) {
                string2 = string2.replace('.', '_');
            }
            if (hashtable.containsKey(string2)) {
                int n3 = string2.lastIndexOf(".");
                string2 = n3 > n2 ? string2.substring(0, n3) + "[" + n + "]" + string2.substring(n3) : string2 + "[" + n + "]";
            }
            jmolList.addLast(string);
            jmolList.addLast(string2);
            jmolList.addLast(byArray);
            hashtable.put(l, string2);
        }
        return string2;
    }

    @Override
    public Object writeZipFile(double d, FileManager fileManager, Viewer viewer, String string, JmolList<Object> jmolList, String string2) {
        byte[] byArray = new byte[1024];
        long l = 0L;
        long l2 = 0L;
        Logger.info("creating zip file " + (string == null ? "" : string) + "...");
        String string3 = null;
        String string4 = "";
        try {
            String string5;
            ByteArrayOutputStream byteArrayOutputStream = string == null || string.startsWith("http://") ? new ByteArrayOutputStream() : null;
            ByteArrayOutputStream byteArrayOutputStream2 = byteArrayOutputStream == null ? (OutputStream)viewer.openOutputChannel(d, string, false) : byteArrayOutputStream;
            ZipOutputStream zipOutputStream = new ZipOutputStream(byteArrayOutputStream2);
            for (int i = 0; i < jmolList.size(); i += 3) {
                String string6;
                String string7;
                string5 = (String)jmolList.get(i);
                byte[] byArray2 = null;
                Object object = fileManager.cacheGet(string5, false);
                if (object instanceof Map) continue;
                if (string5.indexOf("file:/") == 0) {
                    if ((string5 = string5.substring(5)).length() > 2 && string5.charAt(2) == ':') {
                        string5 = string5.substring(1);
                    }
                } else if (string5.indexOf("cache://") == 0) {
                    string5 = string5.substring(8);
                }
                if ((string7 = (String)jmolList.get(i + 1)) == null) {
                    string7 = string5;
                }
                if (object != null) {
                    byte[] byArray3 = byArray2 = Escape.isAB(object) ? (byte[])object : ((String)object).getBytes();
                }
                if (byArray2 == null) {
                    byArray2 = (byte[])jmolList.get(i + 2);
                }
                if (string4.indexOf(string6 = ";" + string7 + ";") >= 0) {
                    Logger.info("duplicate entry");
                    continue;
                }
                string4 = string4 + string6;
                zipOutputStream.putNextEntry(new ZipEntry(string7));
                int n = 0;
                if (byArray2 == null) {
                    int n2;
                    InputStream inputStream = viewer.openFileInputStream(d, string5);
                    while ((n2 = inputStream.read(byArray, 0, 1024)) > 0) {
                        zipOutputStream.write(byArray, 0, n2);
                        n += n2;
                    }
                    inputStream.close();
                } else {
                    zipOutputStream.write(byArray2, 0, byArray2.length);
                    n += byArray2.length;
                }
                l += (long)n;
                zipOutputStream.closeEntry();
                Logger.info("...added " + string5 + " (" + n + " bytes)");
            }
            zipOutputStream.close();
            Logger.info(l + " bytes prior to compression");
            if (byteArrayOutputStream == null) {
                string3 = viewer.getAbsolutePath(d, string).replace('\\', '/');
                l2 = viewer.getFileLength(d, string);
            } else {
                byte[] byArray4 = byteArrayOutputStream.toByteArray();
                if (string == null) {
                    return byArray4;
                }
                string3 = string;
                l2 = byArray4.length;
                string5 = JmolBinary.postByteArray(fileManager, string, byArray4);
                if (string5.indexOf("Exception") >= 0) {
                    return string5;
                }
                string2 = string2 + " " + string5;
            }
        }
        catch (IOException iOException) {
            Logger.info(iOException.toString());
            return iOException.toString();
        }
        return string2 + " " + l2 + " " + string3;
    }

    @Override
    public String getSceneScript(String[] stringArray, Map<String, String> map, JmolList<Integer> jmolList) {
        int n = 0;
        int n2 = 0;
        SB sB = new SB().append(SCENE_TAG).append(" Jmol ").append(Viewer.getJmolVersion()).append("\n{\nsceneScripts={");
        for (int i = 1; i < stringArray.length; ++i) {
            stringArray[i - 1] = TextFormat.trim(stringArray[i - 1], "\t\n\r ");
            int[] nArray = new int[1];
            n2 = Parser.parseIntNext(stringArray[i], nArray);
            if (n2 == Integer.MIN_VALUE) {
                return "bad scene ID: " + n2;
            }
            stringArray[i] = stringArray[i].substring(nArray[0]);
            jmolList.addLast(n2);
            String string = n + "-" + n2;
            map.put(string, stringArray[i - 1]);
            if (i > 1) {
                sB.append(",");
            }
            sB.appendC('\n').append(Escape.eS(string)).append(": ").append(Escape.eS(stringArray[i - 1]));
            n = n2;
        }
        sB.append("\n}\n");
        if (jmolList.size() == 0) {
            return "no lines 'pause scene n'";
        }
        sB.append("\nthisSceneRoot = '$SCRIPT_PATH$'.split('_scene_')[1];\n").append("thisSceneID = 0 + ('$SCRIPT_PATH$'.split('_scene_')[2]).split('.')[1];\n").append("var thisSceneState = '$SCRIPT_PATH$'.replace('.min.png','.all.png') + 'state.spt';\n").append("var spath = ''+currentSceneID+'-'+thisSceneID;\n").append("print thisSceneRoot + ' ' + spath;\n").append("var sscript = sceneScripts[spath];\n").append("var isOK = true;\n").append("try{\n").append("if (thisSceneRoot != currentSceneRoot){\n").append(" isOK = false;\n").append("} else if (sscript != '') {\n").append(" isOK = true;\n").append("} else if (thisSceneID <= currentSceneID){\n").append(" isOK = false;\n").append("} else {\n").append(" sscript = '';\n").append(" for (var i = currentSceneID; i < thisSceneID; i++){\n").append("  var key = ''+i+'-'+(i + 1); var script = sceneScripts[key];\n").append("  if (script = '') {isOK = false;break;}\n").append("  sscript += ';'+script;\n").append(" }\n").append("}\n}catch(e){print e;isOK = false}\n").append("if (isOK) {" + ZipUtil.wrapPathForAllFiles("script inline @sscript", "print e;isOK = false") + "}\n").append("if (!isOK){script @thisSceneState}\n").append("currentSceneRoot = thisSceneRoot; currentSceneID = thisSceneID;\n}\n");
        return sB.toString();
    }

    private static String wrapPathForAllFiles(String string, String string2) {
        String string3 = "v__" + ("" + Math.random()).substring(3);
        return "# Jmol script\n{\n\tVar " + string3 + " = pathForAllFiles\n\tpathForAllFiles=\"$SCRIPT_PATH$\"\n\ttry{\n\t\t" + string + "\n\t}catch(e){" + string2 + "}\n\tpathForAllFiles = " + string3 + "\n}\n";
    }

    @Override
    public Object createZipSet(double d, FileManager fileManager, Viewer viewer, String string, String string2, String[] stringArray, boolean bl) {
        Object object;
        String string3;
        String string4;
        int n;
        boolean bl2;
        boolean bl3;
        JmolList<Object> jmolList = new JmolList<Object>();
        JmolList<String> jmolList2 = new JmolList<String>();
        Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
        boolean bl4 = stringArray != null && stringArray.length == 3 && stringArray[1].startsWith(SCENE_TAG);
        boolean bl5 = bl3 = bl4 && stringArray[2].equals("min");
        if (!bl3) {
            JmolBinary.getFileReferences(string2, jmolList2);
            if (bl4) {
                JmolBinary.getFileReferences(stringArray[1], jmolList2);
            }
        }
        boolean bl6 = bl2 = !bl4 && stringArray != null && stringArray.length > 0;
        if (bl2) {
            string2 = ZipUtil.wrapPathForAllFiles("script " + Escape.eS(stringArray[0]), "");
            for (n = 0; n < stringArray.length; ++n) {
                jmolList2.addLast(stringArray[n]);
            }
        }
        n = jmolList2.size();
        if (string != null) {
            string = string.replace('\\', '/');
        }
        if ((string4 = string) != null && (string4 = string.substring(string.lastIndexOf("/") + 1)).indexOf(".") >= 0) {
            string4 = string4.substring(0, string4.indexOf("."));
        }
        JmolList<String> jmolList3 = new JmolList<String>();
        for (int i = 0; i < n; ++i) {
            string3 = (String)jmolList2.get(i);
            boolean bl7 = !viewer.isJS && FileManager.isLocal(string3);
            String string5 = string3;
            if (bl7 || bl) {
                boolean bl8;
                int n2 = string3.lastIndexOf("/");
                string5 = string3.indexOf("?") > 0 && string3.indexOf("|") < 0 ? TextFormat.replaceAllCharacters(string3, "/:?\"'=&", "_") : FileManager.stripPath(string3);
                string5 = TextFormat.replaceAllCharacters(string5, "[]", "_");
                boolean bl9 = bl8 = fileManager.spardirCache != null && fileManager.spardirCache.containsKey(string3);
                if (bl7 && string3.indexOf("|") < 0 && !bl8) {
                    jmolList.addLast(string3);
                    jmolList.addLast(string5);
                    jmolList.addLast((Object)null);
                } else {
                    Object object2;
                    Object object3 = object2 = bl8 ? fileManager.spardirCache.get(string3) : (Object)fileManager.getFileAsBytes(string3, null, true);
                    if (!Escape.isAB(object2)) {
                        return object2;
                    }
                    string5 = this.addPngFileBytes(string3, (byte[])object2, i, hashtable, bl8, string5, n2, jmolList);
                }
                string3 = "$SCRIPT_PATH$" + string5;
            }
            hashtable.put(string5, string5);
            jmolList3.addLast(string3);
        }
        if (!bl3) {
            string2 = TextFormat.replaceQuotedStrings(string2, jmolList2, jmolList3);
            jmolList.addLast("state.spt");
            jmolList.addLast((Object)null);
            jmolList.addLast(string2.getBytes());
        }
        if (bl4) {
            if (stringArray[0] != null) {
                jmolList.addLast("animate.spt");
                jmolList.addLast((Object)null);
                jmolList.addLast(stringArray[0].getBytes());
            }
            jmolList.addLast("scene.spt");
            jmolList.addLast((Object)null);
            string2 = TextFormat.replaceQuotedStrings(stringArray[1], jmolList2, jmolList3);
            jmolList.addLast(string2.getBytes());
        }
        String string6 = bl4 ? "scene.spt" : "state.spt";
        jmolList.addLast("JmolManifest.txt");
        jmolList.addLast((Object)null);
        string3 = "# Jmol Manifest Zip Format 1.1\n# Created " + new Date() + "\n" + "# JmolVersion " + Viewer.getJmolVersion() + "\n" + string6;
        jmolList.addLast(string3.getBytes());
        jmolList.addLast("Jmol_version_" + Viewer.getJmolVersion().replace(' ', '_').replace(':', '.'));
        jmolList.addLast((Object)null);
        jmolList.addLast(new byte[0]);
        if (string4 != null && Escape.isAB(object = viewer.getImageAsWithComment("PNG", -1, -1, -1, null, null, null, JC.embedScript(string2)))) {
            jmolList.addLast("preview.png");
            jmolList.addLast((Object)null);
            jmolList.addLast(object);
        }
        return JmolBinary.writeZipFile(d, fileManager, viewer, string, jmolList, "OK JMOL");
    }

    @Override
    public Object getAtomSetCollectionOrBufferedReaderFromZip(JmolAdapter jmolAdapter, InputStream inputStream, String string, String[] stringArray, Map<String, Object> map, int n, boolean bl) {
        Object object;
        boolean bl2;
        boolean bl3;
        String string2;
        boolean bl4;
        String string3;
        boolean bl5 = n == 1;
        map.put("zipSet", string);
        String[] stringArray2 = (String[])map.get("subFileList");
        if (stringArray2 == null) {
            stringArray2 = ZipUtil.checkSpecialInZip(stringArray);
        }
        String string4 = string3 = stringArray2 == null || n >= stringArray2.length ? null : stringArray2[n];
        if (string3 != null && (string3.startsWith("/") || string3.startsWith("\\"))) {
            string3 = string3.substring(1);
        }
        int n2 = 0;
        if (string3 == null && map.containsKey("modelNumber") && (n2 = ((Integer)map.get("modelNumber")).intValue()) > 0 && bl5) {
            map.remove("modelNumber");
        }
        boolean bl6 = bl4 = (string2 = (String)map.get("manifest")) == null;
        if (bl4) {
            string2 = stringArray.length > 0 ? stringArray[0] : "";
        }
        boolean bl7 = bl3 = string2.length() > 0;
        if (bl3 && Logger.debugging) {
            Logger.debug("manifest for  " + string + ":\n" + string2);
        }
        boolean bl8 = string2.indexOf("IGNORE_ERRORS") >= 0;
        boolean bl9 = string2.indexOf("IGNORE_MANIFEST") >= 0;
        boolean bl10 = bl2 = string2.indexOf("EXCEPT_FILES") >= 0;
        if (bl9 || string3 != null) {
            bl3 = false;
        }
        if (bl4 && bl3 && (object = JmolBinary.getManifestScriptPath(string2)) != null) {
            return "NOTE: file recognized as a script file: " + string + (String)object + "\n";
        }
        object = new JmolList();
        Hashtable<String[], Object> hashtable = bl3 ? new Hashtable<String[], Object>() : null;
        boolean bl11 = false;
        Object object2 = ZipUtil.checkSpecialData(inputStream, stringArray);
        if (object2 instanceof String) {
            return object2;
        }
        SB sB = object2;
        try {
            Object object3;
            Object object4;
            ZipEntry zipEntry;
            if (sB != null) {
                BufferedReader bufferedReader = new BufferedReader(new StringReader(sB.toString()));
                if (bl) {
                    return bufferedReader;
                }
                object2 = jmolAdapter.getAtomSetCollectionFromReader(string, bufferedReader, map);
                if (object2 instanceof String) {
                    return object2;
                }
                if (object2 instanceof AtomSetCollection) {
                    AtomSetCollection atomSetCollection = (AtomSetCollection)object2;
                    if (atomSetCollection.errorMessage != null) {
                        if (bl8) {
                            return null;
                        }
                        return atomSetCollection.errorMessage;
                    }
                    return atomSetCollection;
                }
                if (bl8) {
                    return null;
                }
                return "unknown reader error";
            }
            if (inputStream instanceof BufferedInputStream) {
                inputStream = JmolBinary.checkPngZipStream((BufferedInputStream)inputStream);
            }
            ZipInputStream zipInputStream = (ZipInputStream)((Object)JmolBinary.newZipInputStream(inputStream));
            if (bl3) {
                string2 = '|' + string2.replace('\r', '|').replace('\n', '|') + '|';
            }
            while ((zipEntry = zipInputStream.getNextEntry()) != null && (n2 <= 0 || ((ArrayList)object).size() < n2)) {
                Object object5;
                Object object6;
                if (zipEntry.isDirectory()) continue;
                object4 = zipEntry.getName();
                if (string3 != null && !object4.equals(string3)) continue;
                if (string3 != null) {
                    map.put("subFileName", string3);
                }
                if (ZipUtil.isJmolManifest((String)object4) || bl3 && bl2 == string2.indexOf("|" + (String)object4 + "|") >= 0) continue;
                byte[] byArray = JmolBinary.getStreamBytes(zipInputStream, zipEntry.getSize());
                if (JmolBinary.isZipB(byArray)) {
                    object3 = new BufferedInputStream(new ByteArrayInputStream(byArray));
                    object6 = JmolBinary.getZipDirectoryAndClose((BufferedInputStream)object3, true);
                    object3 = new BufferedInputStream(new ByteArrayInputStream(byArray));
                    object5 = this.getAtomSetCollectionOrBufferedReaderFromZip(jmolAdapter, (InputStream)object3, string + "|" + (String)object4, (String[])object6, map, ++n, bl);
                    if (object5 instanceof String) {
                        if (bl8) continue;
                        return object5;
                    }
                    if (object5 instanceof AtomSetCollection || object5 instanceof JmolList) {
                        if (bl3 && !bl2) {
                            hashtable.put((String[])object4, object5);
                            continue;
                        }
                        ((JmolList)object).addLast(object5);
                        continue;
                    }
                    if (object5 instanceof BufferedReader) {
                        if (bl5) {
                            zipInputStream.close();
                        }
                        return object5;
                    }
                    if (bl8) continue;
                    zipInputStream.close();
                    return "unknown zip reader error";
                }
                if (JmolBinary.isGzipB(byArray)) {
                    return this.getUnGzippedInputStream(byArray);
                }
                if (JmolBinary.isPickleB(byArray)) {
                    object3 = new BufferedInputStream(new ByteArrayInputStream(byArray));
                    if (bl5) {
                        zipInputStream.close();
                    }
                    return object3;
                }
                if (JmolBinary.isCompoundDocumentB(byArray)) {
                    object6 = (JmolDocument)Interface.getInterface("jmol.util.CompoundDocument");
                    object6.setStream(new BufferedInputStream(new ByteArrayInputStream(byArray)), true);
                    object3 = object6.getAllDataFiles("Molecule", "Input").toString();
                } else {
                    object3 = JmolBinary.isGzipB(byArray) ? JmolBinary.getGzippedBytesAsString(byArray) : JmolBinary.fixUTF(byArray);
                }
                object6 = new BufferedReader(new StringReader((String)object3));
                if (bl) {
                    if (bl5) {
                        zipInputStream.close();
                    }
                    return object6;
                }
                object5 = string + "|" + zipEntry.getName();
                object2 = jmolAdapter.getAtomSetCollectionFromReader((String)object5, object6, map);
                if (!(object2 instanceof AtomSetCollection)) {
                    if (bl8) continue;
                    zipInputStream.close();
                    return "" + object2;
                }
                if (bl3 && !bl2) {
                    hashtable.put((String[])object4, object2);
                } else {
                    ((JmolList)object).addLast(object2);
                }
                AtomSetCollection atomSetCollection = (AtomSetCollection)object2;
                if (atomSetCollection.errorMessage == null || bl8) continue;
                zipInputStream.close();
                return atomSetCollection.errorMessage;
            }
            if (bl5) {
                zipInputStream.close();
            }
            if (bl3 && !bl2) {
                object4 = TextFormat.split(string2, '|');
                for (int i = 0; i < ((String[])object4).length; ++i) {
                    object3 = object4[i];
                    if (((String)object3).length() == 0 || ((String)object3).indexOf("#") == 0) continue;
                    if (hashtable.containsKey(object3)) {
                        ((JmolList)object).addLast(hashtable.get(object3));
                        continue;
                    }
                    if (!Logger.debugging) continue;
                    Logger.debug("manifested file " + (String)object3 + " was not found in " + string);
                }
            }
            if (!bl5) {
                return object;
            }
            object4 = new AtomSetCollection("Array", null, null, (JmolList<?>)object);
            if (object4.errorMessage != null) {
                if (bl8) {
                    return null;
                }
                return object4.errorMessage;
            }
            if (bl11) {
                n2 = 1;
            }
            if (n2 > 0 && n2 <= ((ArrayList)object).size()) {
                return ((ArrayList)object).get(n2 - 1);
            }
            return object4;
        }
        catch (Exception exception) {
            if (bl8) {
                return null;
            }
            Logger.error("" + exception);
            return "" + exception;
        }
        catch (Error error) {
            Logger.errorEx(null, error);
            return "" + error;
        }
    }

    private static SB checkSpecialData(InputStream inputStream, String[] stringArray) {
        boolean bl = false;
        for (int i = 1; i < stringArray.length; ++i) {
            if (!stringArray[i].endsWith(".spardir/") && stringArray[i].indexOf("_spartandir") < 0) continue;
            bl = true;
            break;
        }
        if (!bl) {
            return null;
        }
        SB sB = new SB();
        sB.append("Zip File Directory: ").append("\n").append(Escape.eAS(stringArray, true)).append("\n");
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        ZipUtil.getAllZipDataStatic(inputStream, new String[0], "", "Molecule", hashtable);
        String string = "|";
        String string2 = (String)hashtable.get(string + "output");
        if (string2 == null) {
            string = "|" + stringArray[1];
            string2 = (String)hashtable.get(string + "output");
        }
        sB.append(string2);
        String[] stringArray2 = ZipUtil.getSpartanFileList(string, ZipUtil.getSpartanDirs(string2));
        for (int i = 2; i < stringArray2.length; ++i) {
            String string3 = stringArray2[i];
            if (hashtable.containsKey(string3)) {
                sB.append((String)hashtable.get(string3));
                continue;
            }
            sB.append(string3 + "\n");
        }
        return sB;
    }

    @Override
    public String[] spartanFileList(String string, String string2) {
        String[] stringArray = ZipUtil.getSpartanDirs(string2);
        if (stringArray.length == 0 && string.endsWith(".spardir.zip") && string2.indexOf(".zip|output") >= 0) {
            String string3 = string.replace('\\', '/');
            int n = string.lastIndexOf(".spardir");
            n = string3.lastIndexOf("/");
            string3 = string + "|" + string.substring(n + 1, string.length() - 4);
            return new String[]{"SpartanSmol", string3, string3 + "/output"};
        }
        return ZipUtil.getSpartanFileList(string, stringArray);
    }

    private static String[] getSpartanDirs(String string) {
        if (string == null) {
            return new String[0];
        }
        if (string.startsWith("java.io.FileNotFoundException") || string.startsWith("FILE NOT FOUND") || string.indexOf("<html") >= 0) {
            return new String[]{"M0001"};
        }
        JmolList<String> jmolList = new JmolList<String>();
        String string2 = "";
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, " \t\r\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                if (string3.equals(")")) {
                    jmolList.addLast(string2);
                } else if (string3.equals("Start-") && stringTokenizer.nextToken().equals("Molecule")) {
                    jmolList.addLast(TextFormat.split(stringTokenizer.nextToken(), '\"')[1]);
                }
                string2 = string3;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return jmolList.toArray(new String[jmolList.size()]);
    }

    private static String[] getSpartanFileList(String string, String[] stringArray) {
        String[] stringArray2 = new String[2 + stringArray.length * 5];
        stringArray2[0] = "SpartanSmol";
        stringArray2[1] = "Directory Entry ";
        int n = 2;
        if ((string = string.replace('\\', '/')).endsWith("/")) {
            string = string.substring(0, string.length() - 1);
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = string + (Character.isDigit(stringArray[i].charAt(0)) ? "/Profile." + stringArray[i] : "/" + stringArray[i]);
            stringArray2[n++] = string2 + "/#JMOL_MODEL " + stringArray[i];
            stringArray2[n++] = string2 + "/input";
            stringArray2[n++] = string2 + "/archive";
            stringArray2[n++] = string2 + "/Molecule:asBinaryString";
            stringArray2[n++] = string2 + "/proparc";
        }
        return stringArray2;
    }

    static String[] checkSpecialInZip(String[] stringArray) {
        String[] stringArray2;
        if (stringArray.length < 2) {
            stringArray2 = null;
        } else {
            String string = stringArray[1];
            if (string.endsWith(".spardir/") || stringArray.length == 2) {
                String[] stringArray3 = new String[2];
                stringArray3[0] = "";
                stringArray2 = stringArray3;
                stringArray3[1] = string.endsWith("/") ? string.substring(0, string.length() - 1) : string;
            } else {
                stringArray2 = null;
            }
        }
        return stringArray2;
    }

    @Override
    public byte[] getCachedPngjBytes(FileManager fileManager, String string) {
        boolean bl;
        if (string.indexOf(".png") < 0) {
            return null;
        }
        Logger.info("FileManager checking PNGJ cache for " + string);
        String string2 = ZipUtil.shortSceneFilename(string);
        if (fileManager.pngjCache == null && !this.cachePngjFile(fileManager, new String[]{string, null})) {
            return null;
        }
        Map<String, byte[]> map = fileManager.pngjCache;
        boolean bl2 = bl = string.indexOf(".min.") >= 0;
        if (!bl) {
            String string3 = fileManager.getCanonicalName(JmolBinary.getZipRoot(string));
            if (!map.containsKey(string3) && !this.cachePngjFile(fileManager, new String[]{string, null})) {
                return null;
            }
            if (string.indexOf("|") < 0) {
                string2 = string3;
            }
        }
        if (map.containsKey(string2)) {
            Logger.info("FileManager using memory cache " + string2);
            return map.get(string2);
        }
        if (!bl || !this.cachePngjFile(fileManager, new String[]{string, null})) {
            return null;
        }
        Logger.info("FileManager using memory cache " + string2);
        return map.get(string2);
    }

    @Override
    public boolean cachePngjFile(FileManager fileManager, String[] stringArray) {
        fileManager.pngjCache = new Hashtable<String, byte[]>();
        Hashtable<String, byte[]> hashtable = fileManager.pngjCache;
        if (stringArray == null) {
            return false;
        }
        stringArray[1] = null;
        if (stringArray[0] == null) {
            return false;
        }
        stringArray[0] = JmolBinary.getZipRoot(stringArray[0]);
        String string = ZipUtil.shortSceneFilename(stringArray[0]);
        try {
            stringArray[1] = this.cacheZipContents(JmolBinary.checkPngZipStream((BufferedInputStream)fileManager.getBufferedInputStreamOrErrorMessageFromName(stringArray[0], null, false, false, null, false)), string, fileManager.pngjCache);
        }
        catch (Exception exception) {
            return false;
        }
        if (stringArray[1] == null) {
            return false;
        }
        byte[] byArray = stringArray[1].getBytes();
        hashtable.put(fileManager.getCanonicalName(stringArray[0]), byArray);
        if (string.indexOf("_scene_") >= 0) {
            hashtable.put(ZipUtil.shortSceneFilename(stringArray[0]), byArray);
            byArray = (byte[])hashtable.remove(string + "|state.spt");
            if (byArray != null) {
                hashtable.put(ZipUtil.shortSceneFilename(stringArray[0] + "|state.spt"), byArray);
            }
        }
        for (String string2 : hashtable.keySet()) {
            System.out.println(string2);
        }
        return true;
    }

    private static String shortSceneFilename(String string) {
        int n;
        int n2 = string.indexOf("_scene_") + 7;
        if (n2 < 7) {
            return string;
        }
        String string2 = "";
        if (string.endsWith("|state.spt")) {
            n = string.indexOf(46, n2);
            if (n < 0) {
                return string;
            }
            string2 = string.substring(n2, n);
        }
        n = string.lastIndexOf("|");
        return string.substring(0, n2) + string2 + (n > 0 ? string.substring(n) : "");
    }
}

