/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.awt;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.MediaTracker;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.net.URL;
import javax.swing.JPanel;
import org.jmol.api.ApiPlatform;
import org.jmol.io2.JpegEncoder;
import org.jmol.util.Escape;
import org.jmol.util.JmolFont;
import org.jmol.viewer.Viewer;

class Image {
    private static final DirectColorModel rgbColorModel = new DirectColorModel(24, 0xFF0000, 65280, 255, 0);
    private static final int[] sampleModelBitMasks = new int[]{0xFF0000, 65280, 255};

    Image() {
    }

    static Object createImage(Object object) {
        if (object instanceof URL) {
            return Toolkit.getDefaultToolkit().createImage((URL)object);
        }
        if (object instanceof String) {
            return Toolkit.getDefaultToolkit().createImage((String)object);
        }
        if (Escape.isAB(object)) {
            return Toolkit.getDefaultToolkit().createImage((byte[])object);
        }
        return null;
    }

    static void waitForDisplay(Object object, Object object2) throws InterruptedException {
        if (object == null) {
            object = new JPanel();
        }
        MediaTracker mediaTracker = new MediaTracker((Component)object);
        int n = (int)(Math.random() * 100000.0);
        mediaTracker.addImage((java.awt.Image)object2, n);
        mediaTracker.waitForID(n);
    }

    static int getWidth(Object object) {
        return ((java.awt.Image)object).getWidth(null);
    }

    static int getHeight(Object object) {
        return ((java.awt.Image)object).getHeight(null);
    }

    static Object getJpgImage(ApiPlatform apiPlatform, Viewer viewer, int n, String string) {
        BufferedImage bufferedImage = (BufferedImage)viewer.getScreenImageBuffer(null, true);
        if (bufferedImage == null) {
            return null;
        }
        if (n < 0) {
            n = 75;
        }
        byte[] byArray = JpegEncoder.getBytes(apiPlatform, bufferedImage, n, string);
        viewer.releaseScreenImage();
        return byArray;
    }

    static int[] grabPixels(Object object, int n, int n2, int[] nArray, int n3, int n4) {
        java.awt.Image image = (java.awt.Image)object;
        PixelGrabber pixelGrabber = nArray == null ? new PixelGrabber(image, 0, 0, n, n2, true) : new PixelGrabber(image, 0, n3, n, n4, nArray, 0, n);
        try {
            pixelGrabber.grabPixels();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        return (int[])pixelGrabber.getPixels();
    }

    static int[] drawImageToBuffer(Object object, Object object2, Object object3, int n, int n2, int n3) {
        Graphics graphics = (Graphics)object;
        java.awt.Image image = (java.awt.Image)object3;
        int n4 = image.getWidth(null);
        int n5 = image.getHeight(null);
        if (graphics instanceof Graphics2D) {
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(5, 1.0f));
            graphics.setColor(n3 == 0 ? new Color(0, 0, 0, 0) : new Color(n3));
            graphics.fillRect(0, 0, n, n2);
            ((Graphics2D)graphics).setComposite(AlphaComposite.getInstance(3, 1.0f));
            graphics.drawImage(image, 0, 0, n, n2, 0, 0, n4, n5, null);
        } else {
            graphics.clearRect(0, 0, n, n2);
            graphics.drawImage(image, 0, 0, n, n2, 0, 0, n4, n5, null);
        }
        return Image.grabPixels(object2, n, n2, null, 0, 0);
    }

    public static int[] getTextPixels(String string, JmolFont jmolFont, Object object, Object object2, int n, int n2, int n3) {
        Graphics graphics = (Graphics)object;
        graphics.setColor(Color.black);
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(Color.white);
        graphics.setFont((Font)jmolFont.font);
        graphics.drawString(string, 0, n3);
        return Image.grabPixels(object2, n, n2, null, 0, 0);
    }

    static Object newBufferedImage(Object object, int n, int n2) {
        return new BufferedImage(n, n2, ((BufferedImage)object).getType());
    }

    static Object newBufferedImage(int n, int n2) {
        return new BufferedImage(n, n2, 2);
    }

    static Object allocateRgbImage(int n, int n2, int[] nArray, int n3, boolean bl) {
        return new BufferedImage(rgbColorModel, Raster.createWritableRaster(new SinglePixelPackedSampleModel(3, n, n2, sampleModelBitMasks), new DataBufferInt(nArray, n3), null), false, null);
    }

    static Object getStaticGraphics(Object object, boolean bl) {
        Graphics2D graphics2D = ((BufferedImage)object).createGraphics();
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        return graphics2D;
    }

    static Object getGraphics(Object object) {
        return ((java.awt.Image)object).getGraphics();
    }

    static void drawImage(Object object, Object object2, int n, int n2, int n3, int n4) {
        ((Graphics)object).drawImage((java.awt.Image)object2, n, n2, null);
    }

    static void flush(Object object) {
        ((java.awt.Image)object).flush();
    }

    static void disposeGraphics(Object object) {
        ((Graphics)object).dispose();
    }
}

