/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import org.jmol.applet.AppletWrapper;
import org.jmol.applet.TickerThread;
import org.jmol.applet.WrappedApplet;
import org.jmol.util.Logger;

class WrappedAppletLoader
extends Thread {
    private AppletWrapper appletWrapper;
    private String wrappedAppletClassName;

    WrappedAppletLoader(AppletWrapper appletWrapper, String string) {
        this.appletWrapper = appletWrapper;
        this.wrappedAppletClassName = string;
    }

    public void run() {
        long l = System.currentTimeMillis();
        if (Logger.debugging) {
            Logger.debug("WrappedAppletLoader.run(" + this.wrappedAppletClassName + ")");
        }
        TickerThread tickerThread = new TickerThread(this.appletWrapper);
        tickerThread.start();
        WrappedApplet wrappedApplet = null;
        try {
            Class<?> clazz = Class.forName(this.wrappedAppletClassName);
            wrappedApplet = (WrappedApplet)clazz.newInstance();
            wrappedApplet.setAppletWrapper(this.appletWrapper);
            wrappedApplet.init();
        }
        catch (Exception exception) {
            Logger.errorEx("Could not instantiate wrappedApplet class" + this.wrappedAppletClassName, exception);
        }
        long l2 = (System.currentTimeMillis() - l + 500L) / 1000L;
        if (Logger.debugging) {
            Logger.debug(this.wrappedAppletClassName + " load time = " + l2 + " seconds");
        }
        tickerThread.keepRunning = false;
        tickerThread.interrupt();
        this.appletWrapper.wrappedApplet = wrappedApplet;
        this.appletWrapper.repaint();
        wrappedApplet.jmolReady();
    }
}

