/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.applet;

import java.applet.Applet;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Event;
import java.awt.Graphics;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Hashtable;
import java.util.Map;
import javax.swing.UIManager;
import netscape.javascript.JSObject;
import org.jmol.api.JmolCallbackListener;
import org.jmol.api.JmolScriptInterface;
import org.jmol.api.JmolStatusListener;
import org.jmol.api.JmolSyncInterface;
import org.jmol.api.JmolViewer;
import org.jmol.applet.AppletWrapper;
import org.jmol.applet.JmolAppletRegistry;
import org.jmol.applet.WrappedApplet;
import org.jmol.constant.EnumCallback;
import org.jmol.export.JmolFileDropper;
import org.jmol.i18n.GT;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Parser;
import org.jmol.util.TextFormat;
import org.jmol.viewer.JC;

public class Jmol
implements WrappedApplet {
    private static final boolean REQUIRE_PROGRESSBAR = true;
    private static final int SCRIPT_CHECK = 0;
    private static final int SCRIPT_WAIT = 1;
    private static final int SCRIPT_NOWAIT = 2;
    private boolean hasProgressBar;
    private boolean isSigned;
    private boolean isUpdating;
    private boolean showPaintTime;
    private int paintCounter;
    private int timeLast;
    private int timeCount;
    private int timeTotal;
    private int lastMotionEventNumber;
    private long timeBegin;
    private String language;
    private String statusForm;
    private String statusText;
    private String statusTextarea;
    private JmolFileDropper dropper;
    protected boolean doTranslate = true;
    protected boolean haveDocumentAccess;
    protected boolean isStereoSlave;
    protected boolean loading;
    protected boolean mayScript;
    protected String htmlName;
    protected String fullName;
    protected String syncId;
    protected StringBuilder outputBuffer;
    protected AppletWrapper appletWrapper;
    protected Object gRight;
    protected JmolViewer viewer;
    protected Map<EnumCallback, String> callbacks = new Hashtable<EnumCallback, String>();
    private static final String[] progressbarMsgs = new String[]{"Jmol developer alert!", "", "Please use jmol.js. You are missing the ", "required 'progressbar' parameter.", "  <param name='progressbar' value='true' />"};

    public void paint(Graphics graphics) {
        this.update(graphics, "paint ");
    }

    public void update(Graphics graphics) {
        this.update(graphics, "update");
    }

    public void setAppletWrapper(AppletWrapper appletWrapper) {
        this.appletWrapper = appletWrapper;
    }

    public void jmolReady() {
        System.out.println("Jmol applet " + this.fullName + " ready");
        this.viewer.getBooleanProperty("__appletReady");
    }

    public void destroy() {
        this.gRight = null;
        JmolAppletRegistry.checkOut(this.fullName);
        this.viewer.setModeMouse(-1);
        this.viewer.getBooleanProperty("__appletDestroyed");
        this.viewer = null;
        if (this.dropper != null) {
            this.dropper.dispose();
            this.dropper = null;
        }
        System.out.println("Jmol applet " + this.fullName + " destroyed");
    }

    public Object setStereoGraphics(boolean bl) {
        this.isStereoSlave = bl;
        return bl ? this.appletWrapper.getGraphics() : null;
    }

    public void init() {
        this.htmlName = this.getParameter("name");
        this.syncId = this.getParameter("syncId");
        this.fullName = this.htmlName + "__" + this.syncId + "__";
        System.out.println("Jmol applet " + this.fullName + " initializing");
        this.setLogging();
        String string = this.getParameter("mayscript");
        this.mayScript = string != null && !string.equalsIgnoreCase("false");
        JmolAppletRegistry.checkIn(this.fullName, (JmolSyncInterface)((Object)this.appletWrapper));
        this.initWindows();
        this.initApplication();
    }

    private void initWindows() {
        String string = "-applet";
        boolean bl = this.isSigned = this.getBooleanValue("signed", false) || this.appletWrapper.isSigned();
        if (this.isSigned) {
            string = string + "-signed";
        }
        if (this.getBooleanValue("useCommandThread", this.isSigned)) {
            string = string + "-threaded";
        }
        if (this.isSigned && this.getBooleanValue("multiTouchSparshUI-simulated", false)) {
            string = string + "-multitouch-sparshui-simulated";
        } else if (this.isSigned && this.getBooleanValue("multiTouchSparshUI", false)) {
            string = string + "-multitouch-sparshui";
        }
        String string2 = this.getValue("MaximumSize", null);
        if (string2 != null) {
            string = string + "-maximumSize " + string2;
        }
        if ((string2 = this.getValue("JmolAppletProxy", null)) != null) {
            string = string + "-appletProxy " + string2;
        }
        if (this.getBooleanValue("noScripting", false)) {
            string = string + "-noScripting ";
        }
        this.viewer = JmolViewer.allocateViewer(this.appletWrapper, null, this.fullName, this.appletWrapper.getDocumentBase(), this.appletWrapper.getCodeBase(), string, new MyStatusListener());
        String string3 = this.getParameter("menuFile");
        if (string3 != null) {
            this.viewer.getProperty("DATA_API", "setMenu", this.viewer.getFileAsString(string3));
        }
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (Throwable throwable) {
            System.err.println("Error loading L&F: " + throwable);
        }
        if (Logger.debugging) {
            Logger.debug("checking for jsoWindow mayScript=" + this.mayScript);
        }
        if (this.mayScript) {
            this.haveDocumentAccess = false;
            this.mayScript = false;
            JSObject jSObject = null;
            JSObject jSObject2 = null;
            try {
                jSObject = JSObject.getWindow((Applet)this.appletWrapper);
                if (Logger.debugging) {
                    Logger.debug("jsoWindow=" + jSObject);
                }
                if (jSObject == null) {
                    Logger.error("jsoWindow returned null ... no JavaScript callbacks :-(");
                } else {
                    this.mayScript = true;
                }
                jSObject2 = (JSObject)jSObject.getMember("document");
                if (jSObject2 == null) {
                    Logger.error("jsoDocument returned null ... no DOM manipulations :-(");
                } else {
                    this.haveDocumentAccess = true;
                }
            }
            catch (Exception exception) {
                Logger.error("Microsoft MSIE bug -- http://bugs.sun.com/bugdatabase/view_bug.do?bug_id=5012558 " + exception);
            }
            if (Logger.debugging) {
                Logger.debug("jsoWindow:" + jSObject + " jsoDocument:" + jSObject2 + " mayScript:" + this.mayScript + " haveDocumentAccess:" + this.haveDocumentAccess);
            }
        }
    }

    private void initApplication() {
        this.viewer.pushHoldRepaint();
        this.hasProgressBar = this.getBooleanValue("progressbar", false);
        String string = this.getValueLowerCase("emulate", "jmol");
        this.setStringProperty("defaults", string.equals("chime") ? "RasMol" : "Jmol");
        this.setStringProperty("backgroundColor", this.getValue("bgcolor", this.getValue("boxbgcolor", "black")));
        this.viewer.setBooleanProperty("frank", true);
        this.loading = true;
        for (EnumCallback enumCallback : EnumCallback.values()) {
            this.setValue(enumCallback.name() + "Callback", null);
        }
        this.loading = false;
        this.language = this.getParameter("language");
        if (this.language != null) {
            System.out.print("requested language=" + this.language + "; ");
            new GT(this.language);
        }
        this.doTranslate = !"none".equals(this.language) && this.getBooleanValue("doTranslate", true);
        this.language = GT.getLanguage();
        System.out.println("language=" + this.language);
        boolean bl = false;
        for (EnumCallback enumCallback : EnumCallback.values()) {
            if (this.callbacks.get((Object)enumCallback) == null) continue;
            bl = true;
            break;
        }
        if ((bl || this.statusForm != null || this.statusText != null) && !this.mayScript) {
            Logger.warn("MAYSCRIPT missing -- all applet JavaScript calls disabled");
        }
        if (this.callbacks.get((Object)EnumCallback.SCRIPT) == null && this.callbacks.get((Object)EnumCallback.ERROR) == null && (this.callbacks.get((Object)EnumCallback.MESSAGE) != null || this.statusForm != null || this.statusText != null)) {
            if (this.doTranslate && this.getValue("doTranslate", null) == null) {
                this.doTranslate = false;
                Logger.warn("Note -- Presence of message callback disables disable translation; to enable message translation use jmolSetTranslation(true) prior to jmolApplet()");
            }
            if (this.doTranslate) {
                Logger.warn("Note -- Automatic language translation may affect parsing of message callbacks messages; use scriptCallback or errorCallback to process errors");
            }
        }
        if (!this.doTranslate) {
            GT.setDoTranslate(false);
            Logger.warn("Note -- language translation disabled");
        }
        this.statusForm = this.getValue("StatusForm", null);
        this.statusText = this.getValue("StatusText", null);
        this.statusTextarea = this.getValue("StatusTextarea", null);
        if (this.statusForm != null && this.statusText != null) {
            Logger.info("applet text status will be reported to document." + this.statusForm + "." + this.statusText);
        }
        if (this.statusForm != null && this.statusTextarea != null) {
            Logger.info("applet textarea status will be reported to document." + this.statusForm + "." + this.statusTextarea);
        }
        if (!this.getBooleanValue("popupMenu", true)) {
            this.viewer.getProperty("DATA_API", "disablePopupMenu", null);
        }
        this.loadNodeId(this.getValue("loadNodeId", null));
        String string2 = this.getValue("script", "");
        String string3 = this.getValue("loadInline", null);
        if (string3 != null) {
            this.loadInlineSeparated(string3, string2.length() > 0 ? string2 : null);
        } else {
            String string4 = this.getValue("load", null);
            if (string4 != null) {
                string2 = "load \"" + string4 + "\";" + string2;
            }
            if (string2.length() > 0) {
                this.scriptProcessor(string2, null, 2);
            }
        }
        if (this.isSigned) {
            try {
                this.dropper = new JmolFileDropper(null, this.viewer);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.viewer.popHoldRepaint("applet init");
    }

    private void setLogging() {
        int n = this.getValue("logLevel", this.getBooleanValue("debug", false) ? "5" : "4").charAt(0) - 48;
        if (n != 4) {
            System.out.println("setting logLevel=" + n + " -- To change, use script \"set logLevel [0-5]\"");
        }
        Logger.setLogLevel(n);
    }

    private String getParameter(String string) {
        return this.appletWrapper.getParameter(string);
    }

    private boolean getBooleanValue(String string, boolean bl) {
        String string2 = this.getValue(string, bl ? "true" : "");
        return string2.equalsIgnoreCase("true") || string2.equalsIgnoreCase("on") || string2.equalsIgnoreCase("yes");
    }

    private String getValue(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 != null) {
            return string3;
        }
        return string2;
    }

    private String getValueLowerCase(String string, String string2) {
        String string3 = this.getValue(string, string2);
        if (string3 != null && (string3 = string3.trim().toLowerCase()).length() == 0) {
            string3 = null;
        }
        return string3;
    }

    private void setValue(String string, String string2) {
        this.setStringProperty(string, this.getValue(string, string2));
    }

    private void setStringProperty(String string, String string2) {
        if (string2 == null) {
            return;
        }
        Logger.info(string + " = \"" + string2 + "\"");
        this.viewer.setStringProperty(string, string2);
    }

    protected void sendJsTextStatus(String string) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusText == null) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.appletWrapper);
            JSObject jSObject2 = (JSObject)jSObject.getMember("document");
            JSObject jSObject3 = (JSObject)jSObject2.getMember(this.statusForm);
            if (this.statusText != null) {
                JSObject jSObject4 = (JSObject)jSObject3.getMember(this.statusText);
                jSObject4.setMember("value", string);
            }
        }
        catch (Exception exception) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusText + ":" + exception.toString());
        }
    }

    protected void sendJsTextareaStatus(String string) {
        if (!this.haveDocumentAccess || this.statusForm == null || this.statusTextarea == null) {
            return;
        }
        try {
            JSObject jSObject = JSObject.getWindow((Applet)this.appletWrapper);
            JSObject jSObject2 = (JSObject)jSObject.getMember("document");
            JSObject jSObject3 = (JSObject)jSObject2.getMember(this.statusForm);
            if (this.statusTextarea != null) {
                JSObject jSObject4 = (JSObject)jSObject3.getMember(this.statusTextarea);
                if (string == null) {
                    jSObject4.setMember("value", "");
                } else {
                    String string2 = (String)jSObject4.getMember("value");
                    jSObject4.setMember("value", string2 + "\n" + string);
                }
            }
        }
        catch (Exception exception) {
            Logger.error("error indicating status at document." + this.statusForm + "." + this.statusTextarea + ":" + exception.toString());
        }
    }

    private void update(Graphics graphics, String string) {
        if (this.viewer == null) {
            return;
        }
        if (this.isUpdating) {
            return;
        }
        this.isUpdating = true;
        if (this.showPaintTime) {
            this.startPaintClock();
        }
        Dimension dimension = new Dimension();
        this.appletWrapper.getSize(dimension);
        this.viewer.setScreenDimension(dimension.width, dimension.height);
        ++this.paintCounter;
        if (!this.isSigned && !this.hasProgressBar && this.paintCounter < 30 && (this.paintCounter & 1) == 0) {
            this.printProgressbarMessage(graphics);
            this.viewer.notifyViewerRepaintDone();
        } else if (!this.isStereoSlave) {
            this.viewer.renderScreenImageStereo(graphics, this.gRight, dimension.width, dimension.height);
        }
        if (this.showPaintTime) {
            this.stopPaintClock();
            this.showTimes(10, 10, graphics);
        }
        this.isUpdating = false;
    }

    private void printProgressbarMessage(Graphics graphics) {
        graphics.setColor(Color.yellow);
        graphics.fillRect(0, 0, 10000, 10000);
        graphics.setColor(Color.black);
        int n = 0;
        int n2 = 13;
        while (n < progressbarMsgs.length) {
            graphics.drawString(progressbarMsgs[n], 10, n2);
            ++n;
            n2 += 13;
        }
    }

    public boolean handleEvent(Event event) {
        if (this.viewer == null) {
            return false;
        }
        return this.viewer.handleOldJvm10Event(event.id, event.x, event.y, event.modifiers, event.when);
    }

    private void startPaintClock() {
        this.timeBegin = System.currentTimeMillis();
        int n = this.viewer.getMotionEventNumber();
        if (this.lastMotionEventNumber != n) {
            this.lastMotionEventNumber = n;
            this.timeTotal = 0;
            this.timeCount = 0;
            this.timeLast = -1;
        }
    }

    private void stopPaintClock() {
        int n = (int)(System.currentTimeMillis() - this.timeBegin);
        if (this.timeLast != -1) {
            this.timeTotal += this.timeLast;
            ++this.timeCount;
        }
        this.timeLast = n;
    }

    private String fmt(int n) {
        if (n < 0) {
            return "---";
        }
        if (n < 10) {
            return "  " + n;
        }
        if (n < 100) {
            return " " + n;
        }
        return "" + n;
    }

    private void showTimes(int n, int n2, Graphics graphics) {
        int n3 = this.timeCount == 0 ? -1 : (this.timeTotal + this.timeCount / 2) / this.timeCount;
        graphics.setColor(Color.green);
        graphics.drawString(this.fmt(this.timeLast) + "ms : " + this.fmt(n3) + "ms", n, n2);
    }

    private String scriptProcessor(String string, String string2, int n) {
        if (string == null || string.length() == 0) {
            return "";
        }
        switch (n) {
            case 0: {
                Object object = this.viewer.scriptCheck(string);
                return object instanceof String ? (String)object : "";
            }
            case 1: {
                if (string2 != null) {
                    return this.viewer.scriptWaitStatus(string, string2).toString();
                }
                return this.viewer.scriptWait(string);
            }
        }
        return this.viewer.script(string);
    }

    public void script(String string) {
        this.scriptNoWait(string);
    }

    public String scriptNoWait(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 2);
    }

    public String scriptCheck(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        return this.scriptProcessor(string, null, 0);
    }

    public String scriptWait(String string) {
        return this.scriptWait(string, null);
    }

    public String scriptWait(String string, String string2) {
        if (string == null || string.length() == 0) {
            return "";
        }
        this.outputBuffer = null;
        return this.scriptProcessor(string, string2, 1);
    }

    public String scriptWaitOutput(String string) {
        if (string == null || string.length() == 0) {
            return "";
        }
        this.outputBuffer = new StringBuilder();
        this.viewer.scriptWaitStatus(string, "");
        String string2 = this.outputBuffer == null ? "" : this.outputBuffer.toString();
        this.outputBuffer = null;
        return string2;
    }

    public synchronized void syncScript(String string) {
        this.viewer.syncScript(string, "~", 0);
    }

    public String getAppletInfo() {
        return GT._("Jmol Applet version {0} {1}.\n\nAn OpenScience project.\n\nSee http://www.jmol.org for more information", new Object[]{JC.version, JC.date}) + "\nhtmlName = " + Escape.eS(this.htmlName) + "\nsyncId = " + Escape.eS(this.syncId) + "\ndocumentBase = " + Escape.eS("" + this.appletWrapper.getDocumentBase()) + "\ncodeBase = " + Escape.eS("" + this.appletWrapper.getCodeBase());
    }

    public Object getProperty(String string) {
        return this.viewer.getProperty(null, string, "");
    }

    public Object getProperty(String string, String string2) {
        return this.viewer.getProperty(null, string, string2);
    }

    public String getPropertyAsString(String string) {
        return this.viewer.getProperty("readable", string, "").toString();
    }

    public String getPropertyAsString(String string, String string2) {
        return this.viewer.getProperty("readable", string, string2).toString();
    }

    public String getPropertyAsJSON(String string) {
        return this.viewer.getProperty("JSON", string, "").toString();
    }

    public String getPropertyAsJSON(String string, String string2) {
        return this.viewer.getProperty("JSON", string, string2).toString();
    }

    public String loadInlineString(String string, String string2, boolean bl) {
        String string3 = this.viewer.loadInline(string, bl);
        if (string3 == null) {
            this.script(string2);
        }
        return string3;
    }

    public String loadInlineArray(String[] stringArray, String string, boolean bl) {
        if (stringArray == null || stringArray.length == 0) {
            return null;
        }
        String string2 = this.viewer.loadInline(stringArray, bl);
        if (string2 == null) {
            this.script(string);
        }
        return string2;
    }

    @Deprecated
    public String loadInline(String string) {
        return this.loadInlineString(string, "", false);
    }

    @Deprecated
    public String loadInline(String string, String string2) {
        return this.loadInlineString(string, string2, false);
    }

    @Deprecated
    public String loadInline(String[] stringArray) {
        return this.loadInlineArray(stringArray, "", false);
    }

    @Deprecated
    public String loadInline(String[] stringArray, String string) {
        return this.loadInlineArray(stringArray, string, false);
    }

    private String loadInlineSeparated(String string, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = this.viewer.loadInline(string);
        if (string3 == null) {
            this.script(string2);
        }
        return string3;
    }

    public String loadDOMNode(JSObject jSObject) {
        return this.viewer.openDOM(jSObject);
    }

    public String loadNodeId(String string) {
        if (!this.haveDocumentAccess) {
            return "ERROR: NO DOCUMENT ACCESS";
        }
        if (string == null) {
            return null;
        }
        Object[] objectArray = new Object[]{string};
        JSObject jSObject = null;
        try {
            Object[] objectArray2;
            JSObject jSObject2;
            JSObject jSObject3 = JSObject.getWindow((Applet)this.appletWrapper);
            JSObject jSObject4 = (JSObject)jSObject3.getMember("document");
            jSObject = (JSObject)jSObject4.call("getElementById", objectArray);
            if (jSObject == null && (jSObject2 = (JSObject)jSObject4.call("getElementsByTagNameNS", objectArray2 = new Object[]{"http://www.xml-cml.org/schema/cml2/core", "cml"})) != null) {
                Object[] objectArray3;
                String string2;
                for (int i = 0; i < ((Number)jSObject2.getMember("length")).intValue() && !string.equals(string2 = (String)(jSObject = (JSObject)jSObject2.getSlot(i)).call("getAttribute", objectArray3 = new Object[]{"id"})); ++i) {
                    jSObject = null;
                }
            }
        }
        catch (Exception exception) {
            return "" + exception;
        }
        return jSObject == null ? "ERROR: No CML node" : this.loadDOMNode(jSObject);
    }

    protected static String sendCallback(JSObject jSObject, String string, Object[] objectArray) {
        if (string == null || string.length() == 0) {
            return "";
        }
        if (string.indexOf(".") > 0) {
            String[] stringArray = TextFormat.split(string, '.');
            for (int i = 0; i < stringArray.length - 1; ++i) {
                jSObject = (JSObject)jSObject.getMember(stringArray[i]);
            }
            string = stringArray[stringArray.length - 1];
        }
        return "" + jSObject.call(string, objectArray);
    }

    public void register(String string, JmolSyncInterface jmolSyncInterface) {
        JmolAppletRegistry.checkIn(string, jmolSyncInterface);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class MyStatusListener
    implements JmolStatusListener {
        private boolean haveNotifiedError;
        private Boolean allowJSEval;

        MyStatusListener() {
        }

        @Override
        public Map<String, Object> getRegistryInfo() {
            JmolAppletRegistry.checkIn(null, null);
            return JmolAppletRegistry.htRegistry;
        }

        @Override
        public org.jmol.util.Dimension resizeInnerPanel(String string) {
            return new org.jmol.util.Dimension().set(0, 0);
        }

        @Override
        public boolean notifyEnabled(EnumCallback enumCallback) {
            switch (enumCallback) {
                case ANIMFRAME: 
                case ECHO: 
                case ERROR: 
                case EVAL: 
                case LOADSTRUCT: 
                case MEASURE: 
                case MESSAGE: 
                case PICK: 
                case STRUCTUREMODIFIED: 
                case SYNC: 
                case SCRIPT: {
                    return true;
                }
            }
            return Jmol.this.callbacks.get((Object)enumCallback) != null;
        }

        @Override
        public void notifyCallback(EnumCallback enumCallback, Object[] objectArray) {
            Object object;
            String string = Jmol.this.callbacks.get((Object)enumCallback);
            boolean bl = string != null && (objectArray == null || objectArray[0] == null);
            boolean bl2 = false;
            if (objectArray != null) {
                objectArray[0] = Jmol.this.htmlName;
            }
            String string2 = objectArray == null || objectArray[1] == null ? null : objectArray[1].toString();
            switch (enumCallback) {
                case APPLETREADY: {
                    objectArray[3] = Jmol.this.appletWrapper;
                    break;
                }
                case ERROR: 
                case EVAL: 
                case HOVER: 
                case MINIMIZATION: 
                case RESIZE: {
                    break;
                }
                case CLICK: {
                    if (!"alert".equals(string)) break;
                    string2 = "x=" + objectArray[1] + " y=" + objectArray[2] + " action=" + objectArray[3] + " clickCount=" + objectArray[4];
                    break;
                }
                case ANIMFRAME: {
                    int n;
                    object = (int[])objectArray[1];
                    int n2 = object[0];
                    int n3 = object[1];
                    int n4 = object[2];
                    int n5 = object[3];
                    int n6 = object[4];
                    boolean bl3 = n2 <= -2;
                    int n7 = n5 < 0 ? -1 : 1;
                    int n8 = n = n6 < 0 ? -1 : 1;
                    if (!bl) break;
                    objectArray = new Object[]{Jmol.this.htmlName, Math.max(n2, -2 - n2), n3, n4, Math.abs(n5), Math.abs(n6), bl3 ? 1 : 0, n7, n};
                    break;
                }
                case ECHO: {
                    boolean bl4;
                    boolean bl5 = objectArray.length == 2;
                    boolean bl6 = bl4 = bl5 || (Integer)objectArray[2] == 1;
                    if (!bl) {
                        if (bl4) {
                            bl2 = true;
                        }
                        boolean bl7 = bl = !bl5 && (string = Jmol.this.callbacks.get((Object)(enumCallback = EnumCallback.MESSAGE))) != null;
                    }
                    if (bl2) break;
                    this.output(string2);
                    break;
                }
                case LOADSTRUCT: {
                    String string3 = (String)objectArray[4];
                    if (string3 == null) break;
                    string3 = (string3.indexOf("NOTE:") >= 0 ? "" : GT._("File Error:")) + string3;
                    this.showStatus(string3);
                    this.notifyCallback(EnumCallback.MESSAGE, new Object[]{"", string3});
                    return;
                }
                case MEASURE: {
                    String string4;
                    if (!bl) {
                        enumCallback = EnumCallback.MESSAGE;
                        string = Jmol.this.callbacks.get((Object)enumCallback);
                        boolean bl8 = bl = string != null;
                    }
                    if ((string4 = (String)objectArray[3]).indexOf("Picked") >= 0 || string4.indexOf("Sequence") >= 0) {
                        this.showStatus(string2);
                        bl2 = true;
                        break;
                    }
                    if (string4.indexOf("Completed") < 0) break;
                    string2 = string4 + ": " + string2;
                    bl2 = true;
                    break;
                }
                case MESSAGE: {
                    bl2 = !bl;
                    bl &= string2 != null;
                    if (bl2) break;
                    this.output(string2);
                    break;
                }
                case PICK: {
                    this.showStatus(string2);
                    bl2 = true;
                    break;
                }
                case SCRIPT: {
                    int n = (Integer)objectArray[3];
                    if (n > 0) {
                        this.notifyScriptTermination();
                    } else if (!bl) {
                        enumCallback = EnumCallback.MESSAGE;
                        string = Jmol.this.callbacks.get((Object)enumCallback);
                        bl = string != null;
                    }
                    this.output(string2);
                    this.showStatus(string2);
                    break;
                }
                case STRUCTUREMODIFIED: {
                    this.notifyStructureModified((Integer)objectArray[1], (Integer)objectArray[2]);
                    break;
                }
                case SYNC: {
                    this.sendScript(string2, (String)objectArray[2], true, bl);
                    return;
                }
            }
            if (bl2 && (object = (Object)((JmolCallbackListener)Jmol.this.viewer.getProperty("DATA_API", "getAppConsole", null))) != null) {
                object.notifyCallback(enumCallback, objectArray);
                this.output(string2);
                Jmol.this.sendJsTextareaStatus(string2);
            }
            if (!bl || !Jmol.this.mayScript) {
                return;
            }
            try {
                object = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (string.equals("alert")) {
                    ((JSObject)object).call(string, string2);
                } else {
                    Jmol.sendCallback((JSObject)object, string, objectArray);
                }
            }
            catch (Exception exception) {
                if (!this.haveNotifiedError && Logger.debugging) {
                    Logger.debug(enumCallback.name() + "Callback call error to " + string + ": " + exception);
                }
                this.haveNotifiedError = true;
            }
        }

        private void notifyStructureModified(int n, int n2) {
        }

        private void output(String string) {
            if (Jmol.this.outputBuffer != null && string != null) {
                Jmol.this.outputBuffer.append(string).append('\n');
            }
        }

        private void notifyScriptTermination() {
        }

        private String notifySync(String string, String string2) {
            String string3 = Jmol.this.callbacks.get((Object)EnumCallback.SYNC);
            if (!Jmol.this.mayScript || string3 == null) {
                return string;
            }
            try {
                JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                return Jmol.sendCallback(jSObject, string3, new Object[]{Jmol.this.htmlName, string, string2});
            }
            catch (Exception exception) {
                if (!this.haveNotifiedError && Logger.debugging) {
                    Logger.debug("syncCallback call error to " + string3 + ": " + exception);
                }
                this.haveNotifiedError = true;
                return string;
            }
        }

        @Override
        public void setCallbackFunction(String string, String string2) {
            if (string.equalsIgnoreCase("modelkit")) {
                return;
            }
            if (string.equalsIgnoreCase("language")) {
                this.consoleMessage("");
                this.consoleMessage(null);
                return;
            }
            EnumCallback enumCallback = EnumCallback.getCallback(string);
            if (enumCallback != null && (Jmol.this.loading || enumCallback != EnumCallback.EVAL)) {
                if (string2 == null) {
                    Jmol.this.callbacks.remove((Object)enumCallback);
                } else {
                    Jmol.this.callbacks.put(enumCallback, string2);
                }
                return;
            }
            this.consoleMessage("Available callbacks include: " + EnumCallback.getNameList().replace(';', ' ').trim());
        }

        @Override
        public String eval(String string) {
            int n = string.indexOf("\u0001");
            if (n >= 0) {
                return this.sendScript(string.substring(n + 1), string.substring(0, n), false, false);
            }
            if (!Jmol.this.haveDocumentAccess) {
                return "NO EVAL ALLOWED";
            }
            JSObject jSObject = null;
            JSObject jSObject2 = null;
            try {
                jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                jSObject2 = (JSObject)jSObject.getMember("document");
            }
            catch (Exception exception) {
                if (Logger.debugging) {
                    Logger.debug(" error setting jsoWindow or jsoDocument:" + jSObject + ", " + jSObject2);
                }
                return "NO EVAL ALLOWED";
            }
            if (Jmol.this.callbacks.get((Object)EnumCallback.EVAL) != null) {
                this.notifyCallback(EnumCallback.EVAL, new Object[]{null, string});
                return "";
            }
            if (this.allowJSEval == null) {
                try {
                    if (((Boolean)jSObject2.eval("!!Jmol._noEval")).booleanValue()) {
                        this.allowJSEval = Boolean.FALSE;
                    }
                }
                catch (Exception exception) {
                    try {
                        if (((Boolean)jSObject2.eval("!!_jmol.noEval")).booleanValue()) {
                            this.allowJSEval = Boolean.FALSE;
                        }
                    }
                    catch (Exception exception2) {
                        this.allowJSEval = Boolean.FALSE;
                        Logger.error("# no Jmol or _jmol object in evaluating " + string + ":" + exception.toString());
                        return "";
                    }
                }
                this.allowJSEval = Boolean.TRUE;
            }
            if (this.allowJSEval == Boolean.FALSE) {
                return "NO EVAL ALLOWED";
            }
            try {
                return "" + jSObject2.eval(string);
            }
            catch (Exception exception) {
                Logger.error("# error evaluating " + string + ":" + exception.toString());
                return "";
            }
        }

        @Override
        public String createImage(String string, String string2, Object object, int n) {
            return null;
        }

        @Override
        public float[][] functionXY(String string, int n, int n2) {
            float[][] fArray = new float[Math.abs(n)][Math.abs(n2)];
            if (!Jmol.this.mayScript || n == 0 || n2 == 0) {
                return fArray;
            }
            try {
                JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                if (n > 0 && n2 > 0) {
                    for (int i = 0; i < n; ++i) {
                        for (int j = 0; j < n2; ++j) {
                            fArray[i][j] = ((Double)jSObject.call(string, Jmol.this.htmlName, i, j)).floatValue();
                        }
                    }
                } else if (n2 > 0) {
                    String string2 = (String)jSObject.call(string, Jmol.this.htmlName, n, n2);
                    n = Math.abs(n);
                    float[] fArray2 = new float[n * n2];
                    Parser.parseStringInfestedFloatArray(string2, null, fArray2);
                    int n3 = 0;
                    for (int i = 0; i < n; ++i) {
                        int n4 = 0;
                        while (n4 < n2) {
                            fArray[i][n4] = fArray2[n3];
                            ++n4;
                            ++n3;
                        }
                    }
                } else {
                    jSObject.call(string, new Object[]{Jmol.this.htmlName, n, n2, fArray});
                }
            }
            catch (Exception exception) {
                Logger.error("Exception " + exception.getMessage() + " with nX, nY: " + n + " " + n2);
            }
            return fArray;
        }

        @Override
        public float[][][] functionXYZ(String string, int n, int n2, int n3) {
            float[][][] fArray = new float[Math.abs(n)][Math.abs(n2)][Math.abs(n3)];
            if (!Jmol.this.mayScript || n == 0 || n2 == 0 || n3 == 0) {
                return fArray;
            }
            try {
                JSObject jSObject = JSObject.getWindow((Applet)Jmol.this.appletWrapper);
                jSObject.call(string, new Object[]{Jmol.this.htmlName, n, n2, n3, fArray});
            }
            catch (Exception exception) {
                Logger.error("Exception " + exception.getMessage() + " for " + string + " with nX, nY, nZ: " + n + " " + n2 + " " + n3);
            }
            return fArray;
        }

        @Override
        public void showUrl(String string) {
            if (Logger.debugging) {
                Logger.debug("showUrl(" + string + ")");
            }
            if (string != null && string.length() > 0) {
                try {
                    URL uRL = new URL(string);
                    Jmol.this.appletWrapper.getAppletContext().showDocument(uRL, "_blank");
                }
                catch (MalformedURLException malformedURLException) {
                    this.consoleMessage("Malformed URL:" + string);
                }
            }
        }

        protected void finalize() throws Throwable {
            if (Logger.debugging) {
                Logger.debug("MyStatusListener finalize " + this);
            }
            super.finalize();
        }

        private void showStatus(String string) {
            try {
                System.out.println(string);
                Jmol.this.appletWrapper.showStatus(TextFormat.simpleReplace(TextFormat.splitChars(string, "\n")[0], "'", "\\'"));
                Jmol.this.sendJsTextStatus(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        private void consoleMessage(String string) {
            this.notifyCallback(EnumCallback.ECHO, new Object[]{"", string});
        }

        private String sendScript(String string, String string2, boolean bl, boolean bl2) {
            boolean bl3;
            if (bl2 && ((string = this.notifySync(string, string2)) == null || string.length() == 0 || string.equals("0"))) {
                return "";
            }
            JmolList<String> jmolList = new JmolList<String>();
            JmolAppletRegistry.findApplets(string2, Jmol.this.syncId, Jmol.this.fullName, jmolList);
            int n = jmolList.size();
            if (n == 0) {
                if (!bl2 && !string2.equals("*")) {
                    Logger.error(Jmol.this.fullName + " couldn't find applet " + string2);
                }
                return "";
            }
            StringBuilder stringBuilder = bl ? null : new StringBuilder();
            boolean bl4 = bl && string.equals("GET_GRAPHICS");
            boolean bl5 = bl3 = bl && string.equals("SET_GRAPHICS_OFF");
            if (bl4) {
                Jmol.this.gRight = null;
            }
            for (int i = 0; i < n; ++i) {
                String string3 = (String)jmolList.get(i);
                JmolSyncInterface jmolSyncInterface = (JmolSyncInterface)JmolAppletRegistry.htRegistry.get(string3);
                boolean bl6 = jmolSyncInterface instanceof JmolScriptInterface;
                if (Logger.debugging) {
                    Logger.debug(Jmol.this.fullName + " sending to " + string3 + ": " + string);
                }
                try {
                    if (bl6 && (bl4 || bl3)) {
                        Jmol.this.gRight = ((JmolScriptInterface)jmolSyncInterface).setStereoGraphics(bl4);
                        return "";
                    }
                    if (bl) {
                        jmolSyncInterface.syncScript(string);
                        continue;
                    }
                    if (!bl6) continue;
                    stringBuilder.append(((JmolScriptInterface)jmolSyncInterface).scriptWait(string, "output")).append("\n");
                    continue;
                }
                catch (Exception exception) {
                    String string4 = Jmol.this.htmlName + " couldn't send to " + string3 + ": " + string + ": " + exception;
                    Logger.error(string4);
                    if (bl) continue;
                    stringBuilder.append(string4);
                }
            }
            return bl ? "" : stringBuilder.toString();
        }

        @Override
        public Map<String, Object> getProperty(String string) {
            return null;
        }
    }
}

