/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xtal;

import java.io.BufferedReader;
import java.util.Hashtable;
import org.jmol.adapter.readers.cif.ModulationReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.io.JmolBinary;
import org.jmol.util.BS;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Matrix4f;
import org.jmol.util.P3;
import org.jmol.util.TextFormat;

public class JanaReader
extends ModulationReader {
    private JmolList<float[]> lattvecs;
    private int thisSub;
    static final String records = "tit  cell ndim qi   lat  sym  spg  end  wma";
    static final int TITLE = 0;
    static final int CELL = 5;
    static final int NDIM = 10;
    static final int QI = 15;
    static final int LATT = 20;
    static final int SYM = 25;
    static final int SPG = 30;
    static final int END = 35;
    static final int WMATRIX = 40;
    private int qicount;
    private final String LABELS = "xyz";
    private float[] floats = new float[6];

    public void initializeReader() throws Exception {
        this.setFractionalCoordinates(true);
        this.initializeModulation();
        this.atomSetCollection.newAtomSet();
    }

    protected boolean checkLine() throws Exception {
        if (this.line.length() < 3) {
            return true;
        }
        Logger.info(this.line);
        this.parseTokenStr(this.line);
        switch (records.indexOf(this.line.substring(0, 3))) {
            case 0: {
                this.atomSetCollection.setAtomSetName(this.line.substring(5).trim());
                break;
            }
            case 5: {
                this.cell();
                this.setSymmetryOperator("x,y,z");
                break;
            }
            case 10: {
                this.ndim();
                break;
            }
            case 20: {
                this.lattvec(this.line.substring(8));
                break;
            }
            case 30: {
                this.setSpaceGroupName(this.getTokens()[1]);
                break;
            }
            case 25: {
                this.symmetry();
                break;
            }
            case 15: {
                if (this.modAverage) break;
                this.qi();
                break;
            }
            case 35: {
                this.continuing = false;
                break;
            }
            case 40: {
                Matrix4f matrix4f = new Matrix4f();
                if (this.thisSub++ == 0) {
                    matrix4f.setIdentity();
                    this.addSubsystem("1", matrix4f, null);
                    ++this.thisSub;
                    matrix4f = new Matrix4f();
                }
                float[] fArray = new float[16];
                this.fillFloatArray(null, 0, fArray);
                matrix4f.setA(fArray, 0);
                this.addSubsystem("" + this.thisSub, matrix4f, null);
            }
        }
        return true;
    }

    public void finalizeReader() throws Exception {
        this.readM40Data();
        if (this.lattvecs != null) {
            this.atomSetCollection.getSymmetry().addLatticeVectors(this.lattvecs);
        }
        this.applySymmetryAndSetTrajectory();
        this.adjustM40Occupancies();
        this.setModulation();
        this.finalizeModulation();
        this.finalizeReaderASCR();
    }

    private void cell() throws Exception {
        for (int i = 0; i < 6; ++i) {
            this.setUnitCellItem(i, this.parseFloat());
        }
    }

    private void ndim() {
        this.setModDim(this.parseIntStr(this.getTokens()[1]) - 3);
    }

    private void qi() {
        P3 p3 = P3.new3(this.parseFloat(), this.parseFloat(), this.parseFloat());
        this.addModulation(null, "W_" + ++this.qicount, p3, -1);
        p3 = new P3();
        switch (this.qicount) {
            case 1: {
                p3.x = 1.0f;
                break;
            }
            case 2: {
                p3.y = 1.0f;
                break;
            }
            case 3: {
                p3.z = 1.0f;
            }
        }
        this.addModulation(null, "F_" + this.qicount + "_q_", p3, -1);
    }

    private void lattvec(String string) throws Exception {
        float[] fArray;
        char c = string.charAt(0);
        switch (c) {
            case 'P': 
            case 'X': {
                return;
            }
            case 'A': 
            case 'B': 
            case 'C': 
            case 'I': {
                fArray = new float[]{0.5f, 0.5f, 0.5f};
                if (c == 'I') break;
                fArray[c - 65] = 0.0f;
                break;
            }
            case 'F': {
                this.lattvec("A");
                this.lattvec("B");
                this.lattvec("C");
                return;
            }
            case '0': {
                if (string.indexOf(".") < 0) {
                    return;
                }
                fArray = JanaReader.getTokensFloat(string, null, this.modDim + 3);
                break;
            }
            default: {
                this.appendLoadNote(this.line + " not supported");
                return;
            }
        }
        if (this.lattvecs == null) {
            this.lattvecs = new JmolList();
        }
        this.lattvecs.addLast(fArray);
    }

    private void symmetry() throws Exception {
        this.setSymmetryOperator(TextFormat.simpleReplace(this.line.substring(9).trim(), " ", ","));
    }

    private void readM40Data() throws Exception {
        BS bS;
        String string = this.filePath;
        int n = string.lastIndexOf(".");
        if (n < 0) {
            return;
        }
        string = string.substring(0, n + 2) + "40";
        String string2 = string.substring(0, n);
        n = string2.lastIndexOf("/");
        BufferedReader bufferedReader = JmolBinary.getBufferedReaderForString((String)this.viewer.getLigandModel(string2 = string2.substring(n + 1), string, "_file", "----"));
        if (this.readM40Floats(bufferedReader).startsWith("command")) {
            this.readM40WaveVectors(bufferedReader);
        }
        int n2 = (bS = this.getSubSystemList()) == null ? 0 : 1;
        int n3 = -1;
        while (this.readM40Floats(bufferedReader) != null) {
            int n4;
            int n5;
            float f;
            int n6;
            while (this.line != null && (this.line.length() == 0 || this.line.charAt(0) == ' ' || this.line.charAt(0) == '-')) {
                this.readM40Floats(bufferedReader);
            }
            if (this.line == null) break;
            ++n3;
            Atom atom = new Atom();
            atom.atomName = this.line.substring(0, 9).trim();
            Logger.info(this.line);
            if (!this.filterAtom(atom, 0)) continue;
            if (n2 > 0) {
                if (bS.get(n3)) {
                    ++n2;
                }
                this.addSubsystem("" + n2, null, atom.atomName);
            }
            float f2 = atom.foccupancy = this.floats[2];
            this.setAtomCoordXYZ(atom, this.floats[3], this.floats[4], this.floats[5]);
            this.atomSetCollection.addAtom(atom);
            if (!this.incommensurate) continue;
            String string3 = ";" + atom.atomName;
            boolean bl = this.getInt(60, 61) > 0;
            boolean bl2 = this.getInt(61, 62) > 0;
            boolean bl3 = this.getInt(62, 63) > 0;
            int n7 = this.getInt(65, 68);
            int n8 = this.getInt(68, 71);
            int n9 = this.getInt(71, 74);
            this.readM40Floats(bufferedReader);
            boolean bl4 = true;
            for (n6 = 1; n6 < 6; ++n6) {
                if (this.floats[n6] == 0.0f) continue;
                bl4 = false;
                break;
            }
            if (bl4) {
                if (this.floats[0] != 0.0f) {
                    this.setU(atom, 7, this.floats[0]);
                }
            } else {
                for (n6 = 0; n6 < 6; ++n6) {
                    this.setU(atom, n6, this.floats[n6]);
                }
            }
            float f3 = f = n7 > 0 && !bl ? this.parseFloatStr(bufferedReader.readLine()) : 1.0f;
            if (f != 1.0f) {
                this.addModulation(null, "J_O#0;" + atom.atomName, P3.new3(f2, f, 0.0f), -1);
            }
            atom.foccupancy = f * f2;
            int n10 = 0;
            for (n5 = 0; n5 < n7; ++n5) {
                float f4;
                float f5;
                if (bl) {
                    float[][] fArray = this.readM40FloatLines(2, 1, bufferedReader);
                    f5 = fArray[0][0];
                    f4 = fArray[1][0];
                } else {
                    n10 = n5 + 1;
                    this.readM40Floats(bufferedReader);
                    f5 = this.floats[0];
                    f4 = this.floats[1];
                }
                string2 = "O_" + n10 + "#0" + string3;
                P3 p3 = P3.new3(f4, f5, 0.0f);
                if (f4 == 0.0f && f5 == 0.0f) continue;
                this.addModulation(null, string2, p3, -1);
            }
            for (n5 = 0; n5 < n8; ++n5) {
                if (bl2) {
                    this.readM40Floats(bufferedReader);
                    float f6 = this.floats[3];
                    float f7 = this.floats[4];
                    for (n4 = 0; n4 < 3; ++n4) {
                        if (this.floats[n4] == 0.0f) continue;
                        this.addModulation(null, "D_S#" + "xyz".charAt(n4) + string3, P3.new3(f6, f7, this.floats[n4]), -1);
                    }
                    continue;
                }
                this.addSinCos(n5, "D_", string3, bufferedReader);
            }
            for (n5 = 0; n5 < n9; ++n5) {
                this.checkFourier(n5);
                if (bl4) {
                    this.addSinCos(n5, "U_", string3, bufferedReader);
                    continue;
                }
                if (bl3) {
                    Logger.error("JanaReader -- not interpreting SpecialUij flag: " + this.line);
                    continue;
                }
                float[][] fArray = this.readM40FloatLines(2, 6, bufferedReader);
                int n11 = 0;
                n4 = 0;
                while (n11 < 6) {
                    this.addModulation(null, "U_" + (n5 + 1) + "#" + "U11U22U33U12U13U23OTPUISO".substring(n4, n4 + 3) + string3, P3.new3(fArray[1][n11], fArray[0][n11], 0.0f), -1);
                    ++n11;
                    n4 += 3;
                }
            }
        }
        bufferedReader.close();
    }

    private BS getSubSystemList() {
        int n;
        if (this.htSubsystems == null) {
            return null;
        }
        BS bS = new BS();
        String[] stringArray = this.getTokens();
        int n2 = 0;
        for (int i = 0; i < stringArray.length && (n = this.parseIntStr(stringArray[i])) != 0; i += 2) {
            bS.set(n2 += n);
        }
        return bS;
    }

    private void readM40WaveVectors(BufferedReader bufferedReader) throws Exception {
        while (!this.readM40Floats(bufferedReader).contains("end")) {
            if (!this.line.startsWith("wave")) continue;
            String[] stringArray = this.getTokens();
            P3 p3 = new P3();
            switch (this.modDim) {
                case 3: {
                    p3.z = this.parseFloatStr(stringArray[4]);
                }
                case 2: {
                    p3.y = this.parseFloatStr(stringArray[3]);
                }
                case 1: {
                    p3.x = this.parseFloatStr(stringArray[2]);
                }
            }
            this.addModulation(null, "F_" + this.parseIntStr(stringArray[1]) + "_q_", p3, -1);
        }
        this.readM40Floats(bufferedReader);
    }

    private void addSinCos(int n, String string, String string2, BufferedReader bufferedReader) throws Exception {
        this.checkFourier(n);
        this.readM40Floats(bufferedReader);
        for (int i = 0; i < 3; ++i) {
            float f = this.floats[i + 3];
            float f2 = this.floats[i];
            if (f2 == 0.0f && f == 0.0f) continue;
            String string3 = "" + "xyz".charAt(i % 3);
            if (this.modAxes != null && this.modAxes.indexOf(string3.toUpperCase()) < 0) continue;
            String string4 = string + (n + 1) + "#" + string3 + string2;
            P3 p3 = P3.new3(f, f2, 0.0f);
            this.addModulation(null, string4, p3, -1);
        }
    }

    private void checkFourier(int n) {
        P3 p3;
        if (n > 0 && this.getModulationVector("F_" + (n + 1) + "_q_") == null && (p3 = this.getModulationVector("F_1_q_")) != null) {
            p3 = P3.newP(p3);
            p3.scale(n + 1);
            this.addModulation(null, "F_" + (n + 1) + "_q_", p3, -1);
        }
    }

    private int getInt(int n, int n2) {
        int n3 = this.line.length();
        return n3 > n ? this.parseIntStr(this.line.substring(n, Math.min(n3, n2))) : 0;
    }

    private String readM40Floats(BufferedReader bufferedReader) throws Exception {
        this.line = bufferedReader.readLine();
        if (this.line == null || this.line.indexOf("-------") >= 0) {
            this.line = null;
            return null;
        }
        if (Logger.debugging) {
            Logger.debug(this.line);
        }
        int n = this.line.length() - 10;
        int n2 = 0;
        for (int i = 0; n2 < 6 && i <= n; ++n2, i += 9) {
            this.floats[n2] = this.parseFloatStr(this.line.substring(i, i + 9));
        }
        return this.line;
    }

    private float[][] readM40FloatLines(int n, int n2, BufferedReader bufferedReader) throws Exception {
        float[][] fArray = new float[n][n2];
        for (int i = 0; i < n; ++i) {
            this.readM40Floats(bufferedReader);
            for (int j = 0; j < n2; ++j) {
                fArray[i][j] = this.floats[j];
            }
        }
        return fArray;
    }

    private void adjustM40Occupancies() {
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getAtomCount();
        while (--n >= 0) {
            Atom atom = atomArray[n];
            Integer n2 = (Integer)hashtable.get(atom.atomName);
            if (n2 == null) {
                n2 = this.atomSetCollection.getSymmetry().getSiteMultiplicity(atom);
                hashtable.put(atom.atomName, n2);
            }
            atom.foccupancy *= (float)n2.intValue();
        }
    }
}

