/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.xml;

import org.jmol.adapter.readers.xml.XmlReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.util.P3;

public class XmlOdysseyReader
extends XmlReader {
    private String modelName = null;
    private String formula = null;
    private String phase = null;
    private String[] myAttributes = new String[]{"id", "label", "xyz", "element", "hybrid", "a", "b", "order", "box"};

    XmlOdysseyReader() {
    }

    protected String[] getDOMAttributes() {
        return this.myAttributes;
    }

    protected void processStartElement(String string) {
        if ("structure".equals(string)) {
            this.atomSetCollection.newAtomSet();
            return;
        }
        if ("atom".equals(string)) {
            this.atom = new Atom();
            this.atom.atomName = this.atts.containsKey("label") ? (String)this.atts.get("label") : (String)this.atts.get("id");
            if (this.atts.containsKey("xyz")) {
                String string2 = (String)this.atts.get("xyz");
                String[] stringArray = XmlOdysseyReader.getTokensStr(string2);
                this.atom.set(this.parseFloatStr(stringArray[0]), this.parseFloatStr(stringArray[1]), this.parseFloatStr(stringArray[2]));
            }
            if (this.atts.containsKey("element")) {
                this.atom.elementSymbol = (String)this.atts.get("element");
            }
            return;
        }
        if ("bond".equals(string)) {
            String string3 = (String)this.atts.get("a");
            String string4 = (String)this.atts.get("b");
            int n = 1;
            if (this.atts.containsKey("order")) {
                n = this.parseBondToken((String)this.atts.get("order"));
            }
            this.atomSetCollection.addNewBondFromNames(string3, string4, n);
            return;
        }
        if ("boundary".equals(string)) {
            String[] stringArray = XmlOdysseyReader.getTokensStr((String)this.atts.get("box"));
            float f = this.parseFloatStr(stringArray[0]);
            float f2 = this.parseFloatStr(stringArray[1]);
            float f3 = this.parseFloatStr(stringArray[2]);
            this.parent.setUnitCellItem(0, f);
            this.parent.setUnitCellItem(1, f2);
            this.parent.setUnitCellItem(2, f3);
            this.parent.setUnitCellItem(3, 90.0f);
            this.parent.setUnitCellItem(4, 90.0f);
            this.parent.setUnitCellItem(5, 90.0f);
            P3 p3 = P3.new3(-f / 2.0f, -f2 / 2.0f, -f3 / 2.0f);
            this.atomSetCollection.setAtomSetAuxiliaryInfo("periodicOriginXyz", p3);
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            int n = this.atomSetCollection.getAtomCount();
            while (--n >= 0) {
                atomArray[n].sub(p3);
                this.parent.setAtomCoord(atomArray[n]);
            }
            if (this.parent.latticeCells[0] == 0) {
                this.parent.latticeCells[2] = 1;
                this.parent.latticeCells[1] = 1;
                this.parent.latticeCells[0] = 1;
            }
            this.parent.setSymmetryOperator("x,y,z");
            this.parent.setSpaceGroupName("P1");
            this.parent.applySymmetryAndSetTrajectory();
            return;
        }
        if ("odyssey_simulation".equals(string)) {
            if (this.modelName != null && this.phase != null) {
                this.modelName = this.modelName + " - " + this.phase;
            }
            if (this.modelName != null) {
                this.atomSetCollection.setAtomSetName(this.modelName);
            }
            if (this.formula != null) {
                this.atomSetCollection.setAtomSetAuxiliaryInfo("formula", this.formula);
            }
        }
        if ("title".equals(string) || "formula".equals(string) || "phase".equals(string)) {
            this.keepChars = true;
        }
    }

    private int parseBondToken(String string) {
        if (string.length() >= 1) {
            switch (string.charAt(0)) {
                case 's': {
                    return 1;
                }
                case 'd': {
                    return 2;
                }
                case 't': {
                    return 3;
                }
                case 'a': {
                    return 515;
                }
            }
            return this.parseIntStr(string);
        }
        return 1;
    }

    void processEndElement(String string) {
        if ("atom".equals(string)) {
            if (this.atom.elementSymbol != null && !Float.isNaN(this.atom.z)) {
                this.atomSetCollection.addAtomWithMappedName(this.atom);
            }
            this.atom = null;
            return;
        }
        if ("title".equals(string)) {
            this.modelName = this.chars;
        }
        if ("formula".equals(string)) {
            this.formula = this.chars;
        }
        if ("phase".equals(string)) {
            this.phase = this.chars;
        }
        this.keepChars = false;
        this.chars = null;
    }
}

