/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.quantum;

import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.readers.quantum.BasisFunctionReader;
import org.jmol.adapter.readers.quantum.MopacSlaterReader;
import org.jmol.adapter.smarter.Atom;
import org.jmol.api.JmolAdapter;
import org.jmol.util.ArrayUtil;
import org.jmol.util.BS;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Parser;

public class MoldenReader
extends MopacSlaterReader {
    private boolean loadGeometries;
    private boolean loadVibrations;
    private boolean vibOnly;
    private boolean optOnly;
    private boolean doSort = true;
    private String orbitalType = "";
    private int modelAtomCount;
    private BS bsAtomOK = new BS();
    private BS bsBadIndex = new BS();
    private int[] nSPDF;
    private boolean haveEnergy = true;

    protected void initializeReader() {
        this.vibOnly = this.checkFilterKey("VIBONLY");
        this.optOnly = this.checkFilterKey("OPTONLY");
        this.doSort = !this.checkFilterKey("NOSORT");
        this.loadGeometries = !this.vibOnly && this.desiredVibrationNumber < 0 && !this.checkFilterKey("NOOPT");
        boolean bl = this.loadVibrations = !this.optOnly && this.desiredModelNumber < 0 && !this.checkFilterKey("NOVIB");
        this.filter = this.checkFilterKey("ALPHA") ? "alpha" : (this.checkFilterKey("BETA") ? "beta" : this.getFilter("SYM="));
    }

    protected boolean checkLine() throws Exception {
        if (!this.line.contains("[")) {
            return true;
        }
        this.line = this.line.toUpperCase().trim();
        if (!this.line.startsWith("[")) {
            return true;
        }
        Logger.info(this.line);
        if (this.line.indexOf("[ATOMS]") == 0) {
            this.readAtoms();
            this.modelAtomCount = this.atomSetCollection.getFirstAtomSetAtomCount();
            if (this.atomSetCollection.getAtomSetCount() == 1 && this.moData != null) {
                this.finalizeMOData(this.moData);
            }
            return false;
        }
        if (this.line.indexOf("[GTO]") == 0) {
            return this.readGaussianBasis();
        }
        if (this.line.indexOf("[MO]") == 0) {
            return !this.doReadMolecularOrbitals || this.readMolecularOrbitals();
        }
        if (this.line.indexOf("[FREQ]") == 0) {
            return !this.loadVibrations || this.readFreqsAndModes();
        }
        if (this.line.indexOf("[GEOCONV]") == 0) {
            return !this.loadGeometries || this.readGeometryOptimization();
        }
        this.checkOrbitalType(this.line);
        return true;
    }

    public void finalizeReader() {
        if (this.bsBadIndex.isEmpty()) {
            return;
        }
        try {
            short s = 0;
            Atom[] atomArray = this.atomSetCollection.getAtoms();
            int n = this.atomSetCollection.getAtomCount();
            this.bsAtomOK.set(n);
            int n2 = this.shells.size();
            block2: for (int i = 0; i < n2; ++i) {
                int n3 = ((int[])this.shells.get(i))[0];
                if (n3 != Integer.MAX_VALUE) {
                    s = atomArray[n3].elementNumber;
                    continue;
                }
                int n4 = this.bsAtomOK.nextClearBit(0);
                while (n4 >= 0) {
                    if (atomArray[n4].elementNumber == s) {
                        ((int[])this.shells.get((int)i))[0] = n4;
                        Logger.info("MoldenReader assigning shells starting with " + i + " for ** to atom " + (n4 + 1) + " z " + s);
                        while (++i < n2 && !this.bsBadIndex.get(i) && ((int[])this.shells.get(i))[0] == Integer.MAX_VALUE) {
                            ((int[])this.shells.get((int)i))[0] = n4;
                        }
                        --i;
                        this.bsAtomOK.set(n4);
                        continue block2;
                    }
                    n4 = this.bsAtomOK.nextClearBit(n4 + 1);
                }
            }
        }
        catch (Exception exception) {
            Logger.error("Molden reader could not assign shells -- abandoning MOs");
            this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", null);
        }
    }

    private void readAtoms() throws Exception {
        float f;
        boolean bl;
        String string = MoldenReader.getTokensStr(this.line.replace(']', ' '))[1];
        int n = 0;
        int n2 = 0;
        boolean bl2 = bl = string.indexOf("ANGS") < 0;
        if (bl && string.indexOf("AU") < 0) {
            throw new Exception("invalid coordinate unit " + string + " in [Atoms]");
        }
        float f2 = f = bl ? 0.5291772f : 1.0f;
        while (this.readLine() != null && this.line.indexOf(91) < 0) {
            String[] stringArray = this.getTokens();
            if (stringArray.length < 6) continue;
            Atom atom = this.atomSetCollection.addNewAtom();
            atom.atomName = stringArray[0];
            n2 = this.parseIntStr(stringArray[1]);
            if (n > 0 && n2 != n + 1) {
                throw new Exception("out of order atom in [Atoms]");
            }
            n = n2;
            atom.elementNumber = (short)this.parseIntStr(stringArray[2]);
            this.setAtomCoordXYZ(atom, this.parseFloatStr(stringArray[3]) * f, this.parseFloatStr(stringArray[4]) * f, this.parseFloatStr(stringArray[5]) * f);
        }
    }

    private boolean readGaussianBasis() throws Exception {
        Object object;
        this.shells = new JmolList();
        JmolList<float[]> jmolList = new JmolList<float[]>();
        int n = 0;
        int n2 = 0;
        this.nCoef = 0;
        this.nSPDF = new int[12];
        this.discardLinesUntilNonBlank();
        while (this.line != null && (this.line = this.line.trim()).length() != 0 && this.line.charAt(0) != '[') {
            object = this.getTokens();
            n = this.parseIntStr((String)object[0]) - 1;
            if (n == Integer.MAX_VALUE) {
                this.bsBadIndex.set(this.shells.size());
            } else {
                this.bsAtomOK.set(n);
            }
            while (this.readLine() != null && (this.line = this.line.trim()).length() > 0 && this.line.charAt(0) != '[') {
                object = this.getTokens();
                String string = object[0].toUpperCase();
                int n3 = JmolAdapter.getQuantumShellTagID(string);
                int n4 = this.parseIntStr((String)object[1]);
                int[] nArray = new int[4];
                int n5 = n3;
                this.nSPDF[n5] = this.nSPDF[n5] + 1;
                nArray[0] = n;
                nArray[1] = n3;
                nArray[2] = n2;
                nArray[3] = n4;
                int n6 = this.getDfCoefMaps()[n3].length;
                System.out.println("adding " + n6 + " coefficients type " + JmolAdapter.getQuantumShellTag(n3) + " for atom " + n);
                this.nCoef += n6;
                int n7 = n4;
                while (--n7 >= 0) {
                    String[] stringArray = MoldenReader.getTokensStr(this.readLine());
                    int n8 = stringArray.length;
                    float[] fArray = new float[n8];
                    for (int i = 0; i < n8; ++i) {
                        fArray[i] = this.parseFloatStr(stringArray[i]);
                    }
                    jmolList.addLast(fArray);
                    ++n2;
                }
                this.shells.addLast(nArray);
            }
            if (this.line.length() > 0 && this.line.charAt(0) == '[') break;
            this.readLine();
        }
        object = ArrayUtil.newFloat2(n2);
        for (int i = 0; i < n2; ++i) {
            object[i] = (float[])jmolList.get(i);
        }
        this.moData.put("shells", this.shells);
        this.moData.put("gaussians", object);
        Logger.info(this.shells.size() + " slater shells read");
        Logger.info(((float[][])object).length + " gaussian primitives read");
        Logger.info(this.nCoef + " MO coefficients expected for orbital type " + this.orbitalType);
        this.atomSetCollection.setAtomSetAuxiliaryInfo("moData", this.moData);
        return false;
    }

    private boolean readMolecularOrbitals() throws Exception {
        while (this.checkOrbitalType(this.readLine())) {
        }
        this.fixOrbitalType();
        String[] stringArray = this.getMoTokens(this.line);
        while (stringArray != null && stringArray.length > 0 && stringArray[0].indexOf(91) < 0) {
            String string;
            Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
            JmolList<String> jmolList = new JmolList<String>();
            float f = Float.NaN;
            float f2 = Float.NaN;
            String string2 = null;
            while (this.parseIntStr(string = stringArray[0]) == Integer.MIN_VALUE) {
                if (string.startsWith("Ene")) {
                    f = this.parseFloatStr(stringArray[1]);
                } else if (string.startsWith("Occup")) {
                    f2 = this.parseFloatStr(stringArray[1]);
                } else if (string.startsWith("Sym")) {
                    string2 = stringArray[1];
                } else if (string.startsWith("Spin")) {
                    this.alphaBeta = stringArray[1].toLowerCase();
                }
                stringArray = this.getMoTokens(null);
            }
            while (stringArray != null && stringArray.length > 0 && this.parseIntStr(stringArray[0]) != Integer.MIN_VALUE) {
                if (stringArray.length != 2) {
                    throw new Exception("invalid MO coefficient specification");
                }
                jmolList.addLast(stringArray[1]);
                stringArray = this.getMoTokens(null);
            }
            float[] fArray = new float[jmolList.size()];
            if (this.orbitalType.equals("") && fArray.length < this.nCoef) {
                Logger.info("too few orbital coefficients for 6D");
                this.checkOrbitalType("[5D]");
            }
            int n = jmolList.size();
            while (--n >= 0) {
                fArray[n] = this.parseFloatStr((String)jmolList.get(n));
            }
            String string3 = this.line;
            this.line = "" + string2;
            if (this.filterMO()) {
                hashtable.put("coefficients", fArray);
                if (Float.isNaN(f)) {
                    this.haveEnergy = false;
                } else {
                    hashtable.put("energy", Float.valueOf(f));
                }
                if (!Float.isNaN(f2)) {
                    hashtable.put("occupancy", Float.valueOf(f2));
                }
                if (string2 != null) {
                    hashtable.put("symmetry", string2);
                }
                if (this.alphaBeta.length() > 0) {
                    hashtable.put("type", this.alphaBeta);
                }
                this.setMO(hashtable);
                if (Logger.debugging) {
                    Logger.debug(fArray.length + " coefficients in MO " + this.orbitals.size());
                }
            }
            this.line = string3;
        }
        if (Logger.debugging) {
            Logger.debug("read " + this.orbitals.size() + " MOs");
        }
        this.setMOs("eV");
        if (this.haveEnergy && this.doSort) {
            this.sortMOs();
        }
        return false;
    }

    private void sortMOs() {
        Object[] objectArray = this.orbitals.toArray();
        Arrays.sort(objectArray, new BasisFunctionReader.MOEnergySorter());
        this.orbitals.clear();
        for (int i = 0; i < objectArray.length; ++i) {
            this.orbitals.addLast((Map)objectArray[i]);
        }
    }

    private String[] getMoTokens(String string) throws Exception {
        return string == null && (string = this.readLine()) == null ? null : MoldenReader.getTokensStr(string.replace('=', ' '));
    }

    private boolean checkOrbitalType(String string) {
        if (string.length() > 3 && "5D 6D 7F 10 9G 15 11 21".indexOf(string.substring(1, 3)) >= 0) {
            if (this.orbitalType.indexOf(string) >= 0) {
                return true;
            }
            this.orbitalType = this.orbitalType + string;
            Logger.info("Orbital type set to " + this.orbitalType);
            this.fixOrbitalType();
            return true;
        }
        return false;
    }

    private void fixOrbitalType() {
        if (this.orbitalType.contains("5D")) {
            this.fixSlaterTypes(JmolAdapter.SHELL_D_CARTESIAN, JmolAdapter.SHELL_D_SPHERICAL);
            this.fixSlaterTypes(JmolAdapter.SHELL_F_CARTESIAN, JmolAdapter.SHELL_F_SPHERICAL);
            this.fixSlaterTypes(JmolAdapter.SHELL_G_CARTESIAN, JmolAdapter.SHELL_G_SPHERICAL);
            this.fixSlaterTypes(JmolAdapter.SHELL_H_CARTESIAN, JmolAdapter.SHELL_H_SPHERICAL);
        }
        if (this.orbitalType.contains("10F")) {
            this.fixSlaterTypes(JmolAdapter.SHELL_F_SPHERICAL, JmolAdapter.SHELL_F_CARTESIAN);
            this.fixSlaterTypes(JmolAdapter.SHELL_G_SPHERICAL, JmolAdapter.SHELL_G_CARTESIAN);
            this.fixSlaterTypes(JmolAdapter.SHELL_H_SPHERICAL, JmolAdapter.SHELL_H_CARTESIAN);
        }
        if (this.orbitalType.contains("15G")) {
            this.fixSlaterTypes(JmolAdapter.SHELL_G_SPHERICAL, JmolAdapter.SHELL_G_CARTESIAN);
            this.fixSlaterTypes(JmolAdapter.SHELL_H_SPHERICAL, JmolAdapter.SHELL_H_CARTESIAN);
        }
    }

    private boolean readFreqsAndModes() throws Exception {
        JmolList<String> jmolList = new JmolList<String>();
        while (this.readLine() != null && this.line.indexOf(91) < 0) {
            String string = this.getTokens()[0];
            jmolList.addLast(string);
        }
        int n = jmolList.size();
        this.skipTo("[FR-COORD]");
        if (!this.vibOnly) {
            this.readAtomSet("frequency base geometry", true, true);
        }
        this.skipTo("[FR-NORM-COORD]");
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            this.skipTo("vibration");
            this.doGetVibration(++this.vibrationNumber);
            if (bl) {
                this.atomSetCollection.cloneLastAtomSet();
            }
            bl = true;
            this.atomSetCollection.setAtomSetFrequency(null, null, "" + Parser.dVal((String)jmolList.get(i)), null);
            int n2 = this.atomSetCollection.getLastAtomSetAtomIndex();
            for (int j = 0; j < this.modelAtomCount; ++j) {
                String[] stringArray = MoldenReader.getTokensStr(this.readLine());
                this.atomSetCollection.addVibrationVector(j + n2, this.parseFloatStr(stringArray[0]) * 0.5291772f, this.parseFloatStr(stringArray[1]) * 0.5291772f, this.parseFloatStr(stringArray[2]) * 0.5291772f);
            }
        }
        return true;
    }

    private boolean readGeometryOptimization() throws Exception {
        int n;
        JmolList<String> jmolList = new JmolList<String>();
        this.readLine();
        while (this.readLine() != null && this.line.indexOf("force") < 0) {
            jmolList.addLast("" + Parser.dVal(this.line.trim()));
        }
        this.skipTo("[GEOMETRIES] XYZ");
        int n2 = jmolList.size();
        this.modelNumber = n = this.optOnly || this.desiredModelNumber >= 0 ? 0 : 1;
        boolean bl = false;
        if (this.desiredModelNumber == 0 || this.desiredModelNumber == n2) {
            this.desiredModelNumber = n2;
        } else if (this.atomSetCollection.getAtomSetCount() > 0) {
            this.finalizeMOData(null);
        }
        for (int i = 0; i < n2; ++i) {
            this.readLines(2);
            if (this.doGetModel(++this.modelNumber, null)) {
                this.readAtomSet("Step " + (this.modelNumber - n) + "/" + n2 + ": " + (String)jmolList.get(i), false, !this.optOnly || bl);
                bl = true;
                continue;
            }
            this.readLines(this.modelAtomCount);
        }
        return true;
    }

    private void skipTo(String string) throws Exception {
        string = string.toUpperCase();
        if (this.line == null || !this.line.toUpperCase().contains(string)) {
            while (this.readLine() != null && this.line.toUpperCase().indexOf(string) < 0) {
            }
        }
    }

    private void readAtomSet(String string, boolean bl, boolean bl2) throws Exception {
        if (bl2 && this.desiredModelNumber < 0) {
            this.atomSetCollection.cloneFirstAtomSet(0);
        }
        float f = bl ? 0.5291772f : 1.0f;
        this.atomSetCollection.setAtomSetName(string);
        if (this.atomSetCollection.getAtomCount() == 0) {
            while (this.readLine() != null && this.line.indexOf(91) < 0) {
                String[] stringArray = this.getTokens();
                if (stringArray.length != 4) continue;
                Atom atom = this.atomSetCollection.addNewAtom();
                atom.atomName = stringArray[0];
                this.setAtomCoordXYZ(atom, this.parseFloatStr(stringArray[1]) * f, this.parseFloatStr(stringArray[2]) * f, this.parseFloatStr(stringArray[3]) * f);
            }
            this.modelAtomCount = this.atomSetCollection.getLastAtomSetAtomCount();
            return;
        }
        Atom[] atomArray = this.atomSetCollection.getAtoms();
        int n = this.atomSetCollection.getLastAtomSetAtomIndex();
        for (int i = 0; i < this.modelAtomCount; ++i) {
            String[] stringArray = MoldenReader.getTokensStr(this.readLine());
            Atom atom = atomArray[i + n];
            this.setAtomCoordXYZ(atom, this.parseFloatStr(stringArray[1]) * f, this.parseFloatStr(stringArray[2]) * f, this.parseFloatStr(stringArray[3]) * f);
        }
    }
}

