/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.adapter.readers.cif;

import java.util.Hashtable;
import java.util.Map;
import org.jmol.adapter.smarter.Atom;
import org.jmol.adapter.smarter.AtomSetCollectionReader;
import org.jmol.util.BS;
import org.jmol.util.Escape;
import org.jmol.util.JmolList;
import org.jmol.util.Logger;
import org.jmol.util.Matrix3f;
import org.jmol.util.Matrix4f;
import org.jmol.util.Modulation;
import org.jmol.util.ModulationSet;
import org.jmol.util.P3;
import org.jmol.util.SB;
import org.jmol.util.Tensor;
import org.jmol.util.Tuple3f;
import org.jmol.util.V3;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ModulationReader
extends AtomSetCollectionReader {
    protected boolean allowRotations = true;
    protected boolean modVib;
    protected String modAxes;
    protected boolean modAverage;
    protected String modType;
    protected boolean checkSpecial = true;
    protected boolean modDebug;
    protected int modSelected = -1;
    protected int modDim;
    protected boolean incommensurate;
    protected Atom[] atoms;
    private BS bsAtoms;
    private P3 q1;
    private V3 q1Norm;
    private Map<String, P3> htModulation;
    private Map<String, JmolList<Modulation>> htAtomMods;
    protected Map<String, Object> htSubsystems;
    private String suffix;
    private Matrix3f q123;
    private double[] qlen;
    private boolean haveOccupancy;
    private int iopLast = -1;
    private Matrix3f gammaE;
    private Matrix4f gammaIS;
    private int nOps;
    protected static final String U_LIST = "U11U22U33U12U13U23OTPUISO";

    protected void initializeModulation() throws Exception {
        this.modDebug = this.checkFilterKey("MODDEBUG");
        this.modAxes = this.getFilter("MODAXES=");
        this.modType = this.getFilter("MODTYPE=");
        this.modSelected = this.parseIntStr("" + this.getFilter("MOD="));
        this.modVib = this.checkFilterKey("MODVIB");
        this.modAverage = this.checkFilterKey("MODAVE");
        this.checkSpecial = !this.checkFilterKey("NOSPECIAL");
        this.atomSetCollection.setCheckSpecial(this.checkSpecial);
        this.allowRotations = !this.checkFilterKey("NOSYM");
    }

    protected void setModDim(int n) {
        if (this.modAverage) {
            return;
        }
        this.modDim = n;
        if (this.modDim > 3) {
            this.appendLoadNote("Too high modulation dimension (" + this.modDim + ") -- reading average structure");
            this.modDim = 0;
            this.modAverage = true;
        } else {
            this.appendLoadNote("Modulation dimension = " + this.modDim);
            this.htModulation = new Hashtable<String, P3>();
        }
        this.incommensurate = this.modDim > 0;
    }

    protected P3 getModulationVector(String string) {
        return this.htModulation.get(string + "@0");
    }

    protected void addModulation(Map<String, P3> map, String string, P3 p3, int n) {
        char c = string.charAt(0);
        switch (c) {
            case 'D': 
            case 'O': 
            case 'U': {
                if ((this.modType == null || this.modType.indexOf(c) >= 0) && (this.modSelected <= 0 || this.modSelected == 1)) break;
                return;
            }
        }
        if (this.modSelected > 0 && string.contains("_q_")) {
            switch (this.modSelected) {
                case 1: {
                    p3.z = 0.0f;
                    p3.y = 0.0f;
                    break;
                }
                case 2: {
                    p3.z = 0.0f;
                    p3.x = 0.0f;
                    break;
                }
                case 3: {
                    p3.y = 0.0f;
                    p3.x = 0.0f;
                }
            }
        }
        if (p3.x == 0.0f && p3.y == 0.0f && p3.z == 0.0f) {
            return;
        }
        if (map == null) {
            map = this.htModulation;
        }
        string = string + "@" + (n >= 0 ? n : this.atomSetCollection.getCurrentAtomSetIndex());
        Logger.info((String)("Adding " + string + " " + p3));
        map.put(string, p3);
    }

    protected void setModulation() {
        if (!this.incommensurate || this.htModulation == null) {
            return;
        }
        if (this.modDebug) {
            Logger.debuggingHigh = true;
            Logger.debugging = true;
        }
        this.setModulationForStructure(this.atomSetCollection.getCurrentAtomSetIndex());
        if (this.modDebug) {
            Logger.debuggingHigh = false;
            Logger.debugging = false;
        }
    }

    protected void finalizeModulation() {
        if (!this.incommensurate) {
            return;
        }
        if (!this.modVib) {
            this.addJmolScript("modulation on" + (this.haveOccupancy ? ";display occupancy > 0.5" : ""));
        }
    }

    private P3 getMod(String string) {
        return this.htModulation.get(string + this.suffix);
    }

    /*
     * WARNING - void declaration
     */
    private void setModulationForStructure(int n) {
        void var9_15;
        Object object;
        String string;
        Map.Entry<String, P3> entry22;
        P3 p3;
        this.suffix = "@" + n;
        if (this.htModulation.containsKey("X_" + this.suffix)) {
            return;
        }
        this.htModulation.put("X_" + this.suffix, new P3());
        this.q123 = new Matrix3f();
        this.qlen = new double[this.modDim];
        for (int i = 0; i < this.modDim; ++i) {
            p3 = this.getMod("W_" + (i + 1));
            if (p3 == null) {
                Logger.info((String)("Not enough cell wave vectors for d=" + this.modDim));
                return;
            }
            if (i == 0) {
                this.q1 = P3.newP((Tuple3f)p3);
            }
            this.q123.setRowV(i, (Tuple3f)p3);
            this.qlen[i] = p3.length();
        }
        this.q1Norm = V3.new3((float)(this.q1.x == 0.0f ? 0.0f : 1.0f), (float)(this.q1.y == 0.0f ? 0.0f : 1.0f), (float)(this.q1.z == 0.0f ? 0.0f : 1.0f));
        P3 p32 = P3.new3((float)1.0f, (float)0.0f, (float)0.0f);
        int n2 = this.atomSetCollection.getAtomCount();
        Hashtable<String, P3> hashtable = new Hashtable<String, P3>();
        for (Map.Entry<String, P3> entry22 : this.htModulation.entrySet()) {
            string = this.checkKey(entry22.getKey());
            if (string == null) continue;
            p3 = (P3)entry22.getValue();
            switch (string.charAt(0)) {
                case 'O': {
                    this.haveOccupancy = true;
                }
                case 'D': {
                    if (p3.z != 1.0f || string.charAt(2) == 'S') break;
                    double d = p3.x;
                    double string2 = Math.PI * 2 * (double)p3.y;
                    p3.x = (float)(d * Math.cos(string2));
                    p3.y = (float)(d * Math.sin(-string2));
                    p3.z = 0.0f;
                    Logger.info((String)("msCIF setting " + string + " " + p3));
                    break;
                }
                case 'W': {
                    if (this.modDim > 1) break;
                }
                case 'F': {
                    if (string.indexOf("_q_") >= 0) {
                        this.appendLoadNote("Wave vector " + string + "=" + p3);
                        break;
                    }
                    int n3 = (int)(p3.dot((Tuple3f)this.q1) / this.q1.dot((Tuple3f)this.q1) * 1.01f);
                    object = string + "_q_";
                    if (this.htModulation.containsKey((String)object + this.suffix)) break;
                    this.addModulation(hashtable, (String)object, P3.new3((float)n3, (float)0.0f, (float)0.0f), n);
                }
            }
        }
        if (!hashtable.isEmpty()) {
            this.htModulation.putAll(hashtable);
        }
        boolean bl = false;
        for (Map.Entry entry3 : this.htModulation.entrySet()) {
            string = this.checkKey((String)entry3.getKey());
            if (string == null) continue;
            object = (P3)entry3.getValue();
            String string2 = string.substring(string.indexOf(";") + 1);
            int n3 = string2.indexOf("#=");
            if (n3 >= 0) {
                object = this.getMod(string2.substring(n3 + 2));
                string2 = string2.substring(0, n3);
            }
            if (Logger.debuggingHigh) {
                Logger.debug((String)("SetModulation: " + string + " " + object));
            }
            int n4 = string.charAt(0);
            n3 = string.indexOf("#") + 1;
            String string3 = null;
            switch (n4) {
                case 85: {
                    string3 = string.substring(4, string.indexOf(";"));
                }
                case 68: 
                case 79: {
                    int n5;
                    char c = string.charAt(2);
                    char c2 = string.charAt(n3);
                    int n6 = c == 'S' ? 1 : (c == '0' ? 3 : (n4 == 79 ? 2 : (n4 = n4 == 85 ? 4 : 0)));
                    if (this.htAtomMods == null) {
                        this.htAtomMods = new Hashtable<String, JmolList<Modulation>>();
                    }
                    int n7 = n5 = c == 'S' ? 0 : this.parseIntStr(string.substring(2));
                    if (n5 == 0) {
                        this.addAtomModulation(string2, c2, n4, (P3)object, string3, p32);
                    } else {
                        P3 p33 = this.getMod("F_" + n5 + "_q_");
                        if (p33 == null) {
                            Logger.error((String)("Missing qlist for F_" + n5));
                        }
                        this.addAtomModulation(string2, c2, n4, (P3)object, string3, p33);
                    }
                    bl = true;
                }
            }
        }
        if (!bl) {
            return;
        }
        this.atoms = this.atomSetCollection.getAtoms();
        this.symmetry = this.atomSetCollection.getSymmetry();
        this.iopLast = -1;
        entry22 = new SB();
        int i = this.atomSetCollection.getLastAtomSetAtomIndex();
        while (var9_15 < n2) {
            this.modulateAtom(this.atoms[var9_15], (SB)entry22);
            ++var9_15;
        }
        this.atomSetCollection.setAtomSetAtomProperty("modt", entry22.toString(), -1);
        this.htAtomMods = null;
    }

    private void addAtomModulation(String string, char c, int n, P3 p3, String string2, P3 p32) {
        JmolList jmolList = this.htAtomMods.get(string);
        if (jmolList == null) {
            jmolList = new JmolList();
            this.htAtomMods.put(string, (JmolList<Modulation>)jmolList);
        }
        jmolList.addLast((Object)new Modulation(c, n, p3, string2, p32));
    }

    private String checkKey(String string) {
        int n = string.indexOf(this.suffix);
        return n < 0 ? null : string.substring(0, n);
    }

    public void modulateAtom(Atom atom, SB sB) {
        P3 p3;
        JmolList<Modulation> jmolList = this.htAtomMods.get(atom.atomName);
        if (jmolList == null || this.symmetry == null || atom.bsSymmetry == null) {
            return;
        }
        int n = atom.bsSymmetry.nextSetBit(0);
        if (n < 0) {
            n = 0;
        }
        if (Logger.debuggingHigh) {
            Logger.debug((String)("\nsetModulation: i=" + atom.index + " " + atom.atomName + " xyz=" + atom + " occ=" + atom.foccupancy));
        }
        if (n != this.iopLast) {
            this.iopLast = n;
            this.gammaE = new Matrix3f();
            this.symmetry.getSpaceGroupOperation(n).getRotationScale(this.gammaE);
            this.gammaIS = this.symmetry.getOperationGammaIS(n);
            this.nOps = this.symmetry.getSpaceGroupOperationCount();
        }
        if (Logger.debugging) {
            Logger.debug((String)("setModulation iop = " + n + " " + this.symmetry.getSpaceGroupXyz(n, false) + " " + atom.bsSymmetry));
        }
        Matrix4f matrix4f = Matrix4f.newMV((Matrix3f)this.q123, (V3)new V3());
        this.setSubsystemMatrix(atom.atomName, matrix4f);
        ModulationSet modulationSet = new ModulationSet(atom.index + " " + atom.atomName, P3.newP((Tuple3f)atom), this.modDim, jmolList, this.gammaE, this.gammaIS, matrix4f, this.qlen);
        modulationSet.calculate();
        if (!Float.isNaN(modulationSet.vOcc)) {
            float f;
            p3 = this.getMod("J_O#0;" + atom.atomName);
            float f2 = modulationSet.vOcc0;
            if (Float.isNaN(f2)) {
                f = modulationSet.vOcc;
            } else if (p3 == null) {
                f = atom.foccupancy + modulationSet.vOcc;
            } else if (atom.vib != null) {
                float f3 = atom.vib.x;
                float f4 = atom.foccupancy * f3 / (float)this.nOps / p3.y;
                f = f4 * (p3.y + modulationSet.vOcc);
            } else {
                f = p3.x * (p3.y + modulationSet.vOcc);
            }
            atom.foccupancy = Math.min(1.0f, Math.max(0.0f, f));
            atom.vib = modulationSet;
        }
        if (modulationSet.htUij != null) {
            if (Logger.debuggingHigh) {
                Logger.debug((String)("setModulation Uij(initial)=" + Escape.eAF((float[])atom.anisoBorU)));
                Logger.debug((String)("setModulation tensor=" + Escape.e((Object)((Tensor)atom.tensors.get(0)).getInfo("all"))));
            }
            for (Map.Entry entry : modulationSet.htUij.entrySet()) {
                this.addUStr(atom, (String)entry.getKey(), ((Float)entry.getValue()).floatValue());
            }
            if (atom.tensors != null) {
                ((Tensor)atom.tensors.get((int)0)).isUnmodulated = true;
            }
            p3 = this.atomSetCollection.addRotatedTensor(atom, this.symmetry.getTensor(atom.anisoBorU), n, false);
            p3.isModulated = true;
            if (Logger.debuggingHigh) {
                Logger.debug((String)("setModulation Uij(final)=" + Escape.eAF((float[])atom.anisoBorU) + "\n"));
                Logger.debug((String)("setModulation tensor=" + ((Tensor)atom.tensors.get(0)).getInfo("all")));
            }
        }
        if (this.modVib || atom.foccupancy != 0.0f) {
            float f = this.q1Norm.dot((Tuple3f)atom);
            if (Math.abs(f - (float)((int)f)) > 0.001f) {
                f = (int)Math.floor(f);
            }
            sB.append((int)f + "\n");
        }
        this.symmetry.toCartesian((Tuple3f)modulationSet, true);
    }

    private void setSubsystemMatrix(String string, Matrix4f matrix4f) {
    }

    protected void addSubsystem(String string, Matrix4f matrix4f, String string2) {
        if (this.htSubsystems == null) {
            this.htSubsystems = new Hashtable<String, Object>();
        }
        if (matrix4f == null) {
            this.htSubsystems.put(";" + string2, string);
        } else {
            this.htSubsystems.put(string, matrix4f);
        }
    }

    private void addUStr(Atom atom, String string, float f) {
        int n = U_LIST.indexOf(string) / 3;
        if (Logger.debuggingHigh) {
            Logger.debug((String)("MOD RDR adding " + string + " " + n + " " + f + " to " + atom.anisoBorU[n]));
        }
        this.setU(atom, n, f + atom.anisoBorU[n]);
    }

    protected void setU(Atom atom, int n, float f) {
        float[] fArray = this.atomSetCollection.getAnisoBorU(atom);
        if (fArray == null) {
            fArray = new float[8];
            this.atomSetCollection.setAnisoBorU(atom, fArray, 8);
        }
        fArray[n] = f;
    }
}

