/*
 * Decompiled with CFR 0.152.
 */
package jspecview.source;

import java.io.BufferedReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import jspecview.source.JDXSource;
import jspecview.source.XMLReader;
import jspecview.util.JSVBase64;

class AnIMLReader
extends XMLReader {
    private boolean inResult;

    static JDXSource getAniMLInstance(String filePath, BufferedReader br) {
        return new AnIMLReader(filePath).getXML(br);
    }

    AnIMLReader(String filePath) {
        super(filePath);
    }

    private JDXSource getXML(BufferedReader br) {
        block5: {
            this.source = new JDXSource(0, this.filePath);
            this.getSimpleXmlReader(br);
            this.reader.nextEvent();
            this.processXML(0, 3);
            if (this.checkPointCount()) break block5;
            return null;
        }
        try {
            this.xFactor = 1.0;
            this.yFactor = 1.0;
            this.populateVariables();
        }
        catch (Exception pe) {
            System.err.println("That file may be empty...");
            this.errorLog.append("That file may be empty... \n");
        }
        this.processErrors("anIML");
        try {
            br.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return this.source;
    }

    protected boolean processTag(int tagId) throws Exception {
        switch (tagId) {
            case 0: {
                this.processAuditTrail();
                return true;
            }
            case 1: {
                this.processExperimentStepSet();
                return true;
            }
            case 2: {
                this.processSampleSet();
                return true;
            }
            case 11: {
                this.processAuthor();
                return true;
            }
            case 3: {
                this.inResult = true;
                return true;
            }
        }
        System.out.println("AnIMLSource not processing tag " + tagNames[tagId] + "!");
        return false;
    }

    protected void processEndTag(int tagId) throws Exception {
        switch (tagId) {
            case 1: 
            case 3: {
                this.inResult = false;
            }
        }
    }

    private void processAuditTrail() throws Exception {
        if (this.tagName.equals("user")) {
            this.reader.qualifiedValue();
        } else if (this.tagName.equals("timestamp")) {
            this.reader.qualifiedValue();
        }
    }

    private void processSampleSet() throws Exception {
        if (this.tagName.equals("sample")) {
            ++this.samplenum;
        } else if (this.tagName.equals("parameter")) {
            this.attrList = this.reader.getAttrValueLC("name");
            if (this.attrList.equals("name")) {
                this.reader.qualifiedValue();
            } else if (this.attrList.equals("owner")) {
                this.reader.qualifiedValue();
            } else if (this.attrList.equals("molecular formula")) {
                this.molForm = this.reader.qualifiedValue();
            } else if (this.attrList.equals("cas registry number")) {
                this.casRN = this.reader.qualifiedValue();
            }
        }
    }

    private void processExperimentStepSet() throws Exception {
        System.out.println("AnIML experiment " + this.tagName);
        if (this.tagName.equals("result")) {
            this.inResult = true;
        } else if (this.tagName.equals("sampleref")) {
            if (this.reader.getAttrValueLC("role").contains("samplemeasurement")) {
                this.sampleID = this.reader.getAttrValue("sampleID");
            }
        } else if (this.tagName.equals("author")) {
            this.process(11, true);
        } else if (this.tagName.equals("timestamp")) {
            this.LongDate = this.reader.thisValue();
        } else if (this.tagName.equals("technique")) {
            this.techname = String.valueOf(this.reader.getAttrValue("name").toUpperCase()) + " SPECTRUM";
        } else if (this.tagName.equals("vectorset") || this.tagName.equals("seriesset") && this.inResult) {
            this.npoints = Integer.parseInt(this.reader.getAttrValue("length"));
            System.out.println("AnIML No. of points= " + this.npoints);
            this.xaxisData = new double[this.npoints];
            this.yaxisData = new double[this.npoints];
        } else if (this.tagName.equals("vector") || this.tagName.equals("series") && this.inResult) {
            String axisLabel = this.reader.getAttrValue("name");
            String dependency = this.reader.getAttrValueLC("dependency");
            if (dependency.equals("independent")) {
                this.xUnits = axisLabel;
                this.getXValues();
            } else if (dependency.equals("dependent")) {
                this.yUnits = axisLabel;
                this.getYValues();
            }
        } else if (this.tagName.equals("parameter")) {
            this.attrList = this.reader.getAttrValueLC("name");
            if (this.attrList.equals("identifier")) {
                this.title = this.reader.qualifiedValue();
            } else if (this.attrList.equals("nucleus")) {
                this.obNucleus = this.reader.qualifiedValue();
            } else if (this.attrList.equals("observefrequency")) {
                this.StrObFreq = this.reader.qualifiedValue();
                this.obFreq = Double.parseDouble(this.StrObFreq);
            } else if (this.attrList.equals("referencepoint")) {
                this.refPoint = Double.parseDouble(this.reader.qualifiedValue());
            } else if (this.attrList.equals("sample path length")) {
                this.pathlength = this.reader.qualifiedValue();
            } else if (this.attrList.equals("scanmode")) {
                this.reader.thisValue();
            } else if (this.attrList.equals("manufacturer")) {
                this.vendor = this.reader.thisValue();
            } else if (this.attrList.equals("model name")) {
                this.modelType = this.reader.thisValue();
            } else if (this.attrList.equals("resolution")) {
                this.resolution = this.reader.qualifiedValue();
            }
        }
    }

    private void getXValues() throws IOException {
        this.reader.nextTag();
        if (this.reader.getTagName().equals("autoincrementedvalueset")) {
            this.reader.nextTag();
            if (this.reader.getTagName().equals("startvalue")) {
                this.firstX = Double.parseDouble(this.reader.qualifiedValue());
            }
            this.nextStartTag();
            if (this.reader.getTagName().equals("increment")) {
                this.deltaX = Double.parseDouble(this.reader.qualifiedValue());
            }
        }
        if (!this.inResult) {
            this.nextStartTag();
            this.xUnits = this.reader.getAttrValue("label");
        }
        this.increasing = this.deltaX > 0.0;
        this.continuous = true;
        int j = 0;
        while (j < this.npoints) {
            this.xaxisData[j] = this.firstX + this.deltaX * (double)j;
            ++j;
        }
        this.lastX = this.xaxisData[this.npoints - 1];
    }

    private void nextStartTag() throws IOException {
        this.reader.nextStartTag();
        while (this.reader.getTagType() == 6) {
            this.reader.nextStartTag();
        }
    }

    private void getYValues() throws IOException {
        String vectorType = this.reader.getAttrValueLC("type");
        if (vectorType.length() == 0) {
            vectorType = this.reader.getAttrValueLC("vectorType");
        }
        this.reader.nextTag();
        this.tagName = this.reader.getTagName();
        if (this.tagName.equals("individualvalueset")) {
            int ii = 0;
            while (ii < this.npoints) {
                this.yaxisData[ii] = Double.parseDouble(this.reader.qualifiedValue());
                ++ii;
            }
            System.out.println(String.valueOf(this.npoints) + " individual Y values now read");
        } else if (this.tagName.equals("encodedvalueset")) {
            this.attrList = this.reader.getCharacters();
            byte[] dataArray = JSVBase64.decodeBase64(this.attrList);
            int ij = 0;
            if (dataArray.length != 0) {
                ByteBuffer byte_buffer = ByteBuffer.wrap(dataArray).order(ByteOrder.LITTLE_ENDIAN);
                if (vectorType.equals("float64")) {
                    DoubleBuffer double_buffer = byte_buffer.asDoubleBuffer();
                    ij = 0;
                    while (double_buffer.remaining() > 0) {
                        this.yaxisData[ij] = double_buffer.get();
                        ++ij;
                    }
                } else if (vectorType.equals("float32")) {
                    FloatBuffer float_buffer = byte_buffer.asFloatBuffer();
                    ij = 0;
                    while (float_buffer.remaining() > 0) {
                        this.yaxisData[ij] = float_buffer.get();
                        ++ij;
                    }
                }
            }
        }
        this.reader.nextStartTag();
        this.tagName = this.reader.getTagName();
        this.yUnits = this.reader.getAttrValue("label");
        this.firstY = this.yaxisData[0];
    }

    private void processAuthor() throws IOException {
        if (this.tagName.equals("name")) {
            this.owner = this.reader.thisValue();
        } else if (this.tagName.contains("location")) {
            this.origin = this.reader.thisValue();
        }
    }
}

