/*
 * Decompiled with CFR 0.152.
 */
package jspecview.export;

import java.awt.Color;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import jspecview.common.AwtParameters;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;
import jspecview.common.ScaleData;
import jspecview.export.FormExporter;
import jspecview.util.JSVLogger;
import jspecview.util.JSVTextFormat;

class SVGExporter
extends FormExporter {
    private static int svgWidth = 850;
    private static int svgHeight = 400;
    private static int leftInset = 100;
    private static int rightInset = 200;
    private static int bottomInset = 80;
    private static int topInset = 20;

    SVGExporter() {
    }

    String exportAsSVG(String path, JDXSpectrum graph, int startIndex, int endIndex, boolean forInkscape) throws IOException {
        return this.exportAsSVG(path, graph.getXYCoords(), "", startIndex, endIndex, graph.getXUnits(), graph.getYUnits(), graph.isContinuous(), graph.isXIncreasing(), graph.isInverted(), Color.lightGray, Color.white, Color.black, Color.gray, Color.black, Color.black, Color.black, forInkscape);
    }

    String exportAsSVG(String fileName, Coordinate[] xyCoords, String title, int startDataPointIndex, int endDataPointIndex, String xUnits, String yUnits, boolean isContinuous, boolean increasing, boolean isInverted, Color plotAreaColor, Color backgroundColor, Color plotColor, Color gridColor, Color titleColor, Color scaleColor, Color unitsColor, boolean exportForInkscape) throws IOException {
        double secondTranslateY;
        double secondTranslateX;
        double scaleY;
        double scaleX;
        double firstTranslateY;
        double firstTranslateX;
        Hashtable<String, String> hash;
        Hashtable<String, String> hash2;
        String yStr;
        String xStr;
        double yPt;
        double xPt;
        this.initForm(fileName);
        DecimalFormat formatter2 = JSVTextFormat.getDecimalFormat("0.######");
        ScaleData scaleData = new ScaleData(xyCoords, startDataPointIndex, endDataPointIndex, isContinuous, isInverted);
        double maxXOnScale = scaleData.maxXOnScale;
        double minXOnScale = scaleData.minXOnScale;
        double maxYOnScale = scaleData.maxYOnScale;
        double minYOnScale = scaleData.minYOnScale;
        double xStep = scaleData.steps[0];
        double yStep = scaleData.steps[1];
        int plotAreaWidth = svgWidth - leftInset - rightInset;
        int plotAreaHeight = svgHeight - topInset - bottomInset;
        double xScaleFactor = (double)plotAreaWidth / (maxXOnScale - minXOnScale);
        double yScaleFactor = (double)plotAreaHeight / (maxYOnScale - minYOnScale);
        int leftPlotArea = leftInset;
        int rightPlotArea = leftInset + plotAreaWidth;
        int topPlotArea = topInset;
        int bottomPlotArea = topInset + plotAreaHeight;
        int titlePosition = bottomPlotArea + 60;
        this.context.put("titlePosition", new Integer(titlePosition));
        ArrayList vertGridCoords = new ArrayList();
        ArrayList horizGridCoords = new ArrayList();
        double i = minXOnScale;
        while (i < maxXOnScale + xStep / 2.0) {
            xPt = (double)leftPlotArea + (i - minXOnScale) * xScaleFactor;
            yPt = topPlotArea;
            xStr = formatter2.format(xPt);
            yStr = formatter2.format(yPt);
            hash2 = new Hashtable<String, String>();
            hash2.put("xVal", xStr);
            hash2.put("yVal", yStr);
            vertGridCoords.add(hash2);
            i += xStep;
        }
        i = minYOnScale;
        while (i < maxYOnScale + yStep / 2.0) {
            xPt = leftPlotArea;
            yPt = (double)topPlotArea + (i - minYOnScale) * yScaleFactor;
            xStr = formatter2.format(xPt);
            yStr = formatter2.format(yPt);
            hash2 = new Hashtable();
            hash2.put("xVal", xStr);
            hash2.put("yVal", yStr);
            horizGridCoords.add(hash2);
            i += yStep;
        }
        ArrayList xScaleList = new ArrayList();
        ArrayList xScaleListReversed = new ArrayList();
        ArrayList yScaleList = new ArrayList();
        DecimalFormat displayXFormatter = scaleData.formatters[0];
        DecimalFormat displayYFormatter = scaleData.formatters[1];
        double i2 = minXOnScale;
        while (i2 < maxXOnScale + xStep / 2.0) {
            xPt = (double)leftPlotArea + (i2 - minXOnScale) * xScaleFactor;
            yPt = bottomPlotArea + 15;
            xStr = formatter2.format(xPt -= 10.0);
            yStr = formatter2.format(yPt);
            String iStr = displayXFormatter.format(i2);
            hash = new Hashtable<String, String>();
            hash.put("xVal", xStr);
            hash.put("yVal", yStr);
            hash.put("number", iStr);
            xScaleList.add(hash);
            i2 += xStep;
        }
        i2 = minXOnScale;
        double j = maxXOnScale;
        while (i2 < maxXOnScale + xStep / 2.0) {
            xPt = (double)leftPlotArea + (j - minXOnScale) * xScaleFactor;
            yPt = bottomPlotArea + 15;
            xStr = formatter2.format(xPt -= 10.0);
            yStr = formatter2.format(yPt);
            String iStr = displayXFormatter.format(i2);
            Hashtable<String, String> hash3 = new Hashtable<String, String>();
            hash3.put("xVal", xStr);
            hash3.put("yVal", yStr);
            hash3.put("number", iStr);
            xScaleListReversed.add(hash3);
            i2 += xStep;
            j -= xStep;
        }
        i2 = minYOnScale;
        while (i2 < maxYOnScale + yStep / 2.0) {
            xPt = leftPlotArea - 55;
            yPt = (double)bottomPlotArea - (i2 - minYOnScale) * yScaleFactor;
            xStr = formatter2.format(xPt);
            yStr = formatter2.format(yPt += 3.0);
            String iStr = displayYFormatter.format(i2);
            hash = new Hashtable();
            hash.put("xVal", xStr);
            hash.put("yVal", yStr);
            hash.put("number", iStr);
            yScaleList.add(hash);
            i2 += yStep;
        }
        if (increasing) {
            firstTranslateX = leftPlotArea;
            firstTranslateY = bottomPlotArea;
            scaleX = xScaleFactor;
            scaleY = -yScaleFactor;
            secondTranslateX = -1.0 * minXOnScale;
            secondTranslateY = -1.0 * minYOnScale;
        } else {
            firstTranslateX = rightPlotArea;
            firstTranslateY = bottomPlotArea;
            scaleX = -xScaleFactor;
            scaleY = -yScaleFactor;
            secondTranslateX = -minXOnScale;
            secondTranslateY = -minYOnScale;
        }
        double yTickA = minYOnScale - yStep / 2.0;
        double yTickB = yStep / 5.0;
        this.context.put("plotAreaColor", AwtParameters.colorToHexString(plotAreaColor));
        this.context.put("backgroundColor", AwtParameters.colorToHexString(backgroundColor));
        this.context.put("plotColor", AwtParameters.colorToHexString(plotColor));
        this.context.put("gridColor", AwtParameters.colorToHexString(gridColor));
        this.context.put("titleColor", AwtParameters.colorToHexString(titleColor));
        this.context.put("scaleColor", AwtParameters.colorToHexString(scaleColor));
        this.context.put("unitsColor", AwtParameters.colorToHexString(unitsColor));
        this.context.put("svgHeight", new Integer(svgHeight));
        this.context.put("svgWidth", new Integer(svgWidth));
        this.context.put("leftPlotArea", new Integer(leftPlotArea));
        this.context.put("rightPlotArea", new Integer(rightPlotArea));
        this.context.put("topPlotArea", new Integer(topPlotArea));
        this.context.put("bottomPlotArea", new Integer(bottomPlotArea));
        this.context.put("plotAreaHeight", new Integer(plotAreaHeight));
        this.context.put("plotAreaWidth", new Integer(plotAreaWidth));
        this.context.put("minXOnScale", new Double(minXOnScale));
        this.context.put("maxXOnScale", new Double(maxXOnScale));
        this.context.put("minYOnScale", new Double(minYOnScale));
        this.context.put("maxYOnScale", new Double(maxYOnScale));
        this.context.put("yTickA", new Double(yTickA));
        this.context.put("yTickB", new Double(yTickB));
        this.context.put("xScaleFactor", new Double(xScaleFactor));
        this.context.put("yScaleFactor", new Double(yScaleFactor));
        this.context.put("increasing", new Boolean(increasing));
        this.context.put("verticalGridCoords", vertGridCoords);
        this.context.put("horizontalGridCoords", horizGridCoords);
        ArrayList<Coordinate> newXYCoords = new ArrayList<Coordinate>();
        int i3 = startDataPointIndex;
        while (i3 <= endDataPointIndex) {
            newXYCoords.add(xyCoords[i3]);
            ++i3;
        }
        double firstX = xyCoords[startDataPointIndex].getXVal();
        double firstY = xyCoords[startDataPointIndex].getYVal();
        double lastX = xyCoords[endDataPointIndex].getXVal();
        this.context.put("title", title);
        this.context.put("xyCoords", newXYCoords);
        this.context.put("continuous", new Boolean(isContinuous));
        this.context.put("firstTranslateX", new Double(firstTranslateX));
        this.context.put("firstTranslateY", new Double(firstTranslateY));
        this.context.put("scaleX", new Double(scaleX));
        this.context.put("scaleY", new Double(scaleY));
        this.context.put("secondTranslateX", new Double(secondTranslateX));
        this.context.put("secondTranslateY", new Double(secondTranslateY));
        if (increasing) {
            this.context.put("xScaleList", xScaleList);
            this.context.put("xScaleListReversed", xScaleListReversed);
        } else {
            this.context.put("xScaleList", xScaleListReversed);
            this.context.put("xScaleListReversed", xScaleList);
        }
        this.context.put("yScaleList", yScaleList);
        this.context.put("xUnits", xUnits);
        this.context.put("yUnits", yUnits);
        this.context.put("firstX", firstX);
        this.context.put("firstY", firstY);
        this.context.put("lastX", lastX);
        int xUnitLabelX = rightPlotArea - 50;
        int xUnitLabelY = bottomPlotArea + 30;
        int yUnitLabelX = leftPlotArea - 80;
        int yUnitLabelY = bottomPlotArea / 2;
        int tempX = yUnitLabelX;
        yUnitLabelX = -yUnitLabelY;
        yUnitLabelY = tempX;
        this.context.put("xUnitLabelX", "" + xUnitLabelX);
        this.context.put("xUnitLabelY", "" + xUnitLabelY);
        this.context.put("yUnitLabelX", "" + yUnitLabelX);
        this.context.put("yUnitLabelY", "" + yUnitLabelY);
        this.context.put("numDecimalPlacesX", new Integer(Math.abs(scaleData.hashNums[0])));
        this.context.put("numDecimalPlacesY", new Integer(Math.abs(scaleData.hashNums[1])));
        String vm = exportForInkscape ? "plot_ink.vm" : "plot.vm";
        JSVLogger.info("SVGExporter using " + vm);
        return this.writeForm(vm);
    }
}

