/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import jspecview.util.JSVTextFormat;

public class ScriptTokenizer {
    private String str;
    private int pt = -1;
    private int len;
    private boolean isCmd;
    private boolean doCheck = true;

    public ScriptTokenizer(String str, boolean isCmd) {
        this.str = str;
        this.len = str.length();
        this.isCmd = isCmd;
    }

    static String nextStringToken(ScriptTokenizer eachParam, boolean removeQuotes) {
        String s = eachParam.nextToken();
        return removeQuotes && s.charAt(0) == '\"' && s.endsWith("\"") && s.length() > 1 ? JSVTextFormat.trimQuotes(s) : s;
    }

    /*
     * Enabled aggressive block sorting
     */
    public String nextToken() {
        if (this.doCheck) {
            this.hasMoreTokens();
        }
        int pt0 = this.pt;
        boolean inQuote = this.str.charAt(this.pt) == '\"';
        block5: while (++this.pt < this.len) {
            switch (this.str.charAt(this.pt)) {
                case '\"': {
                    if (inQuote) {
                        if (this.isCmd) {
                            inQuote = false;
                            break;
                        }
                        ++this.pt;
                        break block5;
                    }
                    if (!this.isCmd) break;
                    inQuote = true;
                    break;
                }
                case ' ': {
                    if (this.isCmd || inQuote) break;
                    break block5;
                }
                case '\n': 
                case ';': {
                    if (this.isCmd && !inQuote) break block5;
                }
            }
        }
        this.doCheck = true;
        return this.str.substring(pt0, this.pt);
    }

    public boolean hasMoreTokens() {
        block3: while (++this.pt < this.len) {
            switch (this.str.charAt(this.pt)) {
                case '\n': 
                case ' ': 
                case ';': {
                    break;
                }
                default: {
                    break block3;
                }
            }
        }
        this.doCheck = false;
        return this.pt < this.len;
    }
}

