/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import jspecview.common.Annotation;
import jspecview.common.Coordinate;
import jspecview.common.JDXSpectrum;

class Measurement
extends Annotation {
    private Coordinate pt2 = new Coordinate();
    private double value;

    Measurement(JDXSpectrum spec, double x, double y) {
        super(spec, x, y, "", false, false, 0, 6);
        this.setPt2(x, y);
    }

    Measurement(JDXSpectrum spec, double x, double y, String text, double x1, double y1) {
        super(spec, x, y, text, false, false, 0, 6);
        this.setPt2(x1, y1);
    }

    Measurement(Measurement m) {
        super(m.spec, m.getXVal(), m.getYVal(), m.text, false, false, m.offsetX, m.offsetY);
        this.setPt2(m.pt2.getXVal(), m.pt2.getYVal());
    }

    Measurement(JDXSpectrum spec, double x, double y, String text, double value) {
        super(spec, x, y, text, false, false, 0, 6);
        this.value = value;
        this.pt2.setXVal(x);
        this.pt2.setYVal(y);
    }

    Measurement(JDXSpectrum spec, double x, double y, boolean doSetPt2) {
        super(spec, x, y);
        if (doSetPt2) {
            this.setPt2(x, y);
        }
    }

    void setPt2(double x, double y) {
        this.pt2.setXVal(x);
        this.pt2.setYVal(y);
        this.value = Math.abs(x - this.getXVal());
        this.text = this.spec.setMeasurementText(this);
    }

    JDXSpectrum getSpectrum() {
        return this.spec;
    }

    void setValue(double value) {
        this.value = value;
        this.text = this.spec.setMeasurementText(this);
    }

    double getValue() {
        return this.value;
    }

    double getXVal2() {
        return this.pt2.getXVal();
    }

    double getYVal2() {
        return this.pt2.getYVal();
    }

    void addSpecShift(double dx) {
        this.setXVal(this.getXVal() + dx);
        this.pt2.setXVal(this.pt2.getXVal() + dx);
    }

    void setYVal2(double y2) {
        this.pt2.setYVal(y2);
    }

    boolean overlaps(double x1, double x2) {
        return Math.min(this.getXVal(), this.getXVal2()) < Math.max(x1, x2) && Math.max(this.getXVal(), this.getXVal2()) > Math.min(x1, x2);
    }

    public String toString() {
        return "[" + this.getXVal() + "-" + this.pt2.getXVal() + "]";
    }
}

