/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import jspecview.common.Coordinate;
import jspecview.common.JDXDataObject;
import jspecview.common.Parameters;
import jspecview.common.PeakInfo;
import jspecview.source.JDXSourceStreamTokenizer;
import jspecview.util.JSVLogger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDXSpectrum
extends JDXDataObject {
    private List<JDXSpectrum> subSpectra;
    private ArrayList<PeakInfo> peakList = new ArrayList();
    private String piUnitsX;
    private String piUnitsY;
    private PeakInfo selectedPeak;
    private PeakInfo highlightedPeak;
    private double specShift = 0.0;
    private int currentSubSpectrumIndex;
    private boolean isForcedSubset;
    private String id = "";
    private JDXSpectrum convertedSpectrum;
    private double userYFactor = 1.0;
    public static final double MAXABS = 4.0;
    private boolean exportXAxisLeftToRight;

    public void finalize() {
        System.out.println("JDXSpectrum " + this + " finalized " + this.title);
    }

    public void dispose() {
    }

    public boolean isForcedSubset() {
        return this.isForcedSubset;
    }

    public void setId(String id) {
        this.id = id;
    }

    public JDXSpectrum() {
        this.headerTable = new ArrayList();
        this.xyCoords = new Coordinate[0];
        this.parent = this;
    }

    public JDXSpectrum copy() {
        JDXSpectrum newSpectrum = new JDXSpectrum();
        this.copyTo(newSpectrum);
        newSpectrum.setPeakList(this.peakList, this.piUnitsX, null);
        return newSpectrum;
    }

    public Coordinate[] getXYCoords() {
        return this.getCurrentSubSpectrum().xyCoords;
    }

    public ArrayList<PeakInfo> getPeakList() {
        return this.peakList;
    }

    public int setPeakList(ArrayList<PeakInfo> list, String piUnitsX, String piUnitsY) {
        this.peakList = list;
        System.out.println("setting peaklist for " + this + " to " + list);
        if (this.peakList == null) {
            System.out.println("ohoh");
        }
        this.piUnitsX = piUnitsX;
        this.piUnitsY = piUnitsY;
        int i = list.size();
        while (--i >= 0) {
            this.peakList.get((int)i).spectrum = this;
        }
        if (JSVLogger.debugging) {
            JSVLogger.info("Spectrum " + this.getTitle() + " peaks: " + list.size());
        }
        return list.size();
    }

    public PeakInfo selectPeakByFileIndex(String filePath, String index) {
        if (this.peakList != null && this.peakList.size() > 0) {
            int i = 0;
            while (i < this.peakList.size()) {
                if (this.peakList.get(i).checkFileIndex(filePath, index)) {
                    System.out.println("selecting peak in " + this + " " + this.peakList.get(i));
                    this.selectedPeak = this.peakList.get(i);
                    return this.selectedPeak;
                }
                ++i;
            }
        }
        return null;
    }

    public PeakInfo selectPeakByFilePathTypeModel(String filePath, String type, String model) {
        if (this.peakList != null && this.peakList.size() > 0) {
            int i = 0;
            while (i < this.peakList.size()) {
                if (this.peakList.get(i).checkFileTypeModel(filePath, type, model)) {
                    System.out.println("selecting peak in " + this + " " + this.peakList.get(i));
                    this.selectedPeak = this.peakList.get(i);
                    return this.selectedPeak;
                }
                ++i;
            }
        }
        return null;
    }

    public boolean matchesPeakTypeModel(String type, String model) {
        if (this.peakList != null && this.peakList.size() > 0) {
            int i = 0;
            while (i < this.peakList.size()) {
                if (this.peakList.get(i).checkTypeModel(type, model)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public void setSelectedPeak(PeakInfo peak) {
        this.selectedPeak = peak;
    }

    public void setHighlightedPeak(PeakInfo peak) {
        this.highlightedPeak = peak;
    }

    public PeakInfo getSelectedPeak() {
        return this.selectedPeak;
    }

    public PeakInfo getModelPeakInfoForAutoSelectOnLoad() {
        if (this.peakList != null) {
            int i = 0;
            while (i < this.peakList.size()) {
                if (this.peakList.get(i).autoSelectOnLoad()) {
                    return this.peakList.get(i);
                }
                ++i;
            }
        }
        return null;
    }

    public PeakInfo getAssociatedPeakInfo(int xPixel, Coordinate coord) {
        this.selectedPeak = this.findPeakByCoord(xPixel, coord);
        return this.selectedPeak == null ? this.getBasePeakInfo() : this.selectedPeak;
    }

    public PeakInfo findPeakByCoord(int xPixel, Coordinate coord) {
        if (coord != null && this.peakList != null && this.peakList.size() > 0) {
            double xVal = coord.getXVal();
            int iBest = -1;
            double dBest = 1.0E100;
            int i = 0;
            while (i < this.peakList.size()) {
                double d = this.peakList.get(i).checkRange(xPixel, xVal);
                if (d < dBest) {
                    dBest = d;
                    iBest = i;
                }
                ++i;
            }
            if (iBest >= 0) {
                return this.peakList.get(iBest);
            }
        }
        return null;
    }

    public String getPeakTitle() {
        return this.selectedPeak != null ? this.selectedPeak.getTitle() : (this.highlightedPeak != null ? this.highlightedPeak.getTitle() : this.getTitleLabel());
    }

    public String getTitleLabel() {
        String type = this.peakList == null || this.peakList.size() == 0 ? this.getQualifiedDataType() : this.peakList.get(0).getType();
        return String.valueOf(type != null && type.length() > 0 ? String.valueOf(type) + " " : "") + this.getTitle();
    }

    public int setNextPeak(Coordinate coord, int istep) {
        if (this.peakList == null || this.peakList.size() == 0) {
            return -1;
        }
        double x0 = coord.getXVal() + (double)istep * 1.0E-6;
        int ipt1 = -1;
        int ipt2 = -1;
        double dmin1 = Double.MAX_VALUE * (double)istep;
        double dmin2 = 0.0;
        int i = this.peakList.size();
        while (--i >= 0) {
            double x = this.peakList.get(i).getX();
            if (istep > 0) {
                if (x > x0 && x < dmin1) {
                    ipt1 = i;
                    dmin1 = x;
                    continue;
                }
                if (!(x < x0) || !(x - x0 < dmin2)) continue;
                ipt2 = i;
                dmin2 = x - x0;
                continue;
            }
            if (x < x0 && x > dmin1) {
                ipt1 = i;
                dmin1 = x;
                continue;
            }
            if (!(x > x0) || !(x - x0 > dmin2)) continue;
            ipt2 = i;
            dmin2 = x - x0;
        }
        if (ipt1 < 0) {
            if (ipt2 < 0) {
                return -1;
            }
            ipt1 = ipt2;
        }
        return ipt1;
    }

    public double getPercentYValueAt(double x) {
        if (!this.isContinuous()) {
            return Double.NaN;
        }
        return this.getYValueAt(x);
    }

    public double getYValueAt(double x) {
        return Coordinate.getYValueAt(this.xyCoords, x);
    }

    public void setUserYFactor(double userYFactor) {
        this.userYFactor = userYFactor;
    }

    public double getUserYFactor() {
        return this.userYFactor;
    }

    public JDXSpectrum getConvertedSpectrum() {
        return this.convertedSpectrum;
    }

    public void setConvertedSpectrum(JDXSpectrum spectrum) {
        this.convertedSpectrum = spectrum;
    }

    public static JDXSpectrum taConvert(JDXSpectrum spectrum, IRMode mode) {
        if (!spectrum.isContinuous()) {
            return spectrum;
        }
        switch (mode) {
            case NO_CONVERT: {
                return spectrum;
            }
            case TO_ABS: {
                if (spectrum.isTransmittance()) break;
                return spectrum;
            }
            case TO_TRANS: {
                if (spectrum.isAbsorbance()) break;
                return spectrum;
            }
        }
        JDXSpectrum spec = spectrum.getConvertedSpectrum();
        return spec != null ? spec : (spectrum.isAbsorbance() ? JDXSpectrum.toT(spectrum) : JDXSpectrum.toA(spectrum));
    }

    private static JDXSpectrum toT(JDXSpectrum spectrum) {
        if (!spectrum.isAbsorbance()) {
            return null;
        }
        Coordinate[] xyCoords = spectrum.getXYCoords();
        Coordinate[] newXYCoords = new Coordinate[xyCoords.length];
        if (!Coordinate.isYInRange(xyCoords, 0.0, 4.0)) {
            xyCoords = Coordinate.normalise(xyCoords, 0.0, 4.0);
        }
        int i = 0;
        while (i < xyCoords.length) {
            newXYCoords[i] = new Coordinate(xyCoords[i].getXVal(), JDXSpectrum.toTransmittance(xyCoords[i].getYVal()));
            ++i;
        }
        return JDXSpectrum.newSpectrum(spectrum, newXYCoords, "TRANSMITTANCE");
    }

    private static JDXSpectrum toA(JDXSpectrum spectrum) {
        if (!spectrum.isTransmittance()) {
            return null;
        }
        Coordinate[] xyCoords = spectrum.getXYCoords();
        Coordinate[] newXYCoords = new Coordinate[xyCoords.length];
        boolean isPercent = Coordinate.isYInRange(xyCoords, -2.0, 2.0);
        int i = 0;
        while (i < xyCoords.length) {
            newXYCoords[i] = new Coordinate(xyCoords[i].getXVal(), JDXSpectrum.toAbsorbance(xyCoords[i].getYVal(), isPercent));
            ++i;
        }
        return JDXSpectrum.newSpectrum(spectrum, newXYCoords, "ABSORBANCE");
    }

    public static JDXSpectrum newSpectrum(JDXSpectrum spectrum, Coordinate[] newXYCoords, String units) {
        JDXSpectrum specNew = spectrum.copy();
        specNew.setOrigin("JSpecView Converted");
        specNew.setOwner("JSpecView Generated");
        specNew.setXYCoords(newXYCoords);
        specNew.setYUnits(units);
        spectrum.setConvertedSpectrum(specNew);
        specNew.setConvertedSpectrum(spectrum);
        return specNew;
    }

    private static double toAbsorbance(double x, boolean isPercent) {
        return Math.min(4.0, isPercent ? 2.0 - JDXSpectrum.log10(x) : -JDXSpectrum.log10(x));
    }

    private static double toTransmittance(double x) {
        return x <= 0.0 ? 1.0 : Math.pow(10.0, -x);
    }

    private static double log10(double value) {
        return Math.log(value) / Math.log(10.0);
    }

    public static boolean process(List<JDXSpectrum> specs, IRMode irMode) {
        if (irMode == IRMode.TO_ABS || irMode == IRMode.TO_TRANS) {
            int i = 0;
            while (i < specs.size()) {
                specs.set(i, JDXSpectrum.taConvert(specs.get(i), irMode));
                ++i;
            }
        }
        return true;
    }

    public List<JDXSpectrum> getSubSpectra() {
        return this.subSpectra;
    }

    public JDXSpectrum getCurrentSubSpectrum() {
        return this.subSpectra == null ? this : this.subSpectra.get(this.currentSubSpectrumIndex);
    }

    public int advanceSubSpectrum(int dir) {
        return this.setCurrentSubSpectrum(this.currentSubSpectrumIndex + dir);
    }

    public int setCurrentSubSpectrum(int n) {
        this.currentSubSpectrumIndex = Coordinate.intoRange(n, 0, this.subSpectra.size() - 1);
        return this.currentSubSpectrumIndex;
    }

    public boolean addSubSpectrum(JDXSpectrum spectrum, boolean forceSub) {
        if (!forceSub && (this.numDim < 2 || this.blockID != spectrum.blockID) || !JDXSpectrum.allowSubSpec(this, spectrum)) {
            return false;
        }
        this.isForcedSubset = forceSub;
        if (this.subSpectra == null) {
            this.subSpectra = new ArrayList<JDXSpectrum>();
            this.addSubSpectrum(this, true);
        }
        this.subSpectra.add(spectrum);
        spectrum.parent = this;
        return true;
    }

    public int getSubIndex() {
        return this.subSpectra == null ? -1 : this.currentSubSpectrumIndex;
    }

    public void setExportXAxisDirection(boolean leftToRight) {
        this.exportXAxisLeftToRight = leftToRight;
    }

    public boolean isExportXAxisLeftToRight() {
        return this.exportXAxisLeftToRight;
    }

    public Map<String, Object> getInfo(String key) {
        Hashtable<String, Object> info = new Hashtable<String, Object>();
        if ("id".equalsIgnoreCase(key)) {
            info.put(key, this.id);
            return info;
        }
        info.put("id", this.id);
        Parameters.putInfo(key, info, "specShift", this.specShift);
        boolean justHeader = "header".equals(key);
        if (!justHeader && key != null) {
            int i = this.headerTable.size();
            while (--i >= 0) {
                String[] entry = (String[])this.headerTable.get(i);
                if (!entry[0].equalsIgnoreCase(key) && !entry[2].equalsIgnoreCase(key)) continue;
                info.put(key, entry[1]);
                return info;
            }
        }
        Hashtable head = new Hashtable();
        String[][] list = this.getHeaderRowDataAsArray();
        int i = 0;
        while (i < list.length) {
            String label = JDXSourceStreamTokenizer.cleanLabel(list[i][0]);
            if (key == null || justHeader || label.equals(key)) {
                Object val = JDXSpectrum.fixInfoValue(list[i][1]);
                if (key == null) {
                    Hashtable<String, Object> data = new Hashtable<String, Object>();
                    data.put("value", val);
                    data.put("index", i + 1);
                    info.put(label, data);
                } else {
                    info.put(label, val);
                }
            }
            ++i;
        }
        if (head.size() > 0) {
            info.put("header", head);
        }
        if (!justHeader) {
            Parameters.putInfo(key, info, "titleLabel", this.getTitleLabel());
            Parameters.putInfo(key, info, "type", this.getDataType());
            Parameters.putInfo(key, info, "isHZToPPM", this.isHZtoPPM);
            Parameters.putInfo(key, info, "subSpectrumCount", this.subSpectra == null ? 0 : this.subSpectra.size());
        }
        return info;
    }

    private static Object fixInfoValue(String info) {
        try {
            return Integer.valueOf(info);
        }
        catch (Exception exception) {
            try {
                return Double.valueOf(info);
            }
            catch (Exception exception2) {
                return info;
            }
        }
    }

    public String toString() {
        return this.getTitleLabel();
    }

    public PeakInfo findMatchingPeakInfo(PeakInfo pi) {
        int i = 0;
        while (i < this.peakList.size()) {
            if (this.peakList.get(i).checkTypeMatch(pi)) {
                return this.peakList.get(i);
            }
            ++i;
        }
        return null;
    }

    public PeakInfo getBasePeakInfo() {
        return this.peakList.size() == 0 ? new PeakInfo() : new PeakInfo(" baseModel=\"\" " + this.peakList.get(0));
    }

    public String getAxisLabel(boolean isX) {
        String units;
        String string = units = isX ? this.piUnitsX : this.piUnitsY;
        if (units == null) {
            String string2 = units = isX ? this.xLabel : this.yLabel;
        }
        if (units == null) {
            String string3 = units = isX ? this.xUnits : this.yUnits;
        }
        return units == null ? "" : (units.equalsIgnoreCase("WAVENUMBERS") ? "1/cm" : (units.equalsIgnoreCase("nanometers") ? "nm" : units));
    }

    public double findXForPeakNearest(double x) {
        return Coordinate.findXForPeakNearest(this.xyCoords, x, this.isInverted());
    }

    double addSpecShift(double dx) {
        if (dx != 0.0) {
            this.specShift += dx;
            Coordinate.shiftX(this.xyCoords, dx);
            if (this.subSpectra != null) {
                int i = this.subSpectra.size();
                while (--i >= 0) {
                    JDXSpectrum spec = this.subSpectra.get(i);
                    if (spec == this || spec == this.parent) continue;
                    spec.addSpecShift(dx);
                }
            }
        }
        return this.specShift;
    }

    public static boolean allowSubSpec(JDXSpectrum s1, JDXSpectrum s2) {
        return s1.is1D() == s2.is1D() && s1.xUnits.equalsIgnoreCase(s2.xUnits) && s1.isHNMR() == s2.isHNMR();
    }

    public static boolean areXScalesCompatible(JDXSpectrum s1, JDXSpectrum s2, boolean isSubspecCheck, boolean isLinkCheck) {
        boolean isNMR1 = s1.isNMR();
        if (isNMR1 != s2.isNMR()) {
            return false;
        }
        if (!isLinkCheck && !s1.xUnits.equalsIgnoreCase(s2.xUnits)) {
            return false;
        }
        if (isSubspecCheck) {
            if (s1.is1D() != s2.is1D()) {
                return false;
            }
        } else if (isLinkCheck) {
            if (!isNMR1) {
                return true;
            }
        } else if (!s1.is1D() || !s2.is1D()) {
            return false;
        }
        return !isNMR1 || s2.is1D() && s1.parent.nucleusX.equals(s2.parent.nucleusX);
    }

    public static boolean areLinkableX(JDXSpectrum s1, JDXSpectrum s2) {
        return s1.isNMR() && s2.isNMR() && s1.nucleusX.equals(s2.nucleusX);
    }

    public static boolean areLinkableY(JDXSpectrum s1, JDXSpectrum s2) {
        return s1.isNMR() && s2.isNMR() && s1.nucleusX.equals(s2.nucleusY);
    }

    public void setNHydrogens(int nH) {
        this.nH = nH;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum IRMode {
        NO_CONVERT,
        TO_TRANS,
        TO_ABS,
        TOGGLE;


        public static IRMode getMode(String value) {
            switch (value == null ? 73 : (int)value.toUpperCase().charAt(0)) {
                case 65: {
                    return TO_ABS;
                }
                case 84: {
                    return TO_TRANS;
                }
                case 78: {
                    return NO_CONVERT;
                }
            }
            return TOGGLE;
        }
    }
}

