/*
 * Decompiled with CFR 0.152.
 */
package jspecview.common;

import java.awt.Color;
import java.util.List;
import jspecview.common.Annotation;
import jspecview.common.AwtParameters;
import jspecview.common.JDXSpectrum;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AwtColoredAnnotation
extends Annotation {
    private Color color;

    public AwtColoredAnnotation(JDXSpectrum spec, double x, double y, String text, Color color, boolean isPixels, boolean is2D, int offsetX, int offsetY) {
        super(spec, x, y, text, isPixels, is2D, offsetX, offsetY);
        this.color = color;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static AwtColoredAnnotation getAnnotation(JDXSpectrum spec, List<String> args, AwtColoredAnnotation lastAnnotation) {
        int xPt = 0;
        int yPt = 1;
        int colorPt = 2;
        int textPt = 3;
        int nArgs = args.size();
        try {
            String text;
            Color color;
            switch (nArgs) {
                default: {
                    return null;
                }
                case 1: {
                    String arg = args.get(0);
                    yPt = -1;
                    xPt = -1;
                    if (arg.charAt(0) == '\"') {
                        textPt = 0;
                        colorPt = -1;
                        break;
                    }
                    colorPt = 0;
                    textPt = -1;
                    break;
                }
                case 2: {
                    yPt = -1;
                    xPt = -1;
                    String arg = args.get(0);
                    if (arg.charAt(0) == '\"') {
                        textPt = 0;
                        colorPt = 1;
                        break;
                    }
                    colorPt = 0;
                    textPt = 1;
                    break;
                }
                case 3: 
                case 4: {
                    String arg = args.get(2);
                    if (arg.charAt(0) == '\"') {
                        textPt = 2;
                        colorPt = nArgs == 4 ? 3 : -1;
                    } else {
                        colorPt = 2;
                        textPt = nArgs == 4 ? 3 : -1;
                    }
                    arg = args.get(2);
                    if (arg.charAt(0) == '\"') {
                        textPt = 2;
                        colorPt = -1;
                        break;
                    }
                    colorPt = 2;
                    textPt = -1;
                }
            }
            if (lastAnnotation == null) {
                if (xPt < 0) return null;
                if (yPt < 0) return null;
                if (textPt < 0) return null;
                if (colorPt < 0) {
                    return null;
                }
            }
            double x = xPt < 0 ? lastAnnotation.getXVal() : Double.valueOf(args.get(xPt)).doubleValue();
            double y = yPt < 0 ? lastAnnotation.getYVal() : Double.valueOf(args.get(yPt)).doubleValue();
            Color color2 = color = colorPt < 0 ? lastAnnotation.getColor() : AwtParameters.getColorFromString(args.get(colorPt));
            if (textPt < 0) {
                text = lastAnnotation.getText();
                return new AwtColoredAnnotation(spec, x, y, text, color, false, false, 0, 0);
            }
            text = args.get(textPt);
            if (text.charAt(0) != '\"') return new AwtColoredAnnotation(spec, x, y, text, color, false, false, 0, 0);
            text = text.substring(1, text.length() - 1);
            return new AwtColoredAnnotation(spec, x, y, text, color, false, false, 0, 0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public Color getColor() {
        return this.color;
    }
}

